/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.SendMessageFailedException;
import com.echomine.gnutella.GUID;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageModel;
import com.echomine.gnutella.IConnectionList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageRouterController {
    private static Log logger = LogFactory.getLog((Class)(class$com$echomine$gnutella$MessageRouterController == null ? (class$com$echomine$gnutella$MessageRouterController = MessageRouterController.class$("com.echomine.gnutella.MessageRouterController")) : class$com$echomine$gnutella$MessageRouterController));
    private static Log plogger = LogFactory.getLog((String)"gnutella/router/packet");
    private GnutellaContext context;
    private IConnectionList clist;
    private GnutellaMessageModel messageModel = new GnutellaMessageModel();
    static /* synthetic */ Class class$com$echomine$gnutella$MessageRouterController;

    public MessageRouterController(GnutellaContext context, IConnectionList clist) {
        this.context = context;
        this.clist = clist;
    }

    public GnutellaContext getContext() {
        return this.context;
    }

    public IConnectionList getConnectionList() {
        return this.clist;
    }

    public GnutellaMessageModel getMessageModel() {
        return this.messageModel;
    }

    public void addToOwnMsg(GnutellaMessage msg) {
        this.messageModel.addToOwnMsg(msg);
    }

    public boolean checkAndAddMsgSeen(GnutellaMessage msg) {
        return this.messageModel.checkAndAddMsgSeen(msg);
    }

    public boolean isMsgOwner(GnutellaMessage msg) {
        return this.messageModel.isMsgOwner(msg);
    }

    public void routeMessage(GnutellaConnection connection, GnutellaMessage msg) {
        block4: {
            if (!msg.decTTL()) {
                try {
                    connection.send(msg);
                    if (plogger.isDebugEnabled()) {
                        plogger.debug((Object)("[Routed Packet From " + connection.getConnectionModel() + "] " + msg));
                    }
                }
                catch (SendMessageFailedException ex) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn((Object)"Message Failed to Send back to original connection", (Throwable)ex);
                }
            }
        }
    }

    public void routeMessageToAllExcept(GnutellaConnection connection, GnutellaMessage msg) {
        if (!msg.decTTL()) {
            this.clist.sendMessageToAllExcept(msg, connection);
            if (plogger.isDebugEnabled()) {
                plogger.debug((Object)("[Routed Packet From " + connection.getConnectionModel() + "] " + msg));
            }
        }
    }

    public void enablePushRequestRouting(GUID clientID, GnutellaConnection sender) {
        this.messageModel.addToPushRoutingTable(clientID, sender);
    }

    public GnutellaConnection getPushRequestRoute(GUID clientID) {
        return this.messageModel.getPushRouting(clientID);
    }

    public void enableMessageRouting(GnutellaMessage msg, GnutellaConnection sender) {
        this.messageModel.addToRoutingTable(msg.getHeader().getMsgID(), sender);
    }

    public GnutellaConnection getMessageRouting(GnutellaMessage msg) {
        return this.messageModel.getRouting(msg.getHeader().getMsgID());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

