/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.SendMessageFailedException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MessageRouterController;
import com.echomine.gnutella.MsgInitResponse;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MsgInit
extends GnutellaMessage {
    public MsgInit() {
        this(new GnutellaMessageHeader(0));
    }

    public MsgInit(GnutellaMessageHeader header) {
        super(header);
    }

    public void route(GnutellaConnection connection, MessageRouterController controller) {
        if (controller.checkAndAddMsgSeen(this) || controller.isMsgOwner(this)) {
            return;
        }
        controller.enableMessageRouting(this, connection);
        controller.routeMessageToAllExcept(connection, this);
        GnutellaMessageHeader newHeader = new GnutellaMessageHeader(1, this.getHeader().getMsgID());
        MsgInitResponse response = new MsgInitResponse(newHeader);
        newHeader.setTTL(this.getHeader().getHopsTaken() + 1);
        response.setPort(controller.getContext().getPort());
        try {
            InetAddress ip = controller.getContext().getInterfaceIP();
            if (ip == null) {
                ip = InetAddress.getLocalHost();
            }
            response.setIP(ip);
            response.setFileCount(controller.getContext().getShareFileController().getFileCount());
            response.setTotalSize(controller.getContext().getShareFileController().getTotalSize());
            connection.send(response);
        }
        catch (UnknownHostException ex) {
        }
        catch (SendMessageFailedException ex) {
            // empty catch block
        }
    }
}

