/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GUID;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MessageRouterController;
import com.echomine.util.IPUtil;
import com.echomine.util.ParseUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MsgPushRequest
extends GnutellaMessage {
    private static final int sDataLength = 26;
    private GUID remoteClientID;
    private int fileIndex;
    private InetAddress remoteHost;
    private short remotePort;

    public MsgPushRequest(GnutellaMessageHeader header) {
        super(header);
        this.remoteClientID = new GUID();
        this.fileIndex = 0;
        this.remoteHost = null;
        this.remotePort = 0;
    }

    public MsgPushRequest(GUID guid, InetAddress host, short port, int fileIndex) {
        super(new GnutellaMessageHeader(64));
        this.fileIndex = fileIndex;
        this.remoteClientID = guid;
        this.remoteHost = host;
        this.remotePort = port;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public InetAddress getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(InetAddress remoteHost) {
        this.remoteHost = remoteHost;
    }

    public short getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(short remotePort) {
        this.remotePort = remotePort;
    }

    public GUID getRemoteClientID() {
        return this.remoteClientID;
    }

    public void setRemoteClientID(GUID remoteClientID) {
        this.remoteClientID = remoteClientID;
    }

    public int getSize() {
        return super.getSize() + this.remoteClientID.getSize() + 4 + 4 + 2;
    }

    public void copy(MsgPushRequest b) {
        super.copy(b);
        this.remoteClientID = b.remoteClientID;
        this.fileIndex = b.fileIndex;
        this.remoteHost = b.remoteHost;
        this.remotePort = b.remotePort;
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        offset = super.serialize(outbuf, offset);
        offset = this.remoteClientID.serialize(outbuf, offset);
        offset = ParseUtil.serializeIntLE(this.fileIndex, outbuf, offset);
        System.arraycopy(this.remoteHost.getAddress(), 0, outbuf, offset, 4);
        offset += 4;
        offset = ParseUtil.serializeShortLE(this.remotePort, outbuf, offset);
        return offset;
    }

    public int deserialize(byte[] inbuf, int offset, int length) throws ParseException {
        try {
            if (length != 26) {
                throw new ParseException("Invalid Push Message");
            }
            offset = super.deserialize(inbuf, offset, length);
            offset = this.remoteClientID.deserialize(inbuf, offset);
            this.fileIndex = ParseUtil.deserializeIntLE(inbuf, offset);
            offset += 4;
            StringBuffer strBuf = new StringBuffer();
            offset = IPUtil.deserializeIP(inbuf, offset, strBuf);
            this.remoteHost = InetAddress.getByName(strBuf.toString());
            this.remotePort = ParseUtil.deserializeShortLE(inbuf, offset);
        }
        catch (UnknownHostException ex) {
            throw new ParseException(ex.getMessage());
        }
        return offset += 2;
    }

    public String toString() {
        return "[" + this.header + " " + "RemoteClientID=" + this.remoteClientID + ", " + "FileIndex=" + this.fileIndex + ", " + "RemoteHost=" + this.remoteHost.getHostAddress() + ", " + "RemotePort=" + this.remotePort + "]";
    }

    public void route(GnutellaConnection connection, MessageRouterController controller) {
        if (controller.getContext().getClientID().equals(this.getRemoteClientID())) {
            return;
        }
        GnutellaConnection receiver = controller.getPushRequestRoute(this.getRemoteClientID());
        if (receiver == null) {
            return;
        }
        controller.routeMessage(receiver, this);
    }
}

