/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MessageRouterController;

public class MsgUnknown
extends GnutellaMessage {
    private byte[] body = null;

    public MsgUnknown(GnutellaMessageHeader header) {
        super(header);
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public byte[] getBody() {
        return this.body;
    }

    public int getSize() {
        return super.getSize() + this.body.length;
    }

    public void copy(MsgUnknown b) {
        super.copy(b);
        this.body = b.body;
    }

    public int serialize(byte[] outbuf, int offset) throws ParseException {
        offset = super.serialize(outbuf, offset);
        System.arraycopy(this.body, 0, outbuf, offset, this.body.length);
        return offset += this.body.length;
    }

    public int deserialize(byte[] inbuf, int offset, int length) throws ParseException {
        offset = super.deserialize(inbuf, offset, length);
        this.body = new byte[this.header.getDataLen()];
        System.arraycopy(inbuf, offset, this.body, 0, this.body.length);
        return offset += this.body.length;
    }

    public String toString() {
        return "[" + this.header + ", " + new String(this.body, 0, this.body.length) + "]";
    }

    public void route(GnutellaConnection connection, MessageRouterController controller) {
        if (controller.checkAndAddMsgSeen(this) || controller.isMsgOwner(this)) {
            return;
        }
    }
}

