/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaFileListener;
import com.echomine.gnutella.GnutellaFileModel;
import com.echomine.gnutella.ListenerRequestHandler;
import com.echomine.gnutella.ShareInfo;
import com.echomine.gnutella.impl.GnutellaDirectUploadHandler;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionVetoException;
import com.echomine.util.HTTPResponseHeader;
import java.io.IOException;
import java.net.Socket;
import org.apache.oro.text.perl.Perl5Util;

public class GetRequestHandler
implements ListenerRequestHandler {
    protected static final byte[] forbiddenHeader = new HTTPResponseHeader(404, "Forbidden").toString().getBytes();
    protected static final byte[] invalidRequestHeader = new HTTPResponseHeader(400, "Invalid GET Request").toString().getBytes();
    protected static final byte[] fileNotSharedRequestHeader = new HTTPResponseHeader(400, "File Not Shared").toString().getBytes();
    protected HTTPResponseHeader busyHeader = new HTTPResponseHeader(503, "Server Busy");
    private Perl5Util getRequestRE = new Perl5Util();
    private GnutellaFileListener fl;
    private ConnectionListener cl;
    private ShareInfo info;
    private GnutellaContext context;

    public GetRequestHandler(GnutellaContext context, ShareInfo info) {
        this.cl = info.getConnectionListener();
        this.fl = info.getFileListener();
        this.info = info;
        this.context = context;
    }

    public void handleRequest(String request, Socket socket) throws IOException {
        block8: {
            if (this.context.getRestrictedHostCallback().isHostRestricted(socket.getInetAddress())) {
                socket.getOutputStream().write(forbiddenHeader);
                return;
            }
            if (!this.info.incrementCurrentUploads()) {
                this.busyHeader.setHeader("Server", this.context.getSupportedFeatureHeaders().getHeader("User-Agent"));
                socket.getOutputStream().write(this.busyHeader.toString().getBytes());
                return;
            }
            if (!this.getRequestRE.match("m#^GET\\s+/get/(\\d+)/(.+)/?\\s+(.+)#", request)) {
                socket.getOutputStream().write(invalidRequestHeader);
                return;
            }
            int fileidx = Integer.parseInt(this.getRequestRE.group(1));
            String path = this.info.getShareFileController().getFilePath(fileidx);
            String filename = this.getRequestRE.group(2);
            if (path == null || filename == null) {
                socket.getOutputStream().write(fileNotSharedRequestHeader);
                return;
            }
            GnutellaConnectionModel cmodel = new GnutellaConnectionModel(socket.getInetAddress(), socket.getPort(), 1);
            ConnectionEvent cStartingEvent = new ConnectionEvent(cmodel, 4);
            ConnectionEvent cOpenedEvent = new ConnectionEvent(cmodel, 1);
            ConnectionEvent cClosedEvent = new ConnectionEvent(cmodel, 2);
            ConnectionEvent cVetoEvent = new ConnectionEvent(cmodel, 5);
            GnutellaFileModel filemodel = new GnutellaFileModel(filename, path, fileidx, cmodel);
            GnutellaDirectUploadHandler uploadHandler = new GnutellaDirectUploadHandler(this.context, filemodel);
            uploadHandler.addFileListener(this.fl);
            try {
                uploadHandler.start();
                if (this.cl != null) {
                    this.cl.connectionStarting(cStartingEvent);
                    this.cl.connectionEstablished(cOpenedEvent);
                }
                uploadHandler.handle(socket);
                if (this.cl != null) {
                    this.cl.connectionClosed(cClosedEvent);
                }
            }
            catch (ConnectionVetoException ex) {
                if (this.cl == null) break block8;
                this.cl.connectionClosed(cVetoEvent);
            }
        }
        this.info.decrementCurrentUploads();
    }

    public boolean canHandle(String request) {
        return request.startsWith("GET");
    }
}

