/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaFileListener;
import com.echomine.gnutella.GnutellaFirewalledDownloadInfo;
import com.echomine.gnutella.ListenerRequestHandler;
import com.echomine.gnutella.impl.GnutellaFirewalledDownloadHandler;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionVetoException;
import com.echomine.util.HTTPResponseHeader;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import org.apache.oro.text.perl.Perl5Util;

public class GivRequestHandler
implements ListenerRequestHandler {
    protected static final byte[] forbiddenHeader = new HTTPResponseHeader(404, "Forbidden").toString().getBytes();
    protected static final byte[] invalidRequestHeader = new HTTPResponseHeader(400, "Invalid GIV Request").toString().getBytes();
    private Perl5Util givRequestRE = new Perl5Util();
    private HashMap downloads;
    private GnutellaFileListener fl;
    private ConnectionListener cl;
    private GnutellaContext context;

    public GivRequestHandler(GnutellaContext context, ConnectionListener cl, GnutellaFileListener fl) {
        this.fl = fl;
        this.cl = cl;
        this.context = context;
        this.downloads = new HashMap(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(String request, Socket socket) throws IOException {
        if (this.context.getRestrictedHostCallback().isHostRestricted(socket.getInetAddress())) {
            socket.getOutputStream().write(forbiddenHeader);
            return;
        }
        if (!this.givRequestRE.match("m#^GIV (\\d+):(.+)/(.+)#", request)) {
            socket.getOutputStream().write(invalidRequestHeader);
            return;
        }
        GnutellaFirewalledDownloadInfo info = (GnutellaFirewalledDownloadInfo)this.downloads.remove(this.givRequestRE.group(2) + ":/" + this.givRequestRE.group(1) + "/" + this.givRequestRE.group(3));
        if (info == null) {
            socket.getOutputStream().write(invalidRequestHeader);
            return;
        }
        GnutellaConnectionModel cmodel = new GnutellaConnectionModel(socket.getInetAddress(), socket.getPort(), 2);
        ConnectionEvent cStartingEvent = new ConnectionEvent(cmodel, 4);
        ConnectionEvent cOpenedEvent = new ConnectionEvent(cmodel, 1);
        ConnectionEvent cClosedEvent = new ConnectionEvent(cmodel, 2);
        ConnectionEvent cVetoEvent = new ConnectionEvent(cmodel, 5);
        info.getFileModel().setConnectionModel(cmodel);
        GnutellaFirewalledDownloadHandler firewallHandler = new GnutellaFirewalledDownloadHandler(this.context, info.getFileModel());
        try {
            firewallHandler.start();
            firewallHandler.addFileListener(this.fl);
            if (info.getFileListener() != null) {
                firewallHandler.addFileListener(info.getFileListener());
            }
            try {
                if (info.getConnectionListener() != null) {
                    info.getConnectionListener().connectionStarting(cStartingEvent);
                    info.getConnectionListener().connectionEstablished(cOpenedEvent);
                }
            }
            catch (ConnectionVetoException ex) {
                info.getConnectionListener().connectionClosed(cVetoEvent);
                Object var12_12 = null;
                firewallHandler.removeFileListener(this.fl);
                if (info.getFileListener() != null) {
                    firewallHandler.removeFileListener(info.getFileListener());
                }
                return;
            }
            try {
                this.cl.connectionStarting(cStartingEvent);
                this.cl.connectionEstablished(cOpenedEvent);
            }
            catch (ConnectionVetoException ex) {
                if (info.getConnectionListener() != null) {
                    info.getConnectionListener().connectionClosed(cVetoEvent);
                }
                this.cl.connectionClosed(cVetoEvent);
                Object var12_13 = null;
                firewallHandler.removeFileListener(this.fl);
                if (info.getFileListener() != null) {
                    firewallHandler.removeFileListener(info.getFileListener());
                }
                return;
            }
            firewallHandler.handle(socket);
            this.cl.connectionClosed(cClosedEvent);
            if (info.getConnectionListener() != null) {
                info.getConnectionListener().connectionClosed(cClosedEvent);
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            firewallHandler.removeFileListener(this.fl);
            if (info.getFileListener() != null) {
                firewallHandler.removeFileListener(info.getFileListener());
            }
            throw throwable;
        }
        firewallHandler.removeFileListener(this.fl);
        if (info.getFileListener() != null) {
            firewallHandler.removeFileListener(info.getFileListener());
        }
    }

    public boolean canHandle(String request) {
        return request.startsWith("GIV");
    }

    public void addRequest(GnutellaFirewalledDownloadInfo info) {
        this.downloads.put(info.getRemoteClientID() + ":/" + info.getFileModel().getFileIndex() + "/" + info.getFileModel().getFilename(), info);
    }

    public void removeRequest(GnutellaFirewalledDownloadInfo info) {
        this.downloads.remove(info);
    }

    public void clearRequests() {
        this.downloads.clear();
    }

    public boolean requestExists(GnutellaFirewalledDownloadInfo info) {
        return this.downloads.containsKey(info.getRemoteClientID() + ":/" + info.getFileModel().getFileIndex() + "/" + info.getFileModel().getFilename());
    }
}

