/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnectionEvent;
import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.impl.AbstractGnutellaConnection;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.HandshakeFailedException;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.Socket;

public class GnutellaAcceptorConnection
extends AbstractGnutellaConnection {
    public GnutellaAcceptorConnection(GnutellaContext context, int protocolType, GnutellaConnectionModel cmodel) {
        super(context, protocolType);
        this.cmodel = cmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Socket socket) {
        GnutellaConnectionEvent e = new GnutellaConnectionEvent((ConnectionModel)this.cmodel, 4, this);
        GnutellaConnectionEvent vetoEvent = new GnutellaConnectionEvent((ConnectionModel)this.cmodel, 5, this);
        try {
            this.gnutellaHandler.start();
            this.fireConnectionStarting(e, vetoEvent);
            this.gnutellaHandler.handshake(socket);
            e = new GnutellaConnectionEvent((ConnectionModel)this.cmodel, 1, this);
            this.connected = true;
            this.fireConnectionEstablished(e);
            this.resetStats();
            this.gnutellaHandler.handle(socket);
            e = new GnutellaConnectionEvent((ConnectionModel)this.cmodel, 2, this);
            this.fireConnectionClosed(e);
        }
        catch (ConnectionVetoException ex) {
        }
        catch (HandshakeFailedException ex) {
            e = new GnutellaConnectionEvent(this.cmodel, 3, "Error during handshaking: " + ex.getMessage(), this);
            this.fireConnectionClosed(e);
        }
        catch (IOException ex) {
            e = new GnutellaConnectionEvent(this.cmodel, 3, "Error while handling connection: " + ex.getMessage(), this);
            this.fireConnectionClosed(e);
        }
        finally {
            IOUtil.closeSocket(socket);
        }
        this.connected = false;
    }
}

