/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.RawDataReceivable;
import com.echomine.gnutella.impl.AbstractGnutellaProtocol;
import com.echomine.net.HandshakeFailedException;
import com.echomine.util.HTTPResponseHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class GnutellaConnectorProtocolV06
extends AbstractGnutellaProtocol {
    static final byte[] RESPONSE_STRING = "GNUTELLA/0.6 200 OK\r\n".getBytes();
    static final byte[] CONNECT_STRING = "GNUTELLA CONNECT/0.6\r\n".getBytes();

    public GnutellaConnectorProtocolV06(GnutellaConnection connection, RawDataReceivable receiver) {
        super(connection, receiver);
    }

    public void handshake(Socket socket) throws HandshakeFailedException {
        super.handshake(socket);
        try {
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            os.write(CONNECT_STRING);
            GnutellaContext context = this.getConnection().getContext();
            if (context.getSupportedFeatureHeaders() != null) {
                os.write(context.getSupportedFeatureHeaders().getHeadersAsString().getBytes());
            }
            if (this.getConnection().getConnectionModel().getConnectionHeaders() != null) {
                os.write(this.getConnection().getConnectionModel().getConnectionHeaders().getHeadersAsString().getBytes());
            }
            os.write("\r\n".getBytes());
            HTTPResponseHeader remoteResponse = new HTTPResponseHeader();
            remoteResponse.parse(is);
            this.setSupportedFeatureHeaders(remoteResponse);
            if (remoteResponse.getStatusCode() != 200) {
                throw new HandshakeFailedException("Bad Status Code During Handshake");
            }
            os.write(RESPONSE_STRING);
            if (context.getVendorFeatureHeaders() != null) {
                os.write(context.getVendorFeatureHeaders().getHeadersAsString().getBytes());
            }
            os.write("\r\n".getBytes());
        }
        catch (IOException ex) {
            throw new HandshakeFailedException(ex.getMessage());
        }
        this.logHandshakeHeaders();
    }

    public int getProtocolType() {
        return 8;
    }
}

