/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.GnutellaFileHandler;
import com.echomine.gnutella.GnutellaFileModel;
import com.echomine.net.FileEvent;
import com.echomine.net.FileModel;
import com.echomine.net.TransferRateThrottler;
import com.echomine.net.TransferVetoException;
import com.echomine.util.HTTPHeader;
import com.echomine.util.HTTPRangeHeader;
import com.echomine.util.HTTPResponseHeader;
import com.echomine.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;

public class GnutellaDirectUploadHandler
extends GnutellaFileHandler {
    protected static final int SOCKETBUF = 8192;
    private boolean shutdown;

    public GnutellaDirectUploadHandler(GnutellaContext context, FileModel model) {
        super(context, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(Socket socket) throws IOException {
        block20: {
            FileEvent e;
            GnutellaFileModel filemodel;
            BufferedOutputStream bos;
            BufferedInputStream bis;
            block19: {
                int bytesread;
                RandomAccessFile filein;
                block18: {
                    block17: {
                        block16: {
                            bis = null;
                            bos = null;
                            filemodel = (GnutellaFileModel)this.model;
                            bis = new BufferedInputStream(socket.getInputStream(), 8192);
                            bos = new BufferedOutputStream(socket.getOutputStream(), 8192);
                            this.fireFileTransferStarting(new FileEvent(this, filemodel, 3), new FileEvent(this, filemodel, 7));
                            this.logTransferStarting();
                            HTTPRangeHeader range = new HTTPRangeHeader();
                            HTTPHeader header = new HTTPHeader();
                            header.parseHeaders(bis);
                            this.setResponseHeaders(header);
                            if (header.getHeader("Range") == null) {
                                filemodel.setCurrentFilesize(0L);
                                break block16;
                            }
                            if (range.parse(header.getHeader("Range"))) {
                                long pos = range.getStart();
                                if (pos == -1L) {
                                    filemodel.setCurrentFilesize(0L);
                                } else {
                                    filemodel.setCurrentFilesize(pos);
                                }
                                break block16;
                            }
                            bos.write(this.createErrorHeader(503, "Invalid Range Header").getBytes());
                            bos.flush();
                            FileEvent e2 = new FileEvent(this, filemodel, 5, "Invalid Range Header");
                            this.fireFileTransferFinished(e2);
                            this.logTransferFinished(e2);
                            IOUtil.closeStream(bis);
                            IOUtil.closeStream(bos);
                            return;
                        }
                        if (!this.shutdown) break block17;
                        FileEvent e3 = new FileEvent(this, filemodel, 6);
                        this.fireFileTransferFinished(e3);
                        this.logTransferFinished(e3);
                        IOUtil.closeStream(bis);
                        IOUtil.closeStream(bos);
                        return;
                    }
                    filein = new RandomAccessFile(filemodel.getSaveLocation(), "r");
                    if (filemodel.getCurrentFilesize() < filein.length()) break block18;
                    bos.write(this.createErrorHeader(503, "Invalid Request").getBytes());
                    bos.flush();
                    FileEvent e4 = new FileEvent(this, filemodel, 5, "resume offset > file size");
                    this.fireFileTransferFinished(e4);
                    this.logTransferFinished(e4);
                    IOUtil.closeStream(bis);
                    IOUtil.closeStream(bos);
                    return;
                }
                filemodel.setFilesize(filein.length());
                this.fireFileInfoChanged(new FileEvent(this, filemodel, 2));
                HTTPResponseHeader response = new HTTPResponseHeader();
                response.setStatus(200, "OK");
                response.setHeader("Server", this.getContext().getSupportedFeatureHeaders().getHeader("User-Agent"));
                response.setHeader("Content-type", "application/binary");
                response.setHeader("Content-Range", "bytes=" + filemodel.getCurrentFilesize() + "-" + (filemodel.getFilesize() - 1L) + "/" + filemodel.getFilesize());
                response.setHeader("Content-Length", Long.toString(filemodel.getFilesize()));
                bos.write(response.toString().getBytes());
                bos.flush();
                filein.seek(filemodel.getCurrentFilesize());
                filemodel.setStartTime(System.currentTimeMillis());
                byte[] bytebuf = new byte[8192];
                TransferRateThrottler throttler = filemodel.getThrottler();
                while ((bytesread = filein.read(bytebuf, 0, 8192)) != -1) {
                    bos.write(bytebuf, 0, bytesread);
                    filemodel.incrementCurrentFilesize(bytesread);
                    this.fireFilesizeChanged(new FileEvent(this, filemodel, 1));
                    if (filemodel.getCurrentFilesize() >= filemodel.getFilesize() || this.shutdown) break;
                    if (throttler != null) {
                        throttler.throttle(filemodel);
                        continue;
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
                bos.flush();
                filein.close();
                filemodel.setEndTime(System.currentTimeMillis());
                if (!this.shutdown) break block19;
                FileEvent e5 = new FileEvent(this, filemodel, 6);
                this.fireFileTransferFinished(e5);
                this.logTransferFinished(e5);
                IOUtil.closeStream(bis);
                IOUtil.closeStream(bos);
                return;
            }
            try {
                FileEvent e6 = new FileEvent(this, filemodel, 4);
                this.fireFileTransferFinished(e6);
                this.logTransferFinished(e6);
            }
            catch (IOException ex) {
                e = new FileEvent(this, filemodel, 5, ex.getMessage());
                this.fireFileTransferFinished(e);
                this.logTransferFinished(e);
                IOUtil.closeStream(bis);
                IOUtil.closeStream(bos);
                break block20;
            }
            catch (TransferVetoException ex2) {
                e = new FileEvent(this, filemodel, 7, ex2.getMessage());
                this.fireFileTransferFinished(e);
                this.logTransferFinished(e);
                {
                    catch (Throwable throwable) {
                        IOUtil.closeStream(bis);
                        IOUtil.closeStream(bos);
                        throw throwable;
                    }
                }
                IOUtil.closeStream(bis);
                IOUtil.closeStream(bos);
            }
            IOUtil.closeStream(bis);
            IOUtil.closeStream(bos);
        }
    }

    public void start() {
        this.shutdown = false;
    }

    public void shutdown() {
        this.shutdown = true;
        Thread.currentThread().interrupt();
    }
}

