/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageFactory;
import com.echomine.gnutella.GnutellaMessageHeader;
import com.echomine.gnutella.MsgInitResponse;
import com.echomine.gnutella.impl.AbstractGnutellaConnection;
import com.echomine.gnutella.impl.AbstractMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GnutellaMessageReceiver
extends AbstractMessageReceiver {
    private static Log logger = LogFactory.getLog((Class)(class$com$echomine$gnutella$impl$GnutellaMessageReceiver == null ? (class$com$echomine$gnutella$impl$GnutellaMessageReceiver = GnutellaMessageReceiver.class$("com.echomine.gnutella.impl.GnutellaMessageReceiver")) : class$com$echomine$gnutella$impl$GnutellaMessageReceiver));
    private static Log pingilogger = LogFactory.getLog((String)"gnutella/msg/incoming/ping");
    private static Log pongilogger = LogFactory.getLog((String)"gnutella/msg/incoming/pong");
    private static Log pushilogger = LogFactory.getLog((String)"gnutella/msg/incoming/push");
    private static Log queryilogger = LogFactory.getLog((String)"gnutella/msg/incoming/query");
    private static Log hitilogger = LogFactory.getLog((String)"gnutella/msg/incoming/hit");
    private static Log unknownilogger = LogFactory.getLog((String)"gnutella/msg/incoming/unknown");
    private GnutellaMessageFactory factory;
    static /* synthetic */ Class class$com$echomine$gnutella$impl$GnutellaMessageReceiver;

    public GnutellaMessageReceiver(GnutellaMessageFactory factory) {
        this.factory = factory;
    }

    public void receive(GnutellaConnection connection, GnutellaMessageHeader header, byte[] data) {
        block4: {
            try {
                GnutellaMessage msg = this.factory.deserialize(header, data);
                if (msg != null) {
                    this.logIncomingMessage(msg);
                    if (msg.getType() == 1) {
                        AbstractGnutellaConnection aconn = (AbstractGnutellaConnection)connection;
                        aconn.parseStatResponse((MsgInitResponse)msg);
                    }
                    this.fireMessageReceived(connection, msg);
                }
            }
            catch (ParseException ex) {
                if (!logger.isWarnEnabled()) break block4;
                logger.warn((Object)"Parse Exception occurred while deserializing incoming message", (Throwable)ex);
            }
        }
    }

    protected void logIncomingMessage(GnutellaMessage msg) {
        switch (msg.getType()) {
            case 0: {
                if (!pingilogger.isDebugEnabled()) break;
                pingilogger.debug((Object)msg);
                break;
            }
            case 1: {
                if (!pongilogger.isDebugEnabled()) break;
                pongilogger.debug((Object)msg);
                break;
            }
            case 64: {
                if (!pushilogger.isDebugEnabled()) break;
                pushilogger.debug((Object)msg);
                break;
            }
            case 128: {
                if (!queryilogger.isDebugEnabled()) break;
                queryilogger.debug((Object)msg);
                break;
            }
            case 129: {
                if (!hitilogger.isDebugEnabled()) break;
                hitilogger.debug((Object)msg);
                break;
            }
            default: {
                if (!unknownilogger.isDebugEnabled()) break;
                unknownilogger.debug((Object)msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

