/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.RawDataReceivable;
import com.echomine.gnutella.impl.AbstractGnutellaProtocol;
import com.echomine.net.HandshakeFailedException;
import com.echomine.util.HTTPHeader;
import com.echomine.util.HTTPResponseHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class GnutellaRejectedAcceptorProtocolV06
extends AbstractGnutellaProtocol {
    public GnutellaRejectedAcceptorProtocolV06(GnutellaConnection connection, RawDataReceivable receiver) {
        super(connection, receiver);
    }

    public void handshake(Socket socket) throws HandshakeFailedException {
        super.handshake(socket);
        try {
            GnutellaContext context = this.getConnection().getContext();
            OutputStream os = socket.getOutputStream();
            InputStream is = socket.getInputStream();
            HTTPHeader supportedFeatures = new HTTPHeader();
            supportedFeatures.parseHeaders(is);
            HTTPResponseHeader response = new HTTPResponseHeader();
            response.setProtocol("GNUTELLA/0.6");
            response.setStatus(403, "Forbidden");
            os.write(response.toString().getBytes());
            if (context.getSupportedFeatureHeaders() != null) {
                os.write(context.getSupportedFeatureHeaders().getHeadersAsString().getBytes());
            }
            if (context.getVendorFeatureHeaders() != null) {
                os.write(context.getVendorFeatureHeaders().getHeadersAsString().getBytes());
            }
            os.write("\r\n".getBytes());
            HTTPResponseHeader vendorFeatures = new HTTPResponseHeader();
            vendorFeatures.parse(is);
            throw new HandshakeFailedException("Remote Connection Rejected");
        }
        catch (IOException ex) {
            throw new HandshakeFailedException(ex.getMessage());
        }
    }

    public int getProtocolType() {
        return 6;
    }
}

