/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.gnutella.GnutellaConnectionModel;
import com.echomine.gnutella.GnutellaContext;
import com.echomine.gnutella.IConnectionList;
import com.echomine.gnutella.ListenerRequestHandler;
import com.echomine.gnutella.impl.GnutellaAcceptorConnection;
import java.io.IOException;
import java.net.Socket;

public class GnutellaV06RequestHandler
implements ListenerRequestHandler {
    protected static final String CONNECT_STRING = "GNUTELLA CONNECT/0.6";
    private GnutellaContext context;
    private IConnectionList connectionList;

    public GnutellaV06RequestHandler(GnutellaContext context, IConnectionList connectionList) {
        this.context = context;
        this.connectionList = connectionList;
    }

    public boolean canHandle(String request) {
        return CONNECT_STRING.equals(request);
    }

    public void handleRequest(String request, Socket socket) throws IOException {
        GnutellaConnectionModel cmodel = new GnutellaConnectionModel(socket.getInetAddress(), socket.getPort(), 2);
        GnutellaAcceptorConnection connection = this.connectionList.isMaxIncomingReached() ? new GnutellaAcceptorConnection(this.context, 4, cmodel) : (this.context.getRestrictedHostCallback().isHostRestricted(socket.getInetAddress()) ? new GnutellaAcceptorConnection(this.context, 6, cmodel) : new GnutellaAcceptorConnection(this.context, 2, cmodel));
        if (this.connectionList.addConnection(connection, cmodel)) {
            connection.handle(socket);
        }
    }
}

