/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.gnutella.impl;

import com.echomine.common.ParseException;
import com.echomine.gnutella.GnutellaConnection;
import com.echomine.gnutella.GnutellaConnectionEvent;
import com.echomine.gnutella.GnutellaConnectionManager;
import com.echomine.gnutella.GnutellaMessage;
import com.echomine.gnutella.GnutellaMessageEvent;
import com.echomine.gnutella.GnutellaMessageListener;
import com.echomine.gnutella.Host;
import com.echomine.gnutella.HostEvent;
import com.echomine.gnutella.HostListener;
import com.echomine.gnutella.HostManager;
import com.echomine.gnutella.MsgInitResponse;
import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionVetoException;
import com.echomine.util.HTTPHeader;
import com.echomine.util.IPUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;

public class HostManagerImpl
implements HostManager {
    public static final int MAX_HOSTS = 4096;
    protected EventListenerList listenerList = new EventListenerList();
    LinkedList hosts = new LinkedList();
    private int maxhosts;
    private HostManagerMessageListener msgListener = new HostManagerMessageListener();
    private HostConnectionListener connListener = new HostConnectionListener();
    static /* synthetic */ Class class$com$echomine$gnutella$HostListener;

    public HostManagerImpl(GnutellaConnectionManager cmanager) {
        this(cmanager, 4096);
    }

    public HostManagerImpl(GnutellaConnectionManager cmanager, int maxhosts) {
        cmanager.addConnectionListener(this.connListener);
        this.maxhosts = maxhosts;
    }

    public void save(File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        Object[] objs = this.hosts.toArray();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            writer.write(objs[i].toString() + "\n");
        }
        writer.flush();
        writer.close();
    }

    public void load(File file) throws IOException {
        String connection;
        if (!file.exists()) {
            throw new IOException("File doesn't exist for loading hosts");
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> hostStrings = new ArrayList<String>();
        while ((connection = reader.readLine()) != null) {
            hostStrings.add(connection);
        }
        reader.close();
        final ArrayList<String> tempHosts = hostStrings;
        Thread thread = new Thread(){

            public void run() {
                int size = tempHosts.size();
                for (int i = 0; i < size; ++i) {
                    String conn = (String)tempHosts.get(i);
                    try {
                        Host host = new Host();
                        host.deserialize(conn);
                        HostManagerImpl.this.hosts.add(host);
                        HostManagerImpl.this.fireHostAdded(host);
                        continue;
                    }
                    catch (ParseException ex) {
                        // empty catch block
                    }
                }
            }
        };
        thread.start();
    }

    public Host next() {
        try {
            Host host = (Host)this.hosts.removeFirst();
            this.fireHostRemoved(host);
            return host;
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public void addHost(Host host) {
        if (host == null) {
            return;
        }
        if (!this.hosts.contains(host)) {
            this.hosts.addFirst(host);
            this.fireHostAdded(host);
        }
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    public int getMaxhosts() {
        return this.maxhosts;
    }

    public void setMaxhosts(int maxhosts) {
        this.maxhosts = maxhosts;
    }

    public void addHostListener(HostListener l) {
        this.listenerList.add(class$com$echomine$gnutella$HostListener == null ? (class$com$echomine$gnutella$HostListener = HostManagerImpl.class$("com.echomine.gnutella.HostListener")) : class$com$echomine$gnutella$HostListener, l);
    }

    public void removeHostListener(HostListener l) {
        this.listenerList.remove(class$com$echomine$gnutella$HostListener == null ? (class$com$echomine$gnutella$HostListener = HostManagerImpl.class$("com.echomine.gnutella.HostListener")) : class$com$echomine$gnutella$HostListener, l);
    }

    protected void fireHostAdded(Host host) {
        Object[] listeners = this.listenerList.getListenerList();
        HostEvent event = new HostEvent(this, host);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$echomine$gnutella$HostListener == null ? HostManagerImpl.class$("com.echomine.gnutella.HostListener") : class$com$echomine$gnutella$HostListener)) continue;
            ((HostListener)listeners[i + 1]).hostAdded(event);
        }
    }

    protected void fireHostRemoved(Host host) {
        Object[] listeners = this.listenerList.getListenerList();
        HostEvent event = new HostEvent(this, host);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$echomine$gnutella$HostListener == null ? HostManagerImpl.class$("com.echomine.gnutella.HostListener") : class$com$echomine$gnutella$HostListener)) continue;
            ((HostListener)listeners[i + 1]).hostRemoved(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class HostManagerMessageListener
    implements GnutellaMessageListener {
        HostManagerMessageListener() {
        }

        public void messageReceived(GnutellaMessageEvent event) {
            GnutellaMessage msg = event.getMessage();
            if (msg.getType() == 1 && HostManagerImpl.this.hosts.size() < HostManagerImpl.this.maxhosts) {
                MsgInitResponse pong = (MsgInitResponse)msg;
                if (pong.getIP().getHostAddress().startsWith("0.")) {
                    return;
                }
                Host h = new Host(pong.getIP(), (int)pong.getPort());
                if (h.isPortValid() && !IPUtil.isHostIPPrivate(h.getHost().getHostAddress()) && !HostManagerImpl.this.hosts.contains(h)) {
                    HostManagerImpl.this.hosts.addLast(h);
                    HostManagerImpl.this.fireHostAdded(h);
                }
            }
        }
    }

    class HostConnectionListener
    implements ConnectionListener {
        HostConnectionListener() {
        }

        public void connectionStarting(ConnectionEvent event) throws ConnectionVetoException {
        }

        public void connectionEstablished(ConnectionEvent event) {
            this.storeHost(event);
            GnutellaConnection conn = ((GnutellaConnectionEvent)event).getConnection();
            conn.addMessageListener(HostManagerImpl.this.msgListener);
        }

        public void connectionClosed(ConnectionEvent event) {
            this.storeHost(event);
        }

        void storeHost(ConnectionEvent event) {
            GnutellaConnection conn = ((GnutellaConnectionEvent)event).getConnection();
            conn.removeMessageListener(HostManagerImpl.this.msgListener);
            HTTPHeader headers = conn.getSupportedFeatureHeaders();
            if (headers == null) {
                return;
            }
            String[] headerNames = new String[]{"X-Try", "X-Try-Ultrapeers"};
            for (int i = 0; i < headerNames.length; ++i) {
                String value = headers.getHeader(headerNames[i]);
                if (value == null) continue;
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                try {
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        Host host = new Host();
                        host.deserialize(token);
                        if (!host.isPortValid() || IPUtil.isHostIPPrivate(host.getHost().getHostAddress()) || HostManagerImpl.this.hosts.contains(host)) continue;
                        HostManagerImpl.this.hosts.addLast(host);
                        HostManagerImpl.this.fireHostAdded(host);
                    }
                    continue;
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
    }
}

