/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.ErrorMessage;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberJDOMMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import org.jdom.Element;

public abstract class AbstractJabberMessage
extends JabberJDOMMessage {
    private String type;
    private JID to;
    private JID from;
    private ErrorMessage errorMessage;
    public static final String TYPE_ERROR = "error";

    public AbstractJabberMessage(String type, Element root) {
        super(root);
        this.setType(type);
        this.getDOM().setAttribute("id", this.getMessageID());
    }

    protected AbstractJabberMessage() {
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        String msgid;
        super.parse(parser, msgTree);
        this.type = msgTree.getAttributeValue("type");
        String val = msgTree.getAttributeValue("to");
        if (val != null) {
            this.to = new JID(val);
        }
        if ((val = msgTree.getAttributeValue("from")) != null) {
            this.from = new JID(val);
        }
        if ((msgid = msgTree.getAttributeValue("id")) != null) {
            this.setMessageID(msgid);
        }
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (type != null) {
            this.getDOM().setAttribute("type", type);
        } else {
            this.getDOM().removeAttribute("type", this.getDOM().getNamespace());
        }
    }

    public JID getTo() {
        return this.to;
    }

    public void setTo(JID to) {
        this.to = to;
        if (to != null) {
            this.getDOM().setAttribute("to", to.toString());
        } else {
            this.getDOM().removeAttribute("to", this.getDOM().getNamespace());
        }
    }

    public JID getFrom() {
        return this.from;
    }

    public void setFrom(JID from) {
        this.from = from;
        if (from != null) {
            this.getDOM().setAttribute("from", from.toString());
        } else {
            this.getDOM().removeAttribute("from", this.getDOM().getNamespace());
        }
    }

    public boolean isError() {
        if (TYPE_ERROR.equals(this.type)) {
            return true;
        }
        AbstractJabberMessage reply = (AbstractJabberMessage)this.getReplyMessage();
        return reply != null && reply.isError();
    }

    public ErrorMessage getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        AbstractJabberMessage reply = (AbstractJabberMessage)this.getReplyMessage();
        if (!TYPE_ERROR.equals(this.type) && reply == null) {
            return null;
        }
        if (TYPE_ERROR.equals(this.type)) {
            Element errorElem = this.getDOM().getChild(TYPE_ERROR, this.getDOM().getNamespace());
            if (errorElem == null) {
                return null;
            }
            String code = errorElem.getAttributeValue("code");
            String errmsg = errorElem.getText();
            int errcode = 0;
            if (code != null) {
                errcode = Integer.parseInt(code);
            }
            this.errorMessage = new ErrorMessage(errcode, errmsg);
        } else {
            if (reply != null && !reply.isError()) {
                return null;
            }
            this.errorMessage = reply.getErrorMessage();
        }
        return this.errorMessage;
    }

    public void setErrorMessage(ErrorMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Error message cannot be null");
        }
        this.errorMessage = msg;
        this.setType(TYPE_ERROR);
        this.getDOM().removeChild(TYPE_ERROR, this.getDOM().getNamespace());
        Element errorElem = new Element(TYPE_ERROR, this.getDOM().getNamespace());
        errorElem.setAttribute("code", "" + msg.getCode());
        errorElem.addContent(msg.getMessage());
        this.getDOM().addContent(errorElem);
    }
}

