/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class JID {
    private static Pattern jidPat;
    private static Log log;
    private String node;
    private String host;
    private String resource;
    static /* synthetic */ Class class$com$echomine$jabber$JID;

    public JID(String jid) throws ParseException {
        if (jid == null) {
            throw new ParseException("JID is null and cannot be parsed");
        }
        Perl5Matcher matcher = new Perl5Matcher();
        if (!matcher.matches(jid, jidPat)) {
            throw new ParseException("JID has incorrect format: " + jid);
        }
        MatchResult result = matcher.getMatch();
        this.node = result.group(1);
        this.host = result.group(2);
        this.resource = result.group(3);
    }

    public JID(String node, String host, String resource) {
        this.node = node;
        this.host = host;
        this.resource = resource;
    }

    public String getNode() {
        return this.node;
    }

    public String getHost() {
        return this.host;
    }

    public String getResource() {
        return this.resource;
    }

    public String getUsername() {
        return this.getNode();
    }

    public String getJIDWithoutResource() {
        return this.node + "@" + this.host;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.node != null) {
            buf.append(this.node).append("@");
        }
        buf.append(this.host);
        if (this.resource != null) {
            buf.append("/").append(this.resource);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.toString().equals(obj.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            log = LogFactory.getLog((Class)(class$com$echomine$jabber$JID == null ? (class$com$echomine$jabber$JID = JID.class$("com.echomine.jabber.JID")) : class$com$echomine$jabber$JID));
            Perl5Compiler compiler = new Perl5Compiler();
            try {
                jidPat = compiler.compile("(?:(.+)\\@)?([^/]+)(?:/(.+))?");
            }
            catch (MalformedPatternException ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"JID Regular Expression did not compile properly", (Throwable)ex);
            }
        }
    }
}

