/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.msg.LastIQMessage;
import com.echomine.jabber.msg.OOBIQMessage;
import com.echomine.jabber.msg.PrivateXmlIQMessage;
import org.jdom.Element;

public class JabberClientService {
    private JabberSession session;

    public JabberClientService(JabberSession session) {
        this.session = session;
    }

    public long getClientLastOnline(JID jid) throws SendMessageFailedException {
        LastIQMessage msg = new LastIQMessage();
        msg.setTo(jid);
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        LastIQMessage reply = (LastIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getSeconds();
        }
        return -1L;
    }

    public void sendIdleTimeReply(JID jid, String msgID, long seconds) throws SendMessageFailedException {
        LastIQMessage msg = new LastIQMessage("result");
        msg.setTo(jid);
        msg.setMessageID(msgID);
        msg.setSeconds(seconds);
        msg.setReplyRequired(false);
        this.session.sendMessage(msg);
    }

    public String sendOutOfBandRequest(JID jid, String url, String desc) throws SendMessageFailedException {
        OOBIQMessage msg = new OOBIQMessage("set");
        msg.setTo(jid);
        msg.setUrl(url);
        msg.setDescription(desc);
        return msg.getMessageID();
    }

    public Element getPrivateData(String elemName, String ns) throws SendMessageFailedException {
        PrivateXmlIQMessage msg = new PrivateXmlIQMessage();
        msg.setSynchronized(true);
        msg.setPrivateDataRequest(elemName, ns);
        this.session.sendMessage(msg);
        PrivateXmlIQMessage reply = (PrivateXmlIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getPrivateData(elemName, ns);
        }
        return null;
    }
}

