/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.msg.RosterIQMessage;
import com.echomine.jabber.msg.RosterItem;

public class JabberRosterService {
    private JabberSession session;

    public JabberRosterService(JabberSession session) {
        this.session = session;
    }

    public void requestRosterList(boolean wait) throws SendMessageFailedException {
        RosterIQMessage msg = new RosterIQMessage("get");
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
    }

    public void addToRoster(JID jid, String name, String group, boolean wait) throws SendMessageFailedException {
        RosterItem item = new RosterItem(jid, name);
        item.addGroup(group);
        this.addToRoster(item, wait);
    }

    public void addToRoster(RosterItem item, boolean wait) throws SendMessageFailedException {
        RosterIQMessage msg = new RosterIQMessage("set");
        msg.setSynchronized(wait);
        msg.addRosterItem(item);
        this.session.sendMessage(msg);
    }

    public void removeFromRoster(JID jid, boolean wait) throws SendMessageFailedException {
        RosterItem item = new RosterItem(jid, null);
        item.setRemove(true);
        this.removeFromRoster(item, wait);
    }

    public void removeFromRoster(RosterItem item, boolean wait) throws SendMessageFailedException {
        RosterIQMessage msg = new RosterIQMessage("set");
        msg.setSynchronized(wait);
        item.setRemove(true);
        msg.addRosterItem(item);
        this.session.sendMessage(msg);
    }
}

