/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JIDType;
import com.echomine.jabber.JabberMessageException;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.msg.AgentsIQMessage;
import com.echomine.jabber.msg.BrowseIQMessage;
import com.echomine.jabber.msg.LastIQMessage;
import com.echomine.jabber.msg.SearchIQMessage;
import com.echomine.jabber.msg.ServiceItemsIQMessage;
import com.echomine.jabber.msg.TimeIQMessage;
import com.echomine.jabber.msg.VersionIQMessage;
import java.util.HashMap;
import java.util.List;

public class JabberServerService {
    private JabberSession session;

    public JabberServerService(JabberSession session) {
        this.session = session;
    }

    public String getServerTimeInLocal() throws SendMessageFailedException {
        TimeIQMessage msg = new TimeIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.session.getContext().getServerNameJID());
        this.session.sendMessage(msg);
        TimeIQMessage reply = (TimeIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getTimeInLocal().toString();
        }
        return null;
    }

    public String getServerTime() throws SendMessageFailedException {
        TimeIQMessage msg = new TimeIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.session.getContext().getServerNameJID());
        this.session.sendMessage(msg);
        TimeIQMessage reply = (TimeIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getDisplay().toString();
        }
        return null;
    }

    public String getServerVersion() throws SendMessageFailedException {
        VersionIQMessage msg = new VersionIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.session.getContext().getServerNameJID());
        this.session.sendMessage(msg);
        VersionIQMessage reply = (VersionIQMessage)msg.getReplyMessage();
        String version = null;
        if (reply != null) {
            version = reply.getName() + " " + reply.getVersion();
        }
        return version;
    }

    public long getServerUptime() throws SendMessageFailedException {
        LastIQMessage msg = new LastIQMessage();
        msg.setTo(this.session.getContext().getServerNameJID());
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        LastIQMessage reply = (LastIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getSeconds();
        }
        return -1L;
    }

    public List getAgents() throws SendMessageFailedException {
        AgentsIQMessage msg = new AgentsIQMessage();
        msg.setSynchronized(true);
        msg.setTo(this.session.getContext().getServerNameJID());
        this.session.sendMessage(msg);
        AgentsIQMessage reply = (AgentsIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getAgentList();
        }
        return null;
    }

    public JIDType browse(JID jid, String type, boolean wait) throws JabberMessageException, SendMessageFailedException, ParseException {
        if (type == null || jid == null) {
            throw new IllegalArgumentException("Neither the type nor the JID can be null, check to make sure that they're both not null.");
        }
        BrowseIQMessage msg = new BrowseIQMessage("get", type);
        JIDType jidtype = msg.getJIDType();
        msg.setTo(jid);
        jidtype.setJID(jid);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
        if (wait) {
            if (msg.isError()) {
                throw new JabberMessageException(msg.getErrorMessage());
            }
            BrowseIQMessage reply = (BrowseIQMessage)msg.getReplyMessage();
            if (reply != null) {
                return reply.getJIDType();
            }
        }
        return null;
    }

    public HashMap getSearchFields(JID jid) throws SendMessageFailedException, JabberMessageException {
        SearchIQMessage msg = new SearchIQMessage("get");
        msg.setTo(jid);
        msg.setSynchronized(true);
        this.session.sendMessage(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        SearchIQMessage reply = (SearchIQMessage)msg.getReplyMessage();
        if (reply != null) {
            return reply.getFields();
        }
        return new HashMap();
    }

    public List search(JID jid, HashMap searchFields, boolean wait) throws SendMessageFailedException, JabberMessageException {
        SearchIQMessage msg = new SearchIQMessage("set");
        msg.setTo(jid);
        msg.addFields(searchFields);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
        if (wait) {
            if (msg.isError()) {
                throw new JabberMessageException(msg.getErrorMessage());
            }
            SearchIQMessage reply = (SearchIQMessage)msg.getReplyMessage();
            if (reply != null) {
                return reply.getResultItems();
            }
        }
        return null;
    }

    public List discoverItems(JID jid, String node, boolean wait) throws SendMessageFailedException, JabberMessageException {
        ServiceItemsIQMessage msg = new ServiceItemsIQMessage("get");
        msg.setTo(jid);
        msg.setNode(node);
        msg.setSynchronized(wait);
        this.session.sendMessage(msg);
        if (wait) {
            if (msg.isError()) {
                throw new JabberMessageException(msg.getErrorMessage());
            }
            ServiceItemsIQMessage reply = (ServiceItemsIQMessage)msg.getReplyMessage();
            if (reply != null) {
                return reply.getItems();
            }
        }
        return null;
    }
}

