/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;

public class Agent {
    private JID jid;
    private HashMap features = new HashMap();
    private ArrayList ns = new ArrayList();

    public Agent(JID jid) {
        this.jid = jid;
    }

    public JID getJID() {
        return this.jid;
    }

    public String getDescription() {
        return (String)this.features.get("description");
    }

    public boolean supportsMultiUserChat() {
        return this.features.containsKey("groupchat");
    }

    public boolean supportsRegistration() {
        return this.features.containsKey("register");
    }

    public boolean supportsSearching() {
        return this.features.containsKey("search");
    }

    public String getName() {
        return (String)this.features.get("name");
    }

    public String getTransport() {
        return (String)this.features.get("transport");
    }

    public String getService() {
        return (String)this.features.get("service");
    }

    public HashMap getFeatureList() {
        return this.features;
    }

    public List getNSList() {
        return this.ns;
    }

    public void parse(Element agentElem) throws ParseException {
        this.features.clear();
        this.ns.clear();
        List list = agentElem.getChildren();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element elem = (Element)list.get(i);
            String name = elem.getName();
            if (name.equals("ns")) {
                this.ns.add(elem.getText());
                continue;
            }
            this.features.put(name, elem.getText());
        }
    }
}

