/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.msg.Agent;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class AgentsIQMessage
extends JabberIQMessage {
    private ArrayList agents = new ArrayList();

    public AgentsIQMessage() {
        super("get");
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_AGENTS));
    }

    public List getAgentList() {
        return this.agents;
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        this.agents.clear();
        super.parse(parser, msgTree);
        Element query = msgTree.getChild("query", JabberCode.XMLNS_IQ_AGENTS);
        if (query == null) {
            throw new ParseException("No agent message exists");
        }
        List agentElems = query.getChildren("agent", JabberCode.XMLNS_IQ_AGENTS);
        int size = agentElems.size();
        for (int i = 0; i < size; ++i) {
            Element agentElem = (Element)agentElems.get(i);
            JID agentJID = new JID(agentElem.getAttributeValue("jid"));
            Agent agent = new Agent(agentJID);
            agent.parse(agentElem);
            this.agents.add(agent);
        }
        return this;
    }

    public int getMessageType() {
        return 20;
    }
}

