/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.msg.DataXOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class DataXField {
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_FIXED = "fixed";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_JID_MULTI = "jid-multi";
    public static final String TYPE_JID_SINGLE = "jid-single";
    public static final String TYPE_LIST_MULTI = "list-multi";
    public static final String TYPE_LIST_SINGLE = "list-single";
    public static final String TYPE_TEXT_MULTI = "text-multi";
    public static final String TYPE_TEXT_PRIVATE = "text-private";
    public static final String TYPE_TEXT_SINGLE = "text-single";
    private static final String EMPTY_STRING = "";
    private boolean required = false;
    private String description = "";
    private ArrayList values = new ArrayList();
    private ArrayList options = new ArrayList();
    private String fieldType = "text-single";
    private String label;
    private String variableName;

    public DataXField() {
        this(TYPE_TEXT_SINGLE);
    }

    public DataXField(String fieldType) {
        this(fieldType, null, null);
    }

    public DataXField(String fieldType, String variableName, String label) {
        this.setFieldType(fieldType);
        this.variableName = variableName;
        this.label = label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDescription() {
        if (this.description == null) {
            return EMPTY_STRING;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = !this.isSupportedFieldType(fieldType) ? TYPE_TEXT_SINGLE : fieldType;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setBooleanValue(boolean value) {
        if (!TYPE_BOOLEAN.equals(this.fieldType)) {
            throw new IllegalArgumentException("This method can only be called when the field type is boolean");
        }
        if (!this.values.isEmpty()) {
            this.values.clear();
        }
        if (value) {
            this.addValue("1");
        } else {
            this.addValue("0");
        }
    }

    public void setJIDValue(JID jid) {
        if (!TYPE_JID_SINGLE.equals(this.fieldType)) {
            throw new IllegalArgumentException("This method can only be called when the field type is jid-single");
        }
        if (!this.values.isEmpty()) {
            this.values.clear();
        }
        this.addValue(jid.toString());
    }

    public void addJIDValue(JID jid) {
        if (!TYPE_JID_MULTI.equals(this.fieldType)) {
            throw new IllegalArgumentException("This method can only be called when the field type is jid-multi");
        }
        this.addValue(jid.toString());
    }

    public void addTextValue(String text) {
        if (!TYPE_TEXT_MULTI.equals(this.fieldType) && !TYPE_FIXED.equals(this.fieldType)) {
            throw new IllegalArgumentException("This method can only be called when the field type is text-multi or fixed");
        }
        this.addValue(text);
    }

    public void setTextValue(String text) {
        if (!(TYPE_TEXT_SINGLE.equals(this.fieldType) || TYPE_HIDDEN.equals(this.fieldType) || TYPE_TEXT_PRIVATE.equals(this.fieldType))) {
            throw new IllegalArgumentException("This method can only be called when the field type is text-single or hidden or text-private");
        }
        if (!this.values.isEmpty()) {
            this.values.clear();
        }
        this.addValue(text);
    }

    public String getStringValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return (String)this.values.get(0);
    }

    public boolean getBooleanValue() {
        String val = (String)this.values.get(0);
        return "1".equals(val);
    }

    public JID getJIDValue() throws ParseException {
        String val = (String)this.values.get(0);
        return new JID(val);
    }

    public List getJIDValues() throws ParseException {
        int size = this.values.size();
        ArrayList<JID> list = new ArrayList<JID>(size);
        for (int i = 0; i < size; ++i) {
            String val = (String)this.values.get(i);
            list.add(new JID(val));
        }
        return list;
    }

    protected void addValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("The value cannot be null");
        }
        this.values.add(value);
    }

    protected void addOption(DataXOption option) {
        if (option == null) {
            throw new IllegalArgumentException("The option cannot be null");
        }
        this.options.add(option);
    }

    public List getStringValues() {
        return Collections.unmodifiableList(this.values);
    }

    protected void setValues(List values) {
        this.values.clear();
        if (values != null) {
            this.values.addAll(values);
        }
    }

    public List getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public void setOptions(List ops) {
        if (!TYPE_LIST_SINGLE.equals(this.fieldType) && !TYPE_LIST_MULTI.equals(this.fieldType)) {
            throw new IllegalArgumentException("This method can only be called when the field type is list-single or list-multi");
        }
        this.options.clear();
        if (ops != null) {
            this.options.addAll(ops);
        }
    }

    public void parse(Element fieldElem) throws ParseException {
        Namespace ns = JabberCode.XMLNS_X_DATA;
        if (!"field".equals(fieldElem.getName()) && ns != fieldElem.getNamespace()) {
            throw new ParseException("The field does not begin with the <field> element with the appropriate namespace");
        }
        this.fieldType = fieldElem.getAttributeValue("type");
        if (!this.isSupportedFieldType(this.fieldType)) {
            this.fieldType = TYPE_TEXT_SINGLE;
        }
        this.label = fieldElem.getAttributeValue("label");
        this.variableName = fieldElem.getAttributeValue("var");
        this.required = fieldElem.getChild("required", ns) != null;
        this.description = fieldElem.getChildTextNormalize("desc", ns);
        List list = fieldElem.getChildren("value", ns);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.addValue(((Element)list.get(i)).getText());
        }
        list = fieldElem.getChildren("option", ns);
        size = list.size();
        for (int i = 0; i < size; ++i) {
            Element elem = (Element)list.get(i);
            DataXOption option = new DataXOption(elem.getChildTextNormalize("value", ns), elem.getAttributeValue("label"));
            this.addOption(option);
        }
    }

    public Element encode() throws ParseException {
        int i;
        int size;
        Namespace ns = JabberCode.XMLNS_X_DATA;
        Element fieldElem = new Element("field", ns);
        fieldElem.setAttribute("type", this.fieldType);
        if (this.label != null) {
            fieldElem.setAttribute("label", this.label);
        }
        if (this.variableName != null) {
            fieldElem.setAttribute("var", this.variableName);
        }
        if (this.description != null) {
            fieldElem.addContent(new Element("desc", ns).setText(this.description));
        }
        if (this.required) {
            fieldElem.addContent(new Element("required", ns));
        }
        if (!this.values.isEmpty()) {
            size = this.values.size();
            for (i = 0; i < size; ++i) {
                fieldElem.addContent(new Element("value", ns).setText((String)this.values.get(i)));
            }
        }
        if (!this.options.isEmpty()) {
            size = this.options.size();
            for (i = 0; i < size; ++i) {
                fieldElem.addContent(((DataXOption)this.options.get(i)).encode());
            }
        }
        return fieldElem;
    }

    private boolean isSupportedFieldType(String fieldType) {
        return TYPE_BOOLEAN.equals(fieldType) || TYPE_FIXED.equals(fieldType) || TYPE_HIDDEN.equals(fieldType) || TYPE_JID_MULTI.equals(fieldType) || TYPE_JID_SINGLE.equals(fieldType) || TYPE_LIST_MULTI.equals(fieldType) || TYPE_LIST_SINGLE.equals(fieldType) || TYPE_TEXT_MULTI.equals(fieldType) || TYPE_TEXT_SINGLE.equals(fieldType) || TYPE_TEXT_PRIVATE.equals(fieldType);
    }
}

