/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import java.util.Iterator;
import org.jdom.Element;
import org.jdom.Namespace;

public class JabberVCardMessage
extends JabberIQMessage {
    private String nickname;
    private String family;
    private String given;
    private String middle;
    private String fn;
    private String email;
    private String bday;
    private String url;
    private String orgname;
    private String orgunit;
    private String title;
    private String role;
    private String desc;
    private JID jid;
    private String age;
    private String gender;
    private String photo;
    private String foreground;
    private String background;
    private LocalStruct home;
    private LocalStruct work;

    public JabberVCardMessage(String type) {
        super(type);
        this.initToNull();
    }

    public JabberVCardMessage() {
        super("set");
        this.initToNull();
    }

    public String getFullName() {
        return this.fn;
    }

    public void setFullName(String pFullName) {
        this.fn = pFullName;
    }

    public String getMail() {
        return this.email;
    }

    public String getPhoto() {
        return this.photo;
    }

    public void setPhoto(String pPhoto) {
        this.photo = pPhoto;
    }

    public String getForeground() {
        return this.foreground;
    }

    public void setForeground(String pForeground) {
        this.foreground = pForeground;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String pBackground) {
        this.background = pBackground;
    }

    public void setMail(String pMail) {
        this.email = pMail;
    }

    public String getBirthday() {
        return this.bday;
    }

    public void setBirthday(String pBirthday) {
        this.bday = pBirthday;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String pGender) {
        this.gender = pGender;
    }

    public String getAge() {
        return this.age;
    }

    public void setAge(String pAge) {
        this.age = pAge;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String pURL) {
        this.url = pURL;
    }

    public String getOrgName() {
        return this.orgname;
    }

    public void setOrgName(String pOrgName) {
        this.orgname = pOrgName;
    }

    public String getOrgUnit() {
        return this.orgunit;
    }

    public void setOrgUnit(String pOrgUnit) {
        this.orgunit = pOrgUnit;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String pTitle) {
        this.title = pTitle;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String pRole) {
        this.role = pRole;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String pDesc) {
        this.desc = pDesc;
    }

    public JID getJID() {
        return this.jid;
    }

    public void setJID(JID pJID) {
        this.jid = pJID;
    }

    public String getMiddle() {
        return this.middle;
    }

    public void setMiddle(String pMiddleName) {
        this.middle = pMiddleName;
    }

    public String getGiven() {
        return this.given;
    }

    public void setGiven(String pGivenName) {
        this.given = pGivenName;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String pFamilyName) {
        this.family = pFamilyName;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String pNickname) {
        this.nickname = pNickname;
    }

    public LocalStruct getHome() {
        return this.home;
    }

    public LocalStruct getWork() {
        return this.work;
    }

    public int getMessageType() {
        return 21;
    }

    private void initToNull() {
        this.nickname = "";
        this.family = "";
        this.given = "";
        this.middle = "";
        this.photo = "";
        this.fn = "";
        this.email = "";
        this.bday = "";
        this.age = "";
        this.gender = "";
        this.url = "";
        this.orgname = "";
        this.orgunit = "";
        this.title = "";
        this.role = "";
        this.desc = "";
        this.home = new LocalStruct();
        this.work = new LocalStruct();
        this.background = "";
        this.foreground = "";
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        if (msgTree == null || parser == null) {
            throw new ParseException("parser and msgTree cannot be null");
        }
        super.parse(parser, msgTree);
        Namespace ns = JabberCode.XMLNS_IQ_VCARD;
        Element vCard = msgTree.getChild("vCard", ns);
        if (vCard == null) {
            throw new ParseException("No \"vCard\" element");
        }
        Element el = vCard.getChild("N", ns);
        if (el != null) {
            this.family = el.getChildText("FAMILY", ns);
            this.given = el.getChildText("GIVEN", ns);
            this.middle = el.getChildText("MIDDLE", ns);
        }
        this.nickname = vCard.getChildText("NICKNAME", ns);
        this.fn = vCard.getChildText("FN", ns);
        this.email = vCard.getChildText("EMAIL", ns);
        if ((this.email == null || this.email.equals("")) && vCard.getChild("EMAIL", ns) != null) {
            this.email = vCard.getChild("EMAIL", ns).getChildText("USERID", ns);
        }
        this.bday = vCard.getChildText("BDAY", ns);
        this.gender = vCard.getChildText("GENDER", ns);
        this.age = vCard.getChildText("AGE", ns);
        this.url = vCard.getChildText("URL", ns);
        this.title = vCard.getChildText("TITLE", ns);
        this.role = vCard.getChildText("ROLE", ns);
        this.desc = vCard.getChildText("DESC", ns);
        this.jid = new JID(vCard.getChildText("JABBERID", ns));
        this.photo = vCard.getChildText("PHOTO", ns);
        this.foreground = vCard.getChildText("FOREGROUND", ns);
        this.background = vCard.getChildText("BACKGROUND", ns);
        Iterator els = vCard.getChildren("ADR", ns).iterator();
        while (els.hasNext()) {
            el = (Element)els.next();
            if (el.getChild("HOME", ns) != null) {
                this.home.street = el.getChildText("STREET", ns);
                this.home.extadd = el.getChildText("EXTADD", ns);
                this.home.locality = el.getChildText("LOCALITY", ns);
                this.home.region = el.getChildText("REGION", ns);
                this.home.pcode = el.getChildText("PCODE", ns);
                this.home.country = el.getChildText("CTRY", ns);
                continue;
            }
            if (el.getChild("WORK", ns) == null) continue;
            this.work.street = el.getChildText("STREET", ns);
            this.work.extadd = el.getChildText("EXTADD", ns);
            this.work.locality = el.getChildText("LOCALITY", ns);
            this.work.region = el.getChildText("REGION", ns);
            this.work.pcode = el.getChildText("PCODE", ns);
            this.work.country = el.getChildText("CTRY", ns);
        }
        el = vCard.getChild("ORG", ns);
        if (el != null) {
            this.orgname = el.getChildText("ORGNAME", ns);
            this.orgunit = el.getChildText("ORGUNIT", ns);
        }
        els = vCard.getChildren("TEL", ns).iterator();
        while (els.hasNext()) {
            el = (Element)els.next();
            if (el.getChild("HOME", ns) != null) {
                if (el.getChild("VOICE", ns) != null) {
                    this.home.phone = el.getChildText("NUMBER", ns);
                    continue;
                }
                if (el.getChild("FAX", ns) != null) {
                    this.home.fax = el.getChildText("NUMBER", ns);
                    continue;
                }
                if (el.getChild("MSG", ns) == null) continue;
                this.home.msg = el.getChildText("NUMBER", ns);
                continue;
            }
            if (el.getChild("WORK", ns) == null) continue;
            if (el.getChild("VOICE", ns) != null) {
                this.work.phone = el.getChildText("NUMBER", ns);
                continue;
            }
            if (el.getChild("FAX", ns) != null) {
                this.work.fax = el.getChildText("NUMBER", ns);
                continue;
            }
            if (el.getChild("MSG", ns) == null) continue;
            this.work.msg = el.getChildText("NUMBER", ns);
        }
        return this;
    }

    public String encode() throws ParseException {
        this.getDOM().getChildren().clear();
        Namespace ns = JabberCode.XMLNS_IQ_VCARD;
        Element e = new Element("vCard", ns);
        this.add(e, "FN", this.fn);
        this.add(e, "NICKNAME", this.nickname);
        this.add(e, "URL", this.url);
        this.add(e, "BDAY", this.bday);
        this.add(e, "AGE", this.age);
        this.add(e, "GENDER", this.gender);
        this.add(e, "TITLE", this.title);
        this.add(e, "ROLE", this.role);
        if (this.jid != null) {
            this.add(e, "JABBERID", this.jid.toString());
        }
        this.add(e, "DESC", this.desc);
        this.add(e, "PHOTO", this.photo);
        this.add(e, "FOREGROUND", this.foreground);
        this.add(e, "BACKGROUND", this.background);
        Element u = new Element("EMAIL", ns);
        this.add(u, "USERID", this.email);
        if (u.getChildren().size() > 0) {
            e.addContent(u);
        }
        u = new Element("N", ns);
        this.add(u, "FAMILY", this.family);
        this.add(u, "GIVEN", this.given);
        this.add(u, "MIDDLE", this.middle);
        if (u.getChildren().size() > 0) {
            e.addContent(u);
        }
        u = new Element("ORG", ns);
        this.add(u, "ORGNAME", this.orgname);
        this.add(u, "ORGUNIT", this.orgunit);
        if (u.getChildren().size() > 0) {
            e.addContent(u);
        }
        if (this.work != null) {
            u = new Element("ADR", ns);
            u.addContent(new Element("WORK", ns));
            this.add(u, "EXTADD", this.work.extadd);
            this.add(u, "STREET", this.work.street);
            this.add(u, "LOCALITY", this.work.locality);
            this.add(u, "REGION", this.work.region);
            this.add(u, "PCODE", this.work.pcode);
            this.add(u, "CTRY", this.work.country);
            if (u.getChildren().size() > 1) {
                e.addContent(u);
            }
            u = new Element("TEL", ns);
            u.addContent(new Element("VOICE", ns));
            u.addContent(new Element("WORK", ns));
            u.addContent(new Element("NUMBER", ns).setText(this.work.phone));
            if (!u.getChildText("NUMBER", ns).equals("")) {
                e.addContent(u);
            }
            u = new Element("TEL", ns);
            u.addContent(new Element("FAX", ns));
            u.addContent(new Element("WORK", ns));
            u.addContent(new Element("NUMBER", ns).setText(this.work.fax));
            if (!u.getChildText("NUMBER", ns).equals("")) {
                e.addContent(u);
            }
            u = new Element("TEL", e.getNamespace());
            u.addContent(new Element("MSG", ns));
            u.addContent(new Element("WORK", ns));
            u.addContent(new Element("NUMBER", ns).setText(this.work.msg));
            if (!u.getChildText("NUMBER", ns).equals("")) {
                e.addContent(u);
            }
        }
        if (this.home != null) {
            u = new Element("ADR", ns);
            u.addContent(new Element("HOME", ns));
            this.add(u, "EXTADD", this.home.extadd);
            this.add(u, "STREET", this.home.street);
            this.add(u, "LOCALITY", this.home.locality);
            this.add(u, "REGION", this.home.region);
            this.add(u, "PCODE", this.home.pcode);
            this.add(u, "CTRY", this.home.country);
            if (u.getChildren().size() > 1) {
                e.addContent(u);
            }
            u = new Element("TEL", ns);
            u.addContent(new Element("VOICE", ns));
            u.addContent(new Element("HOME", ns));
            u.addContent(new Element("NUMBER", ns).setText(this.home.phone));
            if (!u.getChildText("NUMBER", ns).equals("")) {
                e.addContent(u);
            }
            u = new Element("TEL", ns);
            u.addContent(new Element("FAX", ns));
            u.addContent(new Element("HOME", ns));
            u.addContent(new Element("NUMBER", ns).setText(this.home.fax));
            if (!u.getChildText("NUMBER", ns).equals("")) {
                e.addContent(u);
            }
            u = new Element("TEL", ns);
            u.addContent(new Element("MSG", ns));
            u.addContent(new Element("HOME", ns));
            u.addContent(new Element("NUMBER", ns).setText(this.home.msg));
            if (!u.getChildText("NUMBER", ns).equals("")) {
                e.addContent(u);
            }
        }
        this.getDOM().addContent(e);
        return super.encode();
    }

    protected void add(Element e, String elname, String eltext) {
        if (e != null && eltext != null && !eltext.equals("")) {
            e.addContent(new Element(elname, JabberCode.XMLNS_IQ_VCARD).setText(eltext));
        }
    }

    public class LocalStruct {
        public String phone;
        public String msg;
        public String fax;
        public String street;
        public String extadd;
        public String locality;
        public String region;
        public String pcode;
        public String country;
    }
}

