/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.ErrorMessage;
import com.echomine.jabber.JID;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import org.jdom.Element;

public class OOBIQMessage
extends JabberIQMessage {
    private String url;
    private String description;

    public OOBIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_OOB));
    }

    public OOBIQMessage() {
        this("set");
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        Element query = msgTree.getChild("query", JabberCode.XMLNS_IQ_OOB);
        if (query != null) {
            this.url = query.getChildText("url", JabberCode.XMLNS_IQ_OOB);
            this.description = query.getChildText("desc", JabberCode.XMLNS_IQ_OOB);
        }
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMessageType() {
        return 22;
    }

    public String encode() throws ParseException {
        Element x = this.getDOM();
        x.getChildren().clear();
        Element query = new Element("query", JabberCode.XMLNS_IQ_OOB);
        if (this.url != null) {
            query.addContent(new Element("url", JabberCode.XMLNS_IQ_OOB).addContent(this.url));
        }
        if (this.description != null) {
            query.addContent(new Element("desc", JabberCode.XMLNS_IQ_OOB).addContent(this.description));
        }
        x.addContent(query);
        return super.encode();
    }

    public static OOBIQMessage createSuccessMessage(JID to, String msgId) {
        OOBIQMessage msg = new OOBIQMessage("result");
        msg.setTo(to);
        msg.setMessageID(msgId);
        return msg;
    }

    public static OOBIQMessage createSendUrlMessage(JID to, String url, String desc) {
        OOBIQMessage msg = new OOBIQMessage("set");
        msg.setTo(to);
        msg.setUrl(url);
        msg.setDescription(desc);
        msg.setReplyRequired(true);
        return msg;
    }

    public static OOBIQMessage createNotFoundErrorMessage(JID to, String msgId) {
        OOBIQMessage msg = new OOBIQMessage("error");
        msg.setTo(to);
        msg.setMessageID(msgId);
        ErrorMessage emsg = new ErrorMessage(404, "Not Found");
        msg.setErrorMessage(emsg);
        return msg;
    }

    public static OOBIQMessage createNotAcceptableErrorMessage(JID to, String msgId) {
        OOBIQMessage msg = new OOBIQMessage("error");
        msg.setTo(to);
        msg.setMessageID(msgId);
        ErrorMessage emsg = new ErrorMessage(406, "Not Acceptable");
        msg.setErrorMessage(emsg);
        return msg;
    }
}

