/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import org.jdom.Element;

public class ServiceIdentity {
    String category;
    String name;
    String type;

    public ServiceIdentity(String category, String name) {
        this(category, name, null);
    }

    public ServiceIdentity(String category, String name, String type) {
        if (category == null || name == null) {
            throw new IllegalArgumentException("category and name both cannot be null");
        }
        this.category = category;
        this.name = name;
        this.type = type;
    }

    public ServiceIdentity(Element identElem) throws ParseException {
        this.parse(identElem);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        if (category == null) {
            throw new IllegalArgumentException("category cannot be null");
        }
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void parse(Element identElem) throws ParseException {
        if (!"identity".equals(identElem.getName()) && JabberCode.XMLNS_IQ_DISCO_INFO != identElem.getNamespace()) {
            throw new ParseException("The incoming element is not a recognizable service identity XML element");
        }
        this.category = identElem.getAttributeValue("category");
        if (this.category == null) {
            throw new ParseException("category must exist");
        }
        this.name = identElem.getAttributeValue("name");
        if (this.name == null) {
            throw new ParseException("name must exist");
        }
        this.type = identElem.getAttributeValue("type");
    }

    public Element encode() {
        Element identElem = new Element("identity", JabberCode.XMLNS_IQ_DISCO_INFO);
        identElem.setAttribute("category", this.category);
        identElem.setAttribute("name", this.name);
        if (this.type != null) {
            identElem.setAttribute("type", this.type);
        }
        return identElem;
    }
}

