/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber.msg;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.msg.ServiceIdentity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.jdom.Namespace;

public class ServiceInfoIQMessage
extends JabberIQMessage {
    private static Log log = LogFactory.getLog((Class)(class$com$echomine$jabber$msg$ServiceInfoIQMessage == null ? (class$com$echomine$jabber$msg$ServiceInfoIQMessage = ServiceInfoIQMessage.class$("com.echomine.jabber.msg.ServiceInfoIQMessage")) : class$com$echomine$jabber$msg$ServiceInfoIQMessage));
    private String node;
    private ArrayList identities = new ArrayList();
    private ArrayList features = new ArrayList();
    static /* synthetic */ Class class$com$echomine$jabber$msg$ServiceInfoIQMessage;

    public ServiceInfoIQMessage(String type) {
        super(type);
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_DISCO_INFO));
    }

    public ServiceInfoIQMessage() {
        this("get");
    }

    public int getMessageType() {
        return 26;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void addIdentity(ServiceIdentity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity to add cannot be null");
        }
        this.identities.add(identity);
    }

    public void addFeature(String feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature to add cannot be null");
        }
        this.features.add(feature);
    }

    public List getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public List getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        Element ielem;
        int i;
        super.parse(parser, msgTree);
        if (!this.features.isEmpty()) {
            this.features.clear();
        }
        if (!this.identities.isEmpty()) {
            this.identities.clear();
        }
        Namespace ns = JabberCode.XMLNS_IQ_DISCO_INFO;
        Element query = msgTree.getChild("query", ns);
        this.node = query.getAttributeValue("node");
        List list = query.getChildren("identity", ns);
        int size = list.size();
        for (i = 0; i < size; ++i) {
            try {
                ielem = (Element)list.get(i);
                ServiceIdentity ident = new ServiceIdentity(ielem);
                this.identities.add(ident);
                continue;
            }
            catch (ParseException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Error Parsing Service Identity. Ignoring this entry and continuing.", (Throwable)ex);
            }
        }
        list = query.getChildren("feature", ns);
        size = list.size();
        for (i = 0; i < size; ++i) {
            try {
                ielem = (Element)list.get(i);
                this.addFeature(ielem.getAttributeValue("var"));
                continue;
            }
            catch (Throwable tr) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Error retrieving the feature name.  Ignoring this entry and continuing.", tr);
            }
        }
        return this;
    }

    public String encode() throws ParseException {
        int i;
        int size;
        Namespace ns = JabberCode.XMLNS_IQ_DISCO_INFO;
        Element query = this.getDOM().getChild("query", ns);
        if (this.node == null) {
            query.removeAttribute("node");
        } else {
            query.setAttribute("node", this.node);
        }
        if (!query.getChildren().isEmpty()) {
            query.getChildren().clear();
        }
        if (!this.identities.isEmpty()) {
            size = this.identities.size();
            for (i = 0; i < size; ++i) {
                query.addContent(((ServiceIdentity)this.identities.get(i)).encode());
            }
        }
        if (!this.features.isEmpty()) {
            size = this.features.size();
            for (i = 0; i < size; ++i) {
                query.addContent(new Element("feature", ns).setAttribute("var", (String)this.features.get(i)));
            }
        }
        return super.encode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

