/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.HandshakeFailedException;
import com.echomine.net.HandshakeableSocketHandler;
import com.echomine.net.TimeableConnection;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class HandshakeableSocketAcceptor
extends TimeableConnection {
    protected ServerSocket socket;
    private ConnectionModel connectionModel;

    public HandshakeableSocketAcceptor() {
    }

    public HandshakeableSocketAcceptor(ConnectionModel model) throws IOException {
        this(model, 20);
    }

    public HandshakeableSocketAcceptor(ConnectionModel model, int backlog) throws IOException {
        this.connectionModel = model;
        this.open(backlog);
    }

    public void open(int backlog) throws IOException {
        this.socket = this.connectionModel.getHost() == null ? new ServerSocket(this.connectionModel.getPort(), backlog) : new ServerSocket(this.connectionModel.getPort(), backlog, this.connectionModel.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(HandshakeableSocketHandler socketHandler) {
        try {
            Socket s = this.socket.accept();
            ConnectionEvent e = new ConnectionEvent(this.connectionModel, 4);
            ConnectionEvent vetoEvent = new ConnectionEvent(this.connectionModel, 5);
            try {
                socketHandler.start();
                this.fireConnectionStarting(e, vetoEvent);
                e = new ConnectionEvent(this.connectionModel, 1);
                socketHandler.handshake(s);
                this.fireConnectionEstablished(e);
                socketHandler.handle(s);
                e = new ConnectionEvent(this.connectionModel, 2);
                this.fireConnectionClosed(e);
            }
            catch (ConnectionVetoException ex) {
            }
            catch (HandshakeFailedException ex) {
                e = new ConnectionEvent(this.connectionModel, 3, "Error during handshaking: " + ex.getMessage());
                this.fireConnectionClosed(e);
            }
            catch (IOException ex) {
                e = new ConnectionEvent(this.connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                this.fireConnectionClosed(e);
            }
            finally {
                IOUtil.closeSocket(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void aaccept(final HandshakeableSocketHandler socketHandler) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Socket s = HandshakeableSocketAcceptor.this.socket.accept();
                    ConnectionEvent e = new ConnectionEvent(HandshakeableSocketAcceptor.this.connectionModel, 4);
                    ConnectionEvent vetoEvent = new ConnectionEvent(HandshakeableSocketAcceptor.this.connectionModel, 5);
                    try {
                        socketHandler.start();
                        HandshakeableSocketAcceptor.this.fireConnectionStarting(e, vetoEvent);
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.this.connectionModel, 1);
                        socketHandler.handshake(s);
                        HandshakeableSocketAcceptor.this.fireConnectionEstablished(e);
                        socketHandler.handle(s);
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.this.connectionModel, 2);
                        HandshakeableSocketAcceptor.this.fireConnectionClosed(e);
                    }
                    catch (HandshakeFailedException ex) {
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.this.connectionModel, 3, "Error during handshaking: " + ex.getMessage());
                        HandshakeableSocketAcceptor.this.fireConnectionClosed(e);
                    }
                    catch (IOException ex) {
                        e = new ConnectionEvent(HandshakeableSocketAcceptor.this.connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                        HandshakeableSocketAcceptor.this.fireConnectionClosed(e);
                    }
                    catch (ConnectionVetoException ex) {
                    }
                    finally {
                        IOUtil.closeSocket(s);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) throws IOException {
        this.setConnectionModel(connectionModel, 20);
    }

    public void setConnectionModel(ConnectionModel connectionModel, int backlog) throws IOException {
        this.connectionModel = connectionModel;
        this.close();
        this.open(backlog);
    }
}

