/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketAcceptor;
import com.echomine.net.SocketHandler;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.Socket;

public class PerpetualSocketAcceptor
extends SocketAcceptor {
    private boolean shutdown;

    public PerpetualSocketAcceptor() {
    }

    public PerpetualSocketAcceptor(ConnectionModel model) throws IOException {
        super(model);
    }

    public PerpetualSocketAcceptor(ConnectionModel model, int backlog) throws IOException {
        super(model, backlog);
    }

    public void accept(final SocketHandler socketHandler) {
        this.shutdown = false;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Socket s = null;
                    while (!PerpetualSocketAcceptor.this.shutdown) {
                        s = PerpetualSocketAcceptor.this.socket.accept();
                        ConnectionModel connectionModel = new ConnectionModel(s.getInetAddress(), s.getPort());
                        ConnectionEvent e = new ConnectionEvent(connectionModel, 4);
                        ConnectionEvent vetoEvent = new ConnectionEvent(connectionModel, 5);
                        try {
                            socketHandler.start();
                            PerpetualSocketAcceptor.this.fireConnectionStarting(e, vetoEvent);
                            e = new ConnectionEvent(connectionModel, 1);
                            PerpetualSocketAcceptor.this.fireConnectionEstablished(e);
                            socketHandler.handle(s);
                            e = new ConnectionEvent(connectionModel, 2);
                            PerpetualSocketAcceptor.this.fireConnectionClosed(e);
                        }
                        catch (IOException ex) {
                            e = new ConnectionEvent(connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                            PerpetualSocketAcceptor.this.fireConnectionClosed(e);
                        }
                        catch (ConnectionVetoException ex) {}
                        continue;
                        finally {
                            IOUtil.closeSocket(s);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public void aaccept(final SocketHandler socketHandler) {
        this.shutdown = false;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (!PerpetualSocketAcceptor.this.shutdown) {
                        Socket s = PerpetualSocketAcceptor.this.socket.accept();
                        ConnectionModel model = new ConnectionModel(s.getInetAddress(), s.getPort());
                        AcceptorThread athread = new AcceptorThread(socketHandler, s, model);
                        athread.start();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public void close() {
        this.shutdown = true;
        super.close();
    }

    class AcceptorThread
    extends Thread {
        Socket s;
        ConnectionModel connectionModel;
        SocketHandler handler;

        public AcceptorThread(SocketHandler handler, Socket s, ConnectionModel model) {
            this.s = s;
            this.connectionModel = model;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ConnectionEvent e = new ConnectionEvent(this.connectionModel, 4);
            ConnectionEvent vetoEvent = new ConnectionEvent(this.connectionModel, 5);
            try {
                this.handler.start();
                PerpetualSocketAcceptor.this.fireConnectionStarting(e, vetoEvent);
                e = new ConnectionEvent(this.connectionModel, 1);
                PerpetualSocketAcceptor.this.fireConnectionEstablished(e);
                this.handler.handle(this.s);
                e = new ConnectionEvent(this.connectionModel, 2);
                PerpetualSocketAcceptor.this.fireConnectionClosed(e);
            }
            catch (IOException ex) {
                e = new ConnectionEvent(this.connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                PerpetualSocketAcceptor.this.fireConnectionClosed(e);
            }
            catch (ConnectionVetoException connectionVetoException) {
            }
            finally {
                IOUtil.closeSocket(this.s);
            }
        }
    }
}

