/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import com.echomine.util.HTTPHeader;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.oro.text.perl.Perl5Util;

public class HTTPRequestHeader
extends HTTPHeader {
    private Perl5Util httpRequestRE = new Perl5Util();
    private String method = "GET";
    private String uri = "/";
    private String protocol = "HTTP/1.0";

    public String toString() {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(this.method).append(" ").append(this.uri).append(" ").append(this.protocol).append("\r\n");
        buffer.append(super.toString());
        buffer.append("\r\n");
        return buffer.toString();
    }

    public void parse(InputStream is) throws IOException {
        int SOCKETBUF = 1024;
        byte[] bytebuf = new byte[SOCKETBUF];
        int bytesread = IOUtil.readToCRLF(is, bytebuf, 0, SOCKETBUF);
        String line = new String(bytebuf, 0, bytesread);
        if (!this.httpRequestRE.match("m#^(\\S+)\\s+(\\S+)\\s+(.+)#i", line)) {
            throw new IOException("Invalid HTTP request header");
        }
        this.method = this.httpRequestRE.group(1);
        this.uri = this.httpRequestRE.group(2);
        this.protocol = this.httpRequestRE.group(3);
        this.parseHeaders(is);
    }

    public void setRequest(String uri) {
        this.setRequest("GET", uri);
    }

    public void setRequest(String method, String uri) {
        this.setRequest(method, uri, "HTTP/1.0");
    }

    public void setRequest(String method, String uri, String protocol) {
        this.method = method;
        this.uri = uri;
        this.protocol = protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

