/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import java.net.InetAddress;

public class IPUtil {
    public static boolean isHostIPPrivate(String ip) {
        if (ip.equals("0.0.0.0")) {
            return true;
        }
        if (ip.equals("127.0.0.1")) {
            return true;
        }
        if (ip.startsWith("10.")) {
            return true;
        }
        if (ip.startsWith("192.168.")) {
            return true;
        }
        if (ip.startsWith("172.16.")) {
            return true;
        }
        if (ip.startsWith("172.17.")) {
            return true;
        }
        if (ip.startsWith("172.18.")) {
            return true;
        }
        if (ip.startsWith("172.19.")) {
            return true;
        }
        if (ip.startsWith("172.20.")) {
            return true;
        }
        if (ip.startsWith("172.21.")) {
            return true;
        }
        if (ip.startsWith("172.22.")) {
            return true;
        }
        if (ip.startsWith("172.23.")) {
            return true;
        }
        if (ip.startsWith("172.24.")) {
            return true;
        }
        if (ip.startsWith("172.25.")) {
            return true;
        }
        if (ip.startsWith("172.26.")) {
            return true;
        }
        if (ip.startsWith("172.27.")) {
            return true;
        }
        if (ip.startsWith("172.28.")) {
            return true;
        }
        if (ip.startsWith("172.29.")) {
            return true;
        }
        if (ip.startsWith("172.30.")) {
            return true;
        }
        return ip.startsWith("172.31.");
    }

    public static String convertIP(long ip) {
        return (ip & 0xFFL) + "." + ((ip & 0xFF00L) >> 8) + "." + ((ip & 0xFF0000L) >> 16) + "." + ((ip & 0xFFFFFFFFFF000000L) >>> 24);
    }

    public static int serializeIP(String ip, byte[] outbuf, int offset) {
        InetAddress inet = null;
        byte[] addrBuf = null;
        try {
            inet = InetAddress.getByName(ip);
            addrBuf = inet.getAddress();
        }
        catch (Exception e) {
            addrBuf = new byte[]{0, 0, 0, 0};
        }
        outbuf[offset++] = addrBuf[0];
        outbuf[offset++] = addrBuf[1];
        outbuf[offset++] = addrBuf[2];
        outbuf[offset++] = addrBuf[3];
        return offset;
    }

    public static int deserializeIP(byte[] inbuf, int offset, StringBuffer outbuf) {
        int digit1 = inbuf[offset];
        int digit2 = inbuf[offset + 1];
        int digit3 = inbuf[offset + 2];
        int digit4 = inbuf[offset + 3];
        if (digit1 < 0) {
            digit1 += 256;
        }
        if (digit2 < 0) {
            digit2 += 256;
        }
        if (digit3 < 0) {
            digit3 += 256;
        }
        if (digit4 < 0) {
            digit4 += 256;
        }
        outbuf.append(digit1).append(".").append(digit2).append(".").append(digit3).append(".").append(digit4);
        return offset + 4;
    }
}

