/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import com.echomine.common.ParseException;

public class ParseUtil {
    public static int serializeIntBE(int value, byte[] outbuf, int offset) {
        outbuf[offset++] = (byte)(value >> 24);
        outbuf[offset++] = (byte)(value >> 16);
        outbuf[offset++] = (byte)(value >> 8);
        outbuf[offset++] = (byte)value;
        return offset;
    }

    public static int serializeIntLE(int value, byte[] outbuf, int offset) {
        outbuf[offset++] = (byte)value;
        outbuf[offset++] = (byte)(value >> 8);
        outbuf[offset++] = (byte)(value >> 16);
        outbuf[offset++] = (byte)(value >> 24);
        return offset;
    }

    public static int deserializeIntBE(byte[] inbuf, int offset) {
        return inbuf[offset] << 24 | (inbuf[offset + 1] & 0xFF) << 16 | (inbuf[offset + 2] & 0xFF) << 8 | inbuf[offset + 3] & 0xFF;
    }

    public static int deserializeIntLE(byte[] inbuf, int offset) {
        return inbuf[offset + 3] << 24 | (inbuf[offset + 2] & 0xFF) << 16 | (inbuf[offset + 1] & 0xFF) << 8 | inbuf[offset] & 0xFF;
    }

    public static int serializeShortBE(short value, byte[] outbuf, int offset) {
        outbuf[offset++] = (byte)(value >> 8);
        outbuf[offset++] = (byte)value;
        return offset;
    }

    public static int serializeShortLE(short value, byte[] outbuf, int offset) {
        outbuf[offset++] = (byte)value;
        outbuf[offset++] = (byte)(value >> 8);
        return offset;
    }

    public static short deserializeShortBE(byte[] inbuf, int offset) {
        return (short)((inbuf[offset] & 0xFF) << 8 | inbuf[offset + 1] & 0xFF);
    }

    public static short deserializeShortLE(byte[] inbuf, int offset) {
        return (short)((inbuf[offset + 1] & 0xFF) << 8 | inbuf[offset] & 0xFF);
    }

    public static int serializeString(String str, byte[] outbuf, int offset) {
        for (int i = 0; i < str.length(); ++i) {
            outbuf[offset] = (byte)str.charAt(i);
            ++offset;
        }
        return offset;
    }

    public static int deserializeString(byte[] inbuf, int offset, StringBuffer outbuf) {
        int begin = offset;
        int maxLen = inbuf.length;
        while (offset < maxLen && inbuf[offset] != 0) {
            ++offset;
        }
        if (offset - begin > 0) {
            outbuf.append(new String(inbuf, begin, offset - begin));
        }
        return offset;
    }

    public static int deserializeString(byte[] inbuf, int offset, int len, StringBuffer outbuf) throws ParseException {
        if (len < 0) {
            throw new ParseException("Length must be >= 0");
        }
        if (len > inbuf.length - offset) {
            len = inbuf.length - offset;
        }
        outbuf.append(new String(inbuf, offset, len));
        return offset + len;
    }
}

