/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.Deserializer;
import com.echomine.xmlrpc.Serializer;
import com.echomine.xmlrpc.SerializerFactory;
import com.echomine.xmlrpc.SerializerFactoryAware;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class ArraySerializer
implements Serializer,
Deserializer,
SerializerFactoryAware {
    public static final String NAME = "array";
    private SerializerFactory factory;

    public void setSerializerFactory(SerializerFactory factory) {
        this.factory = factory;
    }

    public Element serialize(Object data, Namespace ns) {
        if (!(data instanceof List)) {
            throw new IllegalArgumentException("Object must implement List");
        }
        List params = (List)data;
        Element root = new Element(NAME, ns);
        Element dataElem = new Element("data", ns);
        root.addContent(dataElem);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Element value = new Element("value", ns);
            Object obj = iter.next();
            Element valueData = this.factory.serialize(obj, ns);
            if (valueData == null) continue;
            value.addContent(valueData);
            dataElem.addContent(value);
        }
        return root;
    }

    public Object deserialize(Element elem) {
        ArrayList<Object> data = new ArrayList<Object>();
        Namespace ns = elem.getNamespace();
        Element dataValue = elem.getChild("data", ns);
        if (dataValue == null) {
            return null;
        }
        Iterator iter = dataValue.getChildren("value", ns).iterator();
        Object value = null;
        Element valElem = null;
        while (iter.hasNext()) {
            value = null;
            valElem = null;
            Element member = (Element)iter.next();
            List valChilds = member.getChildren();
            if (valChilds.size() > 0) {
                valElem = (Element)valChilds.get(0);
            }
            if (valElem != null) {
                value = this.factory.deserialize(valElem);
            }
            if (value == null) continue;
            data.add(value);
        }
        return data;
    }
}

