/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.Deserializer;
import com.echomine.xmlrpc.Serializer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Element;
import org.jdom.Namespace;

public class DateSerializer
implements Serializer,
Deserializer {
    public static final String NAME = "dateTime.iso8601";
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element serialize(Object data, Namespace ns) {
        if (!(data instanceof Date)) {
            throw new IllegalArgumentException("Object must be of type Date or its subclass");
        }
        Element root = new Element(NAME, ns);
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            root.setText(this.format.format((Date)data));
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(Element elem) {
        String text = elem.getText();
        if (text == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            return this.format.parse(text, new ParsePosition(0));
        }
    }

    public void setTimeZone(TimeZone tz) {
        if (tz == null) {
            throw new IllegalArgumentException("Timezone variable cannot be null");
        }
        this.format.setTimeZone(tz);
    }
}

