/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.SerializerFactory;
import java.util.HashMap;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class Response {
    private String faultString;
    private int faultCode;
    private boolean isFault;
    private Object respData;
    private Namespace ns;
    private SerializerFactory factory;

    public Response(SerializerFactory factory) {
        this.factory = factory;
    }

    public Response(Object response, SerializerFactory factory) {
        this.factory = factory;
        this.setResponse(response);
    }

    public Response(int faultCode, String faultString, SerializerFactory factory) {
        this.factory = factory;
        this.setErrorResponse(faultCode, faultString);
    }

    public Response(Element elem) {
        this.parse(elem);
    }

    public void parse(Element elem) {
        this.faultString = null;
        this.faultCode = 0;
        this.isFault = false;
        this.respData = null;
        this.ns = elem.getNamespace();
        Element firstElem = elem.getChild("fault", this.ns);
        if (firstElem != null) {
            this.isFault = true;
            Element fault = firstElem.getChild("value", this.ns).getChild("struct", this.ns);
            this.respData = this.factory.deserialize(fault);
            this.faultCode = (Integer)((HashMap)this.respData).get("faultCode");
            this.faultString = (String)((HashMap)this.respData).get("faultString");
            return;
        }
        firstElem = elem.getChild("params", this.ns);
        if (firstElem == null) {
            return;
        }
        if ((firstElem = firstElem.getChild("param", this.ns)) == null) {
            return;
        }
        if ((firstElem = firstElem.getChild("value", this.ns)) == null) {
            return;
        }
        Element data = (Element)firstElem.getChildren().get(0);
        this.respData = this.factory.deserialize(data);
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public boolean isFault() {
        return this.isFault;
    }

    public int getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public Object getResponse() {
        return this.respData;
    }

    public void setResponse(Object respData) {
        this.respData = respData;
        this.isFault = false;
        this.faultCode = 0;
        this.faultString = null;
    }

    public void setErrorResponse(int faultCode, String faultString) {
        this.isFault = true;
        this.respData = null;
        this.faultCode = faultCode;
        this.faultString = faultString;
        HashMap<String, Object> faultMap = new HashMap<String, Object>();
        faultMap.put("faultCode", new Integer(faultCode));
        faultMap.put("faultString", faultString);
        this.respData = faultMap;
    }

    public Element getDOM() {
        Element resp;
        Element root = new Element("methodResponse", this.ns);
        if (this.isFault()) {
            resp = new Element("fault", this.ns);
            root.addContent(resp);
        } else {
            Element params = new Element("params", this.ns);
            resp = new Element("param", this.ns);
            params.addContent(resp);
            root.addContent(params);
        }
        Element value = new Element("value", this.ns);
        resp.addContent(value);
        Element data = this.factory.serialize(this.respData, this.ns);
        value.addContent(data);
        return root;
    }

    public String toString() {
        Element dom = this.getDOM();
        XMLOutputter xos = new XMLOutputter();
        return xos.outputString(dom);
    }
}

