/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import megamek.client.bot.CEntity;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.LosEffects;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Protomech;
import megamek.common.Targetable;
import megamek.common.ToHitData;

public class MoveOption
extends MovePath
implements Cloneable {
    public static final DistanceComparator DISTANCE_COMPARATOR = new DistanceComparator();
    public static final int ATTACK_MOD = 0;
    public static final int DEFENCE_MOD = 1;
    public static final int ATTACK_PC = 2;
    public static final int DEFENCE_PC = 3;
    boolean inDanger = false;
    boolean doomed = false;
    boolean isPhysical = false;
    double self_threat = 0.0;
    double movement_threat = 0.0;
    double self_damage = 0.0;
    double damage = 0.0;
    double threat = 0.0;
    private transient CEntity centity;
    transient ArrayList<String> tv = new ArrayList();
    transient HashMap<CEntity, DamageInfo> damageInfos = new HashMap();
    private Coords pos;
    private int facing;
    private boolean prone;

    public MoveOption(IGame iGame, CEntity cEntity) {
        super(iGame, cEntity.entity);
        this.centity = cEntity;
        this.pos = cEntity.entity.getPosition();
        this.facing = cEntity.entity.getFacing();
        this.prone = cEntity.entity.isProne();
    }

    public MoveOption(MoveOption moveOption) {
        this(moveOption.game, moveOption.centity);
        this.steps = (Vector)moveOption.steps.clone();
        this.threat = moveOption.threat;
        this.damage = moveOption.damage;
        this.movement_threat = moveOption.movement_threat;
        this.tv = new ArrayList<String>(moveOption.tv);
        this.self_threat = moveOption.self_threat;
        this.inDanger = moveOption.inDanger;
        this.doomed = moveOption.doomed;
        this.isPhysical = moveOption.isPhysical;
        this.self_damage = moveOption.self_damage;
        this.pos = moveOption.pos;
        this.facing = moveOption.facing;
        this.prone = moveOption.prone;
    }

    public Object clone() {
        return new MoveOption(this);
    }

    public double getThreat(CEntity cEntity) {
        return this.getDamageInfo((CEntity)cEntity, (boolean)true).threat;
    }

    public void setThreat(CEntity cEntity, double d) {
        this.getDamageInfo((CEntity)cEntity, (boolean)true).threat = d;
    }

    public double getMinDamage(CEntity cEntity) {
        return this.getDamageInfo((CEntity)cEntity, (boolean)true).min_damage;
    }

    public double getDamage(CEntity cEntity) {
        return this.getDamageInfo((CEntity)cEntity, (boolean)true).damage;
    }

    public void setDamage(CEntity cEntity, double d) {
        this.getDamageInfo((CEntity)cEntity, (boolean)true).damage = d;
    }

    CEntity getCEntity() {
        return this.centity;
    }

    public MoveOption addStep(int n) {
        super.addStep(n);
        MoveStep moveStep = this.getLastStep();
        if (moveStep.getMovementType() == 2 && (this.entity.getBadCriticals(0, 4, 1) > 0 || this.entity.hasHipCrit())) {
            this.getStep(0).setDanger(true);
            moveStep.setDanger(true);
        }
        if (moveStep.isDanger()) {
            if (this.getCEntity().base_psr_odds < 0.1) {
                moveStep.setMovementType(-1);
            } else {
                double d = this.getCEntity().getThreatUtility(0.2 * (double)this.entity.getWeight(), 1) * (1.0 - Math.pow(this.getCEntity().base_psr_odds, 2.0));
                this.movement_threat += d;
                if (this.centity.getTb().debug) {
                    this.tv.add(d + " Movement Threat \r\n");
                }
            }
        }
        return this;
    }

    public int getMovementheatBuildup() {
        MoveStep moveStep = this.getLastStep();
        if (moveStep == null) {
            return 0;
        }
        int n = moveStep.getTotalHeat();
        int n2 = 0;
        switch (moveStep.getMovementType()) {
            case 1: 
            case 4: {
                n2 = 1;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = this.getEntity().getJumpHeat(moveStep.getMpUsed());
                break;
            }
            default: {
                n2 = 1000;
            }
        }
        return n + n2;
    }

    public boolean changeToPhysical() {
        MoveStep moveStep = this.getLastStep();
        boolean bl = this.getEntity() instanceof Infantry;
        boolean bl2 = this.getEntity() instanceof Protomech;
        boolean bl3 = this.getEntity().isClan();
        if (moveStep == null || moveStep.getMovementType() == -1) {
            return false;
        }
        if (moveStep.getType() != 1 || bl || bl2 || bl3 && this.game.getOptions().booleanOption("no_clan_physical") && this.getEntity().getSwarmAttackerId() == -1) {
            return false;
        }
        Enumeration<Entity> enumeration = this.game.getEntities(moveStep.getPosition());
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.isSelectableThisTurn() || !entity.isEnemyOf(this.entity)) continue;
            this.isPhysical = true;
            this.removeLastStep();
            if (this.isJumping()) {
                this.addStep(9, entity);
            } else {
                this.addStep(8, entity);
            }
            return true;
        }
        return false;
    }

    public void setState() {
        this.entity = this.centity.entity;
        if (this.steps.size() == 0) {
            this.entity.setPosition(this.pos);
            this.entity.setFacing(this.facing);
            this.entity.setSecondaryFacing(this.facing);
            this.entity.delta_distance = 0;
            this.entity.setProne(this.prone);
        } else {
            this.entity.setPosition(this.getFinalCoords());
            this.entity.setFacing(this.getFinalFacing());
            this.entity.setSecondaryFacing(this.getFinalFacing());
            this.entity.setProne(this.getFinalProne());
            this.entity.delta_distance = this.getHexesMoved();
        }
        this.entity.moved = this.getLastStepMovementType();
    }

    public int[] getModifiers(Entity entity) {
        Entity entity2 = this.entity;
        int n = entity2.isProne() ? 0 : 1;
        int n2 = entity.isProne() ? 0 : 1;
        int n3 = 0;
        int n4 = 0;
        n3 = entity2.getElevation() + n;
        n4 = entity.getElevation() + n2;
        boolean bl = false;
        boolean bl2 = false;
        ToHitData toHitData = new ToHitData();
        ToHitData toHitData2 = new ToHitData();
        toHitData.append(Compute.getAttackerMovementModifier(this.game, entity2.getId()));
        toHitData.append(Compute.getTargetMovementModifier(this.game, entity.getId()));
        toHitData.append(Compute.getTargetTerrainModifier(this.game, entity));
        toHitData.append(Compute.getAttackerTerrainModifier(this.game, entity2.getId()));
        toHitData2.append(Compute.getAttackerMovementModifier(this.game, entity.getId()));
        toHitData2.append(Compute.getTargetMovementModifier(this.game, entity2.getId()));
        if (!this.isPhysical || !this.isJumping()) {
            toHitData2.append(Compute.getTargetTerrainModifier(this.game, entity2));
        }
        toHitData2.append(Compute.getAttackerTerrainModifier(this.game, entity.getId()));
        IHex iHex = this.game.getBoard().getHex(entity2.getPosition());
        if (iHex.containsTerrain(4) && iHex.surface() > n3) {
            toHitData.addModifier(Integer.MAX_VALUE, "Attacker in depth 2+ water");
            toHitData2.addModifier(Integer.MAX_VALUE, "Defender in depth 2+ water");
        } else if (iHex.surface() == n3 && entity2.height() > 0) {
            bl2 = true;
        }
        IHex iHex2 = this.game.getBoard().getHex(entity.getPosition());
        if (iHex2.containsTerrain(4)) {
            if (iHex2.surface() == n4 && entity.height() > 0) {
                bl = true;
            } else if (iHex2.surface() > n4) {
                toHitData.addModifier(Integer.MAX_VALUE, "Attacker in depth 2+ water");
                toHitData2.addModifier(Integer.MAX_VALUE, "Defender in depth 2+ water");
            }
        }
        LosEffects losEffects = LosEffects.calculateLos(this.game, entity2.getId(), entity);
        toHitData.append(losEffects.losModifiers(this.game));
        bl = losEffects.isTargetCover();
        bl2 = losEffects.isAttackerCover();
        int n5 = losEffects.getTargetCover();
        losEffects.setTargetCover(losEffects.getAttackerCover());
        losEffects.setAttackerCover(n5);
        toHitData2.append(losEffects.losModifiers(this.game));
        if (entity2.getHeatFiringModifier() != 0) {
            toHitData.addModifier(entity2.getHeatFiringModifier(), "heatBuildup");
        }
        if (entity.getHeatFiringModifier() != 0) {
            toHitData2.addModifier(entity.getHeatFiringModifier(), "heatBuildup");
        }
        if (entity.isImmobile()) {
            toHitData.addModifier(-4, "target immobile");
        }
        if (entity2.isImmobile()) {
            toHitData2.addModifier(-4, "target immobile");
        }
        int n6 = entity2.getPosition().distance(entity.getPosition());
        if (entity.isProne()) {
            if (n6 == 1) {
                toHitData.addModifier(-2, "target prone and adjacent");
            }
            if (n6 > 1) {
                toHitData.addModifier(1, "target prone and at range");
            }
        }
        if (entity2.isProne()) {
            if (n6 == 1) {
                toHitData2.addModifier(-2, "target prone and adjacent");
            }
            if (n6 > 1) {
                toHitData2.addModifier(1, "target prone and at range");
            }
        }
        return new int[]{toHitData.getValue(), toHitData2.getValue(), bl2 ? 1 : 0, bl ? 1 : 0};
    }

    public double getUtility() {
        PilotingRollData pilotingRollData;
        double d;
        double d2 = (this.threat + this.movement_threat + this.self_threat + (double)this.getMovementheatBuildup() / 20.0) / this.getCEntity().strategy.attack;
        double d3 = (this.damage + this.self_damage) * this.centity.strategy.attack;
        if (this.threat + this.movement_threat > 4.0 * this.centity.avg_armor) {
            d = (this.threat + this.movement_threat) / (this.centity.avg_armor + 0.25 * this.centity.avg_iarmor);
            if (d > 2.0) {
                d2 += (double)this.centity.bv / 15.0;
                this.doomed = true;
                this.inDanger = true;
            } else if (d > 1.0) {
                d2 += (double)this.centity.bv / 30.0;
                this.inDanger = true;
            } else {
                d2 += (double)this.centity.bv / 75.0;
                this.inDanger = true;
            }
        } else if (this.threat + this.movement_threat > 30.0) {
            d2 += (double)this.centity.entity.getWeight();
        }
        d = d2 - d3;
        if (this.hasActiveMASC()) {
            int n = 0;
            Enumeration enumeration = this.getSteps();
            while (enumeration.hasMoreElements()) {
                MoveStep moveStep = (MoveStep)enumeration.nextElement();
                if (!moveStep.isUsingMASC() || moveStep.getTargetNumberMASC() <= n) continue;
                n = moveStep.getTargetNumberMASC();
            }
            double d4 = Compute.oddsAbove(n) / 100.0;
            d *= d4 > 0.0 ? d4 : 0.01;
        }
        if (this.prone && (pilotingRollData = this.centity.getEntity().checkGetUp(this.getStep(0))) != null && (pilotingRollData.getValue() == Integer.MAX_VALUE || pilotingRollData.getValue() == 0x7FFFFFFE)) {
            d *= 0.01;
        }
        return d;
    }

    public double getMaxModifiedDamage(MoveOption moveOption, int n, int n2) {
        double d = 0.0;
        int n3 = this.getFinalCoords().distance(moveOption.getFinalCoords());
        double d2 = 1.0;
        if (moveOption.isJumping() || moveOption.entity.heat + moveOption.entity.heatBuildup > 4) {
            d2 = moveOption.centity.overheat == 1 ? 0.75 : (moveOption.centity.overheat == 2 ? 0.5 : 0.9);
        }
        int[] nArray = new int[]{0, 3, 4};
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = CEntity.getThreatHitArc(moveOption.getFinalCoords(), MovePath.getAdjustedFacing(moveOption.getFinalFacing(), nArray[i]), this.getFinalCoords());
        }
        d = moveOption.centity.getModifiedDamage(n2 == 1 ? 4 : nArray[0], n3, n);
        d = nArray[1] == 0 ? Math.max(d, moveOption.centity.getModifiedDamage(4, n3, n)) : Math.max(d, moveOption.centity.getModifiedDamage(nArray[1], n3, n));
        d = nArray[2] == 0 ? Math.max(d, moveOption.centity.getModifiedDamage(4, n3, n)) : Math.max(d, moveOption.centity.getModifiedDamage(nArray[2], n3, n));
        d *= d2;
        if (!moveOption.getFinalProne() && n3 == 1 && nArray[0] != 1) {
            IHex iHex = this.game.getBoard().getHex(this.getFinalCoords());
            IHex iHex2 = this.game.getBoard().getHex(moveOption.getFinalCoords());
            if (Math.abs(iHex.getElevation() - iHex2.getElevation()) < 2) {
                d += (double)(iHex2.getElevation() - iHex.getElevation() == 1 || this.getFinalProne() ? 5 : 1) * (nArray[0] == 0 ? 0.2 : 0.05) * (double)this.centity.entity.getWeight() * Compute.oddsAbove(3 + n) / 100.0 + (1.0 - moveOption.centity.base_psr_odds) * (double)moveOption.entity.getWeight() / 10.0;
            }
        }
        return d;
    }

    public DamageInfo getDamageInfo(CEntity cEntity, boolean bl) {
        DamageInfo damageInfo = this.damageInfos.get(cEntity);
        if (bl && damageInfo == null) {
            damageInfo = new DamageInfo();
            this.damageInfos.put(cEntity, damageInfo);
        }
        return damageInfo;
    }

    public double getDistUtility() {
        return (double)this.getMpUsed() + this.movement_threat * 100.0 / (double)this.centity.bv;
    }

    int getPhysicalTargetId() {
        MoveStep moveStep = this.getLastStep();
        if (moveStep == null) {
            return -1;
        }
        Targetable targetable = moveStep.getTarget(this.game);
        if (targetable == null) {
            return -1;
        }
        return targetable.getTargetId();
    }

    public String toString() {
        return this.getEntity().getShortName() + " " + this.getEntity().getId() + " " + this.getFinalCoords() + " " + super.toString() + "\r\n Utility: " + this.getUtility() + " \r\n" + this.tv + "\r\n";
    }

    public static class DamageInfo {
        double threat;
        double damage;
        double max_threat;
        double min_damage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DistanceComparator
    implements Comparator<MoveOption> {
        @Override
        public int compare(MoveOption moveOption, MoveOption moveOption2) {
            return moveOption.getDistUtility() < moveOption2.getDistUtility() ? -1 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table
    extends HashMap<MovePath.Key, MoveOption> {
        public void put(MoveOption moveOption) {
            this.put(moveOption.getKey(), moveOption);
        }

        public MoveOption get(MoveOption moveOption) {
            return (MoveOption)super.get(moveOption.getKey());
        }

        public MoveOption remove(MoveOption moveOption) {
            return (MoveOption)super.remove(moveOption.getKey());
        }

        public ArrayList<MoveOption> getArray() {
            return new ArrayList<MoveOption>(this.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeightedComparator
    implements Comparator<MoveOption> {
        private double utility_weight;
        private double damage_weight;

        public WeightedComparator(double d, double d2) {
            this.utility_weight = d;
            this.damage_weight = d2;
        }

        @Override
        public int compare(MoveOption moveOption, MoveOption moveOption2) {
            if (this.damage_weight * moveOption.damage - this.utility_weight * moveOption.getUtility() > this.damage_weight * moveOption2.damage - this.utility_weight * moveOption2.getUtility()) {
                return -1;
            }
            return 1;
        }
    }
}

