/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.util.Enumeration;
import megamek.client.bot.CEntity;
import megamek.client.bot.PhysicalOption;
import megamek.client.bot.TestBot;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.INarcPod;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.ToHitData;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;

public final class PhysicalCalculator {
    private PhysicalCalculator() {
    }

    static PhysicalOption calculatePhysicalTurn(TestBot testBot) {
        int n;
        int n2 = n = testBot.game.getFirstEntityNum();
        do {
            Entity entity;
            PhysicalOption physicalOption;
            if ((physicalOption = PhysicalCalculator.getBestPhysical(entity = testBot.game.getEntity(n), testBot.game)) == null) continue;
            return physicalOption;
        } while ((n = testBot.game.getNextEntityNum(n)) != -1 && n != n2);
        return null;
    }

    static PhysicalOption getBestPhysical(Entity entity, IGame iGame) {
        if (entity instanceof Infantry) {
            return null;
        }
        if (entity.isCharging() || entity.isMakingDfa()) {
            return null;
        }
        PhysicalOption physicalOption = null;
        int n = 0;
        if (entity instanceof Mech) {
            double d;
            ToHitData toHitData;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            if (entity.getSwarmAttackerId() != -1) {
                toHitData = BrushOffAttackAction.toHit(iGame, entity.getId(), iGame.getEntity(entity.getSwarmAttackerId()), 1);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    d2 = BrushOffAttackAction.getDamageFor(entity, 1);
                    if ((d = PhysicalCalculator.punchThroughMod(entity, 1, 0, d2 *= 1.0 - Compute.oddsAbove(toHitData.getValue()) / 100.0, d2)) < 1.5) {
                        n = 10;
                        d5 = d;
                        d4 = BrushOffAttackAction.getDamageFor(entity, 1);
                    }
                }
                if ((toHitData = BrushOffAttackAction.toHit(iGame, entity.getId(), iGame.getEntity(entity.getSwarmAttackerId()), 2)).getValue() != Integer.MAX_VALUE) {
                    d3 = BrushOffAttackAction.getDamageFor(entity, 2);
                    if ((d = PhysicalCalculator.punchThroughMod(entity, 1, 0, d3 *= 1.0 - Compute.oddsAbove(toHitData.getValue()) / 100.0, d3)) < Math.min(d5, 1.5)) {
                        n = 11;
                        d5 = d;
                        d4 = BrushOffAttackAction.getDamageFor(entity, 2);
                    }
                }
                if (d2 > 0.0 && d3 > 0.0 && (d = PhysicalCalculator.punchThroughMod(entity, 1, 0, d2 + d3, (d2 + d3) / 2.0)) < Math.min(d5, 1.5)) {
                    n = 12;
                    d5 = d;
                    d4 = BrushOffAttackAction.getDamageFor(entity, 1);
                    d4 += (double)BrushOffAttackAction.getDamageFor(entity, 2);
                }
                if (n != 0) {
                    return new PhysicalOption(entity, iGame.getEntity(entity.getSwarmAttackerId()), d4, n, null);
                }
            }
            if (entity.hasINarcPodsAttached()) {
                double d6 = 0.0;
                Enumeration enumeration = entity.getINarcPodsAttached();
                INarcPod iNarcPod = (INarcPod)enumeration.nextElement();
                enumeration = entity.getINarcPodsAttached();
                while (enumeration.hasMoreElements()) {
                    double d7 = 1.0;
                    INarcPod iNarcPod2 = (INarcPod)enumeration.nextElement();
                    if (iNarcPod2.getType() == 1 && !entity.hasActiveECM()) {
                        d7 += 1.0;
                    }
                    if (iNarcPod2.getType() == 2 && (entity.hasC3() || entity.hasC3i())) {
                        d7 += 2.0;
                    }
                    if (iNarcPod2.getType() == 8) {
                        d7 += (double)(entity.getWalkMP() + entity.getJumpMP()) / 2.0;
                    }
                    if (!(d7 > d6)) continue;
                    d6 = d7;
                    iNarcPod = iNarcPod2;
                }
                if (iNarcPod != null) {
                    toHitData = BrushOffAttackAction.toHit(iGame, entity.getId(), iNarcPod, 1);
                    if (toHitData.getValue() != Integer.MAX_VALUE) {
                        d2 = BrushOffAttackAction.getDamageFor(entity, 1);
                        if ((d = PhysicalCalculator.punchThroughMod(entity, 1, 0, d2 *= 1.0 - Compute.oddsAbove(toHitData.getValue()) / 100.0, d2)) < 1.5) {
                            n = 10;
                            d5 = d;
                            d4 = BrushOffAttackAction.getDamageFor(entity, 1);
                        }
                    }
                    if ((toHitData = BrushOffAttackAction.toHit(iGame, entity.getId(), iNarcPod, 2)).getValue() != Integer.MAX_VALUE) {
                        d3 = BrushOffAttackAction.getDamageFor(entity, 2);
                        if ((d = PhysicalCalculator.punchThroughMod(entity, 1, 0, d3 *= 1.0 - Compute.oddsAbove(toHitData.getValue()) / 100.0, d3)) < Math.min(d5, 1.5)) {
                            n = 11;
                            d5 = d;
                            d4 = BrushOffAttackAction.getDamageFor(entity, 2);
                        }
                    }
                    if (d2 > 0.0 && d3 > 0.0 && (d = PhysicalCalculator.punchThroughMod(entity, 1, 0, d2 + d3, (d2 + d3) / 2.0)) < Math.min(d5, 1.5)) {
                        n = 12;
                        d4 = BrushOffAttackAction.getDamageFor(entity, 1);
                        d4 += (double)BrushOffAttackAction.getDamageFor(entity, 2);
                    }
                    if (n != 0) {
                        return new PhysicalOption(entity, iNarcPod, d4, n, null);
                    }
                }
            }
        }
        Enumeration<Entity> enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            PhysicalOption physicalOption2;
            Entity entity2 = enumeration.nextElement();
            if (entity2.equals(entity) || !entity2.isEnemyOf(entity) || entity2.getPosition() == null || Compute.effectiveDistance(iGame, entity, entity2) > 1 || (physicalOption2 = PhysicalCalculator.getBestPhysicalAttack(entity, entity2, iGame)) == null || physicalOption != null && !(physicalOption2.expectedDmg > physicalOption.expectedDmg)) continue;
            physicalOption = physicalOption2;
        }
        if (physicalOption == null) {
            physicalOption = new PhysicalOption(entity);
        }
        return physicalOption;
    }

    static PhysicalOption getBestPhysicalAttack(Entity entity, Entity entity2, IGame iGame) {
        IHex iHex;
        double d;
        int n;
        ToHitData toHitData;
        int n2;
        double d2 = 0.0;
        int n3 = 0;
        Mounted mounted = null;
        if (entity instanceof Infantry || entity instanceof Tank) {
            return null;
        }
        int n4 = CEntity.getThreatHitArc(entity2.getPosition(), entity2.getFacing(), entity.getPosition());
        if (entity2 instanceof Mech) {
            if (!entity2.isProne()) {
                n2 = 1;
                if (entity2.getElevation() == entity.getElevation() + 1) {
                    n2 = 2;
                }
            } else {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if ((toHitData = PunchAttackAction.toHit(iGame, entity.getId(), entity2, 1)).getValue() != Integer.MAX_VALUE) {
            n = PunchAttackAction.getDamageFor(entity, 1);
            d2 = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n;
            n3 = 1;
            d2 *= PhysicalCalculator.punchThroughMod(entity2, n2, n4, d2, d2);
        }
        if ((toHitData = PunchAttackAction.toHit(iGame, entity.getId(), entity2, 2)).getValue() != Integer.MAX_VALUE) {
            n = PunchAttackAction.getDamageFor(entity, 2);
            d = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n;
            if ((d *= PhysicalCalculator.punchThroughMod(entity2, n2, n4, d, d)) > d2) {
                n3 = 2;
                d2 = d;
            }
        }
        toHitData = PunchAttackAction.toHit(iGame, entity.getId(), entity2, 1);
        ToHitData toHitData2 = PunchAttackAction.toHit(iGame, entity.getId(), entity2, 2);
        if (toHitData.getValue() != Integer.MAX_VALUE && toHitData2.getValue() != Integer.MAX_VALUE) {
            n = PunchAttackAction.getDamageFor(entity, 1);
            d = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n;
            double d3 = Compute.oddsAbove(toHitData2.getValue()) / 100.0 * (double)n;
            d += d3;
            if ((d *= PhysicalCalculator.punchThroughMod(entity2, n2, n4, d, d / 2.0)) > d2) {
                n3 = 3;
                d2 = d;
            }
        }
        if (entity2 instanceof Mech) {
            n2 = 2;
            if (!entity2.isProne()) {
                if (entity2.getElevation() == entity.getElevation() - 1) {
                    n2 = 1;
                }
            } else {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if ((d = PhysicalCalculator.getExpectedKickDamage(entity, entity2, iGame, n2, n4, 1)) > d2) {
            n3 = 4;
            d2 = d;
        }
        if ((d = PhysicalCalculator.getExpectedKickDamage(entity, entity2, iGame, n2, n4, 2)) > d2) {
            n3 = 5;
            d2 = d;
        }
        for (Mounted mounted2 : entity.getClubs()) {
            if (entity2 instanceof Mech) {
                n2 = 0;
                if (entity2.getElevation() == entity.getElevation() - 1 && !entity2.isProne()) {
                    n2 = 1;
                }
                if (entity2.getElevation() == entity.getElevation() + 1 && !entity2.isProne()) {
                    n2 = 2;
                }
            } else {
                n2 = 0;
            }
            if ((toHitData = ClubAttackAction.toHit(iGame, entity.getId(), entity2, mounted2)).getValue() == Integer.MAX_VALUE) continue;
            n = ClubAttackAction.getDamageFor(entity, mounted2);
            d = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n;
            if (!((d *= PhysicalCalculator.punchThroughMod(entity2, n2, n4, d, d)) > d2)) continue;
            n3 = 6;
            d2 = d;
            mounted = mounted2;
        }
        toHitData = PushAttackAction.toHit(iGame, entity.getId(), entity2);
        if (toHitData.getValue() != Integer.MAX_VALUE) {
            boolean bl = false;
            d = 0.0;
            int n5 = entity.getPosition().direction(entity2.getPosition());
            Coords coords = entity2.getPosition().translated(n5);
            if (Compute.isValidDisplacement(iGame, entity2.getId(), entity2.getPosition(), coords)) {
                if (!iGame.getBoard().contains(coords)) {
                    d = (double)entity2.getTotalArmor() * Compute.oddsAbove(toHitData.getValue()) / 100.0;
                }
                if (iGame.getBoard().contains(coords)) {
                    double d4;
                    int n6 = iGame.getBoard().getHex(entity2.getPosition()).getElevation();
                    if ((n6 -= iGame.getBoard().getHex(coords).getElevation()) < 0) {
                        n6 = 0;
                    }
                    if (iGame.getBoard().getHex(coords).containsTerrain(4)) {
                        bl = true;
                    }
                    if ((d4 = PhysicalCalculator.punchThroughMod(entity2, 0, 0, d = PhysicalCalculator.calculateFallingDamage(Compute.oddsAbove(toHitData.getValue()) / 100.0, entity2) * (1.0 + (double)n6), Math.min(d, 5.0))) > 1.0 && bl) {
                        d4 *= 2.0;
                    }
                    d = entity2.getWalkMP() > 0 ? (d *= Math.sqrt(1.0 / (double)entity2.getWalkMP() + (double)entity2.getJumpMP())) : (d *= Math.max(1.0, Math.sqrt(entity2.getJumpMP())));
                    d *= d4;
                }
            }
            if (!Compute.isValidDisplacement(iGame, entity2.getId(), entity2.getPosition(), coords)) {
                double d5;
                if (iGame.getBoard().getHex(entity2.getPosition()).containsTerrain(4)) {
                    bl = true;
                }
                if ((d5 = PhysicalCalculator.punchThroughMod(entity2, 0, 0, d = PhysicalCalculator.calculateFallingDamage(Compute.oddsAbove(toHitData.getValue()) / 100.0, entity2), Math.min(d, 5.0))) > 1.0 && bl) {
                    d5 *= 2.0;
                }
                d = entity2.getWalkMP() > 0 ? (d *= Math.sqrt(1.0 / (double)entity2.getWalkMP() + (double)entity2.getJumpMP())) : (d *= Math.max(1.0, Math.sqrt(entity2.getJumpMP())));
                d *= d5;
            }
            if (d > d2) {
                n3 = 8;
                d2 = d;
            }
        }
        if (entity2 instanceof Infantry && !(entity2 instanceof BattleArmor) && !(iHex = iGame.getBoard().getHex(entity2.getPosition())).containsTerrain(1) && !iHex.containsTerrain(10)) {
            d2 *= 2.0;
        }
        if (d2 > 0.0) {
            return new PhysicalOption(entity, entity2, d2, n3, mounted);
        }
        return null;
    }

    private static double calculateFallingDamage(double d, Entity entity) {
        double d2 = d;
        d2 *= 1.0 - Compute.oddsAbove(entity.getBasePilotingRoll().getValue()) / 100.0;
        return d2 *= (double)entity.getWeight() * 0.1;
    }

    private static double getExpectedKickDamage(Entity entity, Entity entity2, IGame iGame, int n, int n2, int n3) {
        double d = 0.0;
        ToHitData toHitData = KickAttackAction.toHit(iGame, entity.getId(), entity2, n3);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            return 0.0;
        }
        if (entity2 instanceof Mech) {
            d = PhysicalCalculator.calculateFallingDamage(Compute.oddsAbove(toHitData.getValue()) / 100.0, entity2);
        }
        int n4 = KickAttackAction.getDamageFor(entity, n3);
        double d2 = Compute.oddsAbove(toHitData.getValue()) / 100.0 * (double)n4;
        d2 *= PhysicalCalculator.punchThroughMod(entity2, n, n2, d2, d2);
        double d3 = PhysicalCalculator.calculateFallingDamage(1.0 - Compute.oddsAbove(toHitData.getValue()) / 100.0, entity);
        d3 = entity.getWalkMP() > 0 ? (d3 *= Math.sqrt(1.0 / (double)entity.getWalkMP() + (double)entity.getJumpMP())) : (d3 *= Math.sqrt(entity.getJumpMP()));
        d2 = d2 + d - d3;
        return d2;
    }

    private static double punchThroughMod(Entity entity, int n, int n2, double d, double d2) {
        int[] nArray = new int[8];
        int n3 = 1;
        nArray[0] = 0;
        double d3 = 1.0;
        double d4 = 0.5;
        if (d <= 0.0 || d2 <= 0.0) {
            return d3;
        }
        if (entity instanceof Mech) {
            if (n == 0) {
                n3 = 7;
                nArray[0] = entity.getArmor(0, false);
                nArray[1] = n2 != 0 ? entity.getArmor(1, true) : entity.getArmor(1, false);
                nArray[2] = n2 != 0 ? entity.getArmor(2, true) : entity.getArmor(2, false);
                nArray[3] = n2 != 0 ? entity.getArmor(3, true) : entity.getArmor(3, false);
                nArray[4] = entity.getArmor(4, false);
                nArray[5] = entity.getArmor(5, false);
                nArray[6] = entity.getArmor(6, false);
                nArray[7] = entity.getArmor(6, false);
            }
            if (n == 1) {
                nArray[0] = entity.getArmor(0, false);
                if (n2 == 3) {
                    n3 = 3;
                    nArray[1] = entity.getArmor(1, false);
                    nArray[2] = entity.getArmor(2, false);
                    nArray[3] = entity.getArmor(4, false);
                }
                if (n2 == 2) {
                    n3 = 3;
                    nArray[1] = entity.getArmor(1, false);
                    nArray[2] = entity.getArmor(3, false);
                    nArray[3] = entity.getArmor(5, false);
                }
                if (n2 == 0) {
                    n3 = 5;
                    nArray[1] = entity.getArmor(1, false);
                    nArray[2] = entity.getArmor(2, false);
                    nArray[3] = entity.getArmor(3, false);
                    nArray[4] = entity.getArmor(4, false);
                    nArray[5] = entity.getArmor(5, false);
                }
                if (n2 == 1) {
                    n3 = 5;
                    nArray[1] = entity.getArmor(1, true);
                    nArray[2] = entity.getArmor(2, true);
                    nArray[3] = entity.getArmor(3, true);
                    nArray[4] = entity.getArmor(4, false);
                    nArray[5] = entity.getArmor(5, false);
                }
            }
            if (n == 2) {
                n3 = -1;
                if (n2 == 0 || n2 == 1 || n2 == 3) {
                    nArray[++n3] = entity.getArmor(6, false);
                }
                if (n2 == 0 || n2 == 1 || n2 == 2) {
                    nArray[++n3] = entity.getArmor(7, false);
                }
            }
        }
        if (entity instanceof Protomech) {
            n3 = 6;
            nArray[0] = entity.getArmor(1, false);
            nArray[1] = entity.getArmor(4, false);
            nArray[2] = entity.getArmor(2, false);
            nArray[3] = entity.getArmor(3, false);
            nArray[4] = entity.getArmor(0, false);
            nArray[5] = 100;
            nArray[6] = 100;
            if (((Protomech)entity).hasMainGun()) {
                nArray[++n3] = entity.getArmor(5, false);
            }
        }
        if (entity instanceof Tank) {
            n3 = 0;
            switch (n2) {
                case 0: {
                    nArray[0] = entity.getArmor(1);
                    break;
                }
                case 3: {
                    nArray[0] = entity.getArmor(2);
                    break;
                }
                case 2: {
                    nArray[0] = entity.getArmor(3);
                    break;
                }
                case 1: {
                    nArray[0] = entity.getArmor(4);
                }
            }
            if (!((Tank)entity).hasNoTurret()) {
                nArray[++n3] = entity.getArmor(5);
            }
        }
        if (entity instanceof BattleArmor) {
            n3 = -1;
            for (int i = 1; i < ((BattleArmor)entity).getShootingStrength(); ++i) {
                if (entity.getArmor(i) < 0) continue;
                nArray[++n3] = entity.getArmor(i);
            }
        }
        if (entity instanceof Infantry && !(entity instanceof BattleArmor)) {
            n3 = 0;
            nArray[0] = ((Infantry)entity).getShootingStrength();
        }
        double d5 = 0.0;
        while (d5 <= d) {
            d5 += d2;
            for (int i = 0; i <= n3; ++i) {
                if (!(d5 > (double)nArray[i])) continue;
                d3 += d4;
            }
            d4 /= 2.0;
        }
        return d3;
    }
}

