/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.util.Vector;
import megamek.common.Entity;
import megamek.common.INarcPod;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalOption {
    public static final int NONE = 0;
    public static final int PUNCH_LEFT = 1;
    public static final int PUNCH_RIGHT = 2;
    public static final int PUNCH_BOTH = 3;
    public static final int KICK_LEFT = 4;
    public static final int KICK_RIGHT = 5;
    public static final int USE_CLUB = 6;
    public static final int USE_CLAW = 7;
    public static final int PUSH_ATTACK = 8;
    public static final int TRIP_ATTACK = 9;
    public static final int BRUSH_LEFT = 10;
    public static final int BRUSH_RIGHT = 11;
    public static final int BRUSH_BOTH = 12;
    public static final int THRASH_INF = 13;
    Entity attacker;
    Entity target;
    INarcPod i_target;
    double expectedDmg;
    int type;
    Mounted club;

    public PhysicalOption(Entity entity) {
        this.attacker = entity;
        this.type = 0;
    }

    public PhysicalOption(Entity entity, Targetable targetable, double d, int n, Mounted mounted) {
        this.attacker = entity;
        if (targetable instanceof Entity) {
            this.target = (Entity)targetable;
        }
        if (targetable instanceof INarcPod) {
            this.i_target = (INarcPod)targetable;
        }
        this.expectedDmg = d;
        this.type = n;
        this.club = mounted;
    }

    public AbstractAttackAction toAction() {
        switch (this.type) {
            case 1: {
                return new PunchAttackAction(this.attacker.getId(), this.target.getId(), 1);
            }
            case 2: {
                return new PunchAttackAction(this.attacker.getId(), this.target.getId(), 2);
            }
            case 3: {
                return new PunchAttackAction(this.attacker.getId(), this.target.getId(), 0);
            }
            case 4: {
                return new KickAttackAction(this.attacker.getId(), this.target.getId(), 1);
            }
            case 5: {
                return new KickAttackAction(this.attacker.getId(), this.target.getId(), 2);
            }
            case 6: {
                if (this.club != null) {
                    return new ClubAttackAction(this.attacker.getId(), this.target.getId(), this.club);
                }
                return null;
            }
            case 8: {
                return new PushAttackAction(this.attacker.getId(), this.target.getId(), this.target.getPosition());
            }
            case 9: {
                return null;
            }
            case 10: {
                if (this.target == null) {
                    return new BrushOffAttackAction(this.attacker.getId(), this.i_target.getTargetType(), this.i_target.getTargetId(), 1);
                }
                return new BrushOffAttackAction(this.attacker.getId(), this.target.getTargetType(), this.target.getId(), 1);
            }
            case 11: {
                if (this.target == null) {
                    return new BrushOffAttackAction(this.attacker.getId(), this.i_target.getTargetType(), this.i_target.getTargetId(), 2);
                }
                return new BrushOffAttackAction(this.attacker.getId(), this.target.getTargetType(), this.target.getId(), 2);
            }
            case 12: {
                if (this.target == null) {
                    return new BrushOffAttackAction(this.attacker.getId(), this.i_target.getTargetType(), this.i_target.getTargetId(), 0);
                }
                return new BrushOffAttackAction(this.attacker.getId(), this.target.getTargetType(), this.target.getId(), 0);
            }
        }
        return null;
    }

    public Vector<AbstractAttackAction> getVector() {
        AbstractAttackAction abstractAttackAction = this.toAction();
        Vector<AbstractAttackAction> vector = new Vector<AbstractAttackAction>();
        if (abstractAttackAction != null) {
            vector.addElement(abstractAttackAction);
        }
        return vector;
    }
}

