/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.event.MechDisplayEvent;
import megamek.client.event.MechDisplayListener;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.Displayable;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.IBoardView;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.TilesetManager;
import megamek.client.ui.AWT.util.ImageCache;
import megamek.client.ui.AWT.util.ImprovedAveragingScaleFilter;
import megamek.client.ui.AWT.util.KeyAlphaFilter;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.client.ui.AWT.util.StraightArrowPolygon;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.LosEffects;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.UnitLocation;
import megamek.common.WeaponResult;
import megamek.common.WeaponType;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.PhysicalAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.event.BoardEvent;
import megamek.common.event.BoardListener;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.preference.IPreferenceChangeListener;
import megamek.common.preference.PreferenceChangeEvent;
import megamek.common.preference.PreferenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardView1
extends Canvas
implements IBoardView,
BoardListener,
MouseListener,
MouseMotionListener,
KeyListener,
AdjustmentListener,
MechDisplayListener,
IPreferenceChangeListener {
    private static final int TRANSPARENT = -65281;
    private static final int HEX_W = 84;
    private static final int HEX_H = 72;
    private static final int HEX_WC = 63;
    private static final float[] ZOOM_FACTORS = new float[]{0.3f, 0.41f, 0.5f, 0.6f, 0.68f, 0.79f, 0.9f, 1.0f};
    private static final int BASE_ZOOM_INDEX = 7;
    private static final int C3_LINE_WIDTH = 1;
    private static Font FONT_7 = new Font("SansSerif", 0, 7);
    private static Font FONT_8 = new Font("SansSerif", 0, 8);
    private static Font FONT_9 = new Font("SansSerif", 0, 9);
    private static Font FONT_10 = new Font("SansSerif", 0, 10);
    private static Font FONT_12 = new Font("SansSerif", 0, 12);
    private Dimension hex_size = null;
    private Font font_hexnum = FONT_10;
    private Font font_elev = FONT_9;
    private Font font_minefield = FONT_12;
    private IGame game;
    private Frame frame;
    private Point mousePos = new Point();
    private Rectangle view = new Rectangle();
    private Point offset = new Point();
    private Dimension boardSize;
    private Scrollbar vScrollbar = null;
    private Scrollbar hScrollbar = null;
    private boolean isScrolling = false;
    private Point scroll = new Point();
    private boolean initCtlScroll;
    private boolean ctlKeyHeld = false;
    private int previousMouseX;
    private int previousMouseY;
    private Image backImage;
    private Dimension backSize;
    private Graphics backGraph;
    private Image boardImage;
    private Rectangle boardRect;
    private Graphics boardGraph;
    private Vector<EntitySprite> entitySprites = new Vector();
    private Hashtable<Integer, EntitySprite> entitySpriteIds = new Hashtable();
    private CursorSprite cursorSprite;
    private CursorSprite highlightSprite;
    private CursorSprite selectedSprite;
    private CursorSprite firstLOSSprite;
    private CursorSprite secondLOSSprite;
    private Vector<StepSprite> pathSprites = new Vector();
    private Vector<AttackSprite> attackSprites = new Vector();
    private Vector<C3Sprite> C3Sprites = new Vector();
    private Window tipWindow;
    private boolean isTipPossible = false;
    private long lastIdle;
    private TilesetManager tileManager = null;
    private Polygon hexPoly;
    private Polygon[] facingPolys;
    private Polygon[] movementPolys;
    private Player localPlayer = null;
    private Player m_plDeployer = null;
    private boolean useLOSTool = true;
    public int zoomIndex;
    private float scale;
    private ImageCache<Image, Image> scaledImageCache = new ImageCache();
    private Vector<Displayable> displayables = new Vector();
    private Vector<MovingUnit> movingUnits = new Vector();
    private long moveWait = 0L;
    private Vector<MovingEntitySprite> movingEntitySprites = new Vector();
    private Hashtable<Integer, MovingEntitySprite> movingEntitySpriteIds = new Hashtable();
    private Vector<GhostEntitySprite> ghostEntitySprites = new Vector();
    protected transient Vector<BoardViewListener> boardListeners = new Vector();
    private Vector<WreckSprite> wreckSprites = new Vector();
    private Coords rulerStart;
    private Coords rulerEnd;
    private Color rulerStartColor;
    private Color rulerEndColor;
    private Point oldMousePosition = null;
    private boolean scrolled = false;
    private Coords lastCursor;
    private Coords highlighted;
    private Coords selected;
    private Coords firstLOS;
    private ClientGUI clientgui;
    private RedrawWorker redrawWorker = new RedrawWorker();
    private Entity selectedEntity = null;
    private Mounted selectedWeapon = null;
    private Hashtable<Coords, Integer> ecmHexes = null;
    private boolean dirtyBoard = true;
    private GameListener gameListener = new GameListenerAdapter(){

        public void gameEntityNew(GameEntityNewEvent gameEntityNewEvent) {
            BoardView1.this.updateEcmList();
            BoardView1.this.redrawAllEntities();
        }

        public void gameEntityRemove(GameEntityRemoveEvent gameEntityRemoveEvent) {
            BoardView1.this.updateEcmList();
            BoardView1.this.redrawAllEntities();
        }

        public void gameEntityChange(GameEntityChangeEvent gameEntityChangeEvent) {
            Vector vector = gameEntityChangeEvent.getMovePath();
            BoardView1.this.updateEcmList();
            if (vector != null && vector.size() > 0 && GUIPreferences.getInstance().getShowMoveStep()) {
                BoardView1.this.addMovingUnit(gameEntityChangeEvent.getEntity(), vector);
            } else {
                BoardView1.this.redrawEntity(gameEntityChangeEvent.getEntity());
            }
        }

        public void gameNewAction(GameNewActionEvent gameNewActionEvent) {
            EntityAction entityAction = gameNewActionEvent.getAction();
            if (entityAction instanceof AttackAction) {
                BoardView1.this.addAttack((AttackAction)entityAction);
            }
        }

        public void gameBoardNew(GameBoardNewEvent gameBoardNewEvent) {
            IBoard iBoard = gameBoardNewEvent.getOldBoard();
            if (iBoard != null) {
                iBoard.removeBoardListener(BoardView1.this);
            }
            if ((iBoard = gameBoardNewEvent.getNewBoard()) != null) {
                iBoard.addBoardListener(BoardView1.this);
            }
            BoardView1.this.updateBoard();
        }

        public void gameBoardChanged(GameBoardChangeEvent gameBoardChangeEvent) {
            BoardView1.this.boardChanged();
        }

        public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
            BoardView1.this.refreshAttacks();
            switch (gamePhaseChangeEvent.getNewPhase()) {
                case 8: 
                case 12: 
                case 14: {
                    BoardView1.this.refreshAttacks();
                    break;
                }
                case 5: {
                    BoardView1.this.clearAllAttacks();
                    break;
                }
                case 16: 
                case 18: {
                    BoardView1.this.clearSprites();
                }
            }
        }
    };

    public BoardView1(IGame iGame, Frame frame) throws IOException {
        this(iGame, frame, null);
    }

    public BoardView1(IGame iGame, Frame frame, ClientGUI clientGUI) throws IOException {
        this.clientgui = clientGUI;
        this.game = iGame;
        this.frame = frame;
        this.tileManager = new TilesetManager(this);
        iGame.addGameListener(this.gameListener);
        iGame.getBoard().addBoardListener(this);
        this.redrawWorker.start();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (GUIPreferences.getInstance().getMouseWheelZoom()) {
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        BoardView1.this.zoomIn();
                    } else {
                        BoardView1.this.zoomOut();
                    }
                }
            }
        });
        this.zoomIndex = GUIPreferences.getInstance().getMapZoomIndex();
        this.checkZoomIndex();
        this.scale = ZOOM_FACTORS[this.zoomIndex];
        this.updateFontSizes();
        this.updateBoardSize();
        this.tipWindow = new Window(frame);
        this.hex_size = new Dimension((int)(84.0f * this.scale), (int)(72.0f * this.scale));
        this.initPolys();
        this.cursorSprite = new CursorSprite(Color.cyan);
        this.highlightSprite = new CursorSprite(Color.white);
        this.selectedSprite = new CursorSprite(Color.blue);
        this.firstLOSSprite = new CursorSprite(Color.red);
        this.secondLOSSprite = new CursorSprite(Color.red);
        PreferenceManager.getClientPreferences().addPreferenceChangeListener(this);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getName().equals("MapTileset")) {
            this.updateBoard();
        }
    }

    @Override
    public void addBoardViewListener(BoardViewListener boardViewListener) {
        if (!this.boardListeners.contains(boardViewListener)) {
            this.boardListeners.addElement(boardViewListener);
        }
    }

    @Override
    public void removeBoardViewListener(BoardViewListener boardViewListener) {
        this.boardListeners.removeElement(boardViewListener);
    }

    @Override
    public void processBoardViewEvent(BoardViewEvent boardViewEvent) {
        if (this.boardListeners == null) {
            return;
        }
        for (BoardViewListener boardViewListener : this.boardListeners) {
            switch (boardViewEvent.getType()) {
                case 0: 
                case 1: 
                case 2: {
                    boardViewListener.hexMoused(boardViewEvent);
                    break;
                }
                case 3: {
                    boardViewListener.hexCursor(boardViewEvent);
                    break;
                }
                case 4: {
                    boardViewListener.boardHexHighlighted(boardViewEvent);
                    break;
                }
                case 5: {
                    boardViewListener.hexSelected(boardViewEvent);
                    break;
                }
                case 6: {
                    boardViewListener.firstLOSHex(boardViewEvent);
                    break;
                }
                case 7: {
                    boardViewListener.secondLOSHex(boardViewEvent, this.getFirstLOS());
                    break;
                }
                case 8: {
                    boardViewListener.finishedMovingUnits(boardViewEvent);
                    break;
                }
                case 9: {
                    boardViewListener.unitSelected(boardViewEvent);
                }
            }
        }
    }

    private void addMovingUnit(Entity entity, Vector vector) {
        if (!vector.isEmpty()) {
            MovingUnit movingUnit = new MovingUnit(entity, vector);
            this.movingUnits.addElement(movingUnit);
            GhostEntitySprite ghostEntitySprite = new GhostEntitySprite(entity);
            this.ghostEntitySprites.add(ghostEntitySprite);
            UnitLocation unitLocation = (UnitLocation)vector.elementAt(0);
            this.centerOnHex(unitLocation.getCoords());
        }
    }

    public void addDisplayable(Displayable displayable) {
        this.displayables.addElement(displayable);
    }

    public void removeDisplayable(Displayable displayable) {
        this.displayables.removeElement(displayable);
    }

    public void setScrollbars(Scrollbar scrollbar, Scrollbar scrollbar2) {
        this.vScrollbar = scrollbar;
        this.hScrollbar = scrollbar2;
        this.vScrollbar.addAdjustmentListener(this);
        this.hScrollbar.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Point point = this.scroll;
        Point point2 = new Point(point.x, point.y);
        if (adjustmentEvent.getAdjustable().getOrientation() == 1) {
            point2.y = adjustmentEvent.getValue();
        } else {
            point2.x = adjustmentEvent.getValue();
        }
        this.scroll.setLocation(point2);
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public synchronized void update(Graphics graphics) {
        Object object;
        Dimension dimension = this.getSize();
        if (null != this.vScrollbar) {
            this.vScrollbar.setVisibleAmount(dimension.height);
            this.vScrollbar.setBlockIncrement(dimension.height);
            this.vScrollbar.setUnitIncrement((int)((double)(this.scale * 72.0f) / 2.0));
            this.vScrollbar.setMaximum(this.boardSize.height);
        }
        if (null != this.hScrollbar) {
            this.hScrollbar.setVisibleAmount(dimension.width);
            this.hScrollbar.setBlockIncrement(dimension.width);
            this.hScrollbar.setUnitIncrement((int)((double)(this.scale * 84.0f) / 2.0));
            this.hScrollbar.setMaximum(this.boardSize.width);
        }
        this.view.setLocation(this.scroll);
        this.view.setSize(this.getOptimalView(dimension));
        this.offset.setLocation(this.getOptimalOffset(dimension));
        if (!this.isTileImagesLoaded()) {
            graphics.drawString(Messages.getString("BoardView1.loadingImages"), 20, 50);
            if (!this.tileManager.isStarted()) {
                System.out.println("boardview1: loading images for board");
                this.tileManager.loadNeededImages(this.game);
            }
            return;
        }
        if (this.backGraph == null || !this.view.getSize().equals(this.backSize)) {
            this.backSize = this.view.getSize();
            this.backImage = this.createImage(this.backSize.width, this.backSize.height);
            this.backGraph = this.backImage.getGraphics();
        }
        if (this.boardImage == null || !this.boardRect.union(this.view).equals(this.boardRect) || this.dirtyBoard) {
            this.updateBoardImage();
        }
        this.backGraph.drawImage(this.boardImage, 0, 0, this);
        if (GUIPreferences.getInstance().getShowWrecks()) {
            this.drawSprites(this.wreckSprites);
        }
        this.drawMinefields();
        this.drawArtilleryHexes();
        this.drawSprite(this.highlightSprite);
        this.drawSprite(this.cursorSprite);
        this.drawSprite(this.selectedSprite);
        this.drawSprite(this.firstLOSSprite);
        this.drawSprite(this.secondLOSSprite);
        if (this.m_plDeployer != null) {
            this.drawDeployment();
        }
        this.drawSprites(this.C3Sprites);
        this.drawSprites(this.entitySprites);
        this.drawSprites(this.movingEntitySprites);
        this.drawSprites(this.ghostEntitySprites);
        this.drawSprites(this.attackSprites);
        this.drawSprites(this.pathSprites);
        if (this.rulerStart != null) {
            Point point = this.getCentreHexLocation(this.rulerStart);
            if (this.rulerEnd != null) {
                object = this.getCentreHexLocation(this.rulerEnd);
                this.backGraph.setColor(Color.yellow);
                this.backGraph.drawLine(point.x - this.boardRect.x, point.y - this.boardRect.y, ((Point)object).x - this.boardRect.x, ((Point)object).y - this.boardRect.y);
                this.backGraph.setColor(this.rulerEndColor);
                this.backGraph.fillRect(((Point)object).x - this.boardRect.x - 1, ((Point)object).y - this.boardRect.y - 1, 2, 2);
            }
            this.backGraph.setColor(this.rulerStartColor);
            this.backGraph.fillRect(point.x - this.boardRect.x - 1, point.y - this.boardRect.y - 1, 2, 2);
        }
        for (int i = 0; i < this.displayables.size(); ++i) {
            object = this.displayables.elementAt(i);
            object.draw(this.backGraph, this.backSize);
        }
        if (this.scale < 1.0f) {
            Image image = this.createImage(dimension.width, dimension.height);
            object = image.getGraphics();
            ((Graphics)object).drawImage(this.backImage, this.offset.x, this.offset.y, this);
            graphics.drawImage(image, 0, 0, this);
            ((Graphics)object).dispose();
        } else {
            graphics.drawImage(this.backImage, this.offset.x, this.offset.y, this);
        }
    }

    private void updateBoardSize() {
        int n = this.game.getBoard().getWidth() * (int)(63.0f * this.scale) + (int)(21.0f * this.scale);
        int n2 = this.game.getBoard().getHeight() * (int)(72.0f * this.scale) + (int)(36.0f * this.scale);
        this.boardSize = new Dimension(n, n2);
    }

    private Dimension getOptimalView(Dimension dimension) {
        return new Dimension(Math.min(dimension.width, this.boardSize.width), Math.min(dimension.height, this.boardSize.height));
    }

    private Point getOptimalOffset(Dimension dimension) {
        int n = 0;
        int n2 = 0;
        if (dimension.width > this.boardSize.width) {
            n = (dimension.width - this.boardSize.width) / 2;
        }
        if (dimension.height > this.boardSize.height) {
            n2 = (dimension.height - this.boardSize.height) / 2;
        }
        return new Point(n, n2);
    }

    private void repaintBounds(Rectangle rectangle) {
        if (this.view != null) {
            this.repaint(rectangle.x - this.view.x + this.offset.x, rectangle.y - this.view.y + this.offset.y, rectangle.width, rectangle.height);
        }
    }

    private synchronized void drawSprites(Vector<? extends Sprite> vector) {
        for (Sprite sprite : vector) {
            this.drawSprite(sprite);
        }
    }

    private final void drawSprite(Sprite sprite) {
        if (this.view.intersects(sprite.getBounds()) && !sprite.hidden) {
            int n = sprite.getBounds().x - this.view.x;
            int n2 = sprite.getBounds().y - this.view.y;
            if (!sprite.isReady()) {
                sprite.prepare();
            }
            sprite.drawOnto(this.backGraph, n, n2, this);
        }
    }

    private Image getScaledImage(Image image) {
        if (image == null) {
            return null;
        }
        if (this.zoomIndex == 7) {
            return image;
        }
        Image image2 = this.scaledImageCache.get(image);
        if (image2 == null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            if (image.getWidth(null) == -1 || image.getHeight(null) == -1) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                mediaTracker.removeImage(image);
            }
            int n = (int)((float)image.getWidth(null) * this.scale);
            int n2 = (int)((float)image.getHeight(null) * this.scale);
            image2 = this.scale(image, n, n2);
            mediaTracker.addImage(image2, 1);
            try {
                mediaTracker.waitForID(1);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            mediaTracker.removeImage(image2);
            this.scaledImageCache.put(image, image2);
        }
        return image2;
    }

    private Image scale(Image image, int n, int n2) {
        ImprovedAveragingScaleFilter improvedAveragingScaleFilter = new ImprovedAveragingScaleFilter(image.getWidth(null), image.getHeight(null), n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), improvedAveragingScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    private void drawDeployment() {
        int n = this.view.x / (int)(63.0f * this.scale) - 1;
        int n2 = this.view.y / (int)(72.0f * this.scale) - 1;
        int n3 = this.view.width / (int)(63.0f * this.scale) + 3;
        int n4 = this.view.height / (int)(72.0f * this.scale) + 3;
        IBoard iBoard = this.game.getBoard();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                Coords coords = new Coords(j + n, i + n2);
                Point point = this.getHexLocation(coords);
                point.translate(-this.view.x, -this.view.y);
                if (!iBoard.isLegalDeployment(coords, this.m_plDeployer)) continue;
                this.backGraph.setColor(Color.yellow);
                int[] nArray = new int[]{point.x + (int)(21.0f * this.scale), point.x + (int)(62.0f * this.scale), point.x + (int)(83.0f * this.scale), point.x + (int)(83.0f * this.scale), point.x + (int)(62.0f * this.scale), point.x + (int)(21.0f * this.scale), point.x, point.x};
                int[] nArray2 = new int[]{point.y, point.y, point.y + (int)(35.0f * this.scale), point.y + (int)(36.0f * this.scale), point.y + (int)(71.0f * this.scale), point.y + (int)(71.0f * this.scale), point.y + (int)(36.0f * this.scale), point.y + (int)(35.0f * this.scale)};
                this.backGraph.drawPolygon(nArray, nArray2, 8);
            }
        }
    }

    private Mounted getSelectedArtilleryWeapon() {
        if (this.selectedEntity == null || this.selectedWeapon == null) {
            return null;
        }
        if (this.clientgui != null && !this.selectedEntity.getOwner().equals(this.clientgui.getClient().getLocalPlayer())) {
            return null;
        }
        if (this.selectedEntity.getEquipmentNum(this.selectedWeapon) == -1) {
            return null;
        }
        if (!(this.selectedWeapon.getType() instanceof WeaponType) || !this.selectedWeapon.getType().hasFlag(65536L)) {
            return null;
        }
        return this.selectedWeapon;
    }

    private void drawArtilleryHexes() {
        Mounted mounted = this.getSelectedArtilleryWeapon();
        if (this.game.getArtillerySize() == 0 && mounted == null) {
            return;
        }
        int n = this.view.x / (int)(63.0f * this.scale) - 1;
        int n2 = this.view.y / (int)(72.0f * this.scale) - 1;
        int n3 = this.view.width / (int)(63.0f * this.scale) + 3;
        int n4 = this.view.height / (int)(72.0f * this.scale) + 3;
        IBoard iBoard = this.game.getBoard();
        for (int i = 0; i < n4; ++i) {
            block1: for (int j = 0; j < n3; ++j) {
                Image image;
                Coords coords = new Coords(j + n, i + n2);
                Point point = this.getHexLocation(coords);
                point.translate(-this.view.x, -this.view.y);
                if (!iBoard.contains(coords)) continue;
                if (mounted != null) {
                    int n5 = 0;
                    n5 = this.selectedEntity.getOwner().getArtyAutoHitHexes().contains(coords) ? Integer.MIN_VALUE : this.selectedEntity.aTracker.getModifier(mounted, coords);
                    if (n5 != 0) {
                        image = n5 == Integer.MIN_VALUE ? this.getScaledImage(this.tileManager.getArtilleryTarget(0)) : this.getScaledImage(this.tileManager.getArtilleryTarget(1));
                        this.backGraph.drawImage(image, point.x, point.y, this);
                    }
                }
                Enumeration enumeration = this.game.getArtilleryAttacks();
                while (enumeration.hasMoreElements()) {
                    ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
                    if (!artilleryAttackAction.getWR().waa.getTarget(this.game).getPosition().equals(coords)) continue;
                    image = this.getScaledImage(this.tileManager.getArtilleryTarget(2));
                    this.backGraph.drawImage(image, point.x, point.y, this);
                    continue block1;
                }
            }
        }
    }

    private Vector<ArtilleryAttackAction> getArtilleryAttacksAtLocation(Coords coords) {
        Vector<ArtilleryAttackAction> vector = new Vector<ArtilleryAttackAction>();
        Enumeration enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            if (!artilleryAttackAction.getWR().waa.getTarget(this.game).getPosition().equals(coords)) continue;
            vector.addElement(artilleryAttackAction);
        }
        return vector;
    }

    private void drawMinefields() {
        int n = this.view.x / (int)(63.0f * this.scale) - 1;
        int n2 = this.view.y / (int)(72.0f * this.scale) - 1;
        int n3 = this.view.width / (int)(63.0f * this.scale) + 3;
        int n4 = this.view.height / (int)(72.0f * this.scale) + 3;
        IBoard iBoard = this.game.getBoard();
        for (int i = 0; i < n4; ++i) {
            block9: for (int j = 0; j < n3; ++j) {
                Coords coords = new Coords(j + n, i + n2);
                Point point = this.getHexLocation(coords);
                point.translate(-this.view.x, -this.view.y);
                if (!iBoard.contains(coords) || !this.game.containsMinefield(coords)) continue;
                Minefield minefield = (Minefield)this.game.getMinefields(coords).elementAt(0);
                Image image = this.getScaledImage(this.tileManager.getMinefieldSign());
                this.backGraph.drawImage(image, point.x + (int)(13.0f * this.scale), point.y + (int)(13.0f * this.scale), this);
                this.backGraph.setColor(Color.black);
                int n5 = this.game.getNbrMinefields(coords);
                if (n5 > 1) {
                    this.drawCenteredString(Messages.getString("BoardView1.Multiple"), point.x, point.y + (int)(51.0f * this.scale), this.font_minefield, this.backGraph);
                    continue;
                }
                if (n5 != 1) continue;
                switch (minefield.getType()) {
                    case 0: {
                        this.drawCenteredString(Messages.getString("BoardView1.Conventional"), point.x, point.y + (int)(51.0f * this.scale), this.font_minefield, this.backGraph);
                        continue block9;
                    }
                    case 3: {
                        this.drawCenteredString(Messages.getString("BoardView1.Thunder") + minefield.getDamage() + ")", point.x, point.y + (int)(51.0f * this.scale), this.font_minefield, this.backGraph);
                        continue block9;
                    }
                    case 4: {
                        this.drawCenteredString(Messages.getString("BoardView1.Thunder-Inf") + minefield.getDamage() + ")", point.x, point.y + (int)(51.0f * this.scale), this.font_minefield, this.backGraph);
                        continue block9;
                    }
                    case 5: {
                        this.drawCenteredString(Messages.getString("BoardView1.Thunder-Actv") + minefield.getDamage() + ")", point.x, point.y + (int)(51.0f * this.scale), this.font_minefield, this.backGraph);
                        continue block9;
                    }
                    case 1: {
                        this.drawCenteredString(Messages.getString("BoardView1.Command-"), point.x, point.y + (int)(51.0f * this.scale), this.font_minefield, this.backGraph);
                        this.drawCenteredString(Messages.getString("BoardView1.detonated"), point.x, point.y + (int)(60.0f * this.scale), this.font_minefield, this.backGraph);
                        continue block9;
                    }
                    case 2: {
                        this.drawCenteredString(Messages.getString("BoardView1.Vibrabomb"), point.x, point.y + (int)(51.0f * this.scale), this.font_minefield, this.backGraph);
                        if (minefield.getPlayerId() != this.localPlayer.getId()) continue block9;
                        this.drawCenteredString("(" + minefield.getSetting() + ")", point.x, point.y + (int)(60.0f * this.scale), this.font_minefield, this.backGraph);
                    }
                }
            }
        }
    }

    private void drawCenteredString(String string, int n, int n2, Font font, Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n3 = fontMetrics.stringWidth(string);
        graphics.setFont(font);
        graphics.drawString(string, n += (this.hex_size.width - n3) / 2, n2);
    }

    private void updateBoardImage() {
        if (this.boardGraph == null || this.view.width > this.boardRect.width || this.view.height > this.boardRect.height) {
            this.boardImage = this.createImage(this.view.width, this.view.height);
            if (this.boardGraph != null) {
                this.boardGraph.dispose();
            }
            this.boardGraph = this.boardImage.getGraphics();
            this.checkScrollBounds();
            this.boardRect = new Rectangle(this.view);
            System.out.println("boardview1: made a new board buffer " + this.boardRect);
            this.drawHexes(this.view);
            this.dirtyBoard = false;
        }
        if (!this.boardRect.union(this.view).equals(this.boardRect) || this.dirtyBoard) {
            this.moveBoardImage();
        }
    }

    public Image getEntireBoardImage() {
        Image image = this.createImage(this.boardSize.width, this.boardSize.height);
        Graphics graphics = this.boardImage.getGraphics();
        this.boardGraph = image.getGraphics();
        this.drawHexes(new Rectangle(this.boardSize));
        this.boardGraph.dispose();
        this.boardGraph = graphics;
        return image;
    }

    private void moveBoardImage() {
        this.boardGraph.setClip(0, 0, this.boardRect.width, this.boardRect.height);
        this.boardGraph.copyArea(0, 0, this.boardRect.width, this.boardRect.height, this.boardRect.x - this.view.x, this.boardRect.y - this.view.y);
        int n = Math.max(this.view.x, this.boardRect.x);
        int n2 = this.view.width - Math.abs(this.view.x - this.boardRect.x);
        Rectangle rectangle = new Rectangle(this.view.x, this.view.y, this.boardRect.x - this.view.x, this.view.height);
        Rectangle rectangle2 = new Rectangle(this.boardRect.x + this.boardRect.width, this.view.y, this.view.x - this.boardRect.x, this.view.height);
        Rectangle rectangle3 = new Rectangle(n, this.view.y, n2, this.boardRect.y - this.view.y);
        Rectangle rectangle4 = new Rectangle(n, this.boardRect.y + this.boardRect.height, n2, this.view.y - this.boardRect.y);
        this.boardRect = new Rectangle(this.view);
        if (this.dirtyBoard) {
            this.drawHexes(this.view);
            this.dirtyBoard = false;
        } else {
            if (rectangle.width > 0) {
                this.drawHexes(rectangle);
            } else if (rectangle2.width > 0) {
                this.drawHexes(rectangle2);
            }
            if (rectangle3.height > 0) {
                this.drawHexes(rectangle3);
            } else if (rectangle4.height > 0) {
                this.drawHexes(rectangle4);
            }
        }
    }

    private void drawHexes(Rectangle rectangle) {
        int n = (int)((float)rectangle.x / (63.0f * this.scale)) - 1;
        int n2 = (int)((float)rectangle.y / (72.0f * this.scale)) - 1;
        int n3 = (int)((float)rectangle.width / (63.0f * this.scale)) + 3;
        int n4 = (int)((float)rectangle.height / (72.0f * this.scale)) + 3;
        this.boardGraph.setClip(rectangle.x - this.boardRect.x, rectangle.y - this.boardRect.y, rectangle.width, rectangle.height);
        if ((float)rectangle.x < 21.0f * this.scale) {
            this.boardGraph.clearRect(rectangle.x - this.boardRect.x, rectangle.y - this.boardRect.y, (int)(21.0f * this.scale) - rectangle.x, rectangle.height);
        }
        if ((float)rectangle.y < 36.0f * this.scale) {
            this.boardGraph.clearRect(rectangle.x - this.boardRect.x, rectangle.y - this.boardRect.y, rectangle.width, (int)(36.0f * this.scale) - rectangle.y);
        }
        if ((float)rectangle.x > (float)(this.boardSize.width - this.view.width) - 21.0f * this.scale) {
            this.boardGraph.clearRect(this.boardRect.width - (int)(21.0f * this.scale), rectangle.y - this.boardRect.y, (int)(21.0f * this.scale), rectangle.height);
        }
        if (rectangle.y > this.boardSize.height - this.view.height - (int)(36.0f * this.scale)) {
            this.boardGraph.clearRect(rectangle.x - this.boardRect.x, this.boardRect.height - (int)(36.0f * this.scale), rectangle.width, (int)(36.0f * this.scale));
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.drawHex(new Coords(j + n, i + n2));
            }
        }
    }

    private void redrawAround(Coords coords) {
        this.boardGraph.setClip(0, 0, this.boardRect.width, this.boardRect.height);
        this.drawHex(coords);
        this.drawHex(coords.translated(0));
        this.drawHex(coords.translated(1));
        this.drawHex(coords.translated(2));
        this.drawHex(coords.translated(3));
        this.drawHex(coords.translated(4));
        this.drawHex(coords.translated(5));
    }

    private void drawHex(Coords coords) {
        Object object;
        if (!this.game.getBoard().contains(coords)) {
            return;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        Point point = this.getHexLocation(coords);
        int n = iHex.getElevation();
        int n2 = iHex.depth();
        int n3 = Math.max(iHex.terrainLevel(12), iHex.terrainLevel(16));
        int n4 = point.x - this.boardRect.x;
        int n5 = point.y - this.boardRect.y;
        Image image = this.tileManager.baseFor(iHex);
        Image image2 = this.getScaledImage(image);
        this.boardGraph.drawImage(image2, n4, n5, this);
        if (this.tileManager.supersFor(iHex) != null) {
            object = this.tileManager.supersFor(iHex).iterator();
            while (object.hasNext()) {
                image2 = this.getScaledImage((Image)object.next());
                this.boardGraph.drawImage(image2, n4, n5, this);
            }
        }
        if (this.ecmHexes != null && (object = this.ecmHexes.get(coords)) != null) {
            image2 = this.getScaledImage(this.tileManager.getEcmShade((Integer)object));
            this.boardGraph.drawImage(image2, n4, n5, this);
        }
        if (GUIPreferences.getInstance().getBoolean("AdvancedDarkenMapAtNight") && this.game.getOptions().booleanOption("night_battle") && !this.game.isPositionIlluminated(coords)) {
            image2 = this.getScaledImage(this.tileManager.getNightFog());
            this.boardGraph.drawImage(image2, n4, n5, this);
        }
        this.boardGraph.setColor(GUIPreferences.getInstance().getMapTextColor());
        if ((double)this.scale >= 0.5) {
            this.drawCenteredString(coords.getBoardNum(), n4, n5 + (int)(12.0f * this.scale), this.font_hexnum, this.boardGraph);
        }
        if (this.zoomIndex > 3) {
            int n6 = 70;
            if (n != 0) {
                this.drawCenteredString(Messages.getString("BoardView1.LEVEL") + n, n4, n5 + (int)((float)n6 * this.scale), this.font_elev, this.boardGraph);
                n6 -= 10;
            }
            if (n2 != 0) {
                this.drawCenteredString(Messages.getString("BoardView1.DEPTH") + n2, n4, n5 + (int)((float)n6 * this.scale), this.font_elev, this.boardGraph);
                n6 -= 10;
            }
            if (n3 > 0) {
                this.boardGraph.setColor(GUIPreferences.getInstance().getColor("AdvancedBuildingTextColor"));
                this.drawCenteredString(Messages.getString("BoardView1.HEIGHT") + n3, n4, n5 + (int)((float)n6 * this.scale), this.font_elev, this.boardGraph);
                n6 -= 10;
            }
        }
        this.boardGraph.setColor(Color.black);
        if (this.drawElevationLine(coords, 0)) {
            this.boardGraph.drawLine(n4 + (int)(21.0f * this.scale), n5, n4 + (int)(62.0f * this.scale), n5);
        }
        if (this.drawElevationLine(coords, 1)) {
            this.boardGraph.drawLine(n4 + (int)(62.0f * this.scale), n5, n4 + (int)(83.0f * this.scale), n5 + (int)(35.0f * this.scale));
        }
        if (this.drawElevationLine(coords, 2)) {
            this.boardGraph.drawLine(n4 + (int)(83.0f * this.scale), n5 + (int)(36.0f * this.scale), n4 + (int)(62.0f * this.scale), n5 + (int)(71.0f * this.scale));
        }
        if (this.drawElevationLine(coords, 3)) {
            this.boardGraph.drawLine(n4 + (int)(62.0f * this.scale), n5 + (int)(71.0f * this.scale), n4 + (int)(21.0f * this.scale), n5 + (int)(71.0f * this.scale));
        }
        if (this.drawElevationLine(coords, 4)) {
            this.boardGraph.drawLine(n4 + (int)(21.0f * this.scale), n5 + (int)(71.0f * this.scale), n4, n5 + (int)(36.0f * this.scale));
        }
        if (this.drawElevationLine(coords, 5)) {
            this.boardGraph.drawLine(n4, n5 + (int)(35.0f * this.scale), n4 + (int)(21.0f * this.scale), n5);
        }
        if (GUIPreferences.getInstance().getShowMapsheets()) {
            this.boardGraph.setColor(GUIPreferences.getInstance().getColor("AdvancedMapsheetColor"));
            if (coords.x % 16 == 0) {
                this.boardGraph.drawLine(n4 + (int)(21.0f * this.scale), n5 + (int)(71.0f * this.scale), n4, n5 + (int)(36.0f * this.scale));
                this.boardGraph.drawLine(n4, n5 + (int)(35.0f * this.scale), n4 + (int)(21.0f * this.scale), n5);
            } else if (coords.x % 16 == 15) {
                this.boardGraph.drawLine(n4 + (int)(62.0f * this.scale), n5, n4 + (int)(83.0f * this.scale), n5 + (int)(35.0f * this.scale));
                this.boardGraph.drawLine(n4 + (int)(83.0f * this.scale), n5 + (int)(36.0f * this.scale), n4 + (int)(62.0f * this.scale), n5 + (int)(71.0f * this.scale));
            }
            if (coords.y % 17 == 0) {
                this.boardGraph.drawLine(n4 + (int)(21.0f * this.scale), n5, n4 + (int)(62.0f * this.scale), n5);
                if (coords.x % 2 == 0) {
                    this.boardGraph.drawLine(n4 + (int)(62.0f * this.scale), n5, n4 + (int)(83.0f * this.scale), n5 + (int)(35.0f * this.scale));
                    this.boardGraph.drawLine(n4, n5 + (int)(35.0f * this.scale), n4 + (int)(21.0f * this.scale), n5);
                }
            } else if (coords.y % 17 == 16) {
                this.boardGraph.drawLine(n4 + (int)(62.0f * this.scale), n5 + (int)(71.0f * this.scale), n4 + (int)(21.0f * this.scale), n5 + (int)(71.0f * this.scale));
                if (coords.x % 2 == 1) {
                    this.boardGraph.drawLine(n4 + (int)(83.0f * this.scale), n5 + (int)(36.0f * this.scale), n4 + (int)(62.0f * this.scale), n5 + (int)(71.0f * this.scale));
                    this.boardGraph.drawLine(n4 + (int)(21.0f * this.scale), n5 + (int)(71.0f * this.scale), n4, n5 + (int)(36.0f * this.scale));
                }
            }
            this.boardGraph.setColor(Color.black);
        }
    }

    private final boolean drawElevationLine(Coords coords, int n) {
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHexInDir(coords, n);
        return iHex2 != null && iHex.floor() != iHex2.floor();
    }

    private Point getHexLocation(int n, int n2) {
        return new Point(n * (int)(63.0f * this.scale), n2 * (int)(72.0f * this.scale) + ((n & 1) == 1 ? (int)(36.0f * this.scale) : 0));
    }

    private Point getHexLocation(Coords coords) {
        return this.getHexLocation(coords.x, coords.y);
    }

    private Point getCentreHexLocation(int n, int n2) {
        Point point = this.getHexLocation(n, n2);
        point.x = (int)((float)point.x + 42.0f * this.scale);
        point.y = (int)((float)point.y + 36.0f * this.scale);
        return point;
    }

    private Point getCentreHexLocation(Coords coords) {
        return this.getCentreHexLocation(coords.x, coords.y);
    }

    Coords getCoordsAt(Point point) {
        int n = (point.x + this.scroll.x - this.offset.x) / (int)(63.0f * this.scale);
        int n2 = (point.y + this.scroll.y - this.offset.y - ((n & 1) == 1 ? (int)(36.0f * this.scale) : 0)) / (int)(72.0f * this.scale);
        return new Coords(n, n2);
    }

    private void showTooltip() {
        try {
            Point point = new Point(this.getLocationOnScreen());
            String[] stringArray = this.getTipText(this.mousePos);
            if (stringArray == null) {
                return;
            }
            this.tipWindow.removeAll();
            this.tipWindow.add(new TooltipCanvas(stringArray));
            this.tipWindow.pack();
            point.translate(this.mousePos.x, this.mousePos.y + 20);
            if (this.frame.getLocation().x + this.frame.getSize().width < point.x + this.tipWindow.getSize().width + 10) {
                point.x = this.frame.getSize().width > this.tipWindow.getSize().width ? (point.x -= point.x + this.tipWindow.getSize().width + 10 - this.frame.getSize().width - this.frame.getLocation().x) : this.getLocationOnScreen().x + this.hex_size.width;
            }
            this.tipWindow.setLocation(point);
            this.tipWindow.setVisible(true);
        }
        catch (Exception exception) {
            this.tipWindow = new Window(this.frame);
        }
    }

    private String[] getTipText(Point point) {
        Object object;
        Object object2;
        int n = 0;
        IHex iHex = null;
        Coords coords = this.getCoordsAt(point);
        if (GUIPreferences.getInstance().getShowMapHexPopup() && this.game.getBoard().contains(coords)) {
            iHex = this.game.getBoard().getHex(coords);
            ++n;
        }
        for (EntitySprite object32 : this.entitySprites) {
            if (!object32.isInside(point)) continue;
            n += 3;
        }
        for (AttackSprite attackSprite : this.attackSprites) {
            if (!attackSprite.isInside(point)) continue;
            n += 1 + attackSprite.weaponDescs.size();
        }
        if (iHex != null) {
            if (iHex.containsTerrain(3)) {
                ++n;
            }
            if (iHex.containsTerrain(10)) {
                ++n;
            }
            if (iHex.containsTerrain(32)) {
                ++n;
            }
            if (iHex.containsTerrain(14)) {
                ++n;
            }
            if (iHex.containsTerrain(23)) {
                ++n;
            } else if (iHex.containsTerrain(1)) {
                ++n;
            }
            if (iHex.containsTerrain(20)) {
                ++n;
            }
        }
        n += this.game.getNbrMinefields(coords);
        Vector<ArtilleryAttackAction> vector = this.getArtilleryAttacksAtLocation(coords);
        n += vector.size();
        Mounted mounted = this.getSelectedArtilleryWeapon();
        if (mounted != null) {
            ++n;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        if (iHex != null) {
            int i;
            int vector2;
            stringArray[n2] = Messages.getString("BoardView1.Hex") + coords.getBoardNum() + Messages.getString("BoardView1.level") + iHex.getElevation();
            ++n2;
            if (iHex.containsTerrain(23)) {
                vector2 = iHex.getTerrain(23).getLevel();
                i = iHex.getTerrain(23).getTerrainFactor();
                stringArray[n2] = vector2 == 1 ? Messages.getString("BoardView1.TipLightJungle", new Object[]{i}) : (vector2 == 2 ? Messages.getString("BoardView1.TipHeavyJungle", new Object[]{i}) : (vector2 == 3 ? Messages.getString("BoardView1.TipUltraJungle", new Object[]{i}) : Messages.getString("BoardView1.TipJungle", new Object[]{i})));
                ++n2;
            } else if (iHex.containsTerrain(1)) {
                vector2 = iHex.getTerrain(1).getLevel();
                i = iHex.getTerrain(1).getTerrainFactor();
                stringArray[n2] = vector2 == 1 ? Messages.getString("BoardView1.TipLightWoods", new Object[]{i}) : (vector2 == 2 ? Messages.getString("BoardView1.TipHeavyWoods", new Object[]{i}) : (vector2 == 3 ? Messages.getString("BoardView1.TipUltraWoods", new Object[]{i}) : Messages.getString("BoardView1.TipWoods", new Object[]{i})));
                ++n2;
            }
            if (iHex.containsTerrain(20)) {
                vector2 = iHex.getTerrain(1).getTerrainFactor();
                stringArray[n2] = Messages.getString("BoardView1.TipIce", new Object[]{vector2});
                ++n2;
            }
            if (iHex.containsTerrain(3)) {
                stringArray[n2] = Messages.getString("BoardView1.Rubble");
                ++n2;
            }
            if (iHex.containsTerrain(32) || iHex.containsTerrain(10)) {
                Building iterator = this.game.getBoard().getBuildingAt(coords);
                StringBuffer entitySprite = new StringBuffer(Messages.getString("BoardView1.Height"));
                entitySprite.append(iHex.terrainLevel(12));
                entitySprite.append(" ");
                entitySprite.append(iterator.toString());
                entitySprite.append(Messages.getString("BoardView1.CF"));
                entitySprite.append(iterator.getCurrentCF());
                stringArray[n2] = entitySprite.toString();
                ++n2;
            }
            if (iHex.containsTerrain(14)) {
                Building n5 = this.game.getBoard().getBuildingAt(coords);
                StringBuffer attackSprite = new StringBuffer(Messages.getString("BoardView1.Height"));
                attackSprite.append(iHex.terrainLevel(16));
                attackSprite.append(" ");
                attackSprite.append(n5.toString());
                attackSprite.append(Messages.getString("BoardView1.CF"));
                attackSprite.append(n5.getCurrentCF());
                stringArray[n2] = attackSprite.toString();
                ++n2;
            }
            if (this.game.containsMinefield(coords)) {
                Vector vector3 = this.game.getMinefields(coords);
                for (int artilleryAttackAction = 0; artilleryAttackAction < vector3.size(); ++artilleryAttackAction) {
                    object2 = (Minefield)vector3.elementAt(artilleryAttackAction);
                    object = " (" + this.game.getPlayer(((Minefield)object2).getPlayerId()).getName() + ")";
                    switch (((Minefield)object2).getType()) {
                        case 0: {
                            stringArray[n2] = ((Minefield)object2).getName() + Messages.getString("BoardView1.minefield") + " " + (String)object;
                            break;
                        }
                        case 3: {
                            stringArray[n2] = ((Minefield)object2).getName() + Messages.getString("BoardView1.minefield") + "(" + ((Minefield)object2).getDamage() + ")" + (String)object;
                            break;
                        }
                        case 1: {
                            stringArray[n2] = ((Minefield)object2).getName() + Messages.getString("BoardView1.minefield") + " " + (String)object;
                            break;
                        }
                        case 2: {
                            if (((Minefield)object2).getPlayerId() == this.localPlayer.getId()) {
                                stringArray[n2] = ((Minefield)object2).getName() + Messages.getString("BoardView1.minefield") + "(" + ((Minefield)object2).getSetting() + ") " + (String)object;
                                break;
                            }
                            stringArray[n2] = ((Minefield)object2).getName() + Messages.getString("BoardView1.minefield") + " " + (String)object;
                            break;
                        }
                        case 5: {
                            stringArray[n2] = ((Minefield)object2).getName() + Messages.getString("BoardView1.minefield") + "(" + ((Minefield)object2).getDamage() + ")" + (String)object;
                            break;
                        }
                        case 4: {
                            stringArray[n2] = ((Minefield)object2).getName() + Messages.getString("BoardView1.minefield") + "(" + ((Minefield)object2).getDamage() + ")" + (String)object;
                        }
                    }
                    ++n2;
                }
            }
        }
        for (EntitySprite entitySprite : this.entitySprites) {
            if (!entitySprite.isInside(point)) continue;
            object2 = entitySprite.getTooltip();
            System.arraycopy(object2, 0, stringArray, n2, ((String[])object2).length);
            n2 += ((String[])object2).length;
        }
        for (AttackSprite attackSprite : this.attackSprites) {
            if (!attackSprite.isInside(point)) continue;
            object2 = attackSprite.getTooltip();
            System.arraycopy(object2, 0, stringArray, n2, ((String[])object2).length);
            n2 += 1 + attackSprite.weaponDescs.size();
        }
        Iterator<Sprite> iterator = vector.iterator();
        while (iterator.hasNext()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)((Object)iterator.next());
            object2 = artilleryAttackAction.getWR();
            object = this.game.getEntity(((WeaponResult)object2).waa.getEntityId());
            String string = null;
            if (object != null && ((WeaponResult)object2).waa.getWeaponId() > -1) {
                Mounted mounted2 = ((Entity)object).getEquipment(((WeaponResult)object2).waa.getWeaponId());
                string = mounted2.getName();
                if (((WeaponResult)object2).waa.getAmmoId() > -1) {
                    Mounted mounted3 = ((Entity)object).getEquipment(((WeaponResult)object2).waa.getAmmoId());
                    string = string + "(" + mounted3.getName() + ")";
                }
            }
            if (string == null) {
                string = Messages.getString("BoardView1.Artillery");
            }
            stringArray[n2++] = Messages.getString("BoardView1.ArtilleryAttack", new Object[]{string, new Integer(artilleryAttackAction.turnsTilHit), ((WeaponResult)object2).toHit.getValueAsString()});
        }
        if (mounted != null && this.selectedEntity != null) {
            int n3 = 0;
            n3 = this.selectedEntity.getOwner().getArtyAutoHitHexes().contains(coords) ? Integer.MIN_VALUE : this.selectedEntity.aTracker.getModifier(mounted, coords);
            stringArray[n2++] = n3 == Integer.MIN_VALUE ? Messages.getString("BoardView1.ArtilleryAutohit") : Messages.getString("BoardView1.ArtilleryAdjustment", new Object[]{new Integer(n3)});
        }
        return stringArray;
    }

    public void hideTooltip() {
        this.tipWindow.setVisible(false);
    }

    private boolean isTipShowing() {
        return this.tipWindow.isShowing();
    }

    private void checkTooltip() {
        if (this.isTipShowing()) {
            if (!this.isTipPossible) {
                this.hideTooltip();
            }
        } else if (this.isTipPossible && System.currentTimeMillis() - this.lastIdle > (long)GUIPreferences.getInstance().getTooltipDelay()) {
            this.showTooltip();
        }
    }

    public void redrawMovingEntity(Entity entity, Coords coords, int n) {
        Integer n2 = new Integer(entity.getId());
        EntitySprite entitySprite = this.entitySpriteIds.get(n2);
        if (entitySprite != null) {
            Vector<EntitySprite> vector = new Vector<EntitySprite>(this.entitySprites);
            Hashtable<Integer, EntitySprite> hashtable = new Hashtable<Integer, EntitySprite>(this.entitySpriteIds);
            vector.removeElement(entitySprite);
            this.entitySprites = vector;
            this.entitySpriteIds = hashtable;
        }
        MovingEntitySprite movingEntitySprite = this.movingEntitySpriteIds.get(n2);
        Vector<MovingEntitySprite> vector = new Vector<MovingEntitySprite>(this.movingEntitySprites);
        Hashtable<Integer, MovingEntitySprite> hashtable = new Hashtable<Integer, MovingEntitySprite>(this.movingEntitySpriteIds);
        if (movingEntitySprite != null) {
            vector.removeElement(movingEntitySprite);
        }
        if (entity.getPosition() != null) {
            movingEntitySprite = new MovingEntitySprite(entity, coords, n);
            vector.addElement(movingEntitySprite);
            hashtable.put(n2, movingEntitySprite);
        }
        this.movingEntitySprites = vector;
        this.movingEntitySpriteIds = hashtable;
    }

    public boolean isMovingUnits() {
        return this.movingUnits.size() > 0;
    }

    public void redrawEntity(Entity entity) {
        Coords coords;
        Integer n = new Integer(entity.getId());
        EntitySprite entitySprite = this.entitySpriteIds.get(n);
        Vector<EntitySprite> vector = new Vector<EntitySprite>(this.entitySprites);
        Hashtable<Integer, EntitySprite> hashtable = new Hashtable<Integer, EntitySprite>(this.entitySpriteIds);
        if (entitySprite != null) {
            vector.removeElement(entitySprite);
        }
        if ((coords = entity.getPosition()) != null) {
            entitySprite = new EntitySprite(entity);
            vector.addElement(entitySprite);
            hashtable.put(n, entitySprite);
        }
        this.entitySprites = vector;
        this.entitySpriteIds = hashtable;
        Enumeration<C3Sprite> enumeration = this.C3Sprites.elements();
        while (enumeration.hasMoreElements()) {
            C3Sprite c3Sprite = enumeration.nextElement();
            if (c3Sprite.entityId == entity.getId()) {
                this.C3Sprites.removeElement(c3Sprite);
                continue;
            }
            if (c3Sprite.masterId != entity.getId()) continue;
            if (entity.hasC3()) {
                this.C3Sprites.addElement(new C3Sprite(this.game.getEntity(c3Sprite.entityId), this.game.getEntity(c3Sprite.masterId)));
            }
            this.C3Sprites.removeElement(c3Sprite);
        }
        if (entity.hasC3() || entity.hasC3i()) {
            this.addC3Link(entity);
        }
        this.repaint(100L);
    }

    private void redrawAllEntities() {
        Object object;
        Object object2;
        Vector<EntitySprite> vector = new Vector<EntitySprite>(this.game.getNoOfEntities());
        Hashtable<Integer, EntitySprite> hashtable = new Hashtable<Integer, EntitySprite>(this.game.getNoOfEntities());
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration<Entity> enumeration = this.game.getWreckedEntities();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (object2 instanceof Infantry || ((Entity)object2).getPosition() == null) continue;
            object = new WreckSprite((Entity)object2);
            vector2.addElement(object);
        }
        this.clearC3Networks();
        object2 = this.game.getEntities();
        while (object2.hasMoreElements()) {
            object = (Entity)object2.nextElement();
            if (((Entity)object).getPosition() == null) continue;
            EntitySprite entitySprite = new EntitySprite((Entity)object);
            vector.add(entitySprite);
            hashtable.put(new Integer(((Entity)object).getId()), entitySprite);
            if (!((Entity)object).hasC3() && !((Entity)object).hasC3i()) continue;
            this.addC3Link((Entity)object);
        }
        this.entitySprites = vector;
        this.entitySpriteIds = hashtable;
        this.wreckSprites = vector2;
        this.repaint(100L);
    }

    private void moveCursor(CursorSprite cursorSprite, Coords coords) {
        Rectangle rectangle = new Rectangle(cursorSprite.getBounds());
        if (coords != null) {
            cursorSprite.setHexLocation(coords);
        } else {
            cursorSprite.setOffScreen();
        }
        this.repaintBounds(rectangle);
        this.repaintBounds(cursorSprite.getBounds());
    }

    public void centerOnHex(Coords coords) {
        if (null == coords) {
            return;
        }
        this.scroll.setLocation(this.getHexLocation(coords));
        this.scroll.translate((int)(42.0f * this.scale) - this.view.width / 2, (int)(36.0f * this.scale) - this.view.height / 2);
        this.isScrolling = false;
        this.checkScrollBounds();
        this.repaint();
    }

    public void drawMovementData(Entity entity, MovePath movePath) {
        Vector<StepSprite> vector = this.pathSprites;
        MoveStep moveStep = null;
        this.clearMovementData();
        Enumeration enumeration = movePath.getSteps();
        while (enumeration.hasMoreElements()) {
            MoveStep moveStep2 = (MoveStep)enumeration.nextElement();
            boolean bl = false;
            for (StepSprite stepSprite : vector) {
                if (!stepSprite.getStep().canReuseSprite(moveStep2)) continue;
                this.pathSprites.addElement(stepSprite);
                bl = true;
            }
            if (!bl) {
                if (!(moveStep == null || moveStep2.getType() != 20 && moveStep2.getType() != 21 || moveStep.getType() != 20 && moveStep.getType() != 21)) {
                    ((Sprite)this.pathSprites.elementAt((int)(this.pathSprites.size() - 1))).hidden = true;
                }
                this.pathSprites.addElement(new StepSprite(moveStep2));
            }
            moveStep = moveStep2;
        }
    }

    public void clearMovementData() {
        Vector<StepSprite> vector = this.pathSprites;
        this.pathSprites = new Vector();
        for (StepSprite stepSprite : vector) {
            this.repaintBounds(((Sprite)stepSprite).getBounds());
        }
    }

    public void setLocalPlayer(Player player) {
        this.localPlayer = player;
    }

    public Player getLocalPlayer() {
        return this.localPlayer;
    }

    public void markDeploymentHexesFor(Player player) {
        this.m_plDeployer = player;
    }

    public void addC3Link(Entity entity) {
        if (entity.getPosition() == null) {
            return;
        }
        if (entity.hasC3i()) {
            Enumeration<Entity> enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                Entity entity2 = enumeration.nextElement();
                if (entity2.getPosition() == null) {
                    return;
                }
                if (!entity.onSameC3NetworkAs(entity2)) continue;
                this.C3Sprites.addElement(new C3Sprite(entity, entity2));
            }
        } else if (entity.getC3Master() != null) {
            Entity entity3 = entity.getC3Master();
            if (entity3.getPosition() == null) {
                return;
            }
            if (!Compute.isAffectedByECM(entity, entity.getPosition(), entity3.getPosition()) && !Compute.isAffectedByECM(entity3, entity3.getPosition(), entity3.getPosition())) {
                this.C3Sprites.addElement(new C3Sprite(entity, entity.getC3Master()));
            }
        }
    }

    public synchronized void addAttack(AttackAction attackAction) {
        Entity entity = this.game.getEntity(attackAction.getEntityId());
        Targetable targetable = this.game.getTarget(attackAction.getTargetType(), attackAction.getTargetId());
        if (entity == null || targetable == null || targetable.getTargetType() == 11 || targetable.getPosition() == null || entity.getPosition() == null) {
            return;
        }
        for (AttackSprite attackSprite : this.attackSprites) {
            if (attackSprite.getEntityId() != attackAction.getEntityId() || attackSprite.getTargetId() != attackAction.getTargetId()) continue;
            if (attackAction instanceof WeaponAttackAction) {
                WeaponAttackAction weaponAttackAction = (WeaponAttackAction)attackAction;
                if (attackAction.getTargetType() != 7) {
                    attackSprite.addWeapon(weaponAttackAction);
                } else if (weaponAttackAction.getEntity(this.game).getOwner().getId() == this.localPlayer.getId()) {
                    attackSprite.addWeapon(weaponAttackAction);
                }
            }
            if (attackAction instanceof KickAttackAction) {
                attackSprite.addWeapon((KickAttackAction)attackAction);
            }
            if (attackAction instanceof PunchAttackAction) {
                attackSprite.addWeapon((PunchAttackAction)attackAction);
            }
            if (attackAction instanceof PushAttackAction) {
                attackSprite.addWeapon((PushAttackAction)attackAction);
            }
            if (attackAction instanceof ClubAttackAction) {
                attackSprite.addWeapon((ClubAttackAction)attackAction);
            }
            if (attackAction instanceof ChargeAttackAction) {
                attackSprite.addWeapon((ChargeAttackAction)attackAction);
            }
            if (attackAction instanceof DfaAttackAction) {
                attackSprite.addWeapon((DfaAttackAction)attackAction);
            }
            if (attackAction instanceof ProtomechPhysicalAttackAction) {
                attackSprite.addWeapon((ProtomechPhysicalAttackAction)attackAction);
            }
            if (attackAction instanceof SearchlightAttackAction) {
                attackSprite.addWeapon((SearchlightAttackAction)attackAction);
            }
            return;
        }
        if (attackAction instanceof WeaponAttackAction) {
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)attackAction;
            if (attackAction.getTargetType() != 7) {
                this.attackSprites.addElement(new AttackSprite(attackAction));
            } else if (weaponAttackAction.getEntity(this.game).getOwner().getId() == this.localPlayer.getId()) {
                this.attackSprites.addElement(new AttackSprite(attackAction));
            }
        } else {
            this.attackSprites.addElement(new AttackSprite(attackAction));
        }
    }

    public synchronized void removeAttacksFor(int n) {
        Iterator<AttackSprite> iterator = this.attackSprites.iterator();
        while (iterator.hasNext()) {
            AttackSprite attackSprite = iterator.next();
            if (attackSprite.getEntityId() != n) continue;
            iterator.remove();
        }
    }

    public void refreshAttacks() {
        EntityAction entityAction;
        this.clearAllAttacks();
        Enumeration enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            entityAction = (EntityAction)enumeration.nextElement();
            if (!(entityAction instanceof AttackAction)) continue;
            this.addAttack((AttackAction)entityAction);
        }
        enumeration = this.game.getCharges();
        while (enumeration.hasMoreElements()) {
            entityAction = (EntityAction)enumeration.nextElement();
            if (!(entityAction instanceof PhysicalAttackAction)) continue;
            this.addAttack((AttackAction)entityAction);
        }
    }

    public void clearC3Networks() {
        this.C3Sprites.removeAllElements();
    }

    public void clearAllAttacks() {
        this.attackSprites.removeAllElements();
    }

    protected void firstLOSHex(Coords coords) {
        if (this.useLOSTool) {
            this.moveCursor(this.secondLOSSprite, null);
            this.moveCursor(this.firstLOSSprite, coords);
        }
    }

    protected void secondLOSHex(Coords coords, Coords coords2) {
        if (this.useLOSTool) {
            this.moveCursor(this.firstLOSSprite, coords2);
            this.moveCursor(this.secondLOSSprite, coords);
            boolean bl = GUIPreferences.getInstance().getMechInFirst();
            boolean bl2 = GUIPreferences.getInstance().getMechInSecond();
            LosEffects.AttackInfo attackInfo = new LosEffects.AttackInfo();
            attackInfo.attackPos = coords2;
            attackInfo.targetPos = coords;
            attackInfo.attackHeight = bl ? 1 : 0;
            attackInfo.targetHeight = bl2 ? 1 : 0;
            attackInfo.attackAbsHeight = this.game.getBoard().getHex(coords2).floor() + attackInfo.attackHeight;
            attackInfo.targetAbsHeight = this.game.getBoard().getHex(coords).floor() + attackInfo.targetHeight;
            LosEffects losEffects = LosEffects.calculateLos(this.game, attackInfo);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Messages.getString("BoardView1.Attacker", new Object[]{bl ? Messages.getString("BoardView1.Mech") : Messages.getString("BoardView1.NonMech"), coords2.getBoardNum()}));
            stringBuffer.append(Messages.getString("BoardView1.Target", new Object[]{bl2 ? Messages.getString("BoardView1.Mech") : Messages.getString("BoardView1.NonMech"), coords.getBoardNum()}));
            if (losEffects.isBlocked()) {
                stringBuffer.append(Messages.getString("BoardView1.LOSBlocked", new Object[]{new Integer(coords2.distance(coords))}));
            } else {
                stringBuffer.append(Messages.getString("BoardView1.LOSNotBlocked", new Object[]{new Integer(coords2.distance(coords))}));
                if (losEffects.getHeavyWoods() > 0) {
                    stringBuffer.append(Messages.getString("BoardView1.HeavyWoods", new Object[]{new Integer(losEffects.getHeavyWoods())}));
                }
                if (losEffects.getLightWoods() > 0) {
                    stringBuffer.append(Messages.getString("BoardView1.LightWoods", new Object[]{new Integer(losEffects.getLightWoods())}));
                }
                if (losEffects.getLightSmoke() > 0) {
                    stringBuffer.append(Messages.getString("BoardView1.LightSmoke", new Object[]{new Integer(losEffects.getLightSmoke())}));
                }
                if (losEffects.getHeavySmoke() > 0) {
                    if (this.game.getOptions().booleanOption("maxtech_fire")) {
                        stringBuffer.append(Messages.getString("BoardView1.HeavySmoke", new Object[]{new Integer(losEffects.getHeavySmoke())}));
                    } else {
                        stringBuffer.append(Messages.getString("BoardView1.Smoke", new Object[]{new Integer(losEffects.getHeavySmoke())}));
                    }
                }
                if (losEffects.isTargetCover()) {
                    stringBuffer.append(Messages.getString("BoardView1.TargetPartialCover"));
                }
                if (losEffects.isAttackerCover()) {
                    stringBuffer.append(Messages.getString("BoardView1.AttackerPartialCover"));
                }
            }
            AlertDialog alertDialog = new AlertDialog(this.frame, Messages.getString("BoardView1.LOSTitle"), stringBuffer.toString(), false);
            alertDialog.setVisible(true);
        }
    }

    public boolean doScroll() {
        Point point = new Point(this.scroll);
        boolean bl = false;
        if (this.isScrolling && GUIPreferences.getInstance().getRightDragScroll() && this.oldMousePosition != null && !this.mousePos.equals(this.oldMousePosition)) {
            this.scroll.x -= GUIPreferences.getInstance().getScrollSensitivity() * (this.mousePos.x - this.oldMousePosition.x);
            this.scroll.y -= GUIPreferences.getInstance().getScrollSensitivity() * (this.mousePos.y - this.oldMousePosition.y);
            this.checkScrollBounds();
            this.oldMousePosition.setLocation(this.mousePos);
            bl = !point.equals(this.scroll);
            boolean bl2 = this.scrolled = this.scrolled || bl;
        }
        if (this.isScrolling && (GUIPreferences.getInstance().getClickEdgeScroll() || GUIPreferences.getInstance().getAutoEdgeScroll())) {
            int n = GUIPreferences.getInstance().getScrollSensitivity();
            if (this.mousePos.x < 100) {
                this.scroll.x -= (100 - this.mousePos.x) / n;
            } else if (this.mousePos.x > this.backSize.width - 100) {
                this.scroll.x -= (this.backSize.width - 100 - this.mousePos.x) / n;
            }
            if (this.mousePos.y < 100) {
                this.scroll.y -= (100 - this.mousePos.y) / n;
            } else if (this.mousePos.y > this.backSize.height - 100) {
                this.scroll.y -= (this.backSize.height - 100 - this.mousePos.y) / n;
            }
            this.checkScrollBounds();
            if (!point.equals(this.scroll)) {
                this.scrolled = bl = true;
            }
        }
        return bl;
    }

    public void checkScrollBounds() {
        if (this.scroll.x < 0) {
            this.scroll.x = 0;
        } else if (this.scroll.x > this.boardSize.width - this.view.width) {
            this.scroll.x = this.boardSize.width - this.view.width;
        }
        if (this.scroll.y < 0) {
            this.scroll.y = 0;
        } else if (this.scroll.y > this.boardSize.height - this.view.height) {
            this.scroll.y = this.boardSize.height - this.view.height;
        }
        if (null != this.vScrollbar) {
            this.vScrollbar.setValue(this.scroll.y);
        }
        if (null != this.hScrollbar) {
            this.hScrollbar.setValue(this.scroll.x);
        }
    }

    protected void stopScrolling() {
        this.isScrolling = false;
    }

    public void initPolys() {
        this.hexPoly = new Polygon();
        this.hexPoly.addPoint(21, 0);
        this.hexPoly.addPoint(62, 0);
        this.hexPoly.addPoint(83, 35);
        this.hexPoly.addPoint(83, 36);
        this.hexPoly.addPoint(62, 71);
        this.hexPoly.addPoint(21, 71);
        this.hexPoly.addPoint(0, 36);
        this.hexPoly.addPoint(0, 35);
        this.facingPolys = new Polygon[6];
        this.facingPolys[0] = new Polygon();
        this.facingPolys[0].addPoint(41, 3);
        this.facingPolys[0].addPoint(38, 6);
        this.facingPolys[0].addPoint(45, 6);
        this.facingPolys[0].addPoint(42, 3);
        this.facingPolys[1] = new Polygon();
        this.facingPolys[1].addPoint(69, 17);
        this.facingPolys[1].addPoint(64, 17);
        this.facingPolys[1].addPoint(68, 23);
        this.facingPolys[1].addPoint(70, 19);
        this.facingPolys[2] = new Polygon();
        this.facingPolys[2].addPoint(69, 53);
        this.facingPolys[2].addPoint(68, 49);
        this.facingPolys[2].addPoint(64, 55);
        this.facingPolys[2].addPoint(68, 54);
        this.facingPolys[3] = new Polygon();
        this.facingPolys[3].addPoint(41, 68);
        this.facingPolys[3].addPoint(38, 65);
        this.facingPolys[3].addPoint(45, 65);
        this.facingPolys[3].addPoint(42, 68);
        this.facingPolys[4] = new Polygon();
        this.facingPolys[4].addPoint(15, 53);
        this.facingPolys[4].addPoint(18, 54);
        this.facingPolys[4].addPoint(15, 48);
        this.facingPolys[4].addPoint(14, 52);
        this.facingPolys[5] = new Polygon();
        this.facingPolys[5].addPoint(13, 19);
        this.facingPolys[5].addPoint(15, 23);
        this.facingPolys[5].addPoint(19, 17);
        this.facingPolys[5].addPoint(17, 17);
        this.movementPolys = new Polygon[8];
        this.movementPolys[0] = new Polygon();
        this.movementPolys[0].addPoint(41, 65);
        this.movementPolys[0].addPoint(38, 68);
        this.movementPolys[0].addPoint(45, 68);
        this.movementPolys[0].addPoint(42, 65);
        this.movementPolys[1] = new Polygon();
        this.movementPolys[1].addPoint(17, 48);
        this.movementPolys[1].addPoint(12, 48);
        this.movementPolys[1].addPoint(16, 54);
        this.movementPolys[1].addPoint(17, 49);
        this.movementPolys[2] = new Polygon();
        this.movementPolys[2].addPoint(18, 19);
        this.movementPolys[2].addPoint(17, 15);
        this.movementPolys[2].addPoint(13, 21);
        this.movementPolys[2].addPoint(17, 20);
        this.movementPolys[3] = new Polygon();
        this.movementPolys[3].addPoint(41, 6);
        this.movementPolys[3].addPoint(38, 3);
        this.movementPolys[3].addPoint(45, 3);
        this.movementPolys[3].addPoint(42, 6);
        this.movementPolys[4] = new Polygon();
        this.movementPolys[4].addPoint(67, 15);
        this.movementPolys[4].addPoint(66, 19);
        this.movementPolys[4].addPoint(67, 20);
        this.movementPolys[4].addPoint(71, 20);
        this.movementPolys[5] = new Polygon();
        this.movementPolys[5].addPoint(69, 55);
        this.movementPolys[5].addPoint(66, 50);
        this.movementPolys[5].addPoint(67, 49);
        this.movementPolys[5].addPoint(72, 48);
        this.movementPolys[6] = new Polygon();
        this.movementPolys[6].addPoint(35, 44);
        this.movementPolys[6].addPoint(30, 49);
        this.movementPolys[6].addPoint(33, 49);
        this.movementPolys[6].addPoint(33, 53);
        this.movementPolys[6].addPoint(38, 53);
        this.movementPolys[6].addPoint(38, 49);
        this.movementPolys[6].addPoint(41, 49);
        this.movementPolys[6].addPoint(36, 44);
        this.movementPolys[7] = new Polygon();
        this.movementPolys[7].addPoint(34, 53);
        this.movementPolys[7].addPoint(29, 48);
        this.movementPolys[7].addPoint(32, 48);
        this.movementPolys[7].addPoint(32, 44);
        this.movementPolys[7].addPoint(37, 44);
        this.movementPolys[7].addPoint(37, 48);
        this.movementPolys[7].addPoint(40, 48);
        this.movementPolys[7].addPoint(35, 53);
    }

    private synchronized boolean doMoveUnits(long l) {
        boolean bl = false;
        if (this.movingUnits.size() > 0) {
            this.moveWait += l;
            if (this.moveWait > (long)GUIPreferences.getInstance().getInt("AdvancedMoveStepDelay")) {
                Vector<MovingUnit> vector = new Vector<MovingUnit>();
                for (MovingUnit movingUnit : this.movingUnits) {
                    bl = true;
                    Entity entity = this.game.getEntity(movingUnit.entity.getId());
                    if (movingUnit.path.size() > 0) {
                        UnitLocation unitLocation = (UnitLocation)movingUnit.path.elementAt(0);
                        if (entity != null) {
                            this.redrawMovingEntity(movingUnit.entity, unitLocation.getCoords(), unitLocation.getFacing());
                        }
                        movingUnit.path.removeElementAt(0);
                        continue;
                    }
                    if (entity != null) {
                        this.redrawEntity(entity);
                    }
                    vector.addElement(movingUnit);
                }
                for (MovingUnit movingUnit : vector) {
                    this.movingUnits.removeElement(movingUnit);
                }
                this.moveWait = 0L;
                if (this.movingUnits.size() == 0) {
                    this.movingEntitySpriteIds.clear();
                    this.movingEntitySprites.removeAllElements();
                    this.ghostEntitySprites.removeAllElements();
                    this.processBoardViewEvent(new BoardViewEvent(this, 8));
                }
            }
        }
        return bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 103: {
                this.scroll.y -= 36;
                this.scroll.x -= 36;
                break;
            }
            case 104: {
                this.scroll.y -= 36;
                break;
            }
            case 105: {
                this.scroll.y -= 36;
                this.scroll.x += 36;
                break;
            }
            case 97: {
                this.scroll.y += 36;
                this.scroll.x -= 36;
                break;
            }
            case 98: {
                this.scroll.y += 36;
                break;
            }
            case 99: {
                this.scroll.y += 36;
                this.scroll.x += 36;
                break;
            }
            case 100: {
                this.scroll.x -= 36;
                break;
            }
            case 102: {
                this.scroll.x += 36;
                break;
            }
            case 101: {
                Vector<Entity> vector = this.game.getPlayerEntities(this.localPlayer);
                Entity entity = this.clientgui == null ? null : this.game.getEntity(this.clientgui.getSelectedEntityNum());
                for (int i = 0; i < vector.size(); ++i) {
                    Entity entity2 = vector.elementAt(i);
                    if (entity2 != entity) continue;
                    this.centerOnHex(entity2.getPosition());
                }
                break;
            }
            case 17: {
                this.ctlKeyHeld = true;
                this.initCtlScroll = true;
            }
        }
        if (this.isTipShowing()) {
            this.hideTooltip();
        }
        this.lastIdle = System.currentTimeMillis();
        this.checkScrollBounds();
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            this.ctlKeyHeld = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.scrolled = false;
        Point point = mouseEvent.getPoint();
        if (null == point) {
            return;
        }
        this.oldMousePosition = point;
        this.isTipPossible = false;
        for (n = 0; n < this.displayables.size(); ++n) {
            Displayable displayable = this.displayables.elementAt(n);
            if (this.backSize == null || !displayable.isHit(point, this.backSize)) continue;
            return;
        }
        n = 10;
        if (!GUIPreferences.getInstance().getRightDragScroll() && !GUIPreferences.getInstance().getAlwaysRightClickScroll() && this.game.getPhase() == 12) {
            n |= 0xC;
        }
        if (!GUIPreferences.getInstance().getAutoEdgeScroll()) {
            n |= 0x10;
        }
        if (!GUIPreferences.getInstance().getClickEdgeScroll()) {
            n |= 4;
        }
        if (GUIPreferences.getInstance().getRightDragScroll()) {
            n |= 8;
        }
        this.isScrolling = (mouseEvent.getModifiers() & n) == 0;
        if (this.isTipShowing()) {
            this.hideTooltip();
        }
        this.mouseAction(this.getCoordsAt(point), 3, mouseEvent.getModifiers());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isTipPossible = true;
        this.oldMousePosition = this.mousePos;
        for (int i = 0; i < this.displayables.size(); ++i) {
            Displayable displayable = this.displayables.elementAt(i);
            if (!displayable.isReleased()) continue;
            return;
        }
        this.isScrolling = false;
        if (this.scrolled && ((mouseEvent.getModifiers() & 0x10) == 0 || !GUIPreferences.getInstance().getAutoEdgeScroll())) {
            return;
        }
        if (mouseEvent.getClickCount() == 1) {
            this.mouseAction(this.getCoordsAt(mouseEvent.getPoint()), 1, mouseEvent.getModifiers());
        } else {
            this.mouseAction(this.getCoordsAt(mouseEvent.getPoint()), 2, mouseEvent.getModifiers());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.isTipPossible = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        this.isTipPossible = false;
        Point point = mouseEvent.getPoint();
        if (null == point) {
            return;
        }
        for (n = 0; n < this.displayables.size(); ++n) {
            Displayable displayable = this.displayables.elementAt(n);
            if (!displayable.isDragged(point, this.backSize)) continue;
            this.repaint();
            return;
        }
        this.mousePos = point;
        n = 10;
        if (!GUIPreferences.getInstance().getRightDragScroll() && !GUIPreferences.getInstance().getAlwaysRightClickScroll() && this.game.getPhase() == 12) {
            n |= 0xC;
        }
        if (GUIPreferences.getInstance().getRightDragScroll()) {
            n |= 0x18;
        }
        if (!GUIPreferences.getInstance().getAutoEdgeScroll()) {
            n |= 0x10;
        }
        if (!GUIPreferences.getInstance().getClickEdgeScroll() && !GUIPreferences.getInstance().getRightDragScroll()) {
            n |= 4;
        }
        this.isScrolling = (mouseEvent.getModifiers() & n) == 0;
        this.mouseAction(this.getCoordsAt(point), 3, mouseEvent.getModifiers());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (null == point) {
            return;
        }
        for (int i = 0; i < this.displayables.size(); ++i) {
            Displayable displayable = this.displayables.elementAt(i);
            if (displayable.isBeingDragged()) {
                this.isTipPossible = false;
                return;
            }
            if (this.backSize == null) continue;
            displayable.isMouseOver(point, this.backSize);
        }
        this.mousePos = point;
        if (this.isTipShowing()) {
            this.hideTooltip();
        }
        if (this.ctlKeyHeld && GUIPreferences.getInstance().getCtlScroll()) {
            if (this.initCtlScroll) {
                this.previousMouseX = mouseEvent.getX();
                this.previousMouseY = mouseEvent.getY();
                this.initCtlScroll = false;
            }
            this.scroll.x += GUIPreferences.getInstance().getScrollSensitivity() * (mouseEvent.getX() - this.previousMouseX);
            this.scroll.y += GUIPreferences.getInstance().getScrollSensitivity() * (mouseEvent.getY() - this.previousMouseY);
            this.previousMouseX = mouseEvent.getX();
            this.previousMouseY = mouseEvent.getY();
            this.checkScrollBounds();
            this.repaint();
        }
        this.lastIdle = System.currentTimeMillis();
        this.isTipPossible = true;
    }

    public void zoomIn() {
        if (this.zoomIndex == ZOOM_FACTORS.length - 1) {
            return;
        }
        ++this.zoomIndex;
        this.zoom();
    }

    public void zoomOut() {
        if (this.zoomIndex == 0) {
            return;
        }
        --this.zoomIndex;
        this.zoom();
    }

    public void setZoomIndex(int n) {
        this.zoomIndex = n;
        this.zoom();
    }

    public int getZoomIndex() {
        return this.zoomIndex;
    }

    private void checkZoomIndex() {
        if (this.zoomIndex > ZOOM_FACTORS.length - 1) {
            this.zoomIndex = ZOOM_FACTORS.length - 1;
        }
        if (this.zoomIndex < 0) {
            this.zoomIndex = 0;
        }
    }

    private void zoom() {
        this.checkZoomIndex();
        this.scale = ZOOM_FACTORS[this.zoomIndex];
        GUIPreferences.getInstance().setMapZoomIndex(this.zoomIndex);
        this.hex_size = new Dimension((int)(84.0f * this.scale), (int)(72.0f * this.scale));
        Dimension dimension = this.getSize();
        this.scaledImageCache = new ImageCache();
        this.cursorSprite.prepare();
        this.highlightSprite.prepare();
        this.selectedSprite.prepare();
        this.firstLOSSprite.prepare();
        this.secondLOSSprite.prepare();
        this.updateBoard();
        this.view.setLocation(this.scroll);
        this.view.setSize(this.getOptimalView(dimension));
        this.offset.setLocation(this.getOptimalOffset(dimension));
        this.updateFontSizes();
        this.updateBoardImage();
        this.repaint();
    }

    private void updateFontSizes() {
        if (this.zoomIndex <= 4) {
            this.font_elev = FONT_7;
            this.font_hexnum = FONT_7;
            this.font_minefield = FONT_7;
        }
        if (this.zoomIndex <= 5 & this.zoomIndex > 4) {
            this.font_elev = FONT_8;
            this.font_hexnum = FONT_8;
            this.font_minefield = FONT_8;
        }
        if (this.zoomIndex > 5) {
            this.font_elev = FONT_9;
            this.font_hexnum = FONT_9;
            this.font_minefield = FONT_9;
        }
    }

    public boolean isTileImagesLoaded() {
        return this.tileManager.isLoaded();
    }

    public void setUseLOSTool(boolean bl) {
        this.useLOSTool = bl;
    }

    public TilesetManager getTilesetManager() {
        return this.tileManager;
    }

    public void drawRuler(Coords coords, Coords coords2, Color color, Color color2) {
        this.rulerStart = coords;
        this.rulerEnd = coords2;
        this.rulerStartColor = color;
        this.rulerEndColor = color2;
        this.repaint();
    }

    @Override
    public void setLastCursor(Coords coords) {
        this.lastCursor = coords;
    }

    @Override
    public Coords getLastCursor() {
        return this.lastCursor;
    }

    @Override
    public void setHighlighted(Coords coords) {
        this.highlighted = coords;
    }

    @Override
    public Coords getHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setSelected(Coords coords) {
        this.selected = coords;
    }

    @Override
    public Coords getSelected() {
        return this.selected;
    }

    @Override
    public void setFirstLOS(Coords coords) {
        this.firstLOS = coords;
    }

    @Override
    public Coords getFirstLOS() {
        return this.firstLOS;
    }

    @Override
    public void select(Coords coords) {
        if (coords == null || this.game.getBoard().contains(coords)) {
            this.setSelected(coords);
            this.moveCursor(this.selectedSprite, coords);
            this.moveCursor(this.firstLOSSprite, null);
            this.moveCursor(this.secondLOSSprite, null);
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 5, 0));
        }
    }

    @Override
    public void select(int n, int n2) {
        this.select(new Coords(n, n2));
    }

    @Override
    public void highlight(Coords coords) {
        if (coords == null || this.game.getBoard().contains(coords)) {
            this.setHighlighted(coords);
            this.moveCursor(this.highlightSprite, coords);
            this.moveCursor(this.firstLOSSprite, null);
            this.moveCursor(this.secondLOSSprite, null);
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 4, 0));
        }
    }

    @Override
    public void highlight(int n, int n2) {
        this.highlight(new Coords(n, n2));
    }

    @Override
    public void cursor(Coords coords) {
        if (coords == null || this.game.getBoard().contains(coords)) {
            if (this.getLastCursor() == null || coords == null || !coords.equals(this.getLastCursor())) {
                this.setLastCursor(coords);
                this.moveCursor(this.cursorSprite, coords);
                this.moveCursor(this.firstLOSSprite, null);
                this.moveCursor(this.secondLOSSprite, null);
                this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 3, 0));
            } else {
                this.setLastCursor(coords);
            }
        }
    }

    @Override
    public void cursor(int n, int n2) {
        this.cursor(new Coords(n, n2));
    }

    @Override
    public void checkLOS(Coords coords) {
        if (coords == null || this.game.getBoard().contains(coords)) {
            if (this.getFirstLOS() == null) {
                this.setFirstLOS(coords);
                this.firstLOSHex(coords);
                this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 6, 0));
            } else {
                this.secondLOSHex(coords, this.getFirstLOS());
                this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 7, 0));
                this.setFirstLOS(null);
            }
        }
    }

    @Override
    public void mouseAction(int n, int n2, int n3, int n4) {
        if (this.game.getBoard().contains(n, n2)) {
            Coords coords = new Coords(n, n2);
            switch (n3) {
                case 1: {
                    if ((n4 & 2) != 0) {
                        this.checkLOS(coords);
                        break;
                    }
                    this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 0, n4));
                    break;
                }
                case 2: {
                    this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 1, n4));
                    break;
                }
                case 3: {
                    this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 2, n4));
                }
            }
        }
    }

    @Override
    public void mouseAction(Coords coords, int n, int n2) {
        this.mouseAction(coords.x, coords.y, n, n2);
    }

    public boolean mayDrawPopup() {
        return !this.scrolled;
    }

    @Override
    public void boardNewBoard(BoardEvent boardEvent) {
        this.updateBoard();
    }

    @Override
    public synchronized void boardChangedHex(BoardEvent boardEvent) {
        IHex iHex = this.game.getBoard().getHex(boardEvent.getCoords());
        this.tileManager.clearHex(iHex);
        this.tileManager.waitForHex(iHex);
        if (this.boardGraph != null) {
            this.redrawAround(boardEvent.getCoords());
        }
    }

    public void die() {
        this.redrawWorker.stop();
    }

    private synchronized void boardChanged() {
        this.redrawAllEntities();
    }

    private void clearSprites() {
        this.pathSprites.clear();
        this.attackSprites.clear();
        this.C3Sprites.clear();
    }

    protected synchronized void updateBoard() {
        this.updateBoardSize();
        if (this.backGraph != null) {
            this.backGraph.dispose();
        }
        this.backGraph = null;
        this.backImage = null;
        this.backSize = null;
        this.boardImage = null;
        if (this.boardGraph != null) {
            this.boardGraph.dispose();
        }
        this.boardGraph = null;
        this.redrawAllEntities();
    }

    @Override
    public synchronized void WeaponSelected(MechDisplayEvent mechDisplayEvent) {
        this.selectedEntity = mechDisplayEvent.getEntity();
        this.selectedWeapon = mechDisplayEvent.getEquip();
        this.repaint(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEcmList() {
        Object object;
        ArrayList<EcmBubble> arrayList = new ArrayList<EcmBubble>();
        Object object2 = this.game.getEntities();
        while (object2.hasMoreElements()) {
            int n;
            object = object2.nextElement();
            if (((Entity)object).getPosition() == null || !((Entity)object).isDeployed() || ((Entity)object).isOffBoard() || (n = ((Entity)object).getECMRange()) == -1) continue;
            int n2 = PlayerColors.getColorRGB(((Entity)object).getOwner().getColorIndex());
            arrayList.add(new EcmBubble(((Entity)object).getPosition(), n, n2));
        }
        object2 = new Hashtable();
        for (EcmBubble ecmBubble : arrayList) {
            Integer n = new Integer(ecmBubble.tint);
            for (int i = -ecmBubble.range; i <= ecmBubble.range; ++i) {
                for (int j = -ecmBubble.range; j <= ecmBubble.range; ++j) {
                    Coords coords = new Coords(i + ecmBubble.x, j + ecmBubble.y);
                    if (ecmBubble.distance(coords) > ecmBubble.range) continue;
                    Integer n3 = (Integer)((Hashtable)object2).get(coords);
                    if (n3 == null) {
                        ((Hashtable)object2).put(coords, n);
                        continue;
                    }
                    if (n3 == ecmBubble.tint) continue;
                    int n4 = n3 >> 16 & 0xFF;
                    int n5 = n3 >> 8 & 0xFF;
                    int n6 = n3 & 0xFF;
                    int n7 = ecmBubble.tint >> 16 & 0xFF;
                    int n8 = ecmBubble.tint >> 8 & 0xFF;
                    int n9 = ecmBubble.tint & 0xFF;
                    n4 = (n4 + n7) / 2;
                    n5 = (n5 + n8) / 2;
                    n6 = (n6 + n9) / 2;
                    ((Hashtable)object2).put(coords, new Integer(n4 << 16 | n5 << 8 | n6));
                }
            }
        }
        object = this;
        synchronized (object) {
            this.ecmHexes = object2;
            this.dirtyBoard = true;
        }
        this.repaint(100L);
    }

    private class EcmBubble
    extends Coords {
        int range;
        int tint;

        public EcmBubble(Coords coords, int n, int n2) {
            super(coords);
            this.range = n;
            this.tint = n2;
        }
    }

    protected class RedrawWorker
    implements Runnable {
        private boolean finished = false;

        protected RedrawWorker() {
        }

        public void start() {
            Thread thread = new Thread((Runnable)this, "BoardView RedrawWorker Thread");
            thread.start();
        }

        public void stop() {
            this.finished = true;
        }

        public void run() {
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis();
            while (!this.finished) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.finished) break;
                if (!BoardView1.this.isShowing()) {
                    l = l2 = System.currentTimeMillis();
                    continue;
                }
                l2 = System.currentTimeMillis();
                boolean bl = false;
                for (int i = 0; i < BoardView1.this.displayables.size(); ++i) {
                    Displayable displayable = (Displayable)BoardView1.this.displayables.elementAt(i);
                    if (!displayable.isSliding()) {
                        displayable.setIdleTime(l2 - l, true);
                        continue;
                    }
                    bl = bl || displayable.slide();
                }
                if (BoardView1.this.backSize != null) {
                    bl = bl || BoardView1.this.doMoveUnits(l2 - l);
                    bl = bl || BoardView1.this.doScroll();
                    BoardView1.this.checkTooltip();
                } else {
                    BoardView1.this.repaint(100L);
                }
                if (bl) {
                    BoardView1.this.repaint();
                }
                l = l2;
            }
        }
    }

    private class AttackSprite
    extends Sprite {
        private Vector<AttackAction> attacks;
        private Point a;
        private Point t;
        private double an;
        private StraightArrowPolygon attackPoly;
        private Color attackColor;
        private int entityId;
        private int targetType;
        private int targetId;
        private String attackerDesc;
        private String targetDesc;
        private Vector<String> weaponDescs;
        private final Entity ae;
        private final Targetable target;

        public AttackSprite(AttackAction attackAction) {
            this.attacks = new Vector();
            this.weaponDescs = new Vector();
            this.attacks.addElement(attackAction);
            this.entityId = attackAction.getEntityId();
            this.targetType = attackAction.getTargetType();
            this.targetId = attackAction.getTargetId();
            this.ae = BoardView1.this.game.getEntity(attackAction.getEntityId());
            this.target = BoardView1.this.game.getTarget(this.targetType, this.targetId);
            this.attackColor = PlayerColors.getColor(this.ae.getOwner().getColorIndex());
            this.an = (this.ae.getPosition().radian(this.target.getPosition()) + 4.71238898038469) % (Math.PI * 2);
            this.makePoly();
            this.bounds = new Rectangle(this.attackPoly.getBounds());
            this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
            this.attackPoly.translate(-this.bounds.getLocation().x, -this.bounds.getLocation().y);
            this.attackerDesc = this.ae.getDisplayName();
            this.targetDesc = this.target.getDisplayName();
            if (attackAction instanceof WeaponAttackAction) {
                this.addWeapon((WeaponAttackAction)attackAction);
            }
            if (attackAction instanceof KickAttackAction) {
                this.addWeapon((KickAttackAction)attackAction);
            }
            if (attackAction instanceof PunchAttackAction) {
                this.addWeapon((PunchAttackAction)attackAction);
            }
            if (attackAction instanceof PushAttackAction) {
                this.addWeapon((PushAttackAction)attackAction);
            }
            if (attackAction instanceof ClubAttackAction) {
                this.addWeapon((ClubAttackAction)attackAction);
            }
            if (attackAction instanceof ChargeAttackAction) {
                this.addWeapon((ChargeAttackAction)attackAction);
            }
            if (attackAction instanceof DfaAttackAction) {
                this.addWeapon((DfaAttackAction)attackAction);
            }
            if (attackAction instanceof ProtomechPhysicalAttackAction) {
                this.addWeapon((ProtomechPhysicalAttackAction)attackAction);
            }
            if (attackAction instanceof SearchlightAttackAction) {
                this.addWeapon((SearchlightAttackAction)attackAction);
            }
            this.image = null;
        }

        private void makePoly() {
            this.a = BoardView1.this.getHexLocation(this.ae.getPosition());
            this.t = BoardView1.this.getHexLocation(this.target.getPosition());
            this.a.x = this.a.x + (int)(42.0f * BoardView1.this.scale) + (int)Math.round(Math.cos(this.an) * (double)((int)(18.0f * BoardView1.this.scale)));
            this.t.x = this.t.x + (int)(42.0f * BoardView1.this.scale) - (int)Math.round(Math.cos(this.an) * (double)((int)(18.0f * BoardView1.this.scale)));
            this.a.y = this.a.y + (int)(36.0f * BoardView1.this.scale) + (int)Math.round(Math.sin(this.an) * (double)((int)(18.0f * BoardView1.this.scale)));
            this.t.y = this.t.y + (int)(36.0f * BoardView1.this.scale) - (int)Math.round(Math.sin(this.an) * (double)((int)(18.0f * BoardView1.this.scale)));
            this.attackPoly = this.isMutualAttack() ? new StraightArrowPolygon(this.a, this.t, (int)(8.0f * BoardView1.this.scale), (int)(12.0f * BoardView1.this.scale), true) : new StraightArrowPolygon(this.a, this.t, (int)(4.0f * BoardView1.this.scale), (int)(8.0f * BoardView1.this.scale), false);
        }

        public Rectangle getBounds() {
            this.makePoly();
            this.bounds = new Rectangle(this.attackPoly.getBounds());
            this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
            this.attackPoly.translate(-this.bounds.getLocation().x, -this.bounds.getLocation().y);
            return this.bounds;
        }

        public void rebuildToHalvedPolygon() {
            this.attackPoly = new StraightArrowPolygon(this.a, this.t, (int)(8.0f * BoardView1.this.scale), (int)(12.0f * BoardView1.this.scale), true);
            this.bounds = new Rectangle(this.attackPoly.getBounds());
            this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
            this.attackPoly.translate(-this.bounds.getLocation().x, -this.bounds.getLocation().y);
        }

        private boolean isMutualAttack() {
            for (AttackSprite attackSprite : BoardView1.this.attackSprites) {
                if (attackSprite.getEntityId() != this.targetId || attackSprite.getTargetId() != this.entityId) continue;
                attackSprite.rebuildToHalvedPolygon();
                return true;
            }
            return false;
        }

        public void prepare() {
        }

        public boolean isReady() {
            return true;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            Polygon polygon = new Polygon(this.attackPoly.xpoints, this.attackPoly.ypoints, this.attackPoly.npoints);
            polygon.translate(n, n2);
            graphics.setColor(this.attackColor);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.gray.darker());
            graphics.drawPolygon(polygon);
        }

        public boolean isInside(Point point) {
            return this.attackPoly.contains(point.x + ((BoardView1)BoardView1.this).view.x - this.bounds.x - ((BoardView1)BoardView1.this).offset.x, point.y + ((BoardView1)BoardView1.this).view.y - this.bounds.y - ((BoardView1)BoardView1.this).offset.y);
        }

        public int getEntityId() {
            return this.entityId;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public void addWeapon(WeaponAttackAction weaponAttackAction) {
            Entity entity = BoardView1.this.game.getEntity(weaponAttackAction.getEntityId());
            WeaponType weaponType = (WeaponType)entity.getEquipment(weaponAttackAction.getWeaponId()).getType();
            String string = weaponAttackAction.toHit(BoardView1.this.game).getValueAsString();
            String string2 = weaponAttackAction.toHit(BoardView1.this.game).getTableDesc();
            this.weaponDescs.addElement(weaponType.getName() + Messages.getString("BoardView1.needs") + string + " " + string2);
        }

        public void addWeapon(KickAttackAction kickAttackAction) {
            String string = "";
            String string2 = "";
            String string3 = "";
            int n = kickAttackAction.getLeg();
            switch (n) {
                case 0: {
                    string2 = KickAttackAction.toHit(BoardView1.this.game, kickAttackAction.getEntityId(), BoardView1.this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId()), 1).getValueAsString();
                    string3 = KickAttackAction.toHit(BoardView1.this.game, kickAttackAction.getEntityId(), BoardView1.this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId()), 2).getValueAsString();
                    string = Messages.getString("BoardView1.kickBoth", new Object[]{string2, string3});
                    break;
                }
                case 1: {
                    string2 = KickAttackAction.toHit(BoardView1.this.game, kickAttackAction.getEntityId(), BoardView1.this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId()), 1).getValueAsString();
                    string = Messages.getString("BoardView1.kickLeft", new Object[]{string2});
                    break;
                }
                case 2: {
                    string3 = KickAttackAction.toHit(BoardView1.this.game, kickAttackAction.getEntityId(), BoardView1.this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId()), 2).getValueAsString();
                    string = Messages.getString("BoardView1.kickRight", new Object[]{string3});
                }
            }
            this.weaponDescs.addElement(string);
        }

        public void addWeapon(PunchAttackAction punchAttackAction) {
            String string = "";
            String string2 = "";
            String string3 = "";
            int n = punchAttackAction.getArm();
            switch (n) {
                case 0: {
                    string2 = PunchAttackAction.toHit(BoardView1.this.game, punchAttackAction.getEntityId(), BoardView1.this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId()), 1).getValueAsString();
                    string3 = PunchAttackAction.toHit(BoardView1.this.game, punchAttackAction.getEntityId(), BoardView1.this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId()), 2).getValueAsString();
                    string = Messages.getString("BoardView1.punchBoth", new Object[]{string2, string3});
                    break;
                }
                case 1: {
                    string2 = PunchAttackAction.toHit(BoardView1.this.game, punchAttackAction.getEntityId(), BoardView1.this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId()), 1).getValueAsString();
                    string = Messages.getString("BoardView1.punchLeft", new Object[]{string2});
                    break;
                }
                case 2: {
                    string3 = PunchAttackAction.toHit(BoardView1.this.game, punchAttackAction.getEntityId(), BoardView1.this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId()), 2).getValueAsString();
                    string = Messages.getString("BoardView1.punchRight", new Object[]{string3});
                }
            }
            this.weaponDescs.addElement(string);
        }

        public void addWeapon(PushAttackAction pushAttackAction) {
            String string = pushAttackAction.toHit(BoardView1.this.game).getValueAsString();
            this.weaponDescs.addElement(Messages.getString("BoardView1.push", new Object[]{string}));
        }

        public void addWeapon(ClubAttackAction clubAttackAction) {
            String string = clubAttackAction.toHit(BoardView1.this.game).getValueAsString();
            String string2 = clubAttackAction.getClub().getName();
            this.weaponDescs.addElement(Messages.getString("BoardView1.hit", new Object[]{string2, string}));
        }

        public void addWeapon(ChargeAttackAction chargeAttackAction) {
            String string = chargeAttackAction.toHit(BoardView1.this.game).getValueAsString();
            this.weaponDescs.addElement(Messages.getString("BoardView1.charge", new Object[]{string}));
        }

        public void addWeapon(DfaAttackAction dfaAttackAction) {
            String string = dfaAttackAction.toHit(BoardView1.this.game).getValueAsString();
            this.weaponDescs.addElement(Messages.getString("BoardView1.DFA", new Object[]{string}));
        }

        public void addWeapon(ProtomechPhysicalAttackAction protomechPhysicalAttackAction) {
            String string = protomechPhysicalAttackAction.toHit(BoardView1.this.game).getValueAsString();
            this.weaponDescs.addElement(Messages.getString("BoardView1.proto", new Object[]{string}));
        }

        public void addWeapon(SearchlightAttackAction searchlightAttackAction) {
            this.weaponDescs.addElement(Messages.getString("BoardView1.Searchlight"));
        }

        public String[] getTooltip() {
            String[] stringArray = new String[1 + this.weaponDescs.size()];
            int n = 1;
            stringArray[0] = this.attackerDesc + " " + Messages.getString("BoardView1.on") + " " + this.targetDesc;
            Iterator<String> iterator = this.weaponDescs.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = iterator.next();
            }
            return stringArray;
        }
    }

    private class C3Sprite
    extends Sprite {
        private Polygon C3Poly;
        protected int entityId;
        protected int masterId;
        protected Entity entityE;
        protected Entity entityM;
        Color spriteColor;

        public C3Sprite(Entity entity, Entity entity2) {
            this.entityE = entity;
            this.entityM = entity2;
            this.entityId = entity.getId();
            this.masterId = entity2.getId();
            this.spriteColor = PlayerColors.getColor(entity.getOwner().getColorIndex());
            if (entity.getPosition() == null || entity2.getPosition() == null) {
                this.C3Poly = new Polygon();
                this.C3Poly.addPoint(0, 0);
                this.C3Poly.addPoint(1, 0);
                this.C3Poly.addPoint(0, 1);
                this.bounds = new Rectangle(this.C3Poly.getBounds());
                this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
                this.image = null;
                return;
            }
            this.makePoly();
            this.bounds = new Rectangle(this.C3Poly.getBounds());
            this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
            this.C3Poly.translate(-this.bounds.getLocation().x, -this.bounds.getLocation().y);
            this.image = null;
        }

        public void prepare() {
        }

        private void makePoly() {
            Point point = BoardView1.this.getHexLocation(this.entityE.getPosition());
            Point point2 = BoardView1.this.getHexLocation(this.entityM.getPosition());
            double d = (this.entityE.getPosition().radian(this.entityM.getPosition()) + 4.71238898038469) % (Math.PI * 2);
            double d2 = BoardView1.this.scale * 1.0f;
            this.C3Poly = new Polygon();
            this.C3Poly.addPoint(point.x + (int)(BoardView1.this.scale * 42.0f - (float)((int)Math.round(Math.sin(d) * d2))), point.y + (int)(BoardView1.this.scale * 36.0f + (float)((int)Math.round(Math.cos(d) * d2))));
            this.C3Poly.addPoint(point.x + (int)(BoardView1.this.scale * 42.0f + (float)((int)Math.round(Math.sin(d) * d2))), point.y + (int)(BoardView1.this.scale * 36.0f - (float)((int)Math.round(Math.cos(d) * d2))));
            this.C3Poly.addPoint(point2.x + (int)(BoardView1.this.scale * 42.0f + (float)((int)Math.round(Math.sin(d) * d2))), point2.y + (int)(BoardView1.this.scale * 36.0f - (float)((int)Math.round(Math.cos(d) * d2))));
            this.C3Poly.addPoint(point2.x + (int)(BoardView1.this.scale * 42.0f - (float)((int)Math.round(Math.sin(d) * d2))), point2.y + (int)(BoardView1.this.scale * 36.0f + (float)((int)Math.round(Math.cos(d) * d2))));
        }

        public Rectangle getBounds() {
            this.makePoly();
            this.bounds = new Rectangle(this.C3Poly.getBounds());
            this.bounds.setSize(this.bounds.getSize().width + 1, this.bounds.getSize().height + 1);
            this.C3Poly.translate(-this.bounds.getLocation().x, -this.bounds.getLocation().y);
            this.image = null;
            return this.bounds;
        }

        public boolean isReady() {
            return true;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            Polygon polygon = new Polygon(this.C3Poly.xpoints, this.C3Poly.ypoints, this.C3Poly.npoints);
            polygon.translate(n, n2);
            graphics.setColor(this.spriteColor);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.black);
            graphics.drawPolygon(polygon);
        }

        public boolean isInside(Point point) {
            return this.C3Poly.contains(point.x + ((BoardView1)BoardView1.this).view.x - this.bounds.x - ((BoardView1)BoardView1.this).offset.x, point.y + ((BoardView1)BoardView1.this).view.y - this.bounds.y - ((BoardView1)BoardView1.this).offset.y);
        }
    }

    private class StepSprite
    extends Sprite {
        private MoveStep step;

        public StepSprite(MoveStep moveStep) {
            this.step = moveStep;
            this.bounds = new Rectangle(BoardView1.this.getHexLocation(moveStep.getPosition()), BoardView1.this.hex_size);
            this.image = null;
        }

        public void prepare() {
            Color color;
            Image image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
            Graphics graphics = image.getGraphics();
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            Point point = BoardView1.this.getHexLocation(this.step.getPosition());
            point.translate(-this.bounds.x, -this.bounds.y);
            Polygon polygon = BoardView1.this.facingPolys[this.step.getFacing()];
            Polygon polygon2 = BoardView1.this.movementPolys[this.step.getFacing()];
            switch (this.step.getMovementType()) {
                case 2: 
                case 5: {
                    if (this.step.isUsingMASC()) {
                        color = GUIPreferences.getInstance().getColor("AdvancedMoveMASCColor");
                        break;
                    }
                    color = GUIPreferences.getInstance().getColor("AdvancedMoveRunColor");
                    break;
                }
                case 3: {
                    color = GUIPreferences.getInstance().getColor("AdvancedMoveJumpColor");
                    break;
                }
                case -1: {
                    color = GUIPreferences.getInstance().getColor("AdvancedMoveIllegalColor");
                    break;
                }
                default: {
                    color = this.step.getType() == 2 ? GUIPreferences.getInstance().getColor("AdvancedMoveBackColor") : GUIPreferences.getInstance().getColor("AdvancedMoveDefaultColor");
                }
            }
            switch (this.step.getType()) {
                case 1: 
                case 2: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 27: {
                    Polygon polygon3 = new Polygon(polygon2.xpoints, polygon2.ypoints, polygon2.npoints);
                    graphics.setColor(Color.darkGray);
                    polygon3.translate(point.x + 1, point.y + 1);
                    graphics.drawPolygon(polygon3);
                    graphics.setColor(color);
                    polygon3.translate(-1, -1);
                    graphics.drawPolygon(polygon3);
                    this.drawMovementCost(this.step, point, graphics, color, true);
                    break;
                }
                case 6: 
                case 21: 
                case 24: 
                case 28: 
                case 29: {
                    Polygon polygon4 = BoardView1.this.movementPolys[7];
                    Polygon polygon5 = new Polygon(polygon4.xpoints, polygon4.ypoints, polygon4.npoints);
                    graphics.setColor(Color.darkGray);
                    polygon5.translate(point.x, point.y);
                    graphics.drawPolygon(polygon5);
                    graphics.setColor(color);
                    polygon5.translate(-1, -1);
                    graphics.drawPolygon(polygon5);
                    Point point2 = new Point(point.x + 1, point.y + 15);
                    this.drawMovementCost(this.step, point2, graphics, color, false);
                    break;
                }
                case 5: 
                case 20: {
                    Polygon polygon6 = BoardView1.this.movementPolys[6];
                    Polygon polygon7 = new Polygon(polygon6.xpoints, polygon6.ypoints, polygon6.npoints);
                    graphics.setColor(Color.darkGray);
                    polygon7.translate(point.x, point.y);
                    graphics.drawPolygon(polygon7);
                    graphics.setColor(color);
                    polygon7.translate(-1, -1);
                    graphics.drawPolygon(polygon7);
                    Point point3 = new Point(point.x, point.y + 15);
                    this.drawMovementCost(this.step, point3, graphics, color, false);
                    break;
                }
                case 25: {
                    String string = Messages.getString("BoardView1.Climb");
                    if (this.step.isPastDanger()) {
                        string = "(" + string + ")";
                    }
                    graphics.setFont(new Font("SansSerif", 0, 12));
                    int n = point.x + 42 - graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2;
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(string, n, point.y + 39);
                    graphics.setColor(color);
                    graphics.drawString(string, n - 1, point.y + 38);
                    break;
                }
                case 26: {
                    String string = Messages.getString("BoardView1.ClimbOff");
                    if (this.step.isPastDanger()) {
                        string = "(" + string + ")";
                    }
                    graphics.setFont(new Font("SansSerif", 0, 12));
                    int n = point.x + 42 - graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2;
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(string, n, point.y + 39);
                    graphics.setColor(color);
                    graphics.drawString(string, n - 1, point.y + 38);
                    break;
                }
                case 3: 
                case 4: {
                    Polygon polygon8 = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
                    graphics.setColor(Color.darkGray);
                    polygon8.translate(point.x + 1, point.y + 1);
                    graphics.drawPolygon(polygon8);
                    graphics.setColor(color);
                    polygon8.translate(-1, -1);
                    graphics.drawPolygon(polygon8);
                    break;
                }
                case 16: {
                    String string = Messages.getString("BoardView1.Load");
                    if (this.step.isPastDanger()) {
                        string = "(" + string + ")";
                    }
                    graphics.setFont(new Font("SansSerif", 0, 12));
                    int n = point.x + 42 - graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2;
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(string, n, point.y + 39);
                    graphics.setColor(color);
                    graphics.drawString(string, n - 1, point.y + 38);
                    break;
                }
                case 17: {
                    String string = Messages.getString("BoardView1.Unload");
                    if (this.step.isPastDanger()) {
                        string = "(" + string + ")";
                    }
                    graphics.setFont(new Font("SansSerif", 0, 12));
                    int n = point.x + 42 - graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2;
                    int n2 = point.y + 38 + graphics.getFontMetrics(graphics.getFont()).getHeight();
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(string, n, n2 + 1);
                    graphics.setColor(color);
                    graphics.drawString(string, n - 1, n2);
                    break;
                }
            }
            this.image = BoardView1.this.zoomIndex == 7 ? BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))) : BoardView1.this.getScaledImage(BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))));
            graphics.dispose();
            image.flush();
        }

        public Rectangle getBounds() {
            this.bounds = new Rectangle(BoardView1.this.getHexLocation(this.step.getPosition()), BoardView1.this.hex_size);
            return this.bounds;
        }

        public MoveStep getStep() {
            return this.step;
        }

        private void drawMovementCost(MoveStep moveStep, Point point, Graphics graphics, Color color, boolean bl) {
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(moveStep.getMpUsed());
            if (moveStep.isPavementStep() && moveStep.getParent().getEntity() instanceof Tank) {
                stringBuffer.append("+");
            }
            if (moveStep.isDanger()) {
                stringBuffer.append("*");
            }
            if (moveStep.isPastDanger()) {
                stringBuffer.insert(0, "(");
                stringBuffer.append(")");
            }
            if (moveStep.isUsingMASC()) {
                stringBuffer.append("[");
                stringBuffer.append(moveStep.getTargetNumberMASC());
                stringBuffer.append("+]");
            }
            if (moveStep.getMovementType() == 4 || moveStep.getMovementType() == 5 || moveStep.getMovementType() == 6 || moveStep.getMovementType() == 7 || moveStep.getElevation() != 0) {
                stringBuffer.append("{").append(moveStep.getElevation()).append("}");
            }
            string = stringBuffer.toString();
            graphics.setFont(new Font("SansSerif", 0, 12));
            int n = point.x + 42;
            if (bl) {
                n -= graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2;
            }
            graphics.setColor(Color.darkGray);
            graphics.drawString(string, n, point.y + 39);
            graphics.setColor(color);
            graphics.drawString(string, n - 1, point.y + 38);
        }
    }

    private class EntitySprite
    extends Sprite {
        private Entity entity;
        private Rectangle entityRect;
        private Rectangle modelRect;

        public EntitySprite(Entity entity) {
            this.entity = entity;
            String string = entity.getShortName();
            if (entity.getMovementMode() == 6) {
                string = string.concat(" (FL: ").concat(Integer.toString(entity.getElevation())).concat(")");
            }
            Font font = new Font("SansSerif", 0, 10);
            this.modelRect = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            Rectangle rectangle = new Rectangle(BoardView1.this.hex_size).union(this.modelRect);
            rectangle.setLocation(BoardView1.this.getHexLocation(entity.getPosition()));
            this.bounds = rectangle;
            this.entityRect = new Rectangle(this.bounds.x + (int)(20.0f * BoardView1.this.scale), this.bounds.y + (int)(14.0f * BoardView1.this.scale), (int)(44.0f * BoardView1.this.scale), (int)(44.0f * BoardView1.this.scale));
            this.image = null;
        }

        public Rectangle getBounds() {
            Rectangle rectangle = new Rectangle(BoardView1.this.hex_size).union(this.modelRect);
            rectangle.setLocation(BoardView1.this.getHexLocation(this.entity.getPosition()));
            this.bounds = rectangle;
            this.entityRect = new Rectangle(this.bounds.x + (int)(20.0f * BoardView1.this.scale), this.bounds.y + (int)(14.0f * BoardView1.this.scale), (int)(44.0f * BoardView1.this.scale), (int)(44.0f * BoardView1.this.scale));
            return this.bounds;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            if (this.trackThisEntitiesVisibilityInfo(this.entity) && !this.entity.isVisibleToEnemy() && GUIPreferences.getInstance().getBoolean("AdvancedTranslucentHiddenUnits")) {
                this.drawOnto(graphics, n, n2, imageObserver, true);
            } else {
                this.drawOnto(graphics, n, n2, imageObserver, false);
            }
        }

        public void prepare() {
            int n;
            Color color;
            Color color2;
            Color color3;
            Graphics graphics;
            Image image;
            String string = this.entity.getShortName();
            if (this.entity.getMovementMode() == 6) {
                string = string.concat(" (FL: ").concat(Integer.toString(this.entity.getElevation())).concat(")");
            }
            if (PreferenceManager.getClientPreferences().getShowUnitId()) {
                string = string + Messages.getString("BoardView1.ID") + this.entity.getId();
            }
            Font font = new Font("SansSerif", 0, 10);
            Rectangle rectangle = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            try {
                image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
                graphics = image.getGraphics();
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            graphics.drawImage(BoardView1.this.tileManager.imageFor(this.entity), 0, 0, this);
            if (this.entity.isDone()) {
                color3 = Color.lightGray;
                color2 = Color.darkGray;
                color = Color.black;
            } else if (this.entity.isImmobile()) {
                color3 = Color.darkGray;
                color2 = Color.black;
                color = Color.lightGray;
            } else {
                color3 = Color.black;
                color2 = Color.lightGray;
                color = Color.darkGray;
            }
            graphics.setFont(font);
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle.translate(-1, -1);
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color3);
            graphics.drawString(string, rectangle.x + 1, rectangle.y + rectangle.height - 1);
            graphics.setColor(Color.white);
            if (!(this.entity.getFacing() == -1 || this.entity instanceof Infantry && ((Infantry)this.entity).getDugIn() == 0)) {
                graphics.drawPolygon(BoardView1.this.facingPolys[this.entity.getFacing()]);
            }
            int n2 = this.entity.getFacing();
            if (!(this.entity instanceof Mech) && !(this.entity instanceof Protomech)) {
                n2 = this.entity.getSecondaryFacing();
            } else if (this.entity.getArmsFlipped()) {
                n2 = (this.entity.getFacing() + 3) % 6;
            }
            if (n2 != -1 && n2 != this.entity.getFacing()) {
                graphics.setColor(Color.red);
                graphics.drawPolygon(BoardView1.this.facingPolys[n2]);
            }
            boolean bl = false;
            int n3 = 0;
            boolean bl2 = false;
            if (this.entity instanceof Tank) {
                bl = !((Tank)this.entity).hasNoTurret() && !this.entity.canChangeSecondaryFacing();
                n3 = ((Tank)this.entity).getStunnedTurns();
            } else if (this.entity instanceof GunEmplacement) {
                bl = ((GunEmplacement)this.entity).hasTurret() && !this.entity.canChangeSecondaryFacing();
                bl2 = true;
            }
            if (this.entity.crew.isDead()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString(Messages.getString("BoardView1.CrewDead"), 18, 39);
                graphics.setColor(Color.red);
                graphics.drawString(Messages.getString("BoardView1.CrewDead"), 17, 38);
            } else if (!bl2 && this.entity.isImmobile()) {
                if (this.entity.isProne()) {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 18, 35);
                    graphics.drawString(Messages.getString("BoardView1.PRONE"), 26, 48);
                    graphics.setColor(Color.red);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 17, 34);
                    graphics.setColor(Color.yellow);
                    graphics.drawString(Messages.getString("BoardView1.PRONE"), 25, 47);
                } else if (n3 > 0) {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 18, 35);
                    graphics.drawString(Messages.getString("BoardView1.STUNNED", new Object[]{n3}), 22, 48);
                    graphics.setColor(Color.red);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 17, 34);
                    graphics.setColor(Color.yellow);
                    graphics.drawString(Messages.getString("BoardView1.STUNNED", new Object[]{n3}), 21, 47);
                } else if (bl) {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 18, 35);
                    graphics.drawString(Messages.getString("BoardView1.LOCKED"), 22, 48);
                    graphics.setColor(Color.red);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 17, 34);
                    graphics.setColor(Color.yellow);
                    graphics.drawString(Messages.getString("BoardView1.LOCKED"), 21, 47);
                } else {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 18, 39);
                    graphics.setColor(Color.red);
                    graphics.drawString(Messages.getString("BoardView1.IMMOBILE"), 17, 38);
                }
            } else if (this.entity.isProne()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString(Messages.getString("BoardView1.PRONE"), 26, 39);
                graphics.setColor(Color.yellow);
                graphics.drawString(Messages.getString("BoardView1.PRONE"), 25, 38);
            } else if (n3 > 0) {
                graphics.setColor(Color.darkGray);
                graphics.drawString(Messages.getString("BoardView1.STUNNED", new Object[]{n3}), 22, 48);
                graphics.setColor(Color.yellow);
                graphics.drawString(Messages.getString("BoardView1.STUNNED", new Object[]{n3}), 21, 47);
            } else if (bl) {
                graphics.setColor(Color.darkGray);
                graphics.drawString(Messages.getString("BoardView1.LOCKED"), 22, 39);
                graphics.setColor(Color.yellow);
                graphics.drawString(Messages.getString("BoardView1.LOCKED"), 21, 38);
            }
            if (-1 != this.entity.getSwarmAttackerId()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString(Messages.getString("BoardView1.SWARMED"), 17, 22);
                graphics.setColor(Color.red);
                graphics.drawString(Messages.getString("BoardView1.SWARMED"), 16, 21);
            }
            if (this.entity.getLoadedUnits().size() > 0) {
                graphics.setColor(Color.darkGray);
                graphics.drawString("T", 20, 71);
                graphics.setColor(Color.black);
                graphics.drawString("T", 19, 70);
            }
            if (this.entity.isStuck()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString(Messages.getString("BoardView1.STUCK"), 26, 61);
                graphics.setColor(Color.orange);
                graphics.drawString(Messages.getString("BoardView1.STUCK"), 25, 60);
            }
            if (this.trackThisEntitiesVisibilityInfo(this.entity)) {
                if (!this.entity.isSeenByEnemy()) {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString("U", 30, 71);
                    graphics.setColor(Color.black);
                    graphics.drawString("U", 29, 70);
                } else if (!this.entity.isVisibleToEnemy() && !GUIPreferences.getInstance().getBoolean("AdvancedTranslucentHiddenUnits")) {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString("H", 30, 71);
                    graphics.setColor(Color.black);
                    graphics.drawString("H", 29, 70);
                }
            }
            if (this.entity.isHullDown()) {
                graphics.setColor(Color.darkGray);
                graphics.drawString("D", 40, 71);
                graphics.setColor(Color.black);
                graphics.drawString("D", 39, 70);
            } else if (this.entity instanceof Infantry) {
                n = ((Infantry)this.entity).getDugIn();
                if (n == 2) {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString("D", 40, 71);
                    graphics.setColor(Color.black);
                    graphics.drawString("D", 39, 70);
                } else if (n != 0) {
                    graphics.setColor(Color.darkGray);
                    graphics.drawString("W", 40, 71);
                    graphics.setColor(Color.black);
                    graphics.drawString("W", 39, 70);
                }
            }
            n = 23;
            int n4 = 0;
            double d = 0.0;
            d = this.entity.getArmorRemainingPercent();
            n4 = (int)((double)n * d);
            graphics.setColor(Color.darkGray);
            graphics.fillRect(56, 7, 23, 3);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(55, 6, 23, 3);
            graphics.setColor(this.getStatusBarColor(d));
            graphics.fillRect(55, 6, n4, 3);
            if (!bl2) {
                d = this.entity.getInternalRemainingPercent();
                n4 = (int)((double)n * d);
                graphics.setColor(Color.darkGray);
                graphics.fillRect(56, 11, 23, 3);
                graphics.setColor(Color.lightGray);
                graphics.fillRect(55, 10, 23, 3);
                graphics.setColor(this.getStatusBarColor(d));
                graphics.fillRect(55, 10, n4, 3);
            }
            this.image = BoardView1.this.zoomIndex == 7 ? BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))) : BoardView1.this.getScaledImage(BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))));
            graphics.dispose();
            image.flush();
        }

        private boolean trackThisEntitiesVisibilityInfo(Entity entity) {
            if (BoardView1.this.getLocalPlayer() == null) {
                return false;
            }
            return BoardView1.this.game.getOptions().booleanOption("double_blind") && (entity.getOwner().getId() == BoardView1.this.getLocalPlayer().getId() || BoardView1.this.game.getOptions().booleanOption("team_vision") && entity.getOwner().getTeam() == BoardView1.this.getLocalPlayer().getTeam());
        }

        private Color getStatusBarColor(double d) {
            if (d <= 0.25) {
                return Color.red;
            }
            if (d <= 0.75) {
                return Color.yellow;
            }
            return new Color(16, 196, 16);
        }

        public boolean isInside(Point point) {
            return this.entityRect.contains(point.x + ((BoardView1)BoardView1.this).view.x - ((BoardView1)BoardView1.this).offset.x, point.y + ((BoardView1)BoardView1.this).view.y - ((BoardView1)BoardView1.this).offset.y);
        }

        public String[] getTooltip() {
            String[] stringArray = new String[3];
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.entity.getChassis()).append(" (").append(this.entity.getOwner().getName()).append("); ").append(this.entity.getCrew().getGunnery()).append("/").append(this.entity.getCrew().getPiloting()).append(Messages.getString("BoardView1.pilot"));
            int n = this.entity.getCrew().countAdvantages();
            if (n > 0) {
                stringBuffer.append(" <").append(n).append(Messages.getString("BoardView1.advs"));
            }
            stringArray[0] = stringBuffer.toString();
            GunEmplacement gunEmplacement = null;
            if (this.entity instanceof GunEmplacement) {
                gunEmplacement = (GunEmplacement)this.entity;
            }
            stringBuffer = new StringBuffer();
            if (gunEmplacement == null) {
                stringBuffer.append(Messages.getString("BoardView1.move")).append(this.entity.getMovementAbbr(this.entity.moved)).append(":").append(this.entity.delta_distance).append(" (+").append(Compute.getTargetMovementModifier(BoardView1.this.game, this.entity.getId()).getValue()).append(");").append(Messages.getString("BoardView1.Heat")).append(this.entity.heat);
                if (this.entity.isCharging()) {
                    stringBuffer.append(" ").append(Messages.getString("BoardView1.charge1"));
                }
                if (this.entity.isMakingDfa()) {
                    stringBuffer.append(" ").append(Messages.getString("BoardBiew1.DFA1"));
                }
            } else if (gunEmplacement.hasTurret() && gunEmplacement.isTurretLocked()) {
                stringBuffer.append(Messages.getString("BoardView1.TurretLocked"));
                if (gunEmplacement.getFirstWeapon() == -1) {
                    stringBuffer.append(",");
                    stringBuffer.append(Messages.getString("BoardView1.WeaponsDestroyed"));
                }
            } else if (gunEmplacement.getFirstWeapon() == -1) {
                stringBuffer.append(Messages.getString("BoardView1.WeaponsDestroyed"));
            } else {
                stringBuffer.append(Messages.getString("BoardView1.Operational"));
            }
            if (this.entity.isDone()) {
                stringBuffer.append(" (").append(Messages.getString("BoardView1.done")).append(")");
            }
            stringArray[1] = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            if (gunEmplacement == null) {
                stringBuffer.append(Messages.getString("BoardView1.Armor")).append(this.entity.getTotalArmor()).append(Messages.getString("BoardView1.internal")).append(this.entity.getTotalInternal());
            } else {
                stringBuffer.append(Messages.getString("BoardView1.cf")).append(gunEmplacement.getCurrentCF()).append(Messages.getString("BoardView1.turretArmor")).append(gunEmplacement.getCurrentTurretArmor());
            }
            stringArray[2] = stringBuffer.toString();
            return stringArray;
        }
    }

    private class WreckSprite
    extends Sprite {
        private Entity entity;
        private Rectangle modelRect;

        public WreckSprite(Entity entity) {
            this.entity = entity;
            String string = entity.getShortName();
            Font font = new Font("SansSerif", 0, 10);
            this.modelRect = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            Rectangle rectangle = new Rectangle(BoardView1.this.hex_size).union(this.modelRect);
            rectangle.setLocation(BoardView1.this.getHexLocation(entity.getPosition()));
            this.bounds = rectangle;
            this.image = null;
        }

        public Rectangle getBounds() {
            Rectangle rectangle = new Rectangle(BoardView1.this.hex_size).union(this.modelRect);
            rectangle.setLocation(BoardView1.this.getHexLocation(this.entity.getPosition()));
            this.bounds = rectangle;
            return this.bounds;
        }

        public void prepare() {
            Graphics graphics;
            Image image;
            String string = this.entity.getShortName();
            Font font = new Font("SansSerif", 0, 10);
            Rectangle rectangle = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            try {
                image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
                graphics = image.getGraphics();
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            Image image2 = BoardView1.this.tileManager.wreckMarkerFor(this.entity);
            if (null != image2) {
                graphics.drawImage(image2, 0, 0, this);
            }
            Color color = Color.lightGray;
            Color color2 = Color.darkGray;
            Color color3 = Color.black;
            graphics.setFont(font);
            graphics.setColor(color3);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            rectangle.translate(-1, -1);
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.drawString(string, rectangle.x + 1, rectangle.y + rectangle.height - 1);
            this.image = BoardView1.this.zoomIndex == 7 ? BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))) : BoardView1.this.getScaledImage(BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))));
            graphics.dispose();
            image.flush();
        }

        public boolean isInside(Point point) {
            return false;
        }
    }

    private class MovingEntitySprite
    extends Sprite {
        private int facing;
        private Entity entity;
        private Rectangle modelRect;

        public MovingEntitySprite(Entity entity, Coords coords, int n) {
            this.entity = entity;
            this.facing = n;
            String string = entity.getShortName();
            Font font = new Font("SansSerif", 0, 10);
            this.modelRect = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            Rectangle rectangle = new Rectangle(BoardView1.this.hex_size).union(this.modelRect);
            rectangle.setLocation(BoardView1.this.getHexLocation(coords));
            this.bounds = rectangle;
            this.image = null;
        }

        public void prepare() {
            Graphics graphics;
            Image image;
            try {
                image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
                graphics = image.getGraphics();
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            graphics.drawImage(BoardView1.this.tileManager.imageFor(this.entity, this.facing), 0, 0, this);
            this.image = BoardView1.this.zoomIndex == 7 ? BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))) : BoardView1.this.getScaledImage(BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))));
            graphics.dispose();
            image.flush();
        }
    }

    private class GhostEntitySprite
    extends Sprite {
        private Entity entity;
        private Rectangle modelRect;

        public GhostEntitySprite(Entity entity) {
            this.entity = entity;
            String string = entity.getShortName();
            Font font = new Font("SansSerif", 0, 10);
            this.modelRect = new Rectangle(47, 55, BoardView1.this.getFontMetrics(font).stringWidth(string) + 1, BoardView1.this.getFontMetrics(font).getAscent());
            Rectangle rectangle = new Rectangle(BoardView1.this.hex_size).union(this.modelRect);
            rectangle.setLocation(BoardView1.this.getHexLocation(entity.getPosition()));
            this.bounds = rectangle;
            this.image = null;
        }

        public void prepare() {
            Graphics graphics;
            Image image;
            try {
                image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
                graphics = image.getGraphics();
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            graphics.drawImage(BoardView1.this.tileManager.imageFor(this.entity), 0, 0, this);
            this.image = BoardView1.this.zoomIndex == 7 ? BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))) : BoardView1.this.getScaledImage(BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))));
            graphics.dispose();
            image.flush();
        }

        public Rectangle getBounds() {
            Rectangle rectangle = new Rectangle(BoardView1.this.hex_size).union(this.modelRect);
            rectangle.setLocation(BoardView1.this.getHexLocation(this.entity.getPosition()));
            this.bounds = rectangle;
            return this.bounds;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            this.drawOnto(graphics, n, n2, imageObserver, true);
        }
    }

    private class CursorSprite
    extends Sprite {
        private Color color;
        private Coords hexLoc;

        public CursorSprite(Color color) {
            this.color = color;
            this.bounds = new Rectangle(((BoardView1)BoardView1.this).hexPoly.getBounds().width + 1, ((BoardView1)BoardView1.this).hexPoly.getBounds().height + 1);
            this.image = null;
            this.setOffScreen();
        }

        public void prepare() {
            Image image = BoardView1.this.createImage(this.bounds.width, this.bounds.height);
            Graphics graphics = image.getGraphics();
            graphics.setColor(new Color(-65281));
            graphics.fillRect(0, 0, this.bounds.width, this.bounds.height);
            graphics.setColor(this.color);
            graphics.drawPolygon(BoardView1.this.hexPoly);
            this.image = BoardView1.this.zoomIndex == 7 ? BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))) : BoardView1.this.getScaledImage(BoardView1.this.createImage(new FilteredImageSource(image.getSource(), new KeyAlphaFilter(-65281))));
            graphics.dispose();
            image.flush();
        }

        public void setOffScreen() {
            this.bounds.setLocation(-100, -100);
            this.hexLoc = new Coords(-2, -2);
        }

        public void setHexLocation(Coords coords) {
            this.hexLoc = coords;
            this.bounds.setLocation(BoardView1.this.getHexLocation(coords));
        }

        public Rectangle getBounds() {
            this.bounds = new Rectangle(((BoardView1)BoardView1.this).hexPoly.getBounds().width + 1, ((BoardView1)BoardView1.this).hexPoly.getBounds().height + 1);
            this.bounds.setLocation(BoardView1.this.getHexLocation(this.hexLoc));
            return this.bounds;
        }
    }

    private abstract class Sprite
    implements ImageObserver {
        protected Rectangle bounds;
        protected Image image;
        protected boolean hidden = false;

        private Sprite() {
        }

        public abstract void prepare();

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (n == 32) {
                this.prepare();
                BoardView1.this.repaint();
                return false;
            }
            return true;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public boolean isReady() {
            return this.image != null;
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver) {
            this.drawOnto(graphics, n, n2, imageObserver, false);
        }

        public void drawOnto(Graphics graphics, int n, int n2, ImageObserver imageObserver, boolean bl) {
            if (this.isReady()) {
                if (bl) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    graphics2D.drawImage(this.image, n, n2, imageObserver);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                } else {
                    graphics.drawImage(this.image, n, n2, imageObserver);
                }
            } else {
                this.prepare();
            }
        }

        public boolean isInside(Point point) {
            return this.bounds.contains(point);
        }

        public String[] getTooltip() {
            return null;
        }
    }

    private class TooltipCanvas
    extends Canvas {
        private String[] tipStrings;
        private Dimension size;

        public TooltipCanvas(String[] stringArray) {
            this.tipStrings = stringArray;
            this.setFont(new Font("SansSerif", 0, 12));
            this.setBackground(SystemColor.info);
            this.setForeground(SystemColor.infoText);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (fontMetrics.stringWidth(stringArray[i]) <= n) continue;
                n = fontMetrics.stringWidth(stringArray[i]);
            }
            this.size = new Dimension(n + 5, fontMetrics.getAscent() * stringArray.length + 4);
            this.setSize(this.size);
        }

        public void paint(Graphics graphics) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.size.width, this.size.height);
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, this.size.width - 1, this.size.height - 1);
            for (int i = 0; i < this.tipStrings.length; ++i) {
                graphics.drawString(this.tipStrings[i], 2, (i + 1) * fontMetrics.getAscent());
            }
        }
    }

    private class MovingUnit {
        public Entity entity;
        public Vector path;

        MovingUnit(Entity entity, Vector vector) {
            this.entity = entity;
            this.path = vector;
        }
    }
}

