/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Vector;
import megamek.client.event.BoardViewEvent;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.Displayable;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.util.StringUtil;

public class UnitOverview
implements Displayable {
    private static final String IMAGE_DIR = "data/images/widgets";
    private static final int UNKNOWN_UNITS_PER_PAGE = -1;
    public static final int ICON_NAME_MAX_LENGTH = 52;
    private static final Font FONT = new Font("SansSerif", 0, 10);
    private static final int DIST_TOP = 5;
    private static final int DIST_SIDE = 5;
    private static final int ICON_WIDTH = 56;
    private static final int ICON_HEIGHT = 48;
    private static final int BUTTON_WIDTH = 56;
    private static final int BUTTON_HEIGHT = 11;
    private static final int BUTTON_PADDING = 2;
    private static final int PADDING = 5;
    private int[] unitIds;
    private boolean isHit = false;
    private boolean visible = true;
    private boolean scroll = false;
    private int unitsPerPage = -1;
    private int actUnitsPerPage = 0;
    private int scrollOffset = 0;
    private ClientGUI clientgui;
    private FontMetrics fm;
    private Image scrollUp;
    private Image scrollDown;
    private Image pageUp;
    private Image pageDown;

    public UnitOverview(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.fm = clientGUI.bv.getFontMetrics(FONT);
        Toolkit toolkit = clientGUI.bv.getToolkit();
        this.scrollUp = toolkit.getImage("data/images/widgets/scrollUp.gif");
        PMUtil.setImage(this.scrollUp, clientGUI);
        this.scrollDown = toolkit.getImage("data/images/widgets/scrollDown.gif");
        PMUtil.setImage(this.scrollDown, clientGUI);
        this.pageUp = toolkit.getImage("data/images/widgets/pageUp.gif");
        PMUtil.setImage(this.pageUp, clientGUI);
        this.pageDown = toolkit.getImage("data/images/widgets/pageDown.gif");
        PMUtil.setImage(this.pageDown, clientGUI);
    }

    public void draw(Graphics graphics, Dimension dimension) {
        if (!this.visible) {
            return;
        }
        if (this.unitsPerPage == -1) {
            this.computeUnitsPerPage(dimension);
        }
        graphics.setFont(FONT);
        Vector<Entity> vector = this.clientgui.getClient().game.getPlayerEntities(this.clientgui.getClient().getLocalPlayer());
        this.unitIds = new int[vector.size()];
        this.scroll = vector.size() > this.unitsPerPage;
        int n = this.actUnitsPerPage = this.scroll ? this.unitsPerPage - 1 : this.unitsPerPage;
        if (this.scrollOffset + this.actUnitsPerPage > this.unitIds.length) {
            this.scrollOffset = this.unitIds.length - this.actUnitsPerPage;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
        }
        int n2 = dimension.width - 5 - 56;
        int n3 = 5;
        if (this.scroll) {
            graphics.drawImage(this.pageUp, n2, n3, this.clientgui.bv);
            graphics.drawImage(this.scrollUp, n2, n3 + 11 + 2, this.clientgui.bv);
            n3 += 26;
        }
        for (int i = this.scrollOffset; i < vector.size() && i < this.actUnitsPerPage + this.scrollOffset; ++i) {
            Entity entity;
            Entity entity2 = vector.elementAt(i);
            this.unitIds[i] = entity2.getId();
            String string = this.getIconName(entity2, this.fm);
            Image image = this.clientgui.bv.getTilesetManager().iconFor(entity2);
            graphics.drawImage(image, n2, n3, this.clientgui.bv);
            this.printLine(graphics, n2 + 3, n3 + 46, string);
            this.drawBars(graphics, entity2, n2, n3);
            this.drawHeat(graphics, entity2, n2, n3);
            this.drawConditionStrings(graphics, entity2, n2, n3);
            graphics.setColor(this.getFrameColor(entity2));
            graphics.drawRect(n2, n3, 56, 48);
            Entity entity3 = entity = this.clientgui == null ? null : this.clientgui.getClient().getEntity(this.clientgui.getSelectedEntityNum());
            if (entity2 == entity) {
                graphics.drawRect(n2 - 1, n3 - 1, 58, 50);
            }
            n3 += 53;
        }
        if (this.scroll) {
            n3 -= 5;
            graphics.drawImage(this.scrollDown, n2, n3 += 2, this.clientgui.bv);
            graphics.drawImage(this.pageDown, n2, n3 + 11 + 2, this.clientgui.bv);
        }
    }

    public void setIdleTime(long l, boolean bl) {
    }

    public boolean isHit(Point point, Dimension dimension) {
        if (!this.visible) {
            return false;
        }
        int n = this.scroll ? this.unitsPerPage - 1 : this.unitsPerPage;
        int n2 = point.x;
        int n3 = point.y;
        int n4 = dimension.width - 5 - 56;
        int n5 = 5;
        if (n2 < n4 || n2 > n4 + 56 || n3 < n5 || n3 > n5 + this.unitsPerPage * 53) {
            return false;
        }
        if (this.scroll) {
            if (n3 > n5 && n3 < n5 + 11) {
                this.pageUp();
                return true;
            }
            if (n3 > (n5 += 13) && n3 < n5 + 11) {
                this.scrollUp();
                return true;
            }
            n5 += 13;
        }
        for (int i = this.scrollOffset; i < this.unitIds.length && i < n + this.scrollOffset; ++i) {
            if (n3 > n5 && n3 < n5 + 48) {
                this.clientgui.bv.processBoardViewEvent(new BoardViewEvent(this.clientgui.bv, 9, this.unitIds[i]));
                this.isHit = true;
                return true;
            }
            n5 += 53;
        }
        if (this.scroll) {
            n5 -= 5;
            if (n3 > (n5 += 2) && n3 < n5 + 11) {
                this.scrollDown();
                return true;
            }
            if (n3 > (n5 += 13) && n3 < n5 + 11) {
                this.pageDown();
                return true;
            }
        }
        return false;
    }

    public boolean isMouseOver(Point point, Dimension dimension) {
        return false;
    }

    public boolean isSliding() {
        return false;
    }

    public boolean slide() {
        return false;
    }

    public boolean isDragged(Point point, Dimension dimension) {
        return false;
    }

    public boolean isBeingDragged() {
        return false;
    }

    public boolean isReleased() {
        if (!this.visible) {
            return false;
        }
        if (this.isHit) {
            this.isHit = false;
            return true;
        }
        return false;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void drawHeat(Graphics graphics, Entity entity, int n, int n2) {
        if (!(entity instanceof Mech)) {
            return;
        }
        boolean bl = false;
        int n3 = 30;
        if (entity.getGame() != null && entity.getGame().getOptions().booleanOption("maxtech_heat")) {
            n3 = 50;
            bl = true;
        }
        int n4 = Math.min(n3, entity.heat);
        graphics.setColor(Color.darkGray);
        graphics.fillRect(n + 52, n2 + 4, 2, 30);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n + 51, n2 + 3, 2, 30);
        graphics.setColor(Color.red);
        if (bl) {
            graphics.fillRect(n + 51, n2 + 3 + (30 - (int)((double)n4 * 0.6)), 2, (int)((double)n4 * 0.6));
        } else {
            graphics.fillRect(n + 51, n2 + 3 + (30 - n4), 2, n4);
        }
    }

    private void drawBars(Graphics graphics, Entity entity, int n, int n2) {
        int n3 = 23;
        int n4 = 0;
        double d = 0.0;
        d = entity.getArmorRemainingPercent();
        n4 = (int)((double)n3 * d);
        graphics.setColor(Color.darkGray);
        graphics.fillRect(n + 4, n2 + 4, 23, 2);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n + 3, n2 + 3, 23, 2);
        graphics.setColor(this.getStatusBarColor(d));
        graphics.fillRect(n + 3, n2 + 3, n4, 2);
        d = entity.getInternalRemainingPercent();
        n4 = (int)((double)n3 * d);
        graphics.setColor(Color.darkGray);
        graphics.fillRect(n + 4, n2 + 7, 23, 2);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n + 3, n2 + 6, 23, 2);
        graphics.setColor(this.getStatusBarColor(d));
        graphics.fillRect(n + 3, n2 + 6, n4, 2);
    }

    private Color getStatusBarColor(double d) {
        if (d <= 0.25) {
            return Color.red;
        }
        if (d <= 0.75) {
            return Color.yellow;
        }
        return new Color(16, 196, 16);
    }

    private Color getFrameColor(Entity entity) {
        if (!this.clientgui.getClient().isMyTurn() || !entity.isSelectableThisTurn()) {
            return Color.gray;
        }
        return Color.black;
    }

    private void printLine(Graphics graphics, int n, int n2, String string) {
        graphics.setColor(Color.black);
        graphics.drawString(string, n + 1, n2);
        graphics.drawString(string, n - 1, n2);
        graphics.drawString(string, n, n2 + 1);
        graphics.drawString(string, n, n2 - 1);
        graphics.setColor(Color.white);
        graphics.drawString(string, n, n2);
    }

    private void drawConditionStrings(Graphics graphics, Entity entity, int n, int n2) {
        int n3;
        if (entity.isImmobile() && !entity.isProne()) {
            graphics.setColor(Color.darkGray);
            graphics.drawString(Messages.getString("UnitOverview.IMMOB"), n + 11, n2 + 29);
            graphics.setColor(Color.red);
            graphics.drawString(Messages.getString("UnitOverview.IMMOB"), n + 10, n2 + 28);
        } else if (!entity.isImmobile() && entity.isProne()) {
            graphics.setColor(Color.darkGray);
            graphics.drawString(Messages.getString("UnitOverview.PRONE"), n + 11, n2 + 29);
            graphics.setColor(Color.yellow);
            graphics.drawString(Messages.getString("UnitOverview.PRONE"), n + 10, n2 + 28);
        } else if (entity.isImmobile() && entity.isProne()) {
            graphics.setColor(Color.darkGray);
            graphics.drawString(Messages.getString("UnitOverview.IMMOB"), n + 11, n2 + 24);
            graphics.drawString(Messages.getString("UnitOverview.PRONE"), n + 11, n2 + 34);
            graphics.setColor(Color.red);
            graphics.drawString(Messages.getString("UnitOverview.IMMOB"), n + 10, n2 + 23);
            graphics.setColor(Color.yellow);
            graphics.drawString(Messages.getString("UnitOverview.PRONE"), n + 10, n2 + 33);
        } else if (!entity.isDeployed() && (n3 = entity.getDeployRound() - this.clientgui.getClient().game.getRoundCount()) > 0) {
            this.printLine(graphics, n + 25, n2 + 28, Integer.toString(n3));
        }
    }

    private void computeUnitsPerPage(Dimension dimension) {
        this.unitsPerPage = (dimension.height - 5) / 53;
    }

    private void pageUp() {
        if (this.scrollOffset > 0) {
            this.scrollOffset -= this.actUnitsPerPage;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            this.clientgui.bv.repaint();
        }
    }

    private void pageDown() {
        if (this.scrollOffset < this.unitIds.length - this.actUnitsPerPage) {
            this.scrollOffset += this.actUnitsPerPage;
            if (this.scrollOffset > this.unitIds.length - this.actUnitsPerPage) {
                this.scrollOffset = this.unitIds.length - this.actUnitsPerPage;
            }
            this.clientgui.bv.repaint();
        }
    }

    private void scrollUp() {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.clientgui.bv.repaint();
        }
    }

    private void scrollDown() {
        if (this.scrollOffset < this.unitIds.length - this.actUnitsPerPage) {
            ++this.scrollOffset;
            this.clientgui.bv.repaint();
        }
    }

    protected String getIconName(Entity entity, FontMetrics fontMetrics) {
        if (entity instanceof BattleArmor) {
            Vector<String> vector;
            String string = entity.getShortName();
            if (fontMetrics.stringWidth(string) > 52 && (string = (vector = StringUtil.splitString(string, " ")).elementAt(0)).equals("Clan")) {
                string = vector.elementAt(1);
            }
            return this.adjustString(string, fontMetrics);
        }
        if (entity instanceof Protomech) {
            String string = entity.getChassis() + " " + entity.getModel();
            return this.adjustString(string, fontMetrics);
        }
        if (entity instanceof Tank) {
            String string = entity.getShortName();
            if (fontMetrics.stringWidth(string) > 52) {
                Vector<String> vector = StringUtil.splitString(string, " ");
                string = vector.elementAt(0);
            }
            return this.adjustString(string, fontMetrics);
        }
        if (entity instanceof Infantry || entity instanceof Mech || entity instanceof GunEmplacement) {
            String string = entity.getModel();
            return this.adjustString(string, fontMetrics);
        }
        return "!!Unknown!!";
    }

    protected String adjustString(String string, FontMetrics fontMetrics) {
        while (fontMetrics.stringWidth(string) > 52) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

