/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.widget.BackGroundDrawer;

public class BufferedPanel
extends Panel
implements ComponentListener {
    private Vector bgDrawers = new Vector();
    private Dimension preferredSize = new Dimension();

    public BufferedPanel() {
        this.addComponentListener(this);
    }

    public BufferedPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.addComponentListener(this);
    }

    public void addBgDrawer(BackGroundDrawer backGroundDrawer) {
        this.bgDrawers.addElement(backGroundDrawer);
    }

    public void removeBgDrawer(BackGroundDrawer backGroundDrawer) {
        this.bgDrawers.removeElement(backGroundDrawer);
    }

    public void removeBgDrawers() {
        this.bgDrawers.removeAllElements();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (null == graphics) {
            return;
        }
        Image image = this.createImage(this.getSize().width, this.getSize().height);
        Graphics graphics2 = image.getGraphics();
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.clearGraphics(graphics2);
        Enumeration enumeration = this.bgDrawers.elements();
        while (enumeration.hasMoreElements()) {
            BackGroundDrawer backGroundDrawer = (BackGroundDrawer)enumeration.nextElement();
            backGroundDrawer.drawInto(graphics2, this.getSize().width, this.getSize().height);
        }
        super.paint(graphics2);
        graphics.drawImage(image, 0, 0, null);
        graphics2.dispose();
    }

    private void clearGraphics(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(color);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
    }
}

