/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMPicArea;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.common.Entity;
import megamek.common.Infantry;

public class InfantryMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Image infImage;
    private Component comp;
    private PMPicArea[] areas = new PMPicArea[30];
    private PMAreasGroup content = new PMAreasGroup();
    private PMValueLabel label;
    private Vector bgDrawers = new Vector();
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorMediumFontSize"));

    public InfantryMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setBackGround();
    }

    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    public Vector getBackgroundDrawers() {
        return this.bgDrawers;
    }

    public void setEntity(Entity entity) {
        int n;
        Infantry infantry = (Infantry)entity;
        int n2 = infantry.getInternal(0);
        for (n = 0; n < n2; ++n) {
            this.areas[n].setVisible(true);
        }
        for (n = n2; n < 30; ++n) {
            this.areas[n].setVisible(false);
        }
        this.label.setValue(Messages.getString("InfantryMapSet.InfantryPlatoon", new Object[]{Integer.toString(n2)}));
    }

    private void setAreas() {
        int n = 30;
        int n2 = 42;
        this.infImage = this.comp.getToolkit().getImage("data/images/widgets/inf.gif");
        PMUtil.setImage(this.infImage, this.comp);
        for (int i = 0; i < 30; ++i) {
            int n3 = i % 5 * n;
            int n4 = i / 5 * n2;
            this.areas[i] = new PMPicArea(this.infImage);
            this.areas[i].translate(n3, n4);
            this.content.addArea(this.areas[i]);
        }
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.label = new PMValueLabel(fontMetrics, Color.white);
        this.label.setValue(Messages.getString("InfantryMapSet.InfantryPlatoon", new Object[]{"00"}));
        Dimension dimension = this.label.getSize();
        this.content.translate(0, dimension.height + 5);
        this.label.moveTo(dimension.width / 2, dimension.height);
        this.content.addArea(this.label);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }
}

