/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import megamek.client.Client;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.PlayerListDialog;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameListenerAdapter;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GameTurnChangeEvent;

public class ChatterBox
implements KeyListener {
    private Client client;
    private JPanel chatPanel;
    private JTextArea chatArea;
    private JList playerList;
    private JTextField inputField;
    private JButton butDone;

    public ChatterBox(ClientGUI clientGUI) {
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(new GameListenerAdapter(){

            public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
                ChatterBox.this.chatArea.append('\n' + gamePlayerChatEvent.getMessage());
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gamePlayerChange(GamePlayerChangeEvent gamePlayerChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameEntityNew(GameEntityNewEvent gameEntityNewEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }

            public void gameEntityRemove(GameEntityRemoveEvent gameEntityRemoveEvent) {
                PlayerListDialog.refreshPlayerList(ChatterBox.this.playerList, ChatterBox.this.client);
            }
        });
        this.chatArea = new JTextArea(" \n", GUIPreferences.getInstance().getInt("AdvancedChatboxSize"), 40);
        this.chatArea.setEditable(false);
        this.playerList = new JList(new DefaultListModel());
        this.playerList.setVisibleRowCount(GUIPreferences.getInstance().getInt("AdvancedChatboxSize"));
        this.inputField = new JTextField();
        this.inputField.addKeyListener(this);
        this.butDone = new JButton(Messages.getString("ChatterBox.ImDone"));
        this.butDone.setEnabled(false);
        this.chatPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.chatArea), "Center");
        jPanel.add((Component)this.playerList, "West");
        jPanel.add((Component)this.inputField, "South");
        this.chatPanel.add((Component)jPanel, "Center");
        this.chatPanel.add((Component)this.butDone, "East");
    }

    public void moveToEnd() {
        if (this.chatArea.isShowing()) {
            int n = this.chatArea.getText().length() - 1;
            this.chatArea.select(n, n);
            this.chatArea.setCaretPosition(n);
        }
    }

    public JComponent getComponent() {
        return this.chatPanel;
    }

    public void systemMessage(String string) {
        this.chatArea.append("\nMegaMek: " + string);
    }

    public void setDoneButton(JButton jButton) {
        this.chatPanel.remove(this.butDone);
        this.butDone = jButton;
        this.chatPanel.add((Component)this.butDone, "East");
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.client.sendChat(this.inputField.getText());
            this.inputField.setText("");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

