/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.ui.swing.ClientDialog;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;

public class CommonSettingsDialog
extends ClientDialog
implements ActionListener,
ItemListener,
FocusListener,
ListSelectionListener {
    private JTabbedPane panTabs = new JTabbedPane();
    private JCheckBox minimapEnabled;
    private JCheckBox autoEndFiring;
    private JCheckBox autoDeclareSearchlight;
    private JCheckBox nagForMASC;
    private JCheckBox nagForPSR;
    private JCheckBox nagForNoAction;
    private JCheckBox animateMove;
    private JCheckBox showWrecks;
    private JCheckBox soundMute;
    private JCheckBox showMapHexPopup;
    private JTextField tooltipDelay;
    private JComboBox unitStartChar;
    private JTextField maxPathfinderTime;
    private JCheckBox getFocus;
    private JCheckBox rightDragScroll;
    private JCheckBox ctlScroll;
    private JCheckBox clickEdgeScroll;
    private JCheckBox alwaysRightClickScroll;
    private JCheckBox autoEdgeScroll;
    private JTextField scrollSensitivity;
    private JCheckBox keepGameLog;
    private JTextField gameLogFilename;
    private JCheckBox stampFilenames;
    private JTextField stampFormat;
    private JCheckBox defaultAutoejectDisabled;
    private JCheckBox useAverageSkills;
    private JCheckBox showUnitId;
    private JComboBox displayLocale;
    private JCheckBox chatloungeTabs;
    private JCheckBox showMapsheets;
    private JCheckBox mouseWheelZoom;
    private JList keys;
    private int keysIndex = 0;
    private JTextField value;
    private JComboBox tileSetChoice;
    private File[] tileSets;
    private static final String CANCEL = "CANCEL";
    private static final String UPDATE = "UPDATE";
    private static final String[] LOCALE_CHOICES = new String[]{"en", "de", "ru"};

    public CommonSettingsDialog(JFrame jFrame) {
        super(jFrame, Messages.getString("CommonSettingsDialog.title"));
        JPanel jPanel = this.getSettingsPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.panTabs.add("Main", jScrollPane);
        this.panTabs.add("Advanced", this.getAdvancedSettingsPanel());
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panTabs, "Center");
        this.getContentPane().add((Component)this.getButtonsPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CommonSettingsDialog.this.cancel();
            }
        });
        this.pack();
        this.setLocationAndSize(jPanel.getPreferredSize().width + jScrollPane.getInsets().right + 20, jPanel.getPreferredSize().height);
    }

    private JPanel getButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 20, 5));
        JButton jButton = new JButton(Messages.getString("CommonSettingsDialog.Update"));
        jButton.setActionCommand(UPDATE);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("Cancel"));
        jButton2.setActionCommand(CANCEL);
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        return jPanel;
    }

    private JPanel getSettingsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        this.minimapEnabled = new JCheckBox(Messages.getString("CommonSettingsDialog.minimapEnabled"));
        jPanel.add(this.minimapEnabled);
        this.autoEndFiring = new JCheckBox(Messages.getString("CommonSettingsDialog.autoEndFiring"));
        jPanel.add(this.autoEndFiring);
        this.autoDeclareSearchlight = new JCheckBox(Messages.getString("CommonSettingsDialog.autoDeclareSearchlight"));
        jPanel.add(this.autoDeclareSearchlight);
        this.nagForMASC = new JCheckBox(Messages.getString("CommonSettingsDialog.nagForMASC"));
        jPanel.add(this.nagForMASC);
        this.mouseWheelZoom = new JCheckBox(Messages.getString("CommonSettingsDialog.mouseWheelZoom"));
        jPanel.add(this.mouseWheelZoom);
        this.nagForPSR = new JCheckBox(Messages.getString("CommonSettingsDialog.nagForPSR"));
        jPanel.add(this.nagForPSR);
        this.nagForNoAction = new JCheckBox(Messages.getString("CommonSettingsDialog.nagForNoAction"));
        jPanel.add(this.nagForNoAction);
        this.animateMove = new JCheckBox(Messages.getString("CommonSettingsDialog.animateMove"));
        jPanel.add(this.animateMove);
        this.showWrecks = new JCheckBox(Messages.getString("CommonSettingsDialog.showWrecks"));
        jPanel.add(this.showWrecks);
        this.soundMute = new JCheckBox(Messages.getString("CommonSettingsDialog.soundMute"));
        jPanel.add(this.soundMute);
        this.showMapHexPopup = new JCheckBox(Messages.getString("CommonSettingsDialog.showMapHexPopup"));
        jPanel.add(this.showMapHexPopup);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.tooltipDelay")));
        this.tooltipDelay = new JTextField(4);
        jPanel2.add(this.tooltipDelay);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        this.unitStartChar = new JComboBox();
        this.unitStartChar.addItem("A, B, C, D...");
        this.unitStartChar.addItem("\u0391, \u0392, \u0393, \u0394...");
        this.unitStartChar.addItem("\u03b1, \u03b2, \u03b3, \u03b4...");
        jPanel2.add(this.unitStartChar);
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.protoMechUnitCodes")));
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.pathFiderTimeLimit")));
        this.maxPathfinderTime = new JTextField(5);
        jPanel2.add(this.maxPathfinderTime);
        jPanel.add(jPanel2);
        this.getFocus = new JCheckBox(Messages.getString("CommonSettingsDialog.getFocus"));
        jPanel.add(this.getFocus);
        jPanel.add(jPanel2);
        this.defaultAutoejectDisabled = new JCheckBox(Messages.getString("CommonSettingsDialog.defaultAutoejectDisabled"));
        this.defaultAutoejectDisabled.addItemListener(this);
        jPanel.add(this.defaultAutoejectDisabled);
        this.useAverageSkills = new JCheckBox(Messages.getString("CommonSettingsDialog.useAverageSkills"));
        this.useAverageSkills.addItemListener(this);
        jPanel.add(this.useAverageSkills);
        this.showUnitId = new JCheckBox(Messages.getString("CommonSettingsDialog.showUnitId"));
        this.showUnitId.addItemListener(this);
        jPanel.add(this.showUnitId);
        this.keepGameLog = new JCheckBox(Messages.getString("CommonSettingsDialog.keepGameLog"));
        this.keepGameLog.addItemListener(this);
        jPanel.add(this.keepGameLog);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.logFileName")));
        this.gameLogFilename = new JTextField(15);
        jPanel2.add(this.gameLogFilename);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.tileset")));
        this.tileSetChoice = new JComboBox();
        jPanel2.add(this.tileSetChoice);
        jPanel.add(jPanel2);
        this.stampFilenames = new JCheckBox(Messages.getString("CommonSettingsDialog.stampFilenames"));
        this.stampFilenames.addItemListener(this);
        jPanel.add(this.stampFilenames);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.stampFormat")));
        this.stampFormat = new JTextField(15);
        jPanel2.add(this.stampFormat);
        jPanel.add(jPanel2);
        JTextArea jTextArea = new JTextArea(Messages.getString("CommonSettingsDialog.mapScrollText"));
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jPanel.add(jTextArea);
        this.rightDragScroll = new JCheckBox(Messages.getString("CommonSettingsDialog.rightDragScroll"));
        jPanel.add(this.rightDragScroll);
        this.ctlScroll = new JCheckBox(Messages.getString("CommonSettingsDialog.ctlScroll"));
        jPanel.add(this.ctlScroll);
        this.clickEdgeScroll = new JCheckBox(Messages.getString("CommonSettingsDialog.clickEdgeScroll"));
        jPanel.add(this.clickEdgeScroll);
        this.alwaysRightClickScroll = new JCheckBox(Messages.getString("CommonSettingsDialog.alwaysRightClickScroll"));
        jPanel.add(this.alwaysRightClickScroll);
        this.autoEdgeScroll = new JCheckBox(Messages.getString("CommonSettingsDialog.autoEdgeScroll"));
        jPanel.add(this.autoEdgeScroll);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.scrollSesitivity")));
        this.scrollSensitivity = new JTextField(4);
        jPanel2.add(this.scrollSensitivity);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(Messages.getString("CommonSettingsDialog.locale")));
        this.displayLocale = new JComboBox();
        this.displayLocale.addItem(Messages.getString("CommonSettingsDialog.locale.English"));
        this.displayLocale.addItem(Messages.getString("CommonSettingsDialog.locale.Deutsch"));
        this.displayLocale.addItem(Messages.getString("CommonSettingsDialog.locale.Russian"));
        jPanel2.add(this.displayLocale);
        jPanel.add(jPanel2);
        this.chatloungeTabs = new JCheckBox(Messages.getString("CommonSettingsDialog.chatloungeTabs"));
        jPanel.add(this.chatloungeTabs);
        this.showMapsheets = new JCheckBox(Messages.getString("CommonSettingsDialog.showMapsheets"));
        jPanel.add(this.showMapsheets);
        return jPanel;
    }

    public void setVisible(boolean bl) {
        int n;
        GUIPreferences gUIPreferences = GUIPreferences.getInstance();
        IClientPreferences iClientPreferences = PreferenceManager.getClientPreferences();
        this.minimapEnabled.setSelected(gUIPreferences.getMinimapEnabled());
        this.autoEndFiring.setSelected(gUIPreferences.getAutoEndFiring());
        this.autoDeclareSearchlight.setSelected(gUIPreferences.getAutoDeclareSearchlight());
        this.nagForMASC.setSelected(gUIPreferences.getNagForMASC());
        this.nagForPSR.setSelected(gUIPreferences.getNagForPSR());
        this.nagForNoAction.setSelected(gUIPreferences.getNagForNoAction());
        this.animateMove.setSelected(gUIPreferences.getShowMoveStep());
        this.showWrecks.setSelected(gUIPreferences.getShowWrecks());
        this.soundMute.setSelected(gUIPreferences.getSoundMute());
        this.showMapHexPopup.setSelected(gUIPreferences.getShowMapHexPopup());
        this.tooltipDelay.setText(Integer.toString(gUIPreferences.getTooltipDelay()));
        this.unitStartChar.setSelectedIndex(0);
        for (n = 0; n < this.unitStartChar.getItemCount(); ++n) {
            if (((String)this.unitStartChar.getItemAt(n)).charAt(0) != PreferenceManager.getClientPreferences().getUnitStartChar()) continue;
            this.unitStartChar.setSelectedIndex(n);
            break;
        }
        this.maxPathfinderTime.setText(Integer.toString(iClientPreferences.getMaxPathfinderTime()));
        this.rightDragScroll.setSelected(gUIPreferences.getRightDragScroll());
        this.ctlScroll.setSelected(gUIPreferences.getCtlScroll());
        this.clickEdgeScroll.setSelected(gUIPreferences.getClickEdgeScroll());
        this.alwaysRightClickScroll.setSelected(gUIPreferences.getAlwaysRightClickScroll());
        this.autoEdgeScroll.setSelected(gUIPreferences.getAutoEdgeScroll());
        this.scrollSensitivity.setText(Integer.toString(gUIPreferences.getScrollSensitivity()));
        this.keepGameLog.setSelected(iClientPreferences.keepGameLog());
        this.gameLogFilename.setEnabled(this.keepGameLog.isSelected());
        this.gameLogFilename.setText(iClientPreferences.getGameLogFilename());
        this.stampFilenames.setSelected(iClientPreferences.stampFilenames());
        this.stampFormat.setEnabled(this.stampFilenames.isSelected());
        this.stampFormat.setText(iClientPreferences.getStampFormat());
        this.defaultAutoejectDisabled.setSelected(iClientPreferences.defaultAutoejectDisabled());
        this.useAverageSkills.setSelected(iClientPreferences.useAverageSkills());
        this.showUnitId.setSelected(iClientPreferences.getShowUnitId());
        n = 0;
        if (iClientPreferences.getLocaleString().startsWith("de")) {
            n = 1;
        }
        if (iClientPreferences.getLocaleString().startsWith("ru")) {
            n = 2;
        }
        this.displayLocale.setSelectedIndex(n);
        this.chatloungeTabs.setSelected(gUIPreferences.getChatLoungeTabs());
        this.showMapsheets.setSelected(gUIPreferences.getShowMapsheets());
        File file = new File("data" + File.separator + "images" + File.separator + "hexes" + File.separator);
        this.tileSets = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".tileset");
            }
        });
        this.tileSetChoice.removeAll();
        for (int i = 0; i < this.tileSets.length; ++i) {
            String string = this.tileSets[i].getName();
            this.tileSetChoice.addItem(string.substring(0, string.length() - 8));
            if (!string.equals(iClientPreferences.getMapTileset())) continue;
            this.tileSetChoice.setSelectedIndex(i);
        }
        this.getFocus.setSelected(gUIPreferences.getFocus());
        super.setVisible(bl);
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void update() {
        GUIPreferences gUIPreferences = GUIPreferences.getInstance();
        IClientPreferences iClientPreferences = PreferenceManager.getClientPreferences();
        gUIPreferences.setMinimapEnabled(this.minimapEnabled.isSelected());
        gUIPreferences.setAutoEndFiring(this.autoEndFiring.isSelected());
        gUIPreferences.setAutoDeclareSearchlight(this.autoDeclareSearchlight.isSelected());
        gUIPreferences.setNagForMASC(this.nagForMASC.isSelected());
        gUIPreferences.setNagForPSR(this.nagForPSR.isSelected());
        gUIPreferences.setNagForNoAction(this.nagForNoAction.isSelected());
        gUIPreferences.setShowMoveStep(this.animateMove.isSelected());
        gUIPreferences.setShowWrecks(this.showWrecks.isSelected());
        gUIPreferences.setSoundMute(this.soundMute.isSelected());
        gUIPreferences.setShowMapHexPopup(this.showMapHexPopup.isSelected());
        gUIPreferences.setTooltipDelay(Integer.parseInt(this.tooltipDelay.getText()));
        iClientPreferences.setUnitStartChar(((String)this.unitStartChar.getSelectedItem()).charAt(0));
        gUIPreferences.setRightDragScroll(this.rightDragScroll.isSelected());
        gUIPreferences.setCtlScroll(this.ctlScroll.isSelected());
        gUIPreferences.setClickEdgeScroll(this.clickEdgeScroll.isSelected());
        gUIPreferences.setAlwaysRightClickScroll(this.alwaysRightClickScroll.isSelected());
        gUIPreferences.setAutoEdgeScroll(this.autoEdgeScroll.isSelected());
        gUIPreferences.setScrollSensitivity(Integer.parseInt(this.scrollSensitivity.getText()));
        gUIPreferences.setMouseWheelZoom(this.mouseWheelZoom.isSelected());
        iClientPreferences.setMaxPathfinderTime(Integer.parseInt(this.maxPathfinderTime.getText()));
        gUIPreferences.setGetFocus(this.getFocus.isSelected());
        iClientPreferences.setKeepGameLog(this.keepGameLog.isSelected());
        iClientPreferences.setGameLogFilename(this.gameLogFilename.getText());
        iClientPreferences.setStampFilenames(this.stampFilenames.isSelected());
        iClientPreferences.setStampFormat(this.stampFormat.getText());
        iClientPreferences.setDefaultAutoejectDisabled(this.defaultAutoejectDisabled.isSelected());
        iClientPreferences.setUseAverageSkills(this.useAverageSkills.isSelected());
        iClientPreferences.setShowUnitId(this.showUnitId.isSelected());
        iClientPreferences.setLocale(LOCALE_CHOICES[this.displayLocale.getSelectedIndex()]);
        gUIPreferences.setChatloungeTabs(this.chatloungeTabs.isSelected());
        gUIPreferences.setShowMapsheets(this.showMapsheets.isSelected());
        if (this.tileSetChoice.getSelectedIndex() >= 0) {
            iClientPreferences.setMapTileset(this.tileSets[this.tileSetChoice.getSelectedIndex()].getName());
        }
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (UPDATE.equalsIgnoreCase(string)) {
            this.update();
        } else if (CANCEL.equalsIgnoreCase(string)) {
            this.cancel();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable.equals(this.keepGameLog)) {
            this.gameLogFilename.setEnabled(this.keepGameLog.isSelected());
        } else if (itemSelectable.equals(this.stampFilenames)) {
            this.stampFormat.setEnabled(this.stampFilenames.isSelected());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        GUIPreferences.getInstance().setValue("Advanced" + this.keys.getModel().getElementAt(this.keysIndex), this.value.getText());
    }

    private JPanel getAdvancedSettingsPanel() {
        JPanel jPanel = new JPanel();
        Object[] objectArray = GUIPreferences.getInstance().getAdvancedProperties();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ((String)objectArray[i]).substring(((String)objectArray[i]).indexOf("Advanced") + 8, ((String)objectArray[i]).length());
        }
        this.keys = new JList<Object>(objectArray);
        this.keys.setSelectionMode(0);
        this.keys.addListSelectionListener(this);
        jPanel.add(this.keys);
        this.value = new JTextField(10);
        this.value.addFocusListener(this);
        jPanel.add(this.value);
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.keys)) {
            this.value.setText(GUIPreferences.getInstance().getString("Advanced" + this.keys.getSelectedValue()));
            this.keysIndex = this.keys.getSelectedIndex();
        }
    }
}

