/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import megamek.client.Client;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.swing.ClientDialog;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.DialogOptionComponent;
import megamek.client.ui.swing.DialogOptionListener;
import megamek.client.ui.swing.Slider;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentType;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.PilotOptions;
import megamek.common.preference.PreferenceManager;

public class CustomMechDialog
extends ClientDialog
implements ActionListener,
DialogOptionListener {
    private JLabel labName = new JLabel(Messages.getString("CustomMechDialog.labName"), 4);
    private JTextField fldName = new JTextField(20);
    private JLabel labGunnery = new JLabel(Messages.getString("CustomMechDialog.labGunnery"), 4);
    private JTextField fldGunnery = new JTextField(3);
    private JLabel labPiloting = new JLabel(Messages.getString("CustomMechDialog.labPiloting"), 4);
    private JTextField fldPiloting = new JTextField(3);
    private JLabel labC3 = new JLabel(Messages.getString("CustomMechDialog.labC3"), 4);
    private JComboBox choC3 = new JComboBox();
    private int[] entityCorrespondance;
    private JLabel labCallsign = new JLabel(Messages.getString("CustomMechDialog.labCallsign"), 0);
    private JLabel labUnitNum = new JLabel(Messages.getString("CustomMechDialog.labUnitNum"), 0);
    private JComboBox choUnitNum = new JComboBox();
    private ArrayList<Entity> entityUnitNum = new ArrayList();
    private JLabel labDeployment = new JLabel(Messages.getString("CustomMechDialog.labDeployment"), 4);
    private JComboBox choDeployment = new JComboBox();
    private JLabel labAutoEject = new JLabel(Messages.getString("CustomMechDialog.labAutoEject"), 4);
    private JCheckBox chAutoEject = new JCheckBox();
    private JLabel labSearchlight = new JLabel(Messages.getString("CustomMechDialog.labSearchlight"), 4);
    private JCheckBox chSearchlight = new JCheckBox();
    private JLabel labOffBoard = new JLabel(Messages.getString("CustomMechDialog.labOffBoard"), 4);
    private JCheckBox chOffBoard = new JCheckBox();
    private JLabel labOffBoardDirection = new JLabel(Messages.getString("CustomMechDialog.labOffBoardDirection"), 4);
    private JComboBox choOffBoardDirection = new JComboBox();
    private JLabel labOffBoardDistance = new JLabel(Messages.getString("CustomMechDialog.labOffBoardDistance"), 4);
    private JTextField fldOffBoardDistance = new JTextField(4);
    private JButton butOffBoardDistance = new JButton("0");
    private JLabel labTargSys = new JLabel(Messages.getString("CustomMechDialog.labTargSys"), 4);
    private JComboBox choTargSys = new JComboBox();
    private JPanel panButtons = new JPanel();
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private JButton butNext = new JButton(Messages.getString("Next"));
    private JButton butPrev = new JButton(Messages.getString("Previous"));
    private ArrayList<MunitionChoicePanel> m_vMunitions = new ArrayList();
    private JPanel panMunitions = new JPanel();
    private ArrayList<RapidfireMGPanel> m_vMGs = new ArrayList();
    private JPanel panRapidfireMGs = new JPanel();
    private ArrayList<MineChoicePanel> m_vMines = new ArrayList();
    private JPanel panMines = new JPanel();
    private Entity entity;
    private boolean okay;
    private ClientGUI clientgui;
    private Client client;
    private PilotOptions options;
    private ArrayList<DialogOptionComponent> optionComps = new ArrayList();
    private JPanel panOptions = new JPanel();
    private JScrollPane scrOptions;
    private JScrollPane scrAll;
    private JTextArea texDesc = new JTextArea(Messages.getString("CustomMechDialog.texDesc"), 3, 35);
    private boolean editable;
    private int direction = -1;
    private int distance = 17;

    public CustomMechDialog(ClientGUI clientGUI, Client client, Entity entity, boolean bl) {
        super(clientGUI.frame, Messages.getString("CustomMechDialog.title"), true);
        Mech mech;
        JPanel jPanel = new JPanel();
        this.entity = entity;
        this.clientgui = clientGUI;
        this.client = client;
        this.options = entity.getCrew().getOptions();
        this.editable = bl;
        this.texDesc.setEditable(false);
        if (entity instanceof Tank) {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labDriving"));
        } else if (entity instanceof Infantry) {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labAntiMech"));
        } else {
            this.labPiloting.setText(Messages.getString("CustomMechDialog.labPiloting"));
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labName, gridBagConstraints);
        jPanel.add(this.labName);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldName, gridBagConstraints);
        jPanel.add(this.fldName);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labGunnery, gridBagConstraints);
        jPanel.add(this.labGunnery);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldGunnery, gridBagConstraints);
        jPanel.add(this.fldGunnery);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labPiloting, gridBagConstraints);
        jPanel.add(this.labPiloting);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldPiloting, gridBagConstraints);
        jPanel.add(this.fldPiloting);
        if (entity instanceof Mech && (mech = (Mech)entity).getCockpitType() != 1) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labAutoEject, gridBagConstraints);
            jPanel.add(this.labAutoEject);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chAutoEject, gridBagConstraints);
            jPanel.add(this.chAutoEject);
            this.chAutoEject.setSelected(!mech.isAutoEject());
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labDeployment, gridBagConstraints);
        jPanel.add(this.labDeployment);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choDeployment, gridBagConstraints);
        jPanel.add(this.choDeployment);
        this.refreshDeployment();
        if (clientGUI.getClient().game.getOptions().booleanOption("pilot_advantages")) {
            this.scrOptions = new JScrollPane(this.panOptions);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.scrOptions, gridBagConstraints);
            jPanel.add(this.scrOptions);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
            jPanel.add(new JScrollPane(this.texDesc));
        }
        if (entity.hasC3() || entity.hasC3i()) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labC3, gridBagConstraints);
            jPanel.add(this.labC3);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.choC3, gridBagConstraints);
            jPanel.add(this.choC3);
            this.refreshC3();
        }
        boolean bl2 = false;
        for (Mounted object : entity.getWeaponList()) {
            WeaponType weaponType = (WeaponType)object.getType();
            if (!weaponType.hasFlag(65536L)) continue;
            bl2 = true;
        }
        if (bl2) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoard, gridBagConstraints);
            jPanel.add(this.labOffBoard);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chOffBoard, gridBagConstraints);
            jPanel.add(this.chOffBoard);
            this.chOffBoard.setSelected(entity.isOffBoard());
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoardDirection, gridBagConstraints);
            jPanel.add(this.labOffBoardDirection);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.choOffBoardDirection, gridBagConstraints);
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.North"));
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.South"));
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.East"));
            this.choOffBoardDirection.addItem(Messages.getString("CustomMechDialog.West"));
            this.direction = entity.getOffBoardDirection();
            if (-1 == this.direction) {
                this.direction = 0;
            }
            this.choOffBoardDirection.setSelectedIndex(this.direction);
            jPanel.add(this.choOffBoardDirection);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labOffBoardDistance, gridBagConstraints);
            jPanel.add(this.labOffBoardDistance);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            this.butOffBoardDistance.addActionListener(this);
            gridBagLayout.setConstraints(this.butOffBoardDistance, gridBagConstraints);
            this.butOffBoardDistance.setText(Integer.toString(this.distance));
            jPanel.add(this.butOffBoardDistance);
        }
        if (!entity.hasTargComp() && clientGUI.getClient().game.getOptions().booleanOption("allow_level_3_targsys") && entity instanceof Mech) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labTargSys, gridBagConstraints);
            jPanel.add(this.labTargSys);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            this.choTargSys.addItem(MiscType.getTargetSysName(0));
            this.choTargSys.addItem(MiscType.getTargetSysName(2));
            this.choTargSys.addItem(MiscType.getTargetSysName(3));
            this.choTargSys.addItem(MiscType.getTargetSysName(5));
            gridBagLayout.setConstraints(this.choTargSys, gridBagConstraints);
            jPanel.add(this.choTargSys);
            this.choTargSys.setSelectedItem(MiscType.getTargetSysName(entity.getTargSysType()));
        }
        if (entity instanceof Protomech) {
            StringBuffer stringBuffer = new StringBuffer(Messages.getString("CustomMechDialog.Callsign"));
            stringBuffer.append(": ");
            stringBuffer.append((char)(this.entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(this.entity.getId());
            this.labCallsign.setText(stringBuffer.toString());
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.labCallsign, gridBagConstraints);
            jPanel.add(this.labCallsign);
            Enumeration<Entity> n2 = client.game.getSelectedEntities(new EntitySelector(){
                private final int ownerId;
                private final char unitNumber;
                {
                    this.ownerId = CustomMechDialog.this.entity.getOwnerId();
                    this.unitNumber = CustomMechDialog.this.entity.getUnitNumber();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId() && this.unitNumber != entity.getUnitNumber();
                }
            });
            if (n2.hasMoreElements()) {
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labUnitNum, gridBagConstraints);
                jPanel.add(this.labUnitNum);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.choUnitNum, gridBagConstraints);
                jPanel.add(this.choUnitNum);
                this.refreshUnitNum(n2);
            }
        }
        if (!(entity instanceof Infantry) || entity instanceof BattleArmor) {
            this.setupMunitions();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panMunitions, gridBagConstraints);
            jPanel.add(this.panMunitions);
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("maxtech_burst")) {
            gridBagConstraints.gridwidth = 1;
            this.setupRapidfireMGs();
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.panRapidfireMGs, gridBagConstraints);
            jPanel.add(this.panRapidfireMGs);
        }
        if (clientGUI.getClient().game.getOptions().booleanOption("night_battle")) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.labSearchlight, gridBagConstraints);
            jPanel.add(this.labSearchlight);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chSearchlight, gridBagConstraints);
            jPanel.add(this.chSearchlight);
            this.chSearchlight.setSelected(entity.hasSpotlight());
        }
        this.setupMines();
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.panMines, gridBagConstraints);
        jPanel.add(this.panMines);
        this.setupButtons();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        jPanel.add(this.panButtons);
        this.fldName.setText(entity.getCrew().getName());
        this.fldName.addActionListener(this);
        this.fldGunnery.setText(Integer.toString(entity.getCrew().getGunnery()));
        this.fldGunnery.addActionListener(this);
        this.fldPiloting.setText(Integer.toString(entity.getCrew().getPiloting()));
        this.fldPiloting.addActionListener(this);
        if (!bl) {
            this.fldName.setEnabled(false);
            this.fldGunnery.setEnabled(false);
            this.fldPiloting.setEnabled(false);
            this.choC3.setEnabled(false);
            this.choDeployment.setEnabled(false);
            this.chAutoEject.setEnabled(false);
            this.chSearchlight.setEnabled(false);
            this.choTargSys.setEnabled(false);
            this.disableMunitionEditing();
            this.disableMGSetting();
            this.disableMineSetting();
            this.chOffBoard.setEnabled(false);
            this.choOffBoardDirection.setEnabled(false);
            this.fldOffBoardDistance.setEnabled(false);
        }
        this.scrAll = new JScrollPane(jPanel);
        this.getContentPane().add(this.scrAll);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CustomMechDialog.this.setVisible(false);
            }
        });
        this.pack();
        int n = jPanel.getPreferredSize().width + this.scrAll.getInsets().right;
        int n2 = jPanel.getPreferredSize().height + this.panButtons.getPreferredSize().height + this.scrAll.getInsets().bottom;
        this.setLocationAndSize(n, n2);
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butNext.addActionListener(this);
        this.butPrev.addActionListener(this);
        this.panButtons.setLayout(new GridLayout(1, 4, 10, 0));
        this.panButtons.add(this.butPrev);
        this.panButtons.add(this.butOkay);
        this.panButtons.add(this.butCancel);
        this.panButtons.add(this.butNext);
        this.butNext.setEnabled(this.getNextEntity(true) != null);
        this.butPrev.setEnabled(this.getNextEntity(false) != null);
    }

    private void setupRapidfireMGs() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panRapidfireMGs.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!weaponType.hasFlag(512L)) continue;
            gridBagConstraints.gridy = n++;
            RapidfireMGPanel rapidfireMGPanel = new RapidfireMGPanel(mounted);
            gridBagLayout.setConstraints(rapidfireMGPanel, gridBagConstraints);
            this.panRapidfireMGs.add(rapidfireMGPanel);
            this.m_vMGs.add(rapidfireMGPanel);
        }
    }

    private void setupMines() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMines.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getMisc()) {
            if (!mounted.getType().hasFlag(524288L)) continue;
            gridBagConstraints.gridy = n++;
            MineChoicePanel mineChoicePanel = new MineChoicePanel(mounted);
            gridBagLayout.setConstraints(mineChoicePanel, gridBagConstraints);
            this.panMines.add(mineChoicePanel);
            this.m_vMines.add(mineChoicePanel);
        }
    }

    private void setupMunitions() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panMunitions.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Mounted mounted : this.entity.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            ArrayList<AmmoType> arrayList = new ArrayList<AmmoType>();
            Vector<AmmoType> vector = AmmoType.getMunitionsFor(ammoType.getAmmoType());
            if (vector == null) continue;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                AmmoType ammoType2 = vector.elementAt(i);
                boolean bl = TechConstants.isLegal(this.entity.getTechLevel(), ammoType2.getTechLevel());
                if (!bl && this.entity.getTechLevel() == 1 && ammoType2.getTechLevel() == 0) {
                    bl = true;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits") && this.entity.getTechLevel() == 0 && ammoType2.getTechLevel() == 1) {
                    bl = true;
                }
                if (this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_ammo")) {
                    if (!this.clientgui.getClient().game.getOptions().booleanOption("is_eq_limits")) {
                        if (this.entity.getTechLevel() == 2 && ammoType2.getTechLevel() == 6) {
                            bl = true;
                        }
                        if ((this.entity.getTechLevel() == 0 || this.entity.getTechLevel() == 1) && ammoType2.getTechLevel() == 5) {
                            bl = true;
                        }
                    }
                } else if (ammoType2.getTechLevel() == 5 || ammoType2.getTechLevel() == 6) {
                    bl = false;
                }
                if (this.entity.isMixedTech()) {
                    bl = true;
                }
                long l = ammoType2.getMunitionType();
                if (!this.clientgui.getClient().game.getOptions().booleanOption("clan_ignore_eq_limits") && this.entity.isClan() && ((l &= 0xFFFFFFFFFFFFEFFFL) == 16384L || l == 65536L || l == 8192L || l == 128L || l == 262144L || l == 524288L || l == 0x100000L || l == 0x200000L || l == 0x80000000L || l == 0x100000000L || l == 256L || l == 512L)) {
                    bl = false;
                }
                if (!this.clientgui.getClient().game.getOptions().booleanOption("minefields") && AmmoType.canDeliverMinefield(ammoType2) || ammoType2.hasFlag(4L) && !(this.entity instanceof Protomech) || this.entity instanceof Protomech && ammoType2.hasFlag(1L) && !ammoType2.hasFlag(4L) || !bl || ammoType2.getRackSize() != ammoType.getRackSize() || ammoType2.hasFlag(2L) != ammoType.hasFlag(2L) || ammoType2.hasFlag(16L) != ammoType.hasFlag(16L) || ammoType2.getTonnage(this.entity) != ammoType.getTonnage(this.entity)) continue;
                arrayList.add(ammoType2);
            }
            if (arrayList.size() < 2 && !this.client.game.getOptions().booleanOption("lobby_ammo_dump")) continue;
            gridBagConstraints.gridy = n++;
            MunitionChoicePanel munitionChoicePanel = this.entity instanceof Protomech ? new ProtomechMunitionChoicePanel(mounted, arrayList) : new MunitionChoicePanel(mounted, arrayList);
            gridBagLayout.setConstraints(munitionChoicePanel, gridBagConstraints);
            this.panMunitions.add(munitionChoicePanel);
            this.m_vMunitions.add(munitionChoicePanel);
        }
    }

    private void disableMunitionEditing() {
        for (int i = 0; i < this.m_vMunitions.size(); ++i) {
            this.m_vMunitions.get(i).setEnabled(false);
        }
    }

    private void disableMGSetting() {
        for (int i = 0; i < this.m_vMGs.size(); ++i) {
            this.m_vMGs.get(i).setEnabled(false);
        }
    }

    private void disableMineSetting() {
        for (int i = 0; i < this.m_vMines.size(); ++i) {
            this.m_vMines.get(i).setEnabled(false);
        }
    }

    private void setOptions() {
        Iterator<DialogOptionComponent> iterator = this.optionComps.iterator();
        while (iterator.hasNext()) {
            DialogOptionComponent dialogOptionComponent;
            DialogOptionComponent dialogOptionComponent2 = dialogOptionComponent = iterator.next();
            IOption iOption = dialogOptionComponent2.getOption();
            if (dialogOptionComponent2.getValue() == Messages.getString("CustomMechDialog.None")) {
                this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue("None");
                continue;
            }
            this.entity.getCrew().getOptions().getOption(iOption.getName()).setValue(dialogOptionComponent2.getValue());
        }
    }

    public void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps = new ArrayList();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = (IOptionGroup)enumeration.nextElement();
            this.addGroup(iOptionGroup, gridBagLayout, gridBagConstraints);
            Enumeration enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = (IOption)enumeration2.nextElement();
                this.addOption(iOption, gridBagLayout, gridBagConstraints, this.editable);
            }
        }
        this.validate();
    }

    private void addGroup(IOptionGroup iOptionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(iOptionGroup.getDisplayableName());
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.panOptions.add(jLabel);
    }

    private void addOption(IOption iOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, boolean bl) {
        DialogOptionComponent dialogOptionComponent = new DialogOptionComponent(this, iOption, bl);
        if ("weapon_specialist".equals(iOption.getName())) {
            dialogOptionComponent.addValue(Messages.getString("CustomMechDialog.None"));
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < this.entity.getWeaponList().size(); ++i) {
                Mounted object = this.entity.getWeaponList().get(i);
                treeSet.add(object.getName());
            }
            for (String string : treeSet) {
                dialogOptionComponent.addValue(string);
            }
            dialogOptionComponent.setSelected(iOption.stringValue());
        }
        gridBagLayout.setConstraints(dialogOptionComponent, gridBagConstraints);
        this.panOptions.add(dialogOptionComponent);
        this.optionComps.add(dialogOptionComponent);
    }

    public void showDescFor(IOption iOption) {
        this.texDesc.setText(iOption.getDescription());
    }

    public void optionClicked(DialogOptionComponent dialogOptionComponent, IOption iOption, boolean bl) {
    }

    public boolean isOkay() {
        return this.okay;
    }

    private void refreshDeployment() {
        this.choDeployment.removeAll();
        this.choDeployment.addItem(Messages.getString("CustomMechDialog.StartOfGame"));
        if (this.entity.getDeployRound() < 1) {
            this.choDeployment.setSelectedIndex(0);
        }
        for (int i = 1; i <= 15; ++i) {
            this.choDeployment.addItem(Messages.getString("CustomMechDialog.AfterRound") + i);
            if (this.entity.getDeployRound() != i) continue;
            this.choDeployment.setSelectedIndex(i);
        }
    }

    private void refreshC3() {
        int n;
        this.choC3.removeAll();
        int n2 = 0;
        this.entityCorrespondance = new int[this.client.game.getNoOfEntities() + 2];
        if (this.entity.hasC3i()) {
            this.choC3.addItem(Messages.getString("CustomMechDialog.CreateNewNetwork"));
            if (this.entity.getC3Master() == null) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
        } else if (this.entity.hasC3MM()) {
            n = this.entity.calculateFreeC3MNodes();
            int n3 = this.entity.calculateFreeC3Nodes();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setCompanyMaster", new Object[]{new Integer(n), new Integer(n3)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n3)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        } else if (this.entity.hasC3M()) {
            n = this.entity.calculateFreeC3Nodes();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setCompanyMaster1", new Object[]{new Integer(n)}));
            if (this.entity.C3MasterIs(this.entity)) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = this.entity.getId();
            this.choC3.addItem(Messages.getString("CustomMechDialog.setIndependentMaster", new Object[]{new Integer(n)}));
            if (this.entity.getC3Master() == null) {
                this.choC3.setSelectedIndex(n2);
            }
            this.entityCorrespondance[n2++] = -1;
        }
        Enumeration enumeration = this.client.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Entity entity2 = (Entity)enumeration.nextElement();
            if (this.entity.isEnemyOf(entity2) || this.entity.equals(entity2) || this.entity.hasC3i() != entity2.hasC3i() || (entity = entity2.getC3Master()) != null && entity.getC3Master() != entity) continue;
            int n4 = entity2.calculateFreeC3Nodes();
            if (entity2.hasC3MM() && this.entity.hasC3M() && entity2.C3MasterIs(entity2)) {
                n4 = entity2.calculateFreeC3MNodes();
            }
            if (this.entity.C3MasterIs(entity2) && !this.entity.equals(entity2)) {
                ++n4;
            }
            if (this.entity.hasC3i() && (this.entity.onSameC3NetworkAs(entity2) || this.entity.equals(entity2))) {
                ++n4;
            }
            if (n4 == 0) continue;
            if (entity2.hasC3i()) {
                if (this.entity.onSameC3NetworkAs(entity2)) {
                    this.choC3.addItem(Messages.getString("CustomMechDialog.join1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                    this.choC3.setSelectedIndex(n2);
                } else {
                    this.choC3.addItem(Messages.getString("CustomMechDialog.join2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                }
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            if (entity2.C3MasterIs(entity2) && entity2.hasC3MM()) {
                this.choC3.addItem(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
                this.entityCorrespondance[n2] = entity2.getId();
                if (this.entity.C3MasterIs(entity2)) {
                    this.choC3.setSelectedIndex(n2);
                }
                ++n2;
                continue;
            }
            if (entity2.C3MasterIs(entity2) != this.entity.hasC3M()) continue;
            if (this.entity.C3MasterIs(entity2)) {
                this.choC3.addItem(Messages.getString("CustomMechDialog.connect1", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4 - 1)}));
                this.choC3.setSelectedIndex(n2);
                this.entityCorrespondance[n2++] = entity2.getId();
                continue;
            }
            this.choC3.addItem(Messages.getString("CustomMechDialog.connect2", new Object[]{entity2.getDisplayName(), entity2.getC3NetId(), new Integer(n4)}));
            this.entityCorrespondance[n2++] = entity2.getId();
        }
    }

    private void refreshUnitNum(Enumeration enumeration) {
        this.choUnitNum.removeAll();
        this.entityUnitNum.clear();
        this.choUnitNum.addItem(Messages.getString("CustomMechDialog.doNotSwapUnits"));
        this.entityUnitNum.add(this.entity);
        while (enumeration.hasMoreElements()) {
            Entity entity = (Entity)enumeration.nextElement();
            this.entityUnitNum.add(entity);
            StringBuffer stringBuffer = new StringBuffer(entity.getDisplayName());
            stringBuffer.append(" (").append((char)(entity.getUnitNumber() + PreferenceManager.getClientPreferences().getUnitStartChar())).append('-').append(entity.getId()).append(')');
            this.choUnitNum.addItem(stringBuffer.toString());
        }
        this.choUnitNum.setSelectedIndex(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getSource().equals(this.butOffBoardDistance)) {
            int n = 323;
            for (Mounted mounted : this.entity.getWeaponList()) {
                int n2;
                EquipmentType equipmentType = mounted.getType();
                WeaponType weaponType = (WeaponType)equipmentType;
                if (!weaponType.hasFlag(65536L) || (n2 = (weaponType.getLongRange() - 1) * 17) >= n) continue;
                n = n2;
            }
            Slider slider = new Slider(this.clientgui.frame, Messages.getString("CustomMechDialog.offboardDistanceTitle"), Messages.getString("CustomMechDialog.offboardDistanceQuestion"), this.entity.getOffBoardDistance(), 17, n);
            if (!slider.showDialog()) {
                return;
            }
            this.distance = slider.getValue();
            this.butOffBoardDistance.setText(Integer.toString(this.distance));
            return;
        }
        if (!actionEvent.getSource().equals(this.butCancel)) {
            int n;
            Entity entity;
            int n3;
            int n4;
            object = this.fldName.getText();
            boolean bl = this.chAutoEject.isSelected();
            try {
                n4 = Integer.parseInt(this.fldGunnery.getText());
                n3 = Integer.parseInt(this.fldPiloting.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterValidSkills"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                return;
            }
            if (n4 < 0 || n4 > 7 || n3 < 0 || n3 > 8) {
                JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterSkillsBetween0_7"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                return;
            }
            if (this.chOffBoard.isSelected()) {
                int n5;
                try {
                    n5 = this.distance;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.EnterValidSkills"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                    return;
                }
                if (n5 < 17) {
                    JOptionPane.showMessageDialog(this.clientgui.frame, Messages.getString("CustomMechDialog.OffboardDistance"), Messages.getString("CustomMechDialog.NumberFormatError"), 0);
                    return;
                }
                this.entity.setOffBoard(n5, this.choOffBoardDirection.getSelectedIndex());
            } else {
                this.entity.setOffBoard(0, -1);
            }
            this.entity.setCrew(new Pilot((String)object, n4, n3));
            if (this.entity instanceof Mech) {
                entity = (Mech)this.entity;
                ((Mech)entity).setAutoEject(!bl);
            }
            if (this.entity.hasC3() && this.choC3.getSelectedIndex() > -1) {
                int n6;
                entity = this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]);
                n = this.client.game.getC3SubNetworkMembers(this.entity).size();
                if (n + (n6 = this.client.game.getC3NetworkMembers(entity).size()) <= 12) {
                    this.entity.setC3Master(entity);
                } else {
                    String string = Messages.getString("CustomMechDialog.NetworkTooBig.message", new Object[]{this.entity.getShortName(), entity.getShortName(), new Integer(n), new Integer(n6), new Integer(12)});
                    this.clientgui.doAlertDialog(Messages.getString("CustomMechDialog.NetworkTooBig.title"), string);
                    this.refreshC3();
                }
            } else if (this.entity.hasC3i() && this.choC3.getSelectedIndex() > -1) {
                this.entity.setC3NetId(this.client.getEntity(this.entityCorrespondance[this.choC3.getSelectedIndex()]));
            }
            if (!this.entity.hasTargComp() && this.clientgui.getClient().game.getOptions().booleanOption("allow_level_3_targsys")) {
                int n7 = 0;
                if (this.choTargSys.getSelectedItem() != null) {
                    n7 = MiscType.getTargetSysType((String)this.choTargSys.getSelectedItem());
                }
                if (n7 >= 0) {
                    this.entity.setTargSysType(n7);
                } else {
                    System.err.println("Illegal targeting system index: " + n7);
                    this.entity.setTargSysType(0);
                }
            }
            if (!this.entityUnitNum.isEmpty() && this.choUnitNum.getSelectedIndex() > 0) {
                Entity entity2 = this.entityUnitNum.get(this.choUnitNum.getSelectedIndex());
                n = this.entity.getUnitNumber();
                this.entity.setUnitNumber(entity2.getUnitNumber());
                entity2.setUnitNumber((char)n);
                this.client.sendUpdateEntity(entity2);
            }
            this.entity.setDeployRound(this.choDeployment.getSelectedIndex());
            for (MunitionChoicePanel munitionChoicePanel : this.m_vMunitions) {
                munitionChoicePanel.applyChoice();
            }
            for (RapidfireMGPanel rapidfireMGPanel : this.m_vMGs) {
                rapidfireMGPanel.applyChoice();
            }
            for (MineChoicePanel mineChoicePanel : this.m_vMines) {
                mineChoicePanel.applyChoice();
            }
            this.entity.setSpotlight(this.chSearchlight.isSelected());
            this.entity.setSpotlightState(this.chSearchlight.isSelected());
            this.setOptions();
            this.okay = true;
            this.clientgui.chatlounge.refreshEntities();
        }
        this.setVisible(false);
        object = null;
        if (actionEvent.getSource().equals(this.butPrev)) {
            object = this.getNextEntity(false);
        } else if (actionEvent.getSource().equals(this.butNext)) {
            object = this.getNextEntity(true);
        }
        if (object != null) {
            this.clientgui.chatlounge.customizeMech((Entity)object);
        }
    }

    private Entity getNextEntity(boolean bl) {
        IGame iGame = this.client.game;
        boolean bl2 = iGame.getOptions().booleanOption("blind_drop");
        boolean bl3 = iGame.getOptions().booleanOption("real_blind_drop");
        Player player = this.client.getLocalPlayer();
        Entity entity = bl ? iGame.getNextEntityFromList(this.entity) : iGame.getPreviousEntityFromList(this.entity);
        while (entity != null && !entity.equals(this.entity)) {
            if (entity.getOwner().equals(player) || !bl2 && !bl3) {
                return entity;
            }
            if (bl) {
                entity = iGame.getNextEntityFromList(entity);
                continue;
            }
            entity = iGame.getPreviousEntityFromList(entity);
        }
        return null;
    }

    class RapidfireMGPanel
    extends JPanel {
        private Mounted m_mounted;
        JCheckBox chRapid = new JCheckBox();

        RapidfireMGPanel(Mounted mounted) {
            this.m_mounted = mounted;
            int n = mounted.getLocation();
            String string = Messages.getString("CustomMechDialog.switchToRapidFire", new Object[]{CustomMechDialog.this.entity.getLocationAbbr(n)});
            JLabel jLabel = new JLabel(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.chRapid, gridBagConstraints);
            this.chRapid.setSelected(mounted.isRapidfire());
            this.add(this.chRapid);
        }

        public void applyChoice() {
            boolean bl = this.chRapid.isSelected();
            this.m_mounted.setRapidfire(bl);
        }

        public void setEnabled(boolean bl) {
            this.chRapid.setEnabled(bl);
        }
    }

    class ProtomechMunitionChoicePanel
    extends MunitionChoicePanel {
        private final float m_origShotsLeft;
        private final AmmoType m_origAmmo;

        ProtomechMunitionChoicePanel(Mounted mounted, ArrayList arrayList) {
            super(mounted, arrayList);
            this.m_origAmmo = (AmmoType)mounted.getType();
            this.m_origShotsLeft = mounted.getShotsLeft();
        }

        public void applyChoice() {
            super.applyChoice();
            this.setShotsLeft(Math.round((float)this.getShotsLeft() * this.m_origShotsLeft / (float)this.m_origAmmo.getShots()));
            if (this.chDump.isSelected()) {
                this.setShotsLeft(0);
            }
        }
    }

    class MunitionChoicePanel
    extends JPanel {
        private ArrayList m_vTypes;
        private JComboBox m_choice;
        private Mounted m_mounted;
        JLabel labDump = new JLabel(Messages.getString("CustomMechDialog.labDump"));
        JCheckBox chDump = new JCheckBox();
        JLabel labHotLoad = new JLabel(Messages.getString("CustomMechDialog.switchToHotLoading"));
        JCheckBox chHotLoad = new JCheckBox();

        MunitionChoicePanel(Mounted mounted, ArrayList arrayList) {
            Object object;
            this.m_vTypes = arrayList;
            this.m_mounted = mounted;
            AmmoType ammoType = (AmmoType)mounted.getType();
            this.m_choice = new JComboBox();
            Iterator iterator = this.m_vTypes.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object = (AmmoType)iterator.next();
                this.m_choice.addItem(((EquipmentType)object).getName());
                if (((AmmoType)object).getMunitionType() == ammoType.getMunitionType()) {
                    this.m_choice.setSelectedIndex(n);
                }
                ++n;
            }
            if (mounted.getLocation() == -1) {
                object = mounted.getLinkedBy();
                n = ((Mounted)object).getLocation();
            } else {
                n = mounted.getLocation();
            }
            object = '(' + CustomMechDialog.this.entity.getLocationAbbr(n) + ')';
            JLabel jLabel = new JLabel((String)object);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.m_choice, gridBagConstraints);
            this.add(this.m_choice);
            if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("lobby_ammo_dump")) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labDump, gridBagConstraints);
                this.add(this.labDump);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.chDump, gridBagConstraints);
                this.add(this.chDump);
                if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && ammoType.hasFlag(8L)) {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.anchor = 13;
                    gridBagLayout.setConstraints(this.labHotLoad, gridBagConstraints);
                    this.add(this.labHotLoad);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.anchor = 17;
                    gridBagLayout.setConstraints(this.chHotLoad, gridBagConstraints);
                    this.add(this.chHotLoad);
                }
            } else if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && ammoType.hasFlag(8L)) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.labHotLoad, gridBagConstraints);
                this.add(this.labHotLoad);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.chHotLoad, gridBagConstraints);
                this.add(this.chHotLoad);
            }
        }

        public void applyChoice() {
            int n = this.m_choice.getSelectedIndex();
            AmmoType ammoType = (AmmoType)this.m_vTypes.get(n);
            this.m_mounted.changeAmmoType(ammoType);
            if (this.chDump.isSelected()) {
                this.m_mounted.setShotsLeft(0);
            }
            if (((CustomMechDialog)CustomMechDialog.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && this.chHotLoad.isSelected() != this.m_mounted.isHotLoaded()) {
                this.m_mounted.setHotLoad(this.chHotLoad.isSelected());
            }
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }

        int getShotsLeft() {
            return this.m_mounted.getShotsLeft();
        }

        void setShotsLeft(int n) {
            this.m_mounted.setShotsLeft(n);
        }
    }

    class MineChoicePanel
    extends JPanel {
        private JComboBox m_choice;
        private Mounted m_mounted;

        MineChoicePanel(Mounted mounted) {
            this.m_mounted = mounted;
            this.m_choice = new JComboBox();
            this.m_choice.addItem(Messages.getString("CustomMechDialog.Conventional"));
            this.m_choice.addItem(Messages.getString("CustomMechDialog.Vibrabomb"));
            int n = mounted.getLocation();
            String string = '(' + CustomMechDialog.this.entity.getLocationAbbr(n) + ')';
            JLabel jLabel = new JLabel(string);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.m_choice, gridBagConstraints);
            this.m_choice.setSelectedIndex(mounted.getMineType());
            this.add(this.m_choice);
        }

        public void applyChoice() {
            this.m_mounted.setMineType(this.m_choice.getSelectedIndex());
        }

        public void setEnabled(boolean bl) {
            this.m_choice.setEnabled(bl);
        }
    }
}

