/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.DoneButtoned;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.StatusBarPhaseDisplay;
import megamek.client.ui.swing.VibrabombSettingDialog;
import megamek.common.Coords;
import megamek.common.Minefield;
import megamek.common.Player;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class DeployMinefieldDisplay
extends StatusBarPhaseDisplay
implements BoardViewListener,
ActionListener,
DoneButtoned,
KeyListener,
GameListener,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    public static final String DEPLOY_MINE_CONV = "deployMineConv";
    public static final String DEPLOY_MINE_COM = "deployMineCom";
    public static final String DEPLOY_MINE_VIBRA = "deployMineVibra";
    public ClientGUI clientgui;
    private Client client;
    private JPanel panButtons;
    private JButton butC;
    private JButton butM;
    private JButton butV;
    private JButton butUnload;
    private JButton butDone;
    private boolean deployM = false;
    private boolean deployC = false;
    private boolean deployV = false;
    private Player p;
    private Vector deployedMinefields = new Vector();

    public DeployMinefieldDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        this.setupStatusBar(Messages.getString("DeployMinefieldDisplay.waitingForDeployMinefieldPhase"));
        this.p = this.client.getLocalPlayer();
        this.butM = new JButton(Messages.getString("DeploymentDisplay.buttonMinefield", new Object[]{new Integer(this.p.getNbrMFConventional())}));
        this.butM.addActionListener(this);
        this.butM.setActionCommand(DEPLOY_MINE_CONV);
        this.butM.setEnabled(false);
        this.butC = new JButton(Messages.getString("DeploymentDisplay.buttonCommand", new Object[]{new Integer(this.p.getNbrMFCommand())}));
        this.butC.addActionListener(this);
        this.butC.setActionCommand(DEPLOY_MINE_COM);
        this.butC.setEnabled(false);
        this.butUnload = new JButton(".");
        this.butUnload.addActionListener(this);
        this.butUnload.setEnabled(false);
        this.butV = new JButton(Messages.getString("DeploymentDisplay.buttonVibrabomb", new Object[]{new Integer(this.p.getNbrMFVibra())}));
        this.butV.addActionListener(this);
        this.butV.setActionCommand(DEPLOY_MINE_VIBRA);
        this.butV.setEnabled(false);
        this.butDone = new JButton(Messages.getString("DeployMinefieldDisplay.Done"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.panButtons = new JPanel();
        this.panButtons.setLayout(new GridLayout(0, 8));
        this.panButtons.add(this.butM);
        this.panButtons.add(this.butC);
        this.panButtons.add(this.butV);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent.addKeyListener(this);
    }

    private void beginMyTurn() {
        this.p = this.client.getLocalPlayer();
        this.setConventionalEnabled(this.p.getNbrMFConventional());
        this.setCommandEnabled(this.p.getNbrMFCommand());
        this.setVibrabombEnabled(this.p.getNbrMFVibra());
        if (!this.p.hasMinefields()) {
            this.butDone.setEnabled(true);
        }
    }

    private void endMyTurn() {
        this.disableButtons();
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
    }

    private void disableButtons() {
        this.setConventionalEnabled(0);
        this.setCommandEnabled(0);
        this.setVibrabombEnabled(0);
        this.butDone.setEnabled(false);
        this.butUnload.setEnabled(false);
    }

    private void deployMinefield(Coords coords) {
        if (!this.client.game.getBoard().contains(coords)) {
            return;
        }
        if (this.client.game.containsMinefield(coords)) {
            Minefield minefield = (Minefield)this.client.game.getMinefields(coords).elementAt(0);
            if (minefield.getPlayerId() == this.client.getLocalPlayer().getId()) {
                this.butDone.setEnabled(false);
                this.client.game.removeMinefield(minefield);
                this.deployedMinefields.removeElement(minefield);
                switch (minefield.getType()) {
                    case 0: {
                        this.deployM = true;
                        this.deployC = false;
                        this.deployV = false;
                        this.p.setNbrMFConventional(this.p.getNbrMFConventional() + 1);
                        break;
                    }
                    case 1: {
                        this.deployM = false;
                        this.deployC = true;
                        this.deployV = false;
                        this.p.setNbrMFCommand(this.p.getNbrMFCommand() + 1);
                        break;
                    }
                    case 2: {
                        this.deployM = false;
                        this.deployC = false;
                        this.deployV = true;
                        this.p.setNbrMFVibra(this.p.getNbrMFVibra() + 1);
                    }
                }
            }
        } else {
            Minefield minefield;
            if (this.deployM) {
                minefield = Minefield.createConventionalMF(coords, this.p.getId());
                this.p.setNbrMFConventional(this.p.getNbrMFConventional() - 1);
            } else if (this.deployC) {
                minefield = Minefield.createCommandDetonatedMF(coords, this.p.getId());
                this.p.setNbrMFCommand(this.p.getNbrMFCommand() - 1);
            } else if (this.deployV) {
                VibrabombSettingDialog vibrabombSettingDialog = new VibrabombSettingDialog(this.clientgui.frame);
                vibrabombSettingDialog.setVisible(true);
                this.clientgui.bv.stopScrolling();
                minefield = Minefield.createVibrabombMF(coords, this.p.getId(), vibrabombSettingDialog.getSetting());
                this.p.setNbrMFVibra(this.p.getNbrMFVibra() - 1);
            } else {
                return;
            }
            this.client.game.addMinefield(minefield);
            this.deployedMinefields.addElement(minefield);
            this.clientgui.bv.repaint();
        }
        if (this.p.getNbrMFConventional() == 0 && this.p.getNbrMFCommand() == 0 && this.p.getNbrMFVibra() == 0) {
            this.butDone.setEnabled(true);
        }
        this.setConventionalEnabled(this.p.getNbrMFConventional());
        this.setCommandEnabled(this.p.getNbrMFCommand());
        this.setVibrabombEnabled(this.p.getNbrMFVibra());
        if (this.p.getNbrMFConventional() == 0) {
            this.deployM = false;
        }
        if (this.p.getNbrMFCommand() == 0) {
            this.deployC = false;
        }
        if (this.p.getNbrMFVibra() == 0) {
            this.deployV = false;
        }
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (boardViewEvent.getType() != 2) {
            return;
        }
        if (!this.client.isMyTurn() || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.clientgui.getBoardView().select(boardViewEvent.getCoords());
        this.deployMinefield(boardViewEvent.getCoords());
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.endMyTurn();
        if (this.client.isMyTurn()) {
            this.beginMyTurn();
            this.setStatusBarText(Messages.getString("DeployMinefieldDisplay.its_your_turn"));
        } else {
            this.setStatusBarText(Messages.getString("DeployMinefieldDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != 20) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == 20) {
            this.setStatusBarText(Messages.getString("DeployMinefieldDisplay.waitingForDeploymentPhase"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource().equals(this.butDone)) {
            this.endMyTurn();
            this.client.sendDeployMinefields(this.deployedMinefields);
            this.client.sendPlayerInfo();
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_CONV)) {
            this.deployM = true;
            this.deployC = false;
            this.deployV = false;
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_COM)) {
            this.deployM = false;
            this.deployC = true;
            this.deployV = false;
        }
        if (actionEvent.getActionCommand().equals(DEPLOY_MINE_VIBRA)) {
            this.deployM = false;
            this.deployC = false;
            this.deployV = true;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void setConventionalEnabled(int n) {
        this.butM.setText(Messages.getString("DeploymentDisplay.buttonMinefield", new Object[]{new Integer(n)}));
        this.butM.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployConventionalEnabled(n);
    }

    private void setCommandEnabled(int n) {
        this.butC.setText(Messages.getString("DeploymentDisplay.buttonCommand", new Object[]{new Integer(n)}));
        this.butC.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployCommandEnabled(n);
    }

    private void setVibrabombEnabled(int n) {
        this.butV.setText(Messages.getString("DeploymentDisplay.buttonVibrabomb", new Object[]{new Integer(n)}));
        this.butV.setEnabled(n > 0);
        this.clientgui.getMenuBar().setDeployVibrabombEnabled(n);
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public JButton getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }
}

