/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.DialogOptionComponent;
import megamek.client.ui.swing.DialogOptionListener;
import megamek.client.ui.swing.Messages;
import megamek.common.options.GameOptions;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameOptionsDialog
extends JDialog
implements ActionListener,
DialogOptionListener {
    private ClientGUI client;
    private GameOptions options;
    private boolean editable = true;
    private Vector optionComps = new Vector();
    private int maxOptionWidth;
    private JPanel panOptions = new JPanel();
    private JScrollPane scrOptions;
    private JTextArea texDesc = new JTextArea(Messages.getString("GameOptionsDialog.optionDescriptionHint"), 3, 35);
    private JPanel panPassword = new JPanel();
    private JLabel labPass = new JLabel(Messages.getString("GameOptionsDialog.Password"));
    private JTextField texPass = new JTextField(15);
    private JPanel panButtons = new JPanel();
    private JButton butDefaults = new JButton(Messages.getString("GameOptionsDialog.Defaults"));
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private JFrame currentFrame;

    private void init(JFrame jFrame, GameOptions gameOptions) {
        this.options = gameOptions;
        this.currentFrame = jFrame;
        this.scrOptions = new JScrollPane(this.panOptions);
        this.texDesc.setEditable(false);
        this.texDesc.setOpaque(false);
        this.setupButtons();
        this.setupPassword();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.scrOptions, gridBagConstraints);
        this.getContentPane().add(this.scrOptions);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
        this.getContentPane().add(new JScrollPane(this.texDesc));
        gridBagLayout.setConstraints(this.panPassword, gridBagConstraints);
        this.getContentPane().add(this.panPassword);
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.getContentPane().add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GameOptionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setSize(this.getSize().width, Math.max(this.getSize().height, 400));
        this.setResizable(false);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - this.getSize().width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - this.getSize().height / 2);
    }

    public GameOptionsDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("GameOptionsDialog.title"), true);
        this.client = clientGUI;
        this.init(clientGUI.frame, clientGUI.getClient().game.getOptions());
    }

    public GameOptionsDialog(JFrame jFrame, GameOptions gameOptions) {
        super(jFrame, Messages.getString("GameOptionsDialog.title"), true);
        this.init(jFrame, gameOptions);
        this.butOkay.setEnabled(false);
    }

    public void update(GameOptions gameOptions) {
        this.options = gameOptions;
        this.refreshOptions();
    }

    private void send() {
        Vector<IBasicOption> vector = new Vector<IBasicOption>();
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            if (!dialogOptionComponent.hasChanged()) continue;
            vector.addElement(dialogOptionComponent.changedOption());
        }
        if (this.client != null && vector.size() > 0) {
            this.client.getClient().sendGameOptions(this.texPass.getText(), vector);
        }
    }

    private void doSave() {
        GameOptions.saveOptions(this.getOptions());
    }

    public Vector<IBasicOption> getOptions() {
        Vector<IBasicOption> vector = new Vector<IBasicOption>();
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            IBasicOption iBasicOption = dialogOptionComponent.changedOption();
            vector.addElement(iBasicOption);
        }
        return vector;
    }

    private void resetToDefaults() {
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            dialogOptionComponent.resetToDefault();
        }
    }

    private void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps = new Vector();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = (IOptionGroup)enumeration.nextElement();
            this.addGroup(iOptionGroup, gridBagLayout, gridBagConstraints);
            Enumeration enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = (IOption)enumeration2.nextElement();
                this.addOption(iOption, gridBagLayout, gridBagConstraints);
            }
        }
        this.setSize(Math.min(this.currentFrame.getSize().width, this.maxOptionWidth + 30), Math.max(this.getSize().height, 400));
        this.validate();
    }

    private void addGroup(IOptionGroup iOptionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(iOptionGroup.getDisplayableName());
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.panOptions.add(jLabel);
    }

    private void addOption(IOption iOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        DialogOptionComponent dialogOptionComponent = new DialogOptionComponent(this, iOption);
        gridBagLayout.setConstraints(dialogOptionComponent, gridBagConstraints);
        this.panOptions.add(dialogOptionComponent);
        this.maxOptionWidth = Math.max(this.maxOptionWidth, dialogOptionComponent.getPreferredSize().width);
        if ("inf_deploy_even".equals(iOption.getName())) {
            if (!this.options.getOption("inf_move_even").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("inf_move_multi".equals(iOption.getName())) {
            if (this.options.getOption("inf_move_even").booleanValue() || this.options.getOption("inf_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("inf_move_even".equals(iOption.getName())) {
            if (this.options.getOption("inf_move_multi").booleanValue() || this.options.getOption("inf_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("inf_move_later".equals(iOption.getName())) {
            if (this.options.getOption("inf_move_even").booleanValue() || this.options.getOption("inf_move_multi").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("protos_deploy_even".equals(iOption.getName())) {
            if (!this.options.getOption("protos_move_even").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("protos_move_multi".equals(iOption.getName())) {
            if (this.options.getOption("protos_move_even").booleanValue() || this.options.getOption("protos_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("protos_move_even".equals(iOption.getName())) {
            if (this.options.getOption("protos_move_multi").booleanValue() || this.options.getOption("protos_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("protos_move_later".equals(iOption.getName())) {
            if (this.options.getOption("protos_move_even").booleanValue() || this.options.getOption("protos_move_multi").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if ("visibility".equals(iOption.getName())) {
            if (!this.options.getOption("double_blind").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else {
            dialogOptionComponent.setEditable(this.editable);
        }
        this.optionComps.addElement(dialogOptionComponent);
    }

    @Override
    public void showDescFor(IOption iOption) {
        this.texDesc.setText(iOption.getDescription());
    }

    @Override
    public void optionClicked(DialogOptionComponent dialogOptionComponent, IOption iOption, boolean bl) {
        DialogOptionComponent dialogOptionComponent2;
        Enumeration enumeration;
        if ("inf_move_even".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if ("inf_deploy_even".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(bl);
                    dialogOptionComponent2.setSelected(false);
                }
                if ("inf_move_multi".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!"inf_move_later".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if ("inf_move_multi".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if ("inf_move_even".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!"inf_move_later".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if ("inf_move_later".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if ("inf_move_even".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!"inf_move_multi".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if ("protos_move_even".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if ("protos_deploy_even".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(bl);
                    dialogOptionComponent2.setSelected(false);
                }
                if ("protos_move_multi".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!"protos_move_later".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if ("protos_move_multi".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if ("protos_move_even".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!"protos_move_later".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if ("protos_move_later".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if ("protos_move_even".equals(dialogOptionComponent2.option.getName())) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!"protos_move_multi".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("individual_initiative")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_deploy_even")) {
                    dialogOptionComponent2.setEditable(false);
                    dialogOptionComponent2.setSelected(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setSelected(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setSelected(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_later")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setSelected(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_deploy_even")) {
                    dialogOptionComponent2.setEditable(false);
                    dialogOptionComponent2.setSelected(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setSelected(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setSelected(false);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
                dialogOptionComponent2.setSelected(false);
            }
        }
        if ("vacuum".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (!"fire".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(!bl);
                dialogOptionComponent2.setSelected(false);
            }
        }
        if ("double_blind".equals(iOption.getName())) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = (DialogOptionComponent)enumeration.nextElement();
                if (!"visibility".equals(dialogOptionComponent2.option.getName())) continue;
                dialogOptionComponent2.setEditable(bl);
            }
        }
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butDefaults.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.butDefaults, gridBagConstraints);
        this.panButtons.add(this.butDefaults);
    }

    private void setupPassword() {
        this.panPassword.setLayout(new BorderLayout());
        this.panPassword.add((Component)this.labPass, "West");
        this.panPassword.add((Component)this.texPass, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.butOkay)) {
            if (this.client != null) {
                this.send();
            }
            this.doSave();
        } else if (actionEvent.getSource().equals(this.butDefaults)) {
            this.resetToDefaults();
            return;
        }
        this.setVisible(false);
    }

    public void setEditable(boolean bl) {
        Enumeration enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = (DialogOptionComponent)enumeration.nextElement();
            dialogOptionComponent.setEditable(bl);
        }
        this.texPass.setEnabled(bl);
        this.butOkay.setEnabled(bl);
        this.butDefaults.setEnabled(bl);
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

