/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.event.MechDisplayEvent;
import megamek.client.event.MechDisplayListener;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.FiringDisplay;
import megamek.client.ui.swing.HeatEffects;
import megamek.client.ui.swing.Slider;
import megamek.client.ui.swing.TargetingPhaseDisplay;
import megamek.client.ui.swing.widget.ArmlessMechMapSet;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.BattleArmorMapSet;
import megamek.client.ui.swing.widget.BufferedPanel;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.GeneralInfoMapSet;
import megamek.client.ui.swing.widget.GunEmplacementMapSet;
import megamek.client.ui.swing.widget.InfantryMapSet;
import megamek.client.ui.swing.widget.MechMapSet;
import megamek.client.ui.swing.widget.MechPanelTabStrip;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PicMap;
import megamek.client.ui.swing.widget.ProtomechMapSet;
import megamek.client.ui.swing.widget.QuadMapSet;
import megamek.client.ui.swing.widget.TankMapSet;
import megamek.client.ui.swing.widget.VTOLMapSet;
import megamek.common.AmmoType;
import megamek.common.ArmlessMech;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.VTOL;
import megamek.common.WeaponType;

public class MechDisplay
extends JPanel {
    private MechPanelTabStrip tabStrip;
    private JPanel displayP;
    private MovementPanel mPan;
    private ArmorPanel aPan;
    public WeaponPanel wPan;
    private SystemPanel sPan;
    private ExtraPanel ePan;
    private ClientGUI clientgui;
    private Entity currentlyDisplaying;
    private ArrayList<MechDisplayListener> eventListeners = new ArrayList();

    public MechDisplay(ClientGUI clientGUI) {
        super(new GridBagLayout());
        this.clientgui = clientGUI;
        this.tabStrip = new MechPanelTabStrip(this);
        this.displayP = new JPanel(new CardLayout());
        this.mPan = new MovementPanel();
        this.displayP.add("movement", this.mPan);
        this.aPan = new ArmorPanel();
        this.displayP.add("armor", this.aPan);
        this.wPan = new WeaponPanel();
        this.displayP.add("weapons", this.wPan);
        this.sPan = new SystemPanel();
        this.displayP.add("systems", this.sPan);
        this.ePan = new ExtraPanel();
        this.displayP.add("extras", this.ePan);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 1, 0, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.tabStrip, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.displayP, gridBagConstraints);
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, "movement");
    }

    private void addBag(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        ((GridBagLayout)this.getLayout()).setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
    }

    public void displayEntity(Entity entity) {
        this.clientgui.mechW.setTitle(entity.getShortName());
        this.currentlyDisplaying = entity;
        this.mPan.displayMech(entity);
        this.aPan.displayMech(entity);
        this.wPan.displayMech(entity);
        this.sPan.displayMech(entity);
        this.ePan.displayMech(entity);
    }

    public Entity getCurrentEntity() {
        return this.currentlyDisplaying;
    }

    public void showPanel(String string) {
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, string);
        if ("movement".equals(string)) {
            this.tabStrip.setTab(0);
        } else if ("armor".equals(string)) {
            this.tabStrip.setTab(1);
        } else if ("weapons".equals(string)) {
            this.tabStrip.setTab(3);
        } else if ("systems".equals(string)) {
            this.tabStrip.setTab(2);
        } else if ("extras".equals(string)) {
            this.tabStrip.setTab(4);
        }
    }

    public void addMechDisplayListener(MechDisplayListener mechDisplayListener) {
        this.eventListeners.add(mechDisplayListener);
    }

    private void processMechDisplayEvent(MechDisplayEvent mechDisplayEvent) {
        block3: for (int i = 0; i < this.eventListeners.size(); ++i) {
            MechDisplayListener mechDisplayListener = this.eventListeners.get(i);
            switch (mechDisplayEvent.getType()) {
                case 0: {
                    mechDisplayListener.WeaponSelected(mechDisplayEvent);
                    continue block3;
                }
                default: {
                    System.err.println("unknown event " + mechDisplayEvent.getType() + " in processMechDisplayEvent");
                }
            }
        }
    }

    private class ExtraPanel
    extends BufferedPanel
    implements ItemListener,
    ActionListener {
        private static final String IMAGE_DIR = "data/images/widgets";
        private JLabel narcLabel = new JLabel(Messages.getString("MechDisplay.AffectedBy"), 0);
        private JLabel unusedL;
        private JLabel carrysL;
        private JLabel heatL;
        private JLabel sinksL;
        private JLabel targSysL;
        private JTextArea unusedR;
        private JTextArea carrysR;
        private JTextArea heatR;
        private JTextArea sinksR;
        private JButton sinks2B;
        private JList narcList;
        private int myMechId;
        private Slider prompt = null;
        private int sinks;
        private boolean dontChange;

        ExtraPanel() {
            this.narcLabel.setOpaque(false);
            this.narcList = new JList(new DefaultListModel());
            this.unusedL = new JLabel(Messages.getString("MechDisplay.UnusedSpace"), 0);
            this.unusedL.setOpaque(false);
            this.unusedR = new JTextArea("", 2, 25);
            this.unusedR.setEditable(false);
            this.unusedR.setOpaque(false);
            this.carrysL = new JLabel(Messages.getString("MechDisplay.Carryng"), 0);
            this.carrysL.setOpaque(false);
            this.carrysR = new JTextArea("", 4, 25);
            this.carrysR.setEditable(false);
            this.carrysR.setOpaque(false);
            this.sinksL = new JLabel(Messages.getString("MechDisplay.activeSinksLabel"), 0);
            this.sinksL.setOpaque(false);
            this.sinksR = new JTextArea("", 2, 25);
            this.sinksR.setEditable(false);
            this.sinksR.setOpaque(false);
            this.sinks2B = new JButton(Messages.getString("MechDisplay.configureActiveSinksLabel"));
            this.sinks2B.setActionCommand("changeSinks");
            this.sinks2B.addActionListener(this);
            this.heatL = new JLabel(Messages.getString("MechDisplay.HeatEffects"), 0);
            this.heatL.setOpaque(false);
            this.heatR = new JTextArea("", 4, 25);
            this.heatR.setEditable(false);
            this.heatR.setOpaque(false);
            this.targSysL = new JLabel(Messages.getString("MechDisplay.TargSysLabel").concat(" "), 0);
            this.targSysL.setOpaque(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.narcLabel, gridBagConstraints);
            this.add(this.narcLabel);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.narcList, gridBagConstraints);
            this.add(new JScrollPane(this.narcList));
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.unusedL, gridBagConstraints);
            this.add(this.unusedL);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.unusedR, gridBagConstraints);
            this.add(this.unusedR);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.carrysL, gridBagConstraints);
            this.add(this.carrysL);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.carrysR, gridBagConstraints);
            this.add(this.carrysR);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.sinksL, gridBagConstraints);
            this.add(this.sinksL);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.sinksR, gridBagConstraints);
            this.add(this.sinksR);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.sinks2B, gridBagConstraints);
            this.add(this.sinks2B);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.heatL, gridBagConstraints);
            this.add(this.heatL);
            gridBagConstraints.insets = new Insets(1, 9, 18, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.heatR, gridBagConstraints);
            this.add(this.heatR);
            gridBagLayout.setConstraints(this.targSysL, gridBagConstraints);
            this.add(this.targSysL);
            this.setBackGround();
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void displayMech(Entity entity) {
            StringBuffer stringBuffer;
            Serializable serializable;
            ((DefaultListModel)this.narcList.getModel()).removeAllElements();
            this.sinks = 0;
            this.myMechId = entity.getId();
            if (MechDisplay.this.clientgui.getClient().getLocalPlayer().getId() != entity.getOwnerId()) {
                this.sinks2B.setEnabled(false);
                this.dontChange = true;
            } else {
                this.sinks2B.setEnabled(true);
                this.dontChange = false;
            }
            Enumeration enumeration = ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPlayers();
            while (enumeration.hasMoreElements()) {
                serializable = (Player)enumeration.nextElement();
                int n = ((Player)serializable).getTeam();
                if (entity.isNarcedBy(n) && !((Player)serializable).isObserver()) {
                    stringBuffer = new StringBuffer(Messages.getString("MechDisplay.NARCedBy"));
                    stringBuffer.append(((Player)serializable).getName());
                    stringBuffer.append(" [").append(Player.teamNames[n]).append(']');
                    ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
                }
                if (!entity.isINarcedBy(n) || ((Player)serializable).isObserver()) continue;
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.INarcHoming"));
                stringBuffer.append(((Player)serializable).getName());
                stringBuffer.append(" [").append(Player.teamNames[n]).append("] ").append(Messages.getString("MechDisplay.attached")).append('.');
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.isINarcedWith(2L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcECMPodAttached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.isINarcedWith(4L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcHaywirePodAttached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.isINarcedWith(8L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcNemesisPodAttached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.infernos.isStillBurning()) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.InfernoBurnRemaining"));
                stringBuffer.append(entity.infernos.getTurnsLeftToBurn());
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity instanceof Tank && ((Tank)entity).isOnFire()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.OnFire"));
            }
            if (entity.isSufferingEMI()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.IsEMId"));
            }
            if (Compute.isAffectedByECM(entity, (Coords)(serializable = entity.getPosition()), (Coords)serializable)) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.InEnemyECMField"));
            } else if (Compute.isAffectedByAngelECM(entity, (Coords)serializable, (Coords)serializable)) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.InEnemyAngelECMField"));
            }
            if (entity.isStealthActive()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.UnderStealth"));
            }
            if (entity instanceof Tank && !((Tank)entity).hasNoTurret() && !entity.canChangeSecondaryFacing()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.Turretlocked"));
            }
            for (Mounted object2 : entity.getWeaponList()) {
                if (!object2.isJammed()) continue;
                stringBuffer = new StringBuffer(object2.getName());
                stringBuffer.append(Messages.getString("MechDisplay.isJammed"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            for (int i = 0; i < entity.locations(); ++i) {
                if (entity.getLocationStatus(i) != -1) continue;
                stringBuffer = new StringBuffer(entity.getLocationName(i));
                stringBuffer.append(Messages.getString("MechDisplay.Breached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            String string = entity.getUnusedString();
            if ("".equals(string)) {
                string = Messages.getString("MechDisplay.None");
            }
            this.unusedR.setText(string);
            Enumeration<Entity> enumeration2 = entity.getLoadedUnits().elements();
            this.carrysR.setText(null);
            while (enumeration2.hasMoreElements()) {
                this.carrysR.append(enumeration2.nextElement().getShortName());
                this.carrysR.append("\n");
            }
            for (Mounted bl : entity.getClubs()) {
                this.carrysR.append(bl.getName());
                this.carrysR.append("\n");
            }
            if (entity.hasSpotlight()) {
                if (entity.isUsingSpotlight()) {
                    this.carrysR.append(Messages.getString("MechDisplay.SearchlightOn"));
                } else {
                    this.carrysR.append(Messages.getString("MechDisplay.SearchlightOff"));
                }
            }
            this.heatR.setText("");
            this.sinksR.setText("");
            if (entity instanceof Mech) {
                Mech mech = (Mech)entity;
                this.sinks2B.setEnabled(!this.dontChange);
                this.sinks = mech.getActiveSinksNextRound();
                if (mech.hasDoubleHeatSinks()) {
                    this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextDouble", new Object[]{new Integer(this.sinks), new Integer(this.sinks * 2)}));
                } else {
                    this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextSingle", new Object[]{new Integer(this.sinks)}));
                }
                boolean bl = false;
                boolean bl2 = false;
                if (((Mech)entity).hasTSM()) {
                    bl = true;
                }
                if (((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_heat")) {
                    bl2 = true;
                }
                this.heatR.append(HeatEffects.getHeatEffects(entity.heat, bl2, bl));
            } else {
                this.sinks2B.setEnabled(false);
            }
            this.targSysL.setText(Messages.getString("MechDisplay.TargSysLabel").concat(" ").concat(MiscType.getTargetSysName(entity.getTargSysType())));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("changeSinks".equals(actionEvent.getActionCommand()) && !this.dontChange) {
                this.prompt = new Slider(((MechDisplay)MechDisplay.this).clientgui.frame, Messages.getString("MechDisplay.changeSinks"), Messages.getString("MechDisplay.changeSinks"), this.sinks, 0, ((Mech)((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId)).getNumberOfSinks());
                if (!this.prompt.showDialog()) {
                    return;
                }
                ((MechDisplay)MechDisplay.this).clientgui.menuBar.actionPerformed(actionEvent);
                int n = this.prompt.getValue();
                ((Mech)((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId)).setActiveSinksNextRound(n);
                MechDisplay.this.clientgui.getClient().sendUpdateEntity(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
                this.displayMech(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
            }
        }
    }

    private class SystemPanel
    extends BufferedPanel
    implements ItemListener,
    ActionListener,
    ListSelectionListener {
        private static final String IMAGE_DIR = "data/images/widgets";
        private JLabel locLabel = new JLabel(Messages.getString("MechDisplay.Location"), 0);
        private JLabel slotLabel;
        private JLabel modeLabel;
        private JList slotList;
        private JList locList;
        private JComboBox m_chMode;
        private JButton m_bDumpAmmo;
        private Entity en;

        SystemPanel() {
            this.locLabel.setOpaque(true);
            this.slotLabel = new JLabel(Messages.getString("MechDisplay.Slot"), 0);
            this.slotLabel.setOpaque(true);
            this.locList = new JList(new DefaultListModel());
            this.locList.addListSelectionListener(this);
            this.slotList = new JList(new DefaultListModel());
            this.slotList.addListSelectionListener(this);
            this.m_chMode = new JComboBox();
            this.m_chMode.addItem("   ");
            this.m_chMode.setEnabled(false);
            this.m_chMode.addItemListener(this);
            this.m_bDumpAmmo = new JButton(Messages.getString("MechDisplay.m_bDumpAmmo"));
            this.m_bDumpAmmo.setEnabled(false);
            this.m_bDumpAmmo.setActionCommand("dump");
            this.m_bDumpAmmo.addActionListener(this);
            this.modeLabel = new JLabel(Messages.getString("MechDisplay.modeLabel"), 4);
            this.modeLabel.setOpaque(true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 1);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(this.locLabel, gridBagConstraints);
            this.add(this.locLabel);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(15, 1, 1, 9);
            gridBagLayout.setConstraints(this.slotLabel, gridBagConstraints);
            this.add(this.slotLabel);
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(1, 9, 15, 1);
            gridBagConstraints.gridheight = 0;
            gridBagLayout.setConstraints(this.locList, gridBagConstraints);
            this.add(this.locList);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagLayout.setConstraints(this.slotList, gridBagConstraints);
            this.add(this.slotList);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.modeLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.add(this.modeLabel);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagLayout.setConstraints(this.m_chMode, gridBagConstraints);
            this.add(this.m_chMode);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(4, 4, 15, 9);
            gridBagLayout.setConstraints(this.m_bDumpAmmo, gridBagConstraints);
            this.add(this.m_bDumpAmmo);
            this.setBackGround();
        }

        private CriticalSlot getSelectedCritical() {
            int n = this.locList.getSelectedIndex();
            int n2 = this.slotList.getSelectedIndex();
            if (n == -1 || n2 == -1) {
                return null;
            }
            return this.en.getCritical(n, n2);
        }

        private Mounted getSelectedEquipment() {
            CriticalSlot criticalSlot = this.getSelectedCritical();
            if (criticalSlot == null) {
                return null;
            }
            if (criticalSlot.getType() == 0) {
                return null;
            }
            return this.en.getEquipment(criticalSlot.getIndex());
        }

        public void displayMech(Entity entity) {
            this.en = entity;
            ((DefaultListModel)this.locList.getModel()).removeAllElements();
            for (int i = 0; i < entity.locations(); ++i) {
                if (entity.getNumberOfCriticals(i) <= 0) continue;
                ((DefaultListModel)this.locList.getModel()).insertElementAt(entity.getLocationName(i), i);
            }
            this.locList.setSelectedIndex(0);
            this.displaySlots();
        }

        private void displaySlots() {
            int n = this.locList.getSelectedIndex();
            ((DefaultListModel)this.slotList.getModel()).removeAllElements();
            for (int i = 0; i < this.en.getNumberOfCriticals(n); ++i) {
                CriticalSlot criticalSlot = this.en.getCritical(n, i);
                StringBuffer stringBuffer = new StringBuffer(32);
                if (criticalSlot == null) {
                    stringBuffer.append("---");
                } else {
                    switch (criticalSlot.getType()) {
                        case 0: {
                            stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(criticalSlot.isBreached() ? "x" : "");
                            if (this.en instanceof Protomech) {
                                stringBuffer.append(Protomech.systemNames[criticalSlot.getIndex()]);
                                break;
                            }
                            stringBuffer.append(((Mech)this.en).getSystemName(criticalSlot.getIndex()));
                            break;
                        }
                        case 1: {
                            Mounted mounted = this.en.getEquipment(criticalSlot.getIndex());
                            stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(criticalSlot.isBreached() ? "x" : "").append(mounted.getDesc());
                            if (mounted.isHotLoaded()) {
                                stringBuffer.append(Messages.getString("MechDisplay.isHotLoaded"));
                            }
                            if (!mounted.getType().hasModes()) break;
                            stringBuffer.append(" (").append(mounted.curMode().getDisplayableName()).append(')');
                            if (!(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).isShield()) break;
                            stringBuffer.append(" " + mounted.getDamageAbsorption(this.en, n) + '/' + mounted.getCurrentDamageCapacity(this.en, n) + ')');
                            break;
                        }
                    }
                }
                ((DefaultListModel)this.slotList.getModel()).addElement(stringBuffer.toString());
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable().equals(this.m_chMode)) {
                int n;
                Mounted mounted = this.getSelectedEquipment();
                CriticalSlot criticalSlot = this.getSelectedCritical();
                if (mounted != null && mounted.getType().hasModes()) {
                    int n2 = this.m_chMode.getSelectedIndex();
                    if (n2 >= 0) {
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).isShield() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != 12) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.ShieldModePhase", null));
                            return;
                        }
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).isVibroblade() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != 14) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.VibrobladeModePhase", null));
                            return;
                        }
                        mounted.setMode(n2);
                        MechDisplay.this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), n2);
                        if (mounted.getType().hasInstantModeSwitch()) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{mounted.getName(), mounted.curMode().getDisplayableName()}));
                        } else if (((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() == 4) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtStart", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                        } else {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                        }
                    }
                } else if (criticalSlot != null && criticalSlot.getType() == 0 && (n = this.m_chMode.getSelectedIndex()) >= 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                    Mech mech = (Mech)this.en;
                    mech.setCockpitStatus(n);
                    MechDisplay.this.clientgui.getClient().sendSystemModeChange(this.en.getId(), 2, n);
                    if (mech.getCockpitStatus() == mech.getCockpitStatusNextRound()) {
                        MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                    } else {
                        MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("dump".equals(actionEvent.getActionCommand())) {
                boolean bl;
                boolean bl2;
                Mounted mounted = this.getSelectedEquipment();
                boolean bl3 = MechDisplay.this.clientgui.getClient().getLocalPlayer().equals(this.en.getOwner());
                if (mounted == null || !bl3 || !(mounted.getType() instanceof AmmoType) || mounted.getShotsLeft() <= 0) {
                    return;
                }
                if (mounted.isPendingDump()) {
                    bl2 = false;
                    String string = Messages.getString("MechDisplay.CancelDumping.title");
                    String string2 = Messages.getString("MechDisplay.CancelDumping.message", new Object[]{mounted.getName()});
                    bl = MechDisplay.this.clientgui.doYesNoDialog(string, string2);
                } else {
                    bl2 = true;
                    String string = Messages.getString("MechDisplay.Dump.title");
                    String string3 = Messages.getString("MechDisplay.Dump.message", new Object[]{mounted.getName()});
                    bl = MechDisplay.this.clientgui.doYesNoDialog(string, string3);
                }
                if (bl) {
                    mounted.setPendingDump(bl2);
                    MechDisplay.this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), bl2 ? -1 : 0);
                }
            }
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource().equals(this.locList)) {
                this.m_chMode.removeAll();
                this.m_chMode.setEnabled(false);
                this.displaySlots();
            } else if (listSelectionEvent.getSource().equals(this.slotList)) {
                this.m_bDumpAmmo.setEnabled(false);
                this.m_chMode.setEnabled(false);
                this.modeLabel.setEnabled(false);
                Mounted mounted = this.getSelectedEquipment();
                boolean bl = MechDisplay.this.clientgui.getClient().getLocalPlayer().equals(this.en.getOwner());
                if (mounted != null && bl && mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != 4 && mounted.getShotsLeft() > 0 && !mounted.isDumping() && this.en.isActive()) {
                    this.m_bDumpAmmo.setEnabled(true);
                } else if (mounted != null && bl && mounted.getType().hasModes()) {
                    if (!mounted.isDestroyed() && this.en.isActive()) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (!mounted.isDestroyed() && mounted.getType().hasFlag(262144L)) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (mounted.getType().hasFlag(1024L) && !((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_eccm")) {
                        this.m_chMode.removeAll();
                        return;
                    }
                    this.modeLabel.setEnabled(true);
                    this.m_chMode.removeAll();
                    Enumeration enumeration = mounted.getType().getModes();
                    while (enumeration.hasMoreElements()) {
                        EquipmentMode equipmentMode = (EquipmentMode)enumeration.nextElement();
                        this.m_chMode.addItem(equipmentMode.getDisplayableName());
                    }
                    this.m_chMode.setSelectedItem(mounted.curMode().getDisplayableName());
                } else {
                    CriticalSlot criticalSlot = this.getSelectedCritical();
                    if (criticalSlot != null && criticalSlot.getType() == 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                        this.m_chMode.removeAll();
                        this.m_chMode.setEnabled(true);
                        this.m_chMode.addItem("EI Off");
                        this.m_chMode.addItem("EI On");
                        this.m_chMode.addItem("Aimed shot");
                        this.m_chMode.setSelectedItem(new Integer(((Mech)this.en).getCockpitStatusNextRound()));
                    }
                }
            }
        }
    }

    public class WeaponPanel
    extends BufferedPanel
    implements ItemListener,
    ListSelectionListener {
        private static final String IMAGE_DIR = "data/images/widgets";
        public JList weaponList;
        private JComboBox m_chAmmo;
        private JLabel wAmmo;
        private JLabel wNameL;
        private JLabel wHeatL;
        private JLabel wDamL;
        private JLabel wMinL;
        private JLabel wShortL;
        private JLabel wMedL;
        private JLabel wLongL;
        private JLabel wExtL;
        private JLabel wNameR;
        private JLabel wHeatR;
        private JLabel wDamR;
        private JLabel wMinR;
        private JLabel wShortR;
        private JLabel wMedR;
        private JLabel wLongR;
        private JLabel wExtR;
        private JLabel currentHeatBuildupL;
        private JLabel currentHeatBuildupR;
        private JLabel wTargetL;
        private JLabel wRangeL;
        private JLabel wToHitL;
        public JLabel wTargetR;
        public JLabel wRangeR;
        public JLabel wToHitR;
        public JTextArea toHitText;
        private ArrayList<Mounted> vAmmo;
        private Entity entity;

        WeaponPanel() {
            super(new GridBagLayout());
            this.weaponList = new JList(new DefaultListModel());
            this.weaponList.addListSelectionListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 9);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.weaponList, gridBagConstraints);
            this.add(this.weaponList);
            this.wAmmo = new JLabel(Messages.getString("MechDisplay.Ammo"), 2);
            this.wAmmo.setOpaque(true);
            this.m_chAmmo = new JComboBox();
            this.m_chAmmo.addItemListener(this);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wAmmo, gridBagConstraints);
            this.add(this.wAmmo);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.m_chAmmo, gridBagConstraints);
            this.add(this.m_chAmmo);
            this.currentHeatBuildupL = new JLabel(Messages.getString("MechDisplay.HeatBuildup"), 4);
            this.currentHeatBuildupL.setOpaque(false);
            this.currentHeatBuildupR = new JLabel("--", 2);
            this.currentHeatBuildupR.setOpaque(false);
            gridBagConstraints.insets = new Insets(2, 9, 2, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            ((GridBagLayout)this.getLayout()).setConstraints(this.currentHeatBuildupL, gridBagConstraints);
            this.add(this.currentHeatBuildupL);
            gridBagConstraints.insets = new Insets(2, 1, 2, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            ((GridBagLayout)this.getLayout()).setConstraints(this.currentHeatBuildupR, gridBagConstraints);
            this.add(this.currentHeatBuildupR);
            this.wNameL = new JLabel(Messages.getString("MechDisplay.Name"), 0);
            this.wNameL.setOpaque(true);
            this.wHeatL = new JLabel(Messages.getString("MechDisplay.Heat"), 0);
            this.wHeatL.setOpaque(true);
            this.wDamL = new JLabel(Messages.getString("MechDisplay.Damage"), 0);
            this.wDamL.setOpaque(true);
            this.wNameR = new JLabel("", 0);
            this.wNameR.setOpaque(false);
            this.wHeatR = new JLabel("--", 0);
            this.wHeatR.setOpaque(false);
            this.wDamR = new JLabel("--", 0);
            this.wDamR.setOpaque(false);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wNameL, gridBagConstraints);
            this.add(this.wNameL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wHeatL, gridBagConstraints);
            this.add(this.wHeatL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 3;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wDamL, gridBagConstraints);
            this.add(this.wDamL);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wNameR, gridBagConstraints);
            this.add(this.wNameR);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wHeatR, gridBagConstraints);
            this.add(this.wHeatR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wDamR, gridBagConstraints);
            this.add(this.wDamR);
            this.wMinL = new JLabel(Messages.getString("MechDisplay.Min"), 0);
            this.wMinL.setOpaque(true);
            this.wShortL = new JLabel(Messages.getString("MechDisplay.Short"), 0);
            this.wShortL.setOpaque(true);
            this.wMedL = new JLabel(Messages.getString("MechDisplay.Med"), 0);
            this.wMedL.setOpaque(true);
            this.wLongL = new JLabel(Messages.getString("MechDisplay.Long"), 0);
            this.wLongL.setOpaque(true);
            this.wExtL = new JLabel(Messages.getString("MechDisplay.Ext"), 0);
            this.wExtL.setOpaque(true);
            this.wMinR = new JLabel("---", 0);
            this.wMinR.setOpaque(true);
            this.wShortR = new JLabel("---", 0);
            this.wShortR.setOpaque(true);
            this.wMedR = new JLabel("---", 0);
            this.wMedR.setOpaque(true);
            this.wLongR = new JLabel("---", 0);
            this.wLongR.setOpaque(true);
            this.wExtR = new JLabel("---", 0);
            this.wExtR.setOpaque(true);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMinL, gridBagConstraints);
            this.add(this.wMinL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wShortL, gridBagConstraints);
            this.add(this.wShortL);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMedL, gridBagConstraints);
            this.add(this.wMedL);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 5;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wLongL, gridBagConstraints);
            this.add(this.wLongL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wExtL, gridBagConstraints);
            this.add(this.wExtL);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMinR, gridBagConstraints);
            this.add(this.wMinR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wShortR, gridBagConstraints);
            this.add(this.wShortR);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 6;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMedR, gridBagConstraints);
            this.add(this.wMedR);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 6;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wLongR, gridBagConstraints);
            this.add(this.wLongR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 6;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wExtR, gridBagConstraints);
            this.add(this.wExtR);
            this.wTargetL = new JLabel(Messages.getString("MechDisplay.Target"), 0);
            this.wTargetL.setOpaque(true);
            this.wRangeL = new JLabel(Messages.getString("MechDisplay.Range"), 0);
            this.wRangeL.setOpaque(true);
            this.wToHitL = new JLabel(Messages.getString("MechDisplay.ToHit"), 0);
            this.wToHitL.setOpaque(true);
            this.wTargetR = new JLabel("---", 0);
            this.wTargetR.setOpaque(true);
            this.wRangeR = new JLabel("---", 0);
            this.wRangeR.setOpaque(true);
            this.wToHitR = new JLabel("---", 0);
            this.wToHitR.setOpaque(true);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wTargetL, gridBagConstraints);
            this.add(this.wTargetL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wTargetR, gridBagConstraints);
            this.add(this.wTargetR);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wRangeL, gridBagConstraints);
            this.add(this.wRangeL);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wRangeR, gridBagConstraints);
            this.add(this.wRangeR);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wToHitL, gridBagConstraints);
            this.add(this.wToHitL);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wToHitR, gridBagConstraints);
            this.add(this.wToHitR);
            this.toHitText = new JTextArea("", 2, 20);
            this.toHitText.setEditable(false);
            gridBagConstraints.insets = new Insets(1, 9, 15, 9);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.toHitText, gridBagConstraints);
            this.add(this.toHitText);
            this.setBackGround();
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void displayMech(Entity entity) {
            CharSequence charSequence;
            Object object;
            int n;
            IGame iGame = ((MechDisplay)MechDisplay.this).clientgui.getClient().game;
            this.entity = entity;
            int n2 = entity.heat + entity.getEngineCritHeat() + Math.min(15, entity.heatFromExternal) + entity.heatBuildup;
            if (entity instanceof Mech) {
                if (entity.infernos.isStillBurning()) {
                    n2 += entity.infernos.getHeat();
                }
                if (!((Mech)entity).hasLaserHeatSinks()) {
                    n2 = iGame.getOptions().intOption("temperature") > 0 ? (n2 += iGame.getTemperatureDifference()) : (n2 -= iGame.getTemperatureDifference());
                }
            }
            Coords coords = this.entity.getPosition();
            if (!entity.isOffBoard() && coords != null) {
                IHex iHex = iGame.getBoard().getHex(coords);
                if (iHex.terrainLevel(7) == 2) {
                    n2 += 5;
                }
                if (iHex.terrainLevel(24) == 1) {
                    n2 += 5;
                } else if (iHex.terrainLevel(24) == 2) {
                    n2 += 10;
                }
            }
            if (entity instanceof Mech && entity.isStealthActive()) {
                n2 += 10;
            }
            ((DefaultListModel)this.weaponList.getModel()).removeAllElements();
            this.m_chAmmo.removeAll();
            this.m_chAmmo.setEnabled(false);
            for (n = 0; n < this.entity.getWeaponList().size(); ++n) {
                Mounted mounted = this.entity.getWeaponList().get(n);
                object = (WeaponType)mounted.getType();
                charSequence = new StringBuffer(mounted.getDesc());
                ((StringBuffer)charSequence).append(" [");
                ((StringBuffer)charSequence).append(entity.getLocationAbbr(mounted.getLocation()));
                if (mounted.isSplit()) {
                    ((StringBuffer)charSequence).append('/');
                    ((StringBuffer)charSequence).append(entity.getLocationAbbr(mounted.getSecondLocation()));
                }
                ((StringBuffer)charSequence).append(']');
                if (((WeaponType)object).getAmmoType() != -1 && !((EquipmentType)object).hasFlag(32768L)) {
                    int n3 = 0;
                    if (mounted.getLinked() != null && !mounted.getLinked().isDumping()) {
                        n3 = mounted.getLinked().getShotsLeft();
                    }
                    EquipmentType equipmentType = null;
                    if (mounted.getLinked() != null) {
                        equipmentType = mounted.getLinked().getType();
                    }
                    int n4 = this.entity.getTotalMunitionsOfType(equipmentType);
                    ((StringBuffer)charSequence).append(" (");
                    ((StringBuffer)charSequence).append(n3);
                    ((StringBuffer)charSequence).append('/');
                    ((StringBuffer)charSequence).append(n4);
                    ((StringBuffer)charSequence).append(')');
                }
                if (mounted.isRapidfire()) {
                    ((StringBuffer)charSequence).append(Messages.getString("MechDisplay.rapidFire"));
                }
                if (mounted.isHotLoaded()) {
                    ((StringBuffer)charSequence).append(Messages.getString("MechDisplay.isHotLoaded"));
                }
                if (((EquipmentType)object).hasModes()) {
                    ((StringBuffer)charSequence).append(' ');
                    ((StringBuffer)charSequence).append(mounted.curMode().getDisplayableName());
                }
                ((DefaultListModel)this.weaponList.getModel()).addElement(((StringBuffer)charSequence).toString());
                if (!mounted.isUsedThisRound() || iGame.getPhase() != mounted.usedInPhase() || iGame.getPhase() != 12) continue;
                n2 += ((WeaponType)object).getHeat() * mounted.howManyShots();
            }
            n = entity.getHeatCapacity();
            int n5 = entity.getHeatCapacityWithWater();
            object = Integer.toString(n);
            if (n < n5) {
                object = n + " [" + n5 + ']';
            }
            charSequence = Integer.toString(n2);
            if (n2 > entity.getHeatCapacityWithWater()) {
                charSequence = (String)charSequence + "*";
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.currentHeatBuildupR.setText((String)charSequence + " (" + (String)object + ')');
            if (iGame.getOptions().booleanOption("maxtech_range")) {
                this.wExtL.setVisible(true);
                this.wExtR.setVisible(true);
            } else {
                this.wExtL.setVisible(false);
                this.wExtR.setVisible(false);
            }
        }

        public void selectWeapon(int n) {
            if (n == -1) {
                this.weaponList.setSelectedIndex(-1);
                return;
            }
            int n2 = this.entity.getWeaponList().indexOf(this.entity.getEquipment(n));
            this.weaponList.setSelectedIndex(n2);
            this.displaySelected();
        }

        public int getSelectedWeaponNum() {
            int n = this.weaponList.getSelectedIndex();
            if (n == -1) {
                return -1;
            }
            return this.entity.getEquipmentNum(this.entity.getWeaponList().get(n));
        }

        private void displaySelected() {
            if (this.weaponList.getSelectedIndex() == -1) {
                this.m_chAmmo.removeAll();
                this.m_chAmmo.setEnabled(false);
                this.wNameR.setText("");
                this.wHeatR.setText("--");
                this.wDamR.setText("--");
                this.wMinR.setText("---");
                this.wShortR.setText("---");
                this.wMedR.setText("---");
                this.wLongR.setText("---");
                this.wExtR.setText("---");
                return;
            }
            Mounted mounted = this.entity.getWeaponList().get(this.weaponList.getSelectedIndex());
            WeaponType weaponType = (WeaponType)mounted.getType();
            this.wNameR.setText(mounted.getDesc());
            this.wHeatR.setText(weaponType.getHeat() + "");
            if (weaponType.getDamage() == -2) {
                this.wDamR.setText(Messages.getString("MechDisplay.Missile"));
            } else if (weaponType.getDamage() == -3) {
                this.wDamR.setText(Messages.getString("MechDisplay.Variable"));
            } else if (weaponType.getDamage() == -4) {
                this.wDamR.setText(Messages.getString("MechDisplay.Special"));
            } else if (weaponType.getDamage() == -5) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Integer.toString(weaponType.getRackSize())).append('/').append(Integer.toString(weaponType.getRackSize() / 2));
                this.wDamR.setText(stringBuffer.toString());
            } else {
                this.wDamR.setText(Integer.toString(weaponType.getDamage()));
            }
            int n = weaponType.getShortRange();
            int n2 = weaponType.getMediumRange();
            int n3 = weaponType.getLongRange();
            int n4 = weaponType.getExtremeRange();
            if (this.entity.getLocationStatus(mounted.getLocation()) == 2 || n3 == 0) {
                n = weaponType.getWShortRange();
                n2 = weaponType.getWMediumRange();
                n3 = weaponType.getWLongRange();
                n4 = weaponType.getWExtremeRange();
            }
            if (weaponType.getMinimumRange() > 0) {
                this.wMinR.setText(Integer.toString(weaponType.getMinimumRange()));
            } else {
                this.wMinR.setText("---");
            }
            if (n > 1) {
                this.wShortR.setText("1 - " + n);
            } else {
                this.wShortR.setText("" + n);
            }
            if (n2 - n > 1) {
                this.wMedR.setText(n + 1 + " - " + n2);
            } else {
                this.wMedR.setText("" + n2);
            }
            if (n3 - n2 > 1) {
                this.wLongR.setText(n2 + 1 + " - " + n3);
            } else {
                this.wLongR.setText("" + n3);
            }
            if (n4 - n3 > 1) {
                this.wExtR.setText(n3 + 1 + " - " + n4);
            } else {
                this.wExtR.setText("" + n4);
            }
            if (mounted.getLinked() != null) {
                this.updateRangeDisplayForAmmo(mounted.getLinked());
            }
            boolean bl = MechDisplay.this.clientgui.getClient().getLocalPlayer().equals(this.entity.getOwner());
            this.m_chAmmo.removeAll();
            if (weaponType.getAmmoType() == -1 || !bl) {
                this.m_chAmmo.setEnabled(false);
            } else if (weaponType.hasFlag(32768L)) {
                if (mounted.getLinked().getShotsLeft() == 1) {
                    this.m_chAmmo.addItem(this.formatAmmo(mounted.getLinked()));
                    this.m_chAmmo.setEnabled(true);
                } else {
                    this.m_chAmmo.setEnabled(false);
                }
            } else {
                if (!(this.entity instanceof Infantry)) {
                    this.m_chAmmo.setEnabled(true);
                } else {
                    this.m_chAmmo.setEnabled(false);
                }
                this.vAmmo = new ArrayList();
                int n5 = -1;
                int n6 = 0;
                for (Mounted mounted2 : this.entity.getAmmo()) {
                    AmmoType ammoType = (AmmoType)mounted2.getType();
                    if (!mounted2.isAmmoUsable() || ammoType.getAmmoType() != weaponType.getAmmoType() || ammoType.getRackSize() != weaponType.getRackSize()) continue;
                    this.vAmmo.add(mounted2);
                    this.m_chAmmo.addItem(this.formatAmmo(mounted2));
                    if (mounted.getLinked().equals(mounted2)) {
                        n5 = n6;
                    }
                    ++n6;
                }
                if (n5 != -1) {
                    this.m_chAmmo.setSelectedIndex(n5);
                }
            }
            MechDisplay.this.processMechDisplayEvent(new MechDisplayEvent(this, this.entity, mounted));
        }

        private String formatAmmo(Mounted mounted) {
            StringBuffer stringBuffer = new StringBuffer(64);
            int n = mounted.getDesc().indexOf(Messages.getString("MechDisplay.0"));
            int n2 = mounted.getLocation();
            if (n2 != -1) {
                stringBuffer.append('[').append(this.entity.getLocationAbbr(n2)).append("] ");
            }
            if (n == -1) {
                stringBuffer.append(mounted.getDesc());
            } else {
                stringBuffer.append(mounted.getDesc().substring(0, n));
                stringBuffer.append(mounted.getDesc().substring(n + 4));
            }
            return stringBuffer.toString();
        }

        private void updateRangeDisplayForAmmo(Mounted mounted) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (ammoType.getAmmoType() == 29) {
                if (ammoType.getMunitionType() == 32L) {
                    this.wMinR.setText("4");
                    this.wShortR.setText("1 - 9");
                    this.wMedR.setText("10 - 18");
                    this.wLongR.setText("19 - 27");
                    this.wExtR.setText("28 - 36");
                } else if (ammoType.getMunitionType() == 64L) {
                    this.wMinR.setText("---");
                    this.wShortR.setText("1 - 3");
                    this.wMedR.setText("4 - 6");
                    this.wLongR.setText("7 - 9");
                    this.wExtR.setText("10 - 12");
                } else {
                    this.wMinR.setText("4");
                    this.wShortR.setText("1 - 5");
                    this.wMedR.setText("6 - 10");
                    this.wLongR.setText("11 - 15");
                    this.wExtR.setText("16 - 20");
                }
            } else if (ammoType.getAmmoType() == 50) {
                if (ammoType.hasFlag(32L)) {
                    this.wMinR.setText("6");
                    this.wShortR.setText("1 - 7");
                    this.wMedR.setText("8 - 14");
                    this.wLongR.setText("15 - 21");
                    this.wExtR.setText("21 - 28");
                } else {
                    this.wMinR.setText("---");
                    this.wShortR.setText("1 - 3");
                    this.wMedR.setText("4 - 6");
                    this.wLongR.setText("7 - 9");
                    this.wExtR.setText("10 - 12");
                }
            }
            if (mounted.isHotLoaded()) {
                this.wMinR.setText("---");
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable().equals(this.m_chAmmo)) {
                int n = this.weaponList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                Mounted mounted = this.entity.getWeaponList().get(n);
                Mounted mounted2 = mounted.getLinked();
                Mounted mounted3 = this.vAmmo.get(this.m_chAmmo.getSelectedIndex());
                this.entity.loadWeapon(mounted, mounted3);
                if ((mounted2 == null || !mounted2.isHotLoaded()) && mounted3.isHotLoaded() || mounted2 != null && mounted2.isHotLoaded() && !mounted3.isHotLoaded()) {
                    this.displayMech(this.entity);
                    this.weaponList.setSelectedIndex(n);
                    this.displaySelected();
                }
                this.updateRangeDisplayForAmmo(mounted3);
                if (((MechDisplay)MechDisplay.this).clientgui.curPanel instanceof FiringDisplay) {
                    ((FiringDisplay)((MechDisplay)MechDisplay.this).clientgui.curPanel).updateTarget();
                } else if (((MechDisplay)MechDisplay.this).clientgui.curPanel instanceof TargetingPhaseDisplay) {
                    ((TargetingPhaseDisplay)((MechDisplay)MechDisplay.this).clientgui.curPanel).updateTarget();
                }
                MechDisplay.this.clientgui.getClient().sendAmmoChange(this.entity.getId(), this.entity.getEquipmentNum(mounted), this.entity.getEquipmentNum(mounted3));
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource().equals(this.weaponList)) {
                this.displaySelected();
            }
        }
    }

    private class ArmorPanel
    extends PicMap {
        private TankMapSet tank;
        private MechMapSet mech;
        private InfantryMapSet infantry;
        private BattleArmorMapSet battleArmor;
        private ProtomechMapSet proto;
        private VTOLMapSet vtol;
        private QuadMapSet quad;
        private GunEmplacementMapSet gunEmplacement;
        private ArmlessMechMapSet armless;
        private int minTopMargin;
        private int minLeftMargin;
        private int minBottomMargin;
        private int minRightMargin;
        private static final int minTankTopMargin = 8;
        private static final int minTankLeftMargin = 8;
        private static final int minVTOLTopMargin = 8;
        private static final int minVTOLLeftMargin = 8;
        private static final int minMechTopMargin = 18;
        private static final int minMechLeftMargin = 7;
        private static final int minMechBottomMargin = 0;
        private static final int minMechRightMargin = 0;
        private static final int minInfTopMargin = 8;
        private static final int minInfLeftMargin = 8;

        private ArmorPanel() {
        }

        public void addNotify() {
            super.addNotify();
            this.tank = new TankMapSet(this);
            this.mech = new MechMapSet(this);
            this.infantry = new InfantryMapSet(this);
            this.battleArmor = new BattleArmorMapSet(this);
            this.proto = new ProtomechMapSet(this);
            this.vtol = new VTOLMapSet(this);
            this.quad = new QuadMapSet(this);
            this.gunEmplacement = new GunEmplacementMapSet(this);
            this.armless = new ArmlessMechMapSet(this);
        }

        public void onResize() {
            Rectangle rectangle = this.getContentBounds();
            if (rectangle == null) {
                return;
            }
            int n = Math.round((this.getSize().width - rectangle.width) / 2);
            int n2 = Math.round((this.getSize().height - rectangle.height) / 2);
            int n3 = n < this.minLeftMargin ? this.minLeftMargin : n;
            int n4 = n2 < this.minTopMargin ? this.minTopMargin : n2;
            this.setContentMargins(n3, n4, this.minRightMargin, this.minBottomMargin);
        }

        public void displayMech(Entity entity) {
            if (entity == null) {
                return;
            }
            DisplayMapSet displayMapSet = this.mech;
            this.removeAll();
            if (entity instanceof QuadMech) {
                displayMapSet = this.quad;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof ArmlessMech) {
                displayMapSet = this.armless;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof Mech) {
                displayMapSet = this.mech;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof VTOL) {
                displayMapSet = this.vtol;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Tank) {
                displayMapSet = this.tank;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof BattleArmor) {
                displayMapSet = this.battleArmor;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Infantry) {
                displayMapSet = this.infantry;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Protomech) {
                displayMapSet = this.proto;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof GunEmplacement) {
                displayMapSet = this.gunEmplacement;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            }
            if (displayMapSet == null) {
                System.err.println("The armor panel is null.");
                return;
            }
            displayMapSet.setEntity(entity);
            this.addElement(displayMapSet.getContentGroup());
            Vector<BackGroundDrawer> vector = displayMapSet.getBackgroundDrawers();
            Enumeration<BackGroundDrawer> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.addBgDrawer(enumeration.nextElement());
            }
            this.onResize();
            this.update();
        }
    }

    private class MovementPanel
    extends PicMap {
        private GeneralInfoMapSet gi = new GeneralInfoMapSet(this);
        private int minTopMargin = 8;
        private int minLeftMargin = 8;

        MovementPanel() {
            this.addElement(this.gi.getContentGroup());
            Vector<BackGroundDrawer> vector = this.gi.getBackgroundDrawers();
            Enumeration<BackGroundDrawer> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.addBgDrawer(enumeration.nextElement());
            }
            this.onResize();
        }

        public void addNotify() {
            super.addNotify();
            this.update();
        }

        public void onResize() {
            int n = this.getSize().width;
            Rectangle rectangle = this.getContentBounds();
            int n2 = Math.round((n - rectangle.width) / 2);
            if (n2 < this.minLeftMargin) {
                n2 = this.minLeftMargin;
            }
            int n3 = this.minTopMargin;
            if (rectangle != null) {
                this.setContentMargins(n2, n3, n2, n3);
            }
        }

        public void displayMech(Entity entity) {
            this.gi.setEntity(entity);
            this.onResize();
            this.update();
        }
    }
}

