/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import megamek.MegaMek;
import megamek.client.Client;
import megamek.client.bot.BotClient;
import megamek.client.bot.TestBot;
import megamek.client.bot.ui.swing.BotGUI;
import megamek.client.ui.IMegaMekGUI;
import megamek.client.ui.swing.BoardEditor;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.CommonAboutDialog;
import megamek.client.ui.swing.CommonHelpDialog;
import megamek.client.ui.swing.CommonMenuBar;
import megamek.client.ui.swing.CommonSettingsDialog;
import megamek.client.ui.swing.ConfirmDialog;
import megamek.client.ui.swing.ConnectDialog;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.GameOptionsDialog;
import megamek.client.ui.swing.HostDialog;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.ScenarioDialog;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.MechSummaryCache;
import megamek.common.Player;
import megamek.common.options.GameOptions;
import megamek.common.options.IBasicOption;
import megamek.common.preference.PreferenceManager;
import megamek.server.ScenarioLoader;
import megamek.server.Server;

public class MegaMekGUI
implements IMegaMekGUI {
    private JFrame frame;
    private Client client;
    private Server server;
    private CommonAboutDialog about;
    private CommonHelpDialog help;
    private GameOptionsDialog optdlg;
    private CommonSettingsDialog setdlg;
    private ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if ("fileBoardNew".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.showEditor();
            }
            if ("fileBoardOpen".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.showEditorOpen();
            }
            if ("fileGameNew".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.host();
            }
            if ("fileGameScenario".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.scenario();
            }
            if ("fileGameConnect".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.connect();
            }
            if ("fileGameConnectBot".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.connectBot();
            }
            if ("fileGameOpen".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.loadGame();
            }
            if ("viewGameOptions".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.showGameOptions();
            }
            if ("helpAbout".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.showAbout();
            }
            if ("helpContents".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.showHelp();
            }
            if ("viewClientSettings".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.this.showSettings();
            }
            if ("quit".equalsIgnoreCase(actionEvent.getActionCommand())) {
                MegaMekGUI.quit();
            }
        }
    };

    public void start(String[] stringArray) {
        this.createGUI();
    }

    private void createGUI() {
        ToolTipManager.sharedInstance().setInitialDelay(GUIPreferences.getInstance().getTooltipDelay());
        this.frame = new JFrame("MegaMek");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MegaMekGUI.quit();
            }
        });
        this.frame.setBackground(SystemColor.menu);
        this.frame.setForeground(SystemColor.menuText);
        this.frame.setIconImage(this.frame.getToolkit().getImage("data/images/misc/megamek-icon.gif"));
        CommonMenuBar commonMenuBar = new CommonMenuBar();
        commonMenuBar.addActionListener(this.actionListener);
        this.frame.setJMenuBar(commonMenuBar);
        this.showMainMenu();
        Dimension dimension = this.frame.getToolkit().getScreenSize();
        this.frame.pack();
        this.frame.setLocation(dimension.width / 2 - this.frame.getSize().width / 2, dimension.height / 2 - this.frame.getSize().height / 2);
        MechSummaryCache.getInstance();
        this.frame.setVisible(true);
        if (GUIPreferences.getInstance().getNagForReadme()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, Messages.getString("MegaMek.welcome.title") + MegaMek.VERSION, Messages.getString("MegaMek.welcome.message"), true);
            confirmDialog.setVisible(true);
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForReadme(false);
            }
            if (confirmDialog.getAnswer()) {
                this.showHelp();
            }
        }
    }

    private void showMainMenu() {
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("MegaMek.Version") + MegaMek.VERSION);
        JButton jButton = new JButton(Messages.getString("MegaMek.hostNewGame.label"));
        jButton.setActionCommand("fileGameNew");
        jButton.addActionListener(this.actionListener);
        JButton jButton2 = new JButton(Messages.getString("MegaMek.hostScenario.label"));
        jButton2.setActionCommand("fileGameScenario");
        jButton2.addActionListener(this.actionListener);
        JButton jButton3 = new JButton(Messages.getString("MegaMek.hostSavedGame.label"));
        jButton3.setActionCommand("fileGameOpen");
        jButton3.addActionListener(this.actionListener);
        JButton jButton4 = new JButton(Messages.getString("MegaMek.Connect.label"));
        jButton4.setActionCommand("fileGameConnect");
        jButton4.addActionListener(this.actionListener);
        JButton jButton5 = new JButton(Messages.getString("MegaMek.ConnectAsBot.label"));
        jButton5.setActionCommand("fileGameConnectBot");
        jButton5.addActionListener(this.actionListener);
        JButton jButton6 = new JButton(Messages.getString("MegaMek.MapEditor.label"));
        jButton6.setActionCommand("fileBoardNew");
        jButton6.addActionListener(this.actionListener);
        JButton jButton7 = new JButton(Messages.getString("MegaMek.Quit.label"));
        jButton7.setActionCommand("quit");
        jButton7.addActionListener(this.actionListener);
        Image image = this.frame.getToolkit().getImage("data/images/misc/megamek-splash.jpg");
        MediaTracker mediaTracker = new MediaTracker(this.frame);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ImageIcon imageIcon = new ImageIcon(image);
        JLabel jLabel2 = new JLabel(imageIcon);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.frame.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 1);
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 8;
        this.addBag(jLabel2, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.05;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        this.addBag(jLabel, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(jButton, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(jButton3, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(jButton2, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(jButton4, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(jButton5, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(jButton6, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.addBag(jButton7, gridBagLayout, gridBagConstraints);
        this.frame.validate();
    }

    private void showGameOptions() {
        GameOptions gameOptions = new GameOptions();
        gameOptions.initialize();
        gameOptions.loadOptions();
        if (this.optdlg == null) {
            this.optdlg = new GameOptionsDialog(this.frame, gameOptions);
        }
        this.optdlg.update(gameOptions);
        this.optdlg.setVisible(true);
    }

    private void showEditor() {
        BoardEditor boardEditor = new BoardEditor();
        this.launch(boardEditor.getFrame());
        boardEditor.boardNew();
    }

    private void showEditorOpen() {
        BoardEditor boardEditor = new BoardEditor();
        this.launch(boardEditor.getFrame());
        boardEditor.boardLoad();
    }

    private void host() {
        HostDialog hostDialog = new HostDialog(this.frame);
        hostDialog.setVisible(true);
        if (hostDialog.playerName == null || hostDialog.serverPass == null || hostDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = hostDialog.playerName.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("MegaMek.PlayerNameAlert.message"), Messages.getString("MegaMek.PlayerNameAlert.title"), 0);
            return;
        }
        Compute.d6();
        try {
            this.server = new Server(hostDialog.serverPass, hostDialog.port);
        }
        catch (IOException iOException) {
            System.err.println("could not create server socket on port " + hostDialog.port);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not start server at localhost").append(":").append(hostDialog.port).append(" (").append(iOException.getMessage()).append(").");
            JOptionPane.showMessageDialog(this.frame, stringBuffer.toString(), Messages.getString("MegaMek.HostGameAllert.title"), 0);
            return;
        }
        this.client = new Client(hostDialog.playerName, "localhost", hostDialog.port);
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at localhost").append(":").append(hostDialog.port).append(".");
            JOptionPane.showMessageDialog(this.frame, stringBuffer.toString(), Messages.getString("MegaMek.HostGameAllert.title"), 0);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.launch(clientGUI.getFrame());
        this.optdlg = null;
    }

    private void loadGame() {
        JFileChooser jFileChooser = new JFileChooser("savegames");
        jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        jFileChooser.setDialogTitle(Messages.getString("MegaMek.SaveGameDialog.title"));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName() != null && file.getName().endsWith(".sav");
            }

            public String getDescription() {
                return ".sav";
            }
        });
        int n = jFileChooser.showOpenDialog(this.frame);
        if (n != 0 || jFileChooser.getSelectedFile() == null) {
            return;
        }
        HostDialog hostDialog = new HostDialog(this.frame);
        hostDialog.setVisible(true);
        if (hostDialog.playerName == null || hostDialog.serverPass == null || hostDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = hostDialog.playerName.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("MegaMek.PlayerNameAlert1.message"), Messages.getString("MegaMek.PlayerNameAlert1.title"), 0);
            return;
        }
        Compute.d6();
        try {
            this.server = new Server(hostDialog.serverPass, hostDialog.port);
        }
        catch (IOException iOException) {
            System.err.println("could not create server socket on port " + hostDialog.port);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not start server at localhost").append(":").append(hostDialog.port).append(" (").append(iOException.getMessage()).append(").");
            JOptionPane.showMessageDialog(this.frame, stringBuffer.toString(), Messages.getString("MegaMek.HostGameAllert.title"), 0);
            return;
        }
        if (!this.server.loadGame(jFileChooser.getSelectedFile())) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("MegaMek.LoadGameAlert.message"), Messages.getString("MegaMek.LoadGameAlert.title"), 0);
            this.server = null;
            return;
        }
        this.client = new Client(hostDialog.playerName, "localhost", hostDialog.port);
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at localhost").append(":").append(hostDialog.port).append(".");
            JOptionPane.showMessageDialog(this.frame, stringBuffer.toString(), Messages.getString("MegaMek.HostGameAllert.title"), 0);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.optdlg = null;
        this.launch(clientGUI.getFrame());
    }

    private void scenario() {
        Object object;
        Object object2;
        IGame iGame;
        JFileChooser jFileChooser = new JFileChooser("data" + File.separatorChar + "scenarios");
        jFileChooser.setLocation(this.frame.getLocation().x + 150, this.frame.getLocation().y + 100);
        jFileChooser.setDialogTitle(Messages.getString("MegaMek.SelectScenarioDialog.title"));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName() != null && file.getName().endsWith(".mms");
            }

            public String getDescription() {
                return ".mms";
            }
        });
        int n = jFileChooser.showOpenDialog(this.frame);
        if (n != 0 || jFileChooser.getSelectedFile() == null) {
            return;
        }
        ScenarioLoader scenarioLoader = new ScenarioLoader(jFileChooser.getSelectedFile());
        try {
            iGame = scenarioLoader.createGame();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("MegaMek.HostScenarioAllert.message") + exception.getMessage(), Messages.getString("MegaMek.HostScenarioAllert.title"), 0);
            return;
        }
        GameOptionsDialog gameOptionsDialog = new GameOptionsDialog(this.frame, iGame.getOptions());
        gameOptionsDialog.update(iGame.getOptions());
        gameOptionsDialog.setEditable(true);
        gameOptionsDialog.setVisible(true);
        for (IBasicOption object32 : gameOptionsDialog.getOptions()) {
            object2 = iGame.getOptions().getOption(object32.getName());
            object2.setValue(object32.getValue());
        }
        gameOptionsDialog = null;
        Object[] objectArray = new Player[iGame.getPlayersVector().size()];
        iGame.getPlayersVector().copyInto(objectArray);
        ScenarioDialog scenarioDialog = new ScenarioDialog(this.frame, (Player[])objectArray);
        scenarioDialog.setVisible(true);
        if (!scenarioDialog.bSet) {
            return;
        }
        object2 = new HostDialog(this.frame);
        boolean bl = false;
        if (!"".equals(scenarioDialog.localName)) {
            bl = true;
        }
        ((HostDialog)object2).yourNameF.setText(scenarioDialog.localName);
        ((Dialog)object2).setVisible(true);
        if (((HostDialog)object2).playerName == null || ((HostDialog)object2).serverPass == null || ((HostDialog)object2).port == 0) {
            return;
        }
        scenarioDialog.localName = ((HostDialog)object2).playerName;
        boolean bl2 = false;
        char[] cArray = ((HostDialog)object2).playerName.toCharArray();
        for (int iOException = 0; !bl2 && iOException < cArray.length; ++iOException) {
            if (Character.isWhitespace(cArray[iOException])) continue;
            bl2 = true;
        }
        if (!bl2) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("MegaMek.HostScenarioAllert1.message"), Messages.getString("MegaMek.HostScenarioAllert1.title"), 0);
            return;
        }
        Compute.d6();
        try {
            this.server = new Server(((HostDialog)object2).serverPass, ((HostDialog)object2).port);
        }
        catch (IOException clientGUI) {
            System.err.println("could not create server socket on port " + ((HostDialog)object2).port);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not start server at localhost").append(":").append(((HostDialog)object2).port).append(" (").append(clientGUI.getMessage()).append(").");
            JOptionPane.showMessageDialog(this.frame, stringBuffer.toString(), Messages.getString("MegaMek.HostGameAllert.title"), 0);
            return;
        }
        this.server.setGame(iGame);
        scenarioLoader.applyDamage(this.server);
        ClientGUI clientGUI = null;
        if (!"".equals(scenarioDialog.localName)) {
            this.client = new Client(((HostDialog)object2).playerName, "localhost", ((HostDialog)object2).port);
            clientGUI = new ClientGUI(this.client);
            clientGUI.initialize();
            if (!this.client.connect()) {
                StringBuffer i = new StringBuffer();
                i.append("Error: could not connect to server at localhost").append(":").append(((HostDialog)object2).port).append(".");
                JOptionPane.showMessageDialog(this.frame, i.toString(), Messages.getString("MegaMek.HostScenarioAllert.title"), 0);
                this.frame.setVisible(false);
                this.client.die();
            }
        }
        this.optdlg = null;
        this.server.calculatePlayerBVs();
        for (int enumeration = 0; enumeration < objectArray.length; ++enumeration) {
            if (scenarioDialog.playerTypes[enumeration] != 2) continue;
            object = new TestBot(((Player)objectArray[enumeration]).getName(), "localhost", ((HostDialog)object2).port);
            ((BotClient)object).game.addGameListener(new BotGUI((BotClient)object));
            if (!((Client)object).connect()) {
                // empty if block
            }
            ((BotClient)object).retrieveServerInfo();
        }
        if (!bl) {
            Enumeration enumeration = this.server.getGame().getPlayers();
            while (enumeration.hasMoreElements()) {
                object = (Player)enumeration.nextElement();
                if (!((Player)object).getName().equals(scenarioDialog.localName)) continue;
                ((Player)object).setObserver(true);
            }
        }
        this.launch(clientGUI.getFrame());
    }

    private void connect() {
        ConnectDialog connectDialog = new ConnectDialog(this.frame);
        connectDialog.setVisible(true);
        if (connectDialog.playerName == null || connectDialog.serverAddr == null || connectDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = connectDialog.playerName.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("MegaMek.ConnectAllert.message"), Messages.getString("MegaMek.ConnectAllert.title"), 0);
            return;
        }
        this.client = new Client(connectDialog.playerName, connectDialog.serverAddr, connectDialog.port);
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at ").append(connectDialog.serverAddr).append(':').append(connectDialog.port).append('.');
            JOptionPane.showMessageDialog(this.frame, stringBuffer.toString(), Messages.getString("MegaMek.ConnectAllert.title"), 0);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.launch(clientGUI.getFrame());
    }

    private void connectBot() {
        ConnectDialog connectDialog = new ConnectDialog(this.frame);
        connectDialog.setVisible(true);
        if (connectDialog.playerName == null || connectDialog.serverAddr == null || connectDialog.port == 0) {
            return;
        }
        boolean bl = false;
        char[] cArray = connectDialog.playerName.toCharArray();
        for (int i = 0; !bl && i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this.frame, Messages.getString("MegaMek.ConnectGameAllert.message"), Messages.getString("MegaMek.ConnectGameAllert.title"), 0);
            return;
        }
        this.client = new TestBot(connectDialog.playerName, connectDialog.serverAddr, connectDialog.port);
        this.client.game.addGameListener(new BotGUI((BotClient)this.client));
        ClientGUI clientGUI = new ClientGUI(this.client);
        clientGUI.initialize();
        if (!this.client.connect()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Error: could not connect to server at ").append(connectDialog.serverAddr).append(':').append(connectDialog.port).append('.');
            JOptionPane.showMessageDialog(this.frame, stringBuffer.toString(), Messages.getString("MegaMek.ConnectAllert.title"), 0);
            this.frame.setVisible(false);
            this.client.die();
        }
        this.launch(clientGUI.getFrame());
        this.client.retrieveServerInfo();
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.frame.getContentPane().add(jComponent);
    }

    private void showAbout() {
        if (this.about == null) {
            this.about = new CommonAboutDialog(this.frame);
        }
        this.about.setVisible(true);
    }

    private void showHelp() {
        if (this.help == null) {
            this.help = MegaMekGUI.showHelp(this.frame, "readme");
        }
        this.help.setVisible(true);
    }

    private static CommonHelpDialog showHelp(JFrame jFrame, String string) {
        Locale locale = Locale.getDefault();
        File file = new File(string + '-' + locale.getDisplayLanguage(Locale.ENGLISH) + ".txt");
        if (!file.exists()) {
            file = new File(string + ".txt");
        }
        return new CommonHelpDialog(jFrame, file);
    }

    private void showSettings() {
        if (this.setdlg == null) {
            this.setdlg = new CommonSettingsDialog(this.frame);
        }
        this.setdlg.setVisible(true);
    }

    private static void quit() {
        PreferenceManager.getInstance().save();
        System.exit(0);
    }

    private void launch(JFrame jFrame) {
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MegaMekGUI.this.unlaunch();
            }

            public void windowClosed(WindowEvent windowEvent) {
                MegaMekGUI.this.unlaunch();
            }
        });
        this.frame.setVisible(false);
    }

    private void unlaunch() {
        if (this.server != null) {
            this.server.die();
            this.server = null;
        }
        this.frame.setVisible(true);
        this.client = null;
        System.gc();
        System.runFinalization();
    }
}

