/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.ConfirmDialog;
import megamek.client.ui.swing.DoneButtoned;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.MineLayingDialog;
import megamek.client.ui.swing.SingleChoiceDialog;
import megamek.client.ui.swing.StatusBarPhaseDisplay;
import megamek.client.ui.swing.VibrabombSettingDialog;
import megamek.common.BipedMech;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.GameTurn;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.util.Distractable;
import megamek.common.util.DistractableAdapter;

public class MovementDisplay
extends StatusBarPhaseDisplay
implements ActionListener,
DoneButtoned,
KeyListener,
GameListener,
BoardViewListener,
Distractable {
    private DistractableAdapter distracted = new DistractableAdapter();
    private static final int NUM_BUTTON_LAYOUTS = 4;
    public static final String MOVE_WALK = "moveWalk";
    public static final String MOVE_NEXT = "moveNext";
    public static final String MOVE_JUMP = "moveJump";
    public static final String MOVE_BACK_UP = "moveBackUp";
    public static final String MOVE_TURN = "moveTurn";
    public static final String MOVE_GET_UP = "moveGetUp";
    public static final String MOVE_CHARGE = "moveCharge";
    public static final String MOVE_DFA = "moveDFA";
    public static final String MOVE_GO_PRONE = "moveGoProne";
    public static final String MOVE_FLEE = "moveFlee";
    public static final String MOVE_EJECT = "moveEject";
    public static final String MOVE_LOAD = "moveLoad";
    public static final String MOVE_UNLOAD = "moveUnload";
    public static final String MOVE_UNJAM = "moveUnjam";
    public static final String MOVE_CLEAR = "moveClear";
    public static final String MOVE_CANCEL = "moveCancel";
    public static final String MOVE_RAISE_ELEVATION = "moveRaiseElevation";
    public static final String MOVE_LOWER_ELEVATION = "moveLowerElevation";
    public static final String MOVE_SEARCHLIGHT = "moveSearchlight";
    public static final String MOVE_LAY_MINE = "moveLayMine";
    public static final String MOVE_HULL_DOWN = "moveHullDown";
    public static final String MOVE_CLIMB_MODE = "moveClimbMode";
    public static final String MOVE_SWIM = "moveSwim";
    public static final String MOVE_DIG_IN = "moveDigIn";
    public static final String MOVE_FORTIFY = "moveFortify";
    public static final String MOVE_SHAKE_OFF = "moveShakeOff";
    public Client client;
    private ClientGUI clientgui;
    private JPanel panButtons;
    private JButton butWalk;
    private JButton butJump;
    private JButton butBackup;
    private JButton butTurn;
    private JButton butSwim;
    private JButton butUp;
    private JButton butDown;
    private JButton butCharge;
    private JButton butDfa;
    private JButton butRAC;
    private JButton butFlee;
    private JButton butEject;
    private JButton butLoad;
    private JButton butUnload;
    private JButton butSpace;
    private JButton butClear;
    private JButton butNext;
    private JButton butDone;
    private JButton butMore;
    private JButton butRaise;
    private JButton butLower;
    private JButton butSearchlight;
    private JButton butLayMine;
    private JButton butHullDown;
    private JButton butClimbMode;
    private JButton butDigIn;
    private JButton butFortify;
    private JButton butShakeOff;
    private int buttonLayout;
    private ArrayList<JButton> buttonsMech;
    private ArrayList<JButton> buttonsTank;
    private ArrayList<JButton> buttonsVtol;
    private ArrayList<JButton> buttonsInf;
    private int cen = -1;
    private MovePath cmd;
    private int gear;
    private boolean shiftheld;
    private Vector<Entity> loadedUnits = null;
    public static final int GEAR_LAND = 0;
    public static final int GEAR_BACKUP = 1;
    public static final int GEAR_JUMP = 2;
    public static final int GEAR_CHARGE = 3;
    public static final int GEAR_DFA = 4;
    public static final int GEAR_TURN = 5;
    public static final int GEAR_SWIM = 6;

    public MovementDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        this.gear = 0;
        this.shiftheld = false;
        clientGUI.getBoardView().addBoardViewListener(this);
        this.setupStatusBar(Messages.getString("MovementDisplay.waitingForMovementPhase"));
        this.butClear = new JButton(Messages.getString("MovementDisplay.butClear"));
        this.butClear.addActionListener(this);
        this.butClear.setEnabled(false);
        this.butClear.setActionCommand(MOVE_CLEAR);
        this.butClear.addKeyListener(this);
        this.butWalk = new JButton(Messages.getString("MovementDisplay.butWalk"));
        this.butWalk.addActionListener(this);
        this.butWalk.setEnabled(false);
        this.butWalk.setActionCommand(MOVE_WALK);
        this.butWalk.addKeyListener(this);
        this.butJump = new JButton(Messages.getString("MovementDisplay.butJump"));
        this.butJump.addActionListener(this);
        this.butJump.setEnabled(false);
        this.butJump.setActionCommand(MOVE_JUMP);
        this.butJump.addKeyListener(this);
        this.butSwim = new JButton(Messages.getString("MovementDisplay.butSwim"));
        this.butSwim.addActionListener(this);
        this.butSwim.setEnabled(false);
        this.butSwim.setActionCommand(MOVE_SWIM);
        this.butSwim.addKeyListener(this);
        this.butBackup = new JButton(Messages.getString("MovementDisplay.butBackup"));
        this.butBackup.addActionListener(this);
        this.butBackup.setEnabled(false);
        this.butBackup.setActionCommand(MOVE_BACK_UP);
        this.butBackup.addKeyListener(this);
        this.butTurn = new JButton(Messages.getString("MovementDisplay.butTurn"));
        this.butTurn.addActionListener(this);
        this.butTurn.setEnabled(false);
        this.butTurn.setActionCommand(MOVE_TURN);
        this.butTurn.addKeyListener(this);
        this.butUp = new JButton(Messages.getString("MovementDisplay.butUp"));
        this.butUp.addActionListener(this);
        this.butUp.setEnabled(false);
        this.butUp.setActionCommand(MOVE_GET_UP);
        this.butUp.addKeyListener(this);
        this.butDown = new JButton(Messages.getString("MovementDisplay.butDown"));
        this.butDown.addActionListener(this);
        this.butDown.setEnabled(false);
        this.butDown.setActionCommand(MOVE_GO_PRONE);
        this.butDown.addKeyListener(this);
        this.butCharge = new JButton(Messages.getString("MovementDisplay.butCharge"));
        this.butCharge.addActionListener(this);
        this.butCharge.setEnabled(false);
        this.butCharge.setActionCommand(MOVE_CHARGE);
        this.butCharge.addKeyListener(this);
        this.butDfa = new JButton(Messages.getString("MovementDisplay.butDfa"));
        this.butDfa.addActionListener(this);
        this.butDfa.setEnabled(false);
        this.butDfa.setActionCommand(MOVE_DFA);
        this.butDfa.addKeyListener(this);
        this.butFlee = new JButton(Messages.getString("MovementDisplay.butFlee"));
        this.butFlee.addActionListener(this);
        this.butFlee.setEnabled(false);
        this.butFlee.setActionCommand(MOVE_FLEE);
        this.butFlee.addKeyListener(this);
        this.butEject = new JButton(Messages.getString("MovementDisplay.butEject"));
        this.butEject.addActionListener(this);
        this.butEject.setEnabled(false);
        this.butEject.setActionCommand(MOVE_EJECT);
        this.butEject.addKeyListener(this);
        this.butRAC = new JButton(Messages.getString("MovementDisplay.butRAC"));
        this.butRAC.addActionListener(this);
        this.butRAC.setEnabled(false);
        this.butRAC.setActionCommand(MOVE_UNJAM);
        this.butRAC.addKeyListener(this);
        this.butSearchlight = new JButton(Messages.getString("MovementDisplay.butSearchlightOn"));
        this.butSearchlight.addActionListener(this);
        this.butSearchlight.setEnabled(false);
        this.butSearchlight.setActionCommand(MOVE_SEARCHLIGHT);
        this.butSearchlight.addKeyListener(this);
        this.butMore = new JButton(Messages.getString("MovementDisplay.butMore"));
        this.butMore.addActionListener(this);
        this.butMore.setEnabled(false);
        this.butMore.addKeyListener(this);
        this.butNext = new JButton(Messages.getString("MovementDisplay.butNext"));
        this.butNext.addActionListener(this);
        this.butNext.setEnabled(false);
        this.butNext.setActionCommand(MOVE_NEXT);
        this.butNext.addKeyListener(this);
        this.butDone = new JButton(Messages.getString("MovementDisplay.butDone"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.butDone.addKeyListener(this);
        this.butLoad = new JButton(Messages.getString("MovementDisplay.butLoad"));
        this.butLoad.addActionListener(this);
        this.butLoad.setEnabled(false);
        this.butLoad.setActionCommand(MOVE_LOAD);
        this.butLoad.addKeyListener(this);
        this.butUnload = new JButton(Messages.getString("MovementDisplay.butUnload"));
        this.butUnload.addActionListener(this);
        this.butUnload.setEnabled(false);
        this.butUnload.setActionCommand(MOVE_UNLOAD);
        this.butUnload.addKeyListener(this);
        this.butRaise = new JButton(Messages.getString("MovementDisplay.butRaise"));
        this.butRaise.addActionListener(this);
        this.butRaise.setEnabled(false);
        this.butRaise.setActionCommand(MOVE_RAISE_ELEVATION);
        this.butRaise.addKeyListener(this);
        this.butLower = new JButton(Messages.getString("MovementDisplay.butLower"));
        this.butLower.addActionListener(this);
        this.butLower.setEnabled(false);
        this.butLower.setActionCommand(MOVE_LOWER_ELEVATION);
        this.butLower.addKeyListener(this);
        this.butLayMine = new JButton(Messages.getString("MovementDisplay.butLayMine"));
        this.butLayMine.addActionListener(this);
        this.butLayMine.setEnabled(false);
        this.butLayMine.setActionCommand(MOVE_LAY_MINE);
        this.butLayMine.addKeyListener(this);
        this.butHullDown = new JButton(Messages.getString("MovementDisplay.butHullDown"));
        this.butHullDown.addActionListener(this);
        this.butHullDown.setEnabled(false);
        this.butHullDown.setActionCommand(MOVE_HULL_DOWN);
        this.butHullDown.addKeyListener(this);
        this.butClimbMode = new JButton(Messages.getString("MovementDisplay.butClimbMode"));
        this.butClimbMode.addActionListener(this);
        this.butClimbMode.setEnabled(false);
        this.butClimbMode.setActionCommand(MOVE_CLIMB_MODE);
        this.butClimbMode.addKeyListener(this);
        this.butDigIn = new JButton(Messages.getString("MovementDisplay.butDigIn"));
        this.butDigIn.addActionListener(this);
        this.butDigIn.setEnabled(false);
        this.butDigIn.setActionCommand(MOVE_DIG_IN);
        this.butDigIn.addKeyListener(this);
        this.butFortify = new JButton(Messages.getString("MovementDisplay.butFortify"));
        this.butFortify.addActionListener(this);
        this.butFortify.setEnabled(false);
        this.butFortify.setActionCommand(MOVE_FORTIFY);
        this.butFortify.addKeyListener(this);
        this.butShakeOff = new JButton(Messages.getString("MovementDisplay.butShakeOff"));
        this.butShakeOff.addActionListener(this);
        this.butShakeOff.setEnabled(false);
        this.butShakeOff.setActionCommand(MOVE_SHAKE_OFF);
        this.butShakeOff.addKeyListener(this);
        this.butSpace = new JButton(".");
        this.butSpace.setEnabled(false);
        this.butSpace.addKeyListener(this);
        this.buttonsMech = new ArrayList(22);
        this.buttonsMech.add(this.butWalk);
        this.buttonsMech.add(this.butJump);
        this.buttonsMech.add(this.butBackup);
        this.buttonsMech.add(this.butTurn);
        this.buttonsMech.add(this.butUp);
        this.buttonsMech.add(this.butDown);
        this.buttonsMech.add(this.butCharge);
        this.buttonsMech.add(this.butDfa);
        this.buttonsMech.add(this.butLoad);
        this.buttonsMech.add(this.butUnload);
        this.buttonsMech.add(this.butClimbMode);
        this.buttonsMech.add(this.butSearchlight);
        this.buttonsMech.add(this.butHullDown);
        this.buttonsMech.add(this.butSwim);
        this.buttonsMech.add(this.butEject);
        this.buttonsMech.add(this.butFlee);
        this.buttonsMech.add(this.butRAC);
        this.buttonsMech.add(this.butDigIn);
        this.buttonsMech.add(this.butFortify);
        this.buttonsMech.add(this.butLayMine);
        this.buttonsMech.add(this.butLower);
        this.buttonsMech.add(this.butRaise);
        this.buttonsMech.add(this.butShakeOff);
        this.buttonsTank = new ArrayList(22);
        this.buttonsTank.add(this.butWalk);
        this.buttonsTank.add(this.butBackup);
        this.buttonsTank.add(this.butTurn);
        this.buttonsTank.add(this.butLoad);
        this.buttonsTank.add(this.butUnload);
        this.buttonsTank.add(this.butCharge);
        this.buttonsTank.add(this.butClimbMode);
        this.buttonsTank.add(this.butSearchlight);
        this.buttonsTank.add(this.butHullDown);
        this.buttonsTank.add(this.butSwim);
        this.buttonsTank.add(this.butEject);
        this.buttonsTank.add(this.butFlee);
        this.buttonsTank.add(this.butRAC);
        this.buttonsTank.add(this.butLayMine);
        this.buttonsTank.add(this.butShakeOff);
        this.buttonsTank.add(this.butDfa);
        this.buttonsTank.add(this.butUp);
        this.buttonsTank.add(this.butDown);
        this.buttonsTank.add(this.butJump);
        this.buttonsTank.add(this.butDigIn);
        this.buttonsTank.add(this.butFortify);
        this.buttonsTank.add(this.butLower);
        this.buttonsTank.add(this.butRaise);
        this.buttonsVtol = new ArrayList(22);
        this.buttonsVtol.add(this.butWalk);
        this.buttonsVtol.add(this.butBackup);
        this.buttonsVtol.add(this.butLower);
        this.buttonsVtol.add(this.butRaise);
        this.buttonsVtol.add(this.butTurn);
        this.buttonsVtol.add(this.butLoad);
        this.buttonsVtol.add(this.butUnload);
        this.buttonsVtol.add(this.butSearchlight);
        this.buttonsVtol.add(this.butEject);
        this.buttonsVtol.add(this.butFlee);
        this.buttonsVtol.add(this.butRAC);
        this.buttonsVtol.add(this.butShakeOff);
        this.buttonsVtol.add(this.butHullDown);
        this.buttonsVtol.add(this.butLayMine);
        this.buttonsVtol.add(this.butSwim);
        this.buttonsVtol.add(this.butClimbMode);
        this.buttonsVtol.add(this.butCharge);
        this.buttonsVtol.add(this.butDfa);
        this.buttonsVtol.add(this.butUp);
        this.buttonsVtol.add(this.butDown);
        this.buttonsVtol.add(this.butJump);
        this.buttonsVtol.add(this.butDigIn);
        this.buttonsVtol.add(this.butFortify);
        this.buttonsInf = new ArrayList(22);
        this.buttonsInf.add(this.butWalk);
        this.buttonsInf.add(this.butJump);
        this.buttonsInf.add(this.butLower);
        this.buttonsInf.add(this.butRaise);
        this.buttonsInf.add(this.butTurn);
        this.buttonsInf.add(this.butClimbMode);
        this.buttonsInf.add(this.butSearchlight);
        this.buttonsInf.add(this.butEject);
        this.buttonsInf.add(this.butFlee);
        this.buttonsInf.add(this.butRAC);
        this.buttonsInf.add(this.butLayMine);
        this.buttonsInf.add(this.butSwim);
        this.buttonsInf.add(this.butDigIn);
        this.buttonsInf.add(this.butFortify);
        this.buttonsInf.add(this.butLoad);
        this.buttonsInf.add(this.butUnload);
        this.buttonsInf.add(this.butBackup);
        this.buttonsInf.add(this.butHullDown);
        this.buttonsInf.add(this.butCharge);
        this.buttonsInf.add(this.butDfa);
        this.buttonsInf.add(this.butUp);
        this.buttonsInf.add(this.butDown);
        this.buttonsInf.add(this.butShakeOff);
        this.panButtons = new JPanel();
        this.buttonLayout = 0;
        this.setupButtonPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent.addKeyListener(this);
    }

    private void setupButtonPanel() {
        int n;
        this.panButtons.removeAll();
        this.panButtons.setLayout(new GridLayout(0, 8));
        ArrayList<JButton> arrayList = this.buttonsMech;
        Entity entity = this.ce();
        if (entity != null) {
            if (entity instanceof Infantry) {
                arrayList = this.buttonsInf;
            } else if (entity instanceof VTOL) {
                arrayList = this.buttonsVtol;
            } else if (entity instanceof Tank) {
                arrayList = this.buttonsTank;
            }
        }
        boolean bl = false;
        while (!bl && this.buttonLayout != 0) {
            for (n = this.buttonLayout * 6; n < (this.buttonLayout + 1) * 6 && n < arrayList.size(); ++n) {
                if (!arrayList.get(n).isEnabled()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            ++this.buttonLayout;
            if (this.buttonLayout * 6 < arrayList.size()) continue;
            this.buttonLayout = 0;
        }
        this.panButtons.add(this.butNext);
        for (n = this.buttonLayout * 6; n < (this.buttonLayout + 1) * 6 && n < arrayList.size(); ++n) {
            this.panButtons.add(arrayList.get(n));
        }
        this.panButtons.add(this.butMore);
        this.validate();
    }

    public synchronized void selectEntity(int n) {
        Entity entity = this.client.game.getEntity(n);
        if (entity == null) {
            System.err.println("MovementDisplay: tried to select non-existant entity: " + n);
            return;
        }
        this.cen = n;
        this.clientgui.setSelectedEntityNum(n);
        this.clearAllMoves();
        this.updateButtons();
        this.clientgui.getMenuBar().setEntity(entity);
        this.clientgui.getBoardView().highlight(entity.getPosition());
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.mechD.displayEntity(entity);
        this.clientgui.mechD.showPanel("movement");
        if (!this.clientgui.bv.isMovingUnits()) {
            this.clientgui.bv.centerOnHex(entity.getPosition());
        }
    }

    private void updateButtons() {
        Entity entity = this.ce();
        boolean bl = entity instanceof Mech;
        boolean bl2 = entity instanceof Infantry;
        boolean bl3 = entity instanceof Protomech;
        this.setWalkEnabled(!entity.isImmobile() && entity.getWalkMP() > 0 && !entity.isStuck());
        this.setJumpEnabled(!entity.isImmobile() && entity.getJumpMP() > 0 && !entity.isStuck());
        this.setSwimEnabled(!entity.isImmobile() && entity.hasUMU() && this.client.game.getBoard().getHex(entity.getPosition()).containsTerrain(4));
        this.setBackUpEnabled(this.butWalk.isEnabled());
        this.setChargeEnabled(entity.canCharge());
        this.setDFAEnabled(entity.canDFA());
        if (bl2 || bl3) {
            if (this.client.game.containsMinefield(entity.getPosition())) {
                this.setClearEnabled(true);
            } else {
                this.setClearEnabled(false);
            }
        } else {
            this.setClearEnabled(false);
        }
        if (entity.getMovementMode() == 8 || entity.getMovementMode() == 7 || entity.getMovementMode() == 9 || entity.getMovementMode() == 18 || entity.getMovementMode() == 6 || entity.getMovementMode() == 13 || entity.getMovementMode() == 14) {
            this.butClimbMode.setEnabled(false);
        } else {
            this.butClimbMode.setEnabled(true);
        }
        if (entity instanceof Infantry) {
            this.butDigIn.setEnabled(true);
            this.butFortify.setEnabled(true);
        } else {
            this.butDigIn.setEnabled(false);
            this.butFortify.setEnabled(false);
        }
        this.setTurnEnabled(!entity.isImmobile() && !entity.isStuck() && (entity.getWalkMP() > 0 || entity.getJumpMP() > 0));
        if (entity.isProne()) {
            this.setGetUpEnabled(!entity.isImmobile() && !entity.isStuck());
            this.setGoProneEnabled(false);
            this.setHullDownEnabled(false);
        } else if (entity.isHullDown()) {
            this.setGetUpEnabled(!entity.isImmobile() && !entity.isStuck());
            this.setGoProneEnabled(!entity.isImmobile() && bl && !entity.isStuck());
            this.setHullDownEnabled(false);
        } else {
            this.setGetUpEnabled(false);
            this.setGoProneEnabled(!entity.isImmobile() && bl && !entity.isStuck());
            this.setHullDownEnabled(entity.canGoHullDown());
        }
        this.updateProneButtons();
        this.updateRACButton();
        this.updateSearchlightButton();
        this.updateLoadButtons();
        this.updateElevationButtons();
        if (bl2 && entity.hasWorkingMisc(0x100000L, 1)) {
            this.butFortify.setEnabled(true);
        } else {
            this.butFortify.setEnabled(false);
        }
        if (bl2 && this.client.game.getOptions().booleanOption("maxtech_dig_in")) {
            this.butDigIn.setEnabled(true);
        } else {
            this.butDigIn.setEnabled(false);
        }
        this.butShakeOff.setEnabled(entity instanceof Tank && entity.getSwarmAttackerId() != -1);
        this.setLayMineEnabled(entity.canLayMine());
        this.setFleeEnabled(entity.canFlee());
        if (this.client.game.getOptions().booleanOption("vehicles_can_eject")) {
            this.setEjectEnabled(!bl2 && (!bl || ((Mech)entity).getCockpitType() != 1) && entity.isActive());
        } else {
            this.setEjectEnabled(bl && ((Mech)entity).getCockpitType() != 1 && entity.isActive());
        }
        this.setupButtonPanel();
    }

    private void beginMyTurn() {
        this.setStatusBarText(Messages.getString("MovementDisplay.its_your_turn"));
        this.selectEntity(this.client.getFirstEntityNum());
        this.butDone.setText(Messages.getString("MovementDisplay.Done"));
        this.butDone.setEnabled(true);
        this.setNextEnabled(true);
        this.butMore.setEnabled(true);
        if (!this.clientgui.bv.isMovingUnits()) {
            this.clientgui.setDisplayVisible(true);
        }
    }

    private synchronized void endMyTurn() {
        Entity entity = this.ce();
        this.disableButtons();
        Entity entity2 = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (8 == this.client.game.getPhase() && null != entity2 && null != entity && entity2.getOwnerId() != entity.getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.clearMovementData();
    }

    private void disableButtons() {
        this.setWalkEnabled(false);
        this.setJumpEnabled(false);
        this.setBackUpEnabled(false);
        this.setTurnEnabled(false);
        this.setFleeEnabled(false);
        this.setEjectEnabled(false);
        this.setUnjamEnabled(false);
        this.setSearchlightEnabled(false, false);
        this.setGetUpEnabled(false);
        this.setGoProneEnabled(false);
        this.setChargeEnabled(false);
        this.setDFAEnabled(false);
        this.setNextEnabled(false);
        this.butMore.setEnabled(false);
        this.butDone.setEnabled(false);
        this.setLoadEnabled(false);
        this.setUnloadEnabled(false);
        this.setClearEnabled(false);
        this.setHullDownEnabled(false);
        this.setSwimEnabled(false);
    }

    private void clearAllMoves() {
        Entity entity = this.ce();
        if (entity.getMovementMode() == 13) {
            entity.setMovementMode(1);
        } else if (entity.getMovementMode() == 14) {
            entity.setMovementMode(2);
        }
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        this.cmd = new MovePath(this.client.game, entity);
        this.gear = 0;
        this.clientgui.bv.clearMovementData();
        this.butDone.setText(Messages.getString("MovementDisplay.Done"));
        this.updateProneButtons();
        this.updateRACButton();
        this.updateSearchlightButton();
        this.updateElevationButtons();
        this.loadedUnits = entity != null ? entity.getLoadedUnits() : new Vector();
        this.updateLoadButtons();
        this.updateElevationButtons();
    }

    private void removeLastStep() {
        this.cmd.removeLastStep();
        if (this.cmd.length() == 0) {
            this.clearAllMoves();
        } else {
            this.clientgui.bv.drawMovementData(this.cmd);
            MovePath movePath = (MovePath)this.cmd.clone();
            movePath.clipToPossible();
            if (movePath.length() == 0) {
                this.butDone.setText(Messages.getString("MovementDisplay.Done"));
            }
        }
    }

    private synchronized void moveTo(MovePath movePath) {
        Object object;
        Object object2;
        movePath.clipToPossible();
        if (movePath.length() == 0 && GUIPreferences.getInstance().getNagForNoAction()) {
            object2 = Messages.getString("MovementDisplay.ConfirmNoMoveDlg.title");
            ConfirmDialog confirmDialog = this.clientgui.doYesNoBotherDialog((String)object2, (String)(object = Messages.getString("MovementDisplay.ConfirmNoMoveDlg.message")));
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForNoAction(false);
            }
            if (!confirmDialog.getAnswer()) {
                return;
            }
        }
        if (movePath != null) {
            if (movePath.hasActiveMASC() && GUIPreferences.getInstance().getNagForMASC()) {
                object2 = (Mech)this.ce();
                object = new ConfirmDialog(this.clientgui.frame, Messages.getString("MovementDisplay.areYouSure"), Messages.getString("MovementDisplay.ConfirmMoveRoll", new Object[]{new Integer(((Mech)object2).getMASCTarget())}), true);
                ((Dialog)object).setVisible(true);
                if (((ConfirmDialog)object).getAnswer()) {
                    if (!((ConfirmDialog)object).getShowAgain()) {
                        GUIPreferences.getInstance().setNagForMASC(false);
                    }
                } else {
                    return;
                }
            }
            if (((String)(object2 = this.doPSRCheck(movePath))).length() > 0 && GUIPreferences.getInstance().getNagForPSR()) {
                object = new ConfirmDialog(this.clientgui.frame, Messages.getString("MovementDisplay.areYouSure"), Messages.getString("MovementDisplay.ConfirmPilotingRoll") + (String)object2, true);
                ((Dialog)object).setVisible(true);
                if (((ConfirmDialog)object).getAnswer()) {
                    if (!((ConfirmDialog)object).getShowAgain()) {
                        GUIPreferences.getInstance().setNagForPSR(false);
                    }
                } else {
                    return;
                }
            }
        }
        this.disableButtons();
        this.clientgui.bv.clearMovementData();
        if (this.ce().hasUMU()) {
            this.client.sendUpdateEntity(this.ce());
        }
        this.client.moveEntity(this.cen, movePath);
    }

    private String addNag(PilotingRollData pilotingRollData) {
        return Messages.getString("MovementDisplay.addNag", new Object[]{pilotingRollData.getValueAsString(), pilotingRollData.getDesc()});
    }

    private String doPSRCheck(MovePath movePath) {
        PilotingRollData pilotingRollData;
        StringBuffer stringBuffer = new StringBuffer();
        Entity entity = this.ce();
        Coords coords = entity.getPosition();
        Coords coords2 = entity.getPosition();
        int n = entity.getFacing();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        IHex iHex = null;
        boolean bl = entity instanceof Infantry;
        movePath.clipToPossible();
        n4 = movePath.getLastStepMovementType();
        boolean bl2 = true;
        MoveStep moveStep = null;
        Object object = movePath.getSteps();
        while (object.hasMoreElements()) {
            int n6;
            int n7;
            MoveStep moveStep2 = (MoveStep)object.nextElement();
            boolean bl3 = moveStep2.isPavementStep();
            if (moveStep2.getMovementType() == -1) break;
            pilotingRollData = entity.checkGetUp(moveStep2);
            if (pilotingRollData.getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            n3 = moveStep2.getMovementType();
            n2 = moveStep2.getDistance();
            coords2 = moveStep2.getPosition();
            n = moveStep2.getFacing();
            IHex iHex2 = this.client.game.getBoard().getHex(coords2);
            pilotingRollData = entity.checkSkid(n3, iHex, n4, moveStep, n5, n, coords, coords2, bl, n2);
            if (pilotingRollData.getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            if ((pilotingRollData = entity.checkRubbleMove(moveStep2, iHex2, coords, coords2)).getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            if (iHex2.containsTerrain(20) && iHex2.containsTerrain(4) && !coords2.equals(coords) && moveStep2.getElevation() == 0 && n3 != 3) {
                stringBuffer.append(Messages.getString("MovementDisplay.IceMoving"));
            }
            if ((pilotingRollData = entity.checkWaterMove(moveStep2, iHex2, coords, coords2, bl3)).getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            if (iHex2.containsTerrain(7) && !(entity instanceof Mech) && moveStep2.getElevation() <= 1 && n3 != 3 && !coords2.equals(coords)) {
                stringBuffer.append(Messages.getString("MovementDisplay.FireMoving", new Object[]{new Integer(8)}));
            }
            if ((n7 = iHex2.terrainLevel(24)) == 1 && moveStep2.getElevation() == 0 && n3 != 3 && !coords2.equals(coords)) {
                stringBuffer.append(Messages.getString("MovementDisplay.MagmaCrustMoving"));
            } else if (n7 == 2 && entity.getElevation() == 0 && n3 != 3 && entity.getMovementMode() != 5 && !coords2.equals(coords)) {
                stringBuffer.append(Messages.getString("MovementDisplay.MagmaLiquidMoving"));
            }
            if ((entity instanceof VTOL || entity.getMovementMode() == 5 || entity.getMovementMode() == 15) && (pilotingRollData = entity.checkSideSlip(n3, iHex, n4, moveStep, n5, n, coords, coords2, n2)).getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            if ((pilotingRollData = entity.checkSwampMove(moveStep2, iHex2, coords, coords2, bl3)).getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            if (!object.hasMoreElements() && !bl2) {
                if (entity instanceof Mech || entity instanceof VTOL) {
                    if (moveStep2.getMovementType() == 1 || moveStep2.getMovementType() == 4 || moveStep2.getMovementType() == 2 || moveStep2.getMovementType() == 5) {
                        if (moveStep2.getMpUsed() > entity.getRunMP(false) && (pilotingRollData = entity.checkMovedTooFast(moveStep2)).getValue() != -2147483647) {
                            stringBuffer.append(this.addNag(pilotingRollData));
                        }
                    } else if (moveStep2.getMovementType() == 3 && moveStep2.getMpUsed() > entity.getOriginalJumpMP() && (pilotingRollData = entity.checkMovedTooFast(moveStep2)).getValue() != -2147483647) {
                        stringBuffer.append(this.addNag(pilotingRollData));
                    }
                } else if (entity instanceof Tank && (moveStep2.getMovementType() == 1 || moveStep2.getMovementType() == 4 || moveStep2.getMovementType() == 2 || moveStep2.getMovementType() == 5)) {
                    if (moveStep2.getMpUsed() > entity.getRunMP(false) && !moveStep2.isOnlyPavement()) {
                        pilotingRollData = entity.checkMovedTooFast(moveStep2);
                        if (pilotingRollData.getValue() != -2147483647) {
                            stringBuffer.append(this.addNag(pilotingRollData));
                        }
                    } else if (moveStep2.getMpUsed() > entity.getRunMP(false) + 1 && (pilotingRollData = entity.checkMovedTooFast(moveStep2)).getValue() != -2147483647) {
                        stringBuffer.append(this.addNag(pilotingRollData));
                    }
                }
            }
            if ((n6 = entity.checkMovementInBuilding(moveStep2, moveStep, coords2, coords)) > 0) {
                Building building = null;
                if ((n6 & 1) == 1) {
                    building = this.client.game.getBoard().getBuildingAt(coords);
                }
                Building building2 = null;
                if ((n6 & 2) == 2) {
                    building2 = this.client.game.getBoard().getBuildingAt(coords2);
                }
                if (building != null && building2 != null && !building.equals(building2)) {
                    pilotingRollData = entity.rollMovementInBuilding(building, n2, "exiting");
                    stringBuffer.append(this.addNag(pilotingRollData));
                    pilotingRollData = entity.rollMovementInBuilding(building2, n2, "entering");
                    stringBuffer.append(this.addNag(pilotingRollData));
                } else {
                    Building building3 = building2 == null ? building : building2;
                    if (building3 != null) {
                        pilotingRollData = entity.rollMovementInBuilding(building3, n2, "");
                        stringBuffer.append(this.addNag(pilotingRollData));
                    }
                }
            }
            if (moveStep2.getType() == 6 && (pilotingRollData = entity.checkDislodgeSwarmers(moveStep2)).getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            coords = new Coords(coords2);
            moveStep = moveStep2;
            if (!iHex2.equals(iHex)) {
                n5 = n;
            }
            iHex = iHex2;
            bl2 = false;
        }
        if ((pilotingRollData = entity.checkRunningWithDamage(n4)).getValue() != -2147483647) {
            stringBuffer.append(this.addNag(pilotingRollData));
        }
        if (n4 == 3 && !entity.isMakingDfa()) {
            pilotingRollData = entity.checkLandingWithDamage();
            if (pilotingRollData.getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
            object = this.client.game.getBoard().getHex(coords2);
            int n8 = object.terrainLevel(4);
            if (object.containsTerrain(20) && n8 > 0) {
                stringBuffer.append(Messages.getString("MovementDisplay.IceLanding"));
            }
            if ((pilotingRollData = entity.checkWaterMove(n8)).getValue() != -2147483647) {
                stringBuffer.append(this.addNag(pilotingRollData));
            }
        }
        return stringBuffer.toString();
    }

    private synchronized Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    private void currentMove(Coords coords) {
        if (this.shiftheld || this.gear == 5) {
            this.cmd.rotatePathfinder(this.cmd.getFinalCoords().direction(coords));
        } else if (this.gear == 0 || this.gear == 2) {
            this.cmd.findPathTo(coords, 1);
        } else if (this.gear == 1) {
            this.cmd.findPathTo(coords, 2);
        } else if (this.gear == 3) {
            this.cmd.findPathTo(coords, 8);
        } else if (this.gear == 4) {
            this.cmd.findPathTo(coords, 9);
        } else if (this.gear == 6) {
            this.cmd.findPathTo(coords, 27);
        }
    }

    public synchronized void hexMoused(BoardViewEvent boardViewEvent) {
        Entity entity = this.ce();
        if (this.isIgnoringEvents()) {
            return;
        }
        if (!this.client.isMyTurn() || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0 || (boardViewEvent.getModifiers() & 8) != 0) {
            return;
        }
        if (this.shiftheld != ((boardViewEvent.getModifiers() & 1) != 0)) {
            boolean bl = this.shiftheld = (boardViewEvent.getModifiers() & 1) != 0;
        }
        if (boardViewEvent.getType() == 2) {
            if (!boardViewEvent.getCoords().equals(this.clientgui.getBoardView().getLastCursor()) || this.shiftheld || this.gear == 5) {
                this.clientgui.getBoardView().cursor(boardViewEvent.getCoords());
                if (entity != null) {
                    this.currentMove(boardViewEvent.getCoords());
                    this.clientgui.bv.drawMovementData(this.cmd);
                }
            }
        } else if (boardViewEvent.getType() == 0) {
            Coords coords = boardViewEvent.getCoords();
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.getBoardView().select(boardViewEvent.getCoords());
            if (this.shiftheld || this.gear == 5) {
                this.butDone.setText(Messages.getString("MovementDisplay.Move"));
                MovePath movePath = (MovePath)this.cmd.clone();
                movePath.clipToPossible();
                if (movePath.length() == 0) {
                    this.butDone.setText(Messages.getString("MovementDisplay.Done"));
                }
                return;
            }
            if (this.gear == 3) {
                Targetable targetable = this.chooseTarget(boardViewEvent.getCoords());
                if (targetable == null || targetable.equals(entity)) {
                    this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantCharge"), Messages.getString("MovementDisplay.NoTarget"));
                    this.clearAllMoves();
                    return;
                }
                ToHitData toHitData = new ChargeAttackAction(this.cen, targetable.getTargetType(), targetable.getTargetId(), targetable.getPosition()).toHit(this.client.game, this.cmd);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    int n = 0;
                    if (targetable.getTargetType() == 0) {
                        Entity entity2 = (Entity)targetable;
                        n = ChargeAttackAction.getDamageTakenBy(entity, entity2, this.client.game.getOptions().booleanOption("maxtech_charge_damage"), this.cmd.getHexesMoved());
                    } else if (targetable.getTargetType() == 15 || targetable.getTargetType() == 3) {
                        Building building = this.client.game.getBoard().getBuildingAt(coords);
                        n = ChargeAttackAction.getDamageTakenBy(entity, building);
                    }
                    if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.ChargeDialog.title", new Object[]{targetable.getDisplayName()}), Messages.getString("MovementDisplay.ChargeDialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), new Integer(ChargeAttackAction.getDamageFor(entity, this.cmd.getHexesMoved())), toHitData.getTableDesc(), new Integer(n)}))) {
                        this.cmd.getLastStep().setTarget(targetable);
                        this.moveTo(this.cmd);
                    } else {
                        this.clearAllMoves();
                    }
                    return;
                }
                this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantCharge"), toHitData.getDesc());
                this.clearAllMoves();
                return;
            }
            if (this.gear == 4) {
                Targetable targetable = this.chooseTarget(boardViewEvent.getCoords());
                if (targetable == null || targetable.equals(entity)) {
                    this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantDFA"), Messages.getString("MovementDisplay.NoTarget"));
                    this.clearAllMoves();
                    return;
                }
                ToHitData toHitData = DfaAttackAction.toHit(this.client.game, this.cen, targetable, this.cmd);
                if (toHitData.getValue() != Integer.MAX_VALUE) {
                    if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.DFADialog.title", new Object[]{targetable.getDisplayName()}), Messages.getString("MovementDisplay.DFADialog.message", new Object[]{toHitData.getValueAsString(), new Double(Compute.oddsAbove(toHitData.getValue())), toHitData.getDesc(), new Integer(DfaAttackAction.getDamageFor(entity)), toHitData.getTableDesc(), new Integer(DfaAttackAction.getDamageTakenBy(entity))}))) {
                        this.cmd.getLastStep().setTarget(targetable);
                        this.moveTo(this.cmd);
                    } else {
                        this.clearAllMoves();
                    }
                    return;
                }
                this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantDFA"), toHitData.getDesc());
                this.clearAllMoves();
                return;
            }
            this.butDone.setText(Messages.getString("MovementDisplay.Move"));
            this.updateProneButtons();
            this.updateRACButton();
            this.updateSearchlightButton();
            this.updateLoadButtons();
            this.updateElevationButtons();
        }
    }

    private synchronized void updateProneButtons() {
        Mech mech;
        Entity entity = this.ce();
        if (entity != null && !entity.isImmobile()) {
            this.setGetUpEnabled(this.cmd.getFinalProne() || this.cmd.getFinalHullDown());
            this.setGoProneEnabled(!this.butUp.isEnabled() && entity instanceof Mech);
            this.setHullDownEnabled(!this.butUp.isEnabled() && entity.canGoHullDown());
        } else {
            this.setGetUpEnabled(false);
            this.setGoProneEnabled(false);
            this.setHullDownEnabled(false);
        }
        if (entity instanceof Mech && (mech = (Mech)entity).cannotStandUp()) {
            this.setGetUpEnabled(false);
        }
    }

    private void updateRACButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        this.setUnjamEnabled(entity.canUnjamRAC() && (this.gear == 0 || this.gear == 5 || this.gear == 1) && this.cmd.getMpUsed() <= entity.getWalkMP());
    }

    private void updateSearchlightButton() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        this.setSearchlightEnabled(entity.hasSpotlight() && !this.cmd.contains(22), this.ce().isUsingSpotlight());
    }

    private synchronized void updateElevationButtons() {
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        this.setRaiseEnabled(entity.canGoUp(this.cmd.getFinalElevation(), this.cmd.getFinalCoords()));
        this.setLowerEnabled(entity.canGoDown(this.cmd.getFinalElevation(), this.cmd.getFinalCoords()));
    }

    private synchronized void updateLoadButtons() {
        Object object;
        Entity entity = this.ce();
        if (null == entity) {
            return;
        }
        boolean bl = this.gear == 0 || this.gear == 5 || this.gear == 1;
        int n = this.cmd.getFinalElevation();
        IHex iHex = entity.getGame().getBoard().getHex(this.cmd.getFinalCoords());
        boolean bl2 = false;
        Object object2 = this.loadedUnits.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (!((Entity)object).isElevationValid(n, iHex) && ((Entity)object).getJumpMP() <= 0) continue;
            bl2 = true;
            break;
        }
        if (!bl || this.loadedUnits.size() == 0 || this.cen == -1 || !bl2) {
            this.setUnloadEnabled(false);
        } else {
            this.setUnloadEnabled(true);
        }
        if (this.cmd.length() > 0 || this.cen == -1) {
            this.setLoadEnabled(false);
        } else {
            object2 = null;
            object = this.client.game.getEntities(entity.getPosition());
            boolean bl3 = false;
            while (object.hasMoreElements()) {
                object2 = (Entity)object.nextElement();
                if (entity.getOwner().equals(((Entity)object2).getOwner()) && !entity.equals(object2)) {
                    if (entity.getWalkMP() <= 0 || !entity.canLoad((Entity)object2) || !((Entity)object2).isLoadableThisTurn()) break;
                    this.setLoadEnabled(true);
                    bl3 = true;
                    break;
                }
                object2 = null;
            }
            if (!bl3) {
                this.setLoadEnabled(false);
            }
        }
    }

    private Entity getUnloadedUnit() {
        Entity entity = this.ce();
        Entity entity2 = null;
        if (this.loadedUnits.size() == 0) {
            System.err.println("MovementDisplay#getUnloadedUnit() called without loaded units.");
        } else if (this.loadedUnits.size() > 1) {
            String[] stringArray = new String[this.loadedUnits.size()];
            String string = Messages.getString("MovementDisplay.UnloadUnitDialog.message", new Object[]{entity.getShortName(), entity.getUnusedString()});
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.loadedUnits.elementAt(i).getShortName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.UnloadUnitDialog.title"), string, stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                entity2 = this.loadedUnits.elementAt(singleChoiceDialog.getChoice());
            }
        } else {
            entity2 = this.loadedUnits.elementAt(0);
            this.loadedUnits.removeElementAt(0);
        }
        return entity2;
    }

    private Targetable chooseTarget(Coords coords) {
        Entity entity = this.ce();
        Targetable targetable = null;
        Enumeration<Entity> enumeration = this.client.game.getEntities(coords);
        ArrayList<Targetable> arrayList = new ArrayList<Targetable>();
        while (enumeration.hasMoreElements()) {
            targetable = enumeration.nextElement();
            if (entity.equals(targetable)) continue;
            arrayList.add(targetable);
        }
        Building building = this.client.game.getBoard().getBuildingAt(coords);
        if (building != null) {
            arrayList.add(new BuildingTarget(coords, this.client.game.getBoard(), false));
        }
        if (arrayList.size() == 1) {
            targetable = (Targetable)arrayList.get(0);
        } else if (arrayList.size() > 1) {
            String[] stringArray = new String[arrayList.size()];
            String string = Messages.getString("MovementDisplay.ChooseTargetDialog.message", new Object[]{coords.getBoardNum()});
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((Targetable)arrayList.get(i)).getDisplayName();
            }
            SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("MovementDisplay.ChooseTargetDialog.title"), string, stringArray);
            singleChoiceDialog.setVisible(true);
            if (singleChoiceDialog.getAnswer()) {
                targetable = (Targetable)arrayList.get(singleChoiceDialog.getChoice());
            }
        }
        return targetable;
    }

    private int chooseMineToLay() {
        MineLayingDialog mineLayingDialog = new MineLayingDialog(this.clientgui.frame, this.ce());
        mineLayingDialog.setVisible(true);
        if (mineLayingDialog.getAnswer()) {
            return mineLayingDialog.getMine();
        }
        return -1;
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() != 8) {
            return;
        }
        this.endMyTurn();
        if (this.client.isMyTurn()) {
            if (this.client.canUnloadStranded()) {
                this.unloadStranded();
            } else {
                this.beginMyTurn();
            }
        } else if (gameTurnChangeEvent.getPlayer() == null && this.client.game.getTurn() instanceof GameTurn.UnloadStrandedTurn) {
            this.setStatusBarText(Messages.getString("MovementDisplay.waitForAnother"));
        } else {
            this.setStatusBarText(Messages.getString("MovementDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && this.client.game.getPhase() != 8) {
            this.endMyTurn();
        }
        if (this.client.game.getPhase() == 8) {
            this.setStatusBarText(Messages.getString("MovementDisplay.waitingForMovementPhase"));
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Entity entity = this.ce();
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource().equals(this.butDone)) {
            this.moveTo(this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_NEXT)) {
            this.selectEntity(this.client.getNextEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(MOVE_CANCEL)) {
            this.clearAllMoves();
        } else if (actionEvent.getSource().equals(this.butMore)) {
            ++this.buttonLayout;
            this.buttonLayout %= 4;
            this.setupButtonPanel();
        } else if (actionEvent.getActionCommand().equals(MOVE_UNJAM)) {
            if (this.gear == 2 || this.gear == 3 || this.gear == 4 || this.cmd.getMpUsed() > entity.getWalkMP() || this.gear == 6) {
                this.setUnjamEnabled(false);
            } else {
                this.cmd.addStep(15);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_SEARCHLIGHT)) {
            this.cmd.addStep(22);
        } else if (actionEvent.getActionCommand().equals(MOVE_WALK)) {
            if (this.gear == 2 || this.gear == 6) {
                this.clearAllMoves();
            }
            this.gear = 0;
        } else if (actionEvent.getActionCommand().equals(MOVE_JUMP)) {
            if (this.gear != 2) {
                this.clearAllMoves();
            }
            if (!this.cmd.isJumping()) {
                this.cmd.addStep(7);
            }
            this.gear = 2;
        } else if (actionEvent.getActionCommand().equals(MOVE_SWIM)) {
            if (this.gear != 6) {
                this.clearAllMoves();
            }
            this.gear = 6;
            entity.setMovementMode(entity instanceof BipedMech ? 13 : 14);
        } else if (actionEvent.getActionCommand().equals(MOVE_TURN)) {
            this.gear = 5;
        } else if (actionEvent.getActionCommand().equals(MOVE_BACK_UP)) {
            if (this.gear == 2) {
                this.clearAllMoves();
            }
            this.gear = 1;
        } else if (actionEvent.getActionCommand().equals(MOVE_CLEAR)) {
            this.clearAllMoves();
            if (!this.client.game.containsMinefield(entity.getPosition())) {
                this.clientgui.doAlertDialog(Messages.getString("MovementDisplay.CantClearMinefield"), Messages.getString("MovementDisplay.NoMinefield"));
                return;
            }
            int n = 10;
            int n2 = 5;
            for (Mounted mounted : entity.getMisc()) {
                if (!mounted.getType().hasFlag(0x100000L) || !mounted.getType().hasSubType(8)) continue;
                int n3 = mounted.getType().getToHitModifier();
                n = Minefield.CLEAR_NUMBER_SWEEPER[n3];
                n2 = Minefield.CLEAR_NUMBER_SWEEPER_ACCIDENT[n3];
                break;
            }
            if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.ClearMinefieldDialog.title"), Messages.getString("MovementDisplay.ClearMinefieldDialog.message", new Object[]{new Integer(n), new Integer(n2)}))) {
                this.cmd.addStep(19);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_CHARGE)) {
            if (this.gear != 0) {
                this.clearAllMoves();
            }
            this.gear = 3;
        } else if (actionEvent.getActionCommand().equals(MOVE_DFA)) {
            if (this.gear != 2) {
                this.clearAllMoves();
            }
            this.gear = 4;
            if (!this.cmd.isJumping()) {
                this.cmd.addStep(7);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_GET_UP)) {
            this.clearAllMoves();
            if (this.cmd.getFinalProne() || this.cmd.getFinalHullDown()) {
                this.cmd.addStep(5);
            }
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
            this.butDone.setText(Messages.getString("MovementDisplay.Move"));
        } else if (actionEvent.getActionCommand().equals(MOVE_GO_PRONE)) {
            this.gear = 0;
            if (!this.cmd.getFinalProne()) {
                this.cmd.addStep(6);
            }
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
            this.butDone.setText(Messages.getString("MovementDisplay.Move"));
        } else if (actionEvent.getActionCommand().equals(MOVE_HULL_DOWN)) {
            this.gear = 0;
            if (!this.cmd.getFinalHullDown()) {
                this.cmd.addStep(24);
            }
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
            this.butDone.setText(Messages.getString("MovementDisplay.Move"));
        } else if (actionEvent.getActionCommand().equals(MOVE_FLEE) && this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.EscapeDialog.title"), Messages.getString("MovementDisplay.EscapeDialog.message"))) {
            this.clearAllMoves();
            this.cmd.addStep(10);
            this.moveTo(this.cmd);
        } else if (actionEvent.getActionCommand().equals(MOVE_EJECT)) {
            if (entity instanceof Tank) {
                if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.AbandonDialog.title"), Messages.getString("MovementDisplay.AbandonDialog.message"))) {
                    this.clearAllMoves();
                    this.cmd.addStep(18);
                    this.moveTo(this.cmd);
                }
            } else if (this.clientgui.doYesNoDialog(Messages.getString("MovementDisplay.AbandonDialog1.title"), Messages.getString("MovementDisplay.AbandonDialog1.message"))) {
                this.clearAllMoves();
                this.cmd.addStep(18);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_LOAD)) {
            Entity entity2 = null;
            Enumeration<Entity> enumeration = this.client.game.getEntities(entity.getPosition());
            while (enumeration.hasMoreElements()) {
                entity2 = enumeration.nextElement();
                if (entity.getOwner().equals(entity2.getOwner()) && !entity.equals(entity2)) {
                    this.loadedUnits.addElement(entity2);
                    break;
                }
                entity2 = null;
            }
            if (entity2 != null) {
                this.cmd.addStep(16);
                this.clientgui.bv.drawMovementData(this.cmd);
                this.clientgui.bv.repaint();
                this.gear = 0;
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_UNLOAD)) {
            Entity entity3 = this.getUnloadedUnit();
            if (entity3 != null) {
                this.cmd.addStep(17, entity3);
                this.clientgui.bv.drawMovementData(this.cmd);
                this.clientgui.bv.repaint();
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_RAISE_ELEVATION)) {
            this.cmd.addStep(20);
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
        } else if (actionEvent.getActionCommand().equals(MOVE_LOWER_ELEVATION)) {
            this.cmd.addStep(21);
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
        } else if (actionEvent.getActionCommand().equals(MOVE_CLIMB_MODE)) {
            MoveStep moveStep = this.cmd.getLastStep();
            if (moveStep != null && (moveStep.getType() == 25 || moveStep.getType() == 26)) {
                this.cmd.removeLastStep();
            } else if (this.cmd.getFinalClimbMode()) {
                this.cmd.addStep(26);
            } else {
                this.cmd.addStep(25);
            }
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
        } else if (actionEvent.getActionCommand().equals(MOVE_LAY_MINE)) {
            this.clearAllMoves();
            int n = this.chooseMineToLay();
            if (n != -1) {
                Mounted mounted = this.ce().getEquipment(n);
                if (mounted.getMineType() == 1) {
                    VibrabombSettingDialog vibrabombSettingDialog = new VibrabombSettingDialog(this.clientgui.frame);
                    vibrabombSettingDialog.setVisible(true);
                    mounted.setVibraSetting(vibrabombSettingDialog.getSetting());
                }
                this.cmd.addStep(23, n);
                this.moveTo(this.cmd);
            }
        } else if (actionEvent.getActionCommand().equals(MOVE_DIG_IN)) {
            this.cmd.addStep(28);
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
        } else if (actionEvent.getActionCommand().equals(MOVE_FORTIFY)) {
            this.cmd.addStep(29);
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
        } else if (actionEvent.getActionCommand().equals(MOVE_SHAKE_OFF)) {
            this.cmd.addStep(30);
            this.clientgui.bv.drawMovementData(this.cmd);
            this.clientgui.bv.repaint();
        }
        this.updateProneButtons();
        this.updateRACButton();
        this.updateSearchlightButton();
        this.updateLoadButtons();
        this.updateElevationButtons();
    }

    private void unloadStranded() {
        Object object;
        Vector<Entity> vector = new Vector<Entity>();
        String[] stringArray = null;
        Entity entity = null;
        Entity entity2 = null;
        this.setStatusBarText(Messages.getString("MovementDisplay.AllPlayersUnload"));
        Enumeration<Entity> enumeration = this.client.getSelectedEntities(new EntitySelector(){
            private final IGame game;
            private final GameTurn turn;
            private final int ownerId;
            {
                this.game = MovementDisplay.this.client.game;
                this.turn = MovementDisplay.this.client.game.getTurn();
                this.ownerId = MovementDisplay.this.client.getLocalPlayer().getId();
            }

            public boolean accept(Entity entity) {
                return this.turn.isValid(this.ownerId, entity, this.game);
            }
        });
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            entity = (Entity)vector.elementAt(i);
            entity2 = this.client.getEntity(entity.getTransportId());
            object = null == entity2 ? entity.getDisplayName() : Messages.getString("MovementDisplay.EntityAt", new Object[]{entity.getDisplayName(), entity2.getPosition().getBoardNum()});
            stringArray[i] = ((String)object).toString();
        }
        int[] nArray = this.clientgui.doChoiceDialog(Messages.getString("MovementDisplay.UnloadStrandedUnitsDialog.title"), Messages.getString("MovementDisplay.UnloadStrandedUnitsDialog.message"), stringArray);
        object = null;
        if (null != nArray) {
            object = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                entity = (Entity)vector.elementAt(i);
                object[i] = entity.getId();
            }
        }
        this.client.sendUnloadStranded((int[])object);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 27) {
            this.clearAllMoves();
        }
        if (keyEvent.getKeyCode() == 8 && this.client.isMyTurn()) {
            this.removeLastStep();
        }
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown() && this.client.isMyTurn()) {
            this.moveTo(this.cmd);
        }
        if (keyEvent.getKeyCode() == 16 && !this.shiftheld) {
            this.shiftheld = true;
            if (this.client.isMyTurn() && this.clientgui.getBoardView().getLastCursor() != null && !this.clientgui.getBoardView().getLastCursor().equals(this.clientgui.getBoardView().getSelected())) {
                this.currentMove(this.clientgui.getBoardView().getLastCursor());
                this.clientgui.bv.drawMovementData(this.cmd);
            }
        }
        if (this.shiftheld && this.client.isMyTurn() && (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39)) {
            int n;
            int n2 = n = this.cmd.getFinalFacing();
            n2 = keyEvent.getKeyCode() == 37 ? (n2 + 5) % 6 : (n2 + 7) % 6;
            Coords coords = this.cmd.getFinalCoords();
            Coords coords2 = coords.translated(n2);
            this.currentMove(coords2);
            this.clientgui.bv.drawMovementData(this.cmd);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (keyEvent.getKeyCode() == 16 && this.shiftheld) {
            this.shiftheld = false;
            if (this.client.isMyTurn() && this.clientgui.getBoardView().getLastCursor() != null && !this.clientgui.getBoardView().getLastCursor().equals(this.clientgui.getBoardView().getSelected())) {
                this.clientgui.bv.clearMovementData();
                this.currentMove(this.clientgui.getBoardView().getLastCursor());
                this.clientgui.bv.drawMovementData(this.cmd);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
        Entity entity = this.ce();
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn() && entity != null) {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.bv.centerOnHex(entity.getPosition());
        }
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (null == entity) {
            return;
        }
        if (this.client.isMyTurn()) {
            if (this.client.game.getTurn().isValidEntity(entity, this.client.game)) {
                this.selectEntity(entity.getId());
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    private void setWalkEnabled(boolean bl) {
        this.butWalk.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveWalkEnabled(bl);
    }

    private void setTurnEnabled(boolean bl) {
        this.butTurn.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveTurnEnabled(bl);
    }

    private void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveNextEnabled(bl);
    }

    private void setLayMineEnabled(boolean bl) {
        this.butLayMine.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveLayMineEnabled(bl);
    }

    private void setLoadEnabled(boolean bl) {
        this.butLoad.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveLoadEnabled(bl);
    }

    private void setUnloadEnabled(boolean bl) {
        this.butUnload.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveUnloadEnabled(bl);
    }

    private void setJumpEnabled(boolean bl) {
        this.butJump.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveJumpEnabled(bl);
    }

    private void setSwimEnabled(boolean bl) {
        this.butSwim.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveSwimEnabled(bl);
    }

    private void setBackUpEnabled(boolean bl) {
        this.butBackup.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveBackUpEnabled(bl);
    }

    private void setChargeEnabled(boolean bl) {
        this.butCharge.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveChargeEnabled(bl);
    }

    private void setDFAEnabled(boolean bl) {
        this.butDfa.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveDFAEnabled(bl);
    }

    private void setGoProneEnabled(boolean bl) {
        this.butDown.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveGoProneEnabled(bl);
    }

    private void setFleeEnabled(boolean bl) {
        this.butFlee.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveFleeEnabled(bl);
    }

    private void setEjectEnabled(boolean bl) {
        this.butEject.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveEjectEnabled(bl);
    }

    private void setUnjamEnabled(boolean bl) {
        this.butRAC.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveUnjamEnabled(bl);
    }

    private void setSearchlightEnabled(boolean bl, boolean bl2) {
        if (bl2) {
            this.butSearchlight.setText(Messages.getString("MovementDisplay.butSearchlightOff"));
        } else {
            this.butSearchlight.setText(Messages.getString("MovementDisplay.butSearchlightOn"));
        }
        this.butSearchlight.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveSearchlightEnabled(bl);
    }

    private void setHullDownEnabled(boolean bl) {
        this.butHullDown.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveHullDownEnabled(bl);
    }

    private void setClearEnabled(boolean bl) {
        this.butClear.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveClearEnabled(bl);
    }

    private void setGetUpEnabled(boolean bl) {
        this.butUp.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveGetUpEnabled(bl);
    }

    private void setRaiseEnabled(boolean bl) {
        this.butRaise.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveRaiseEnabled(bl);
    }

    private void setLowerEnabled(boolean bl) {
        this.butLower.setEnabled(bl);
        this.clientgui.getMenuBar().setMoveLowerEnabled(bl);
    }

    public boolean isIgnoringEvents() {
        return this.distracted.isIgnoringEvents();
    }

    public void setIgnoringEvents(boolean bl) {
        this.distracted.setIgnoringEvents(bl);
    }

    public JButton getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
    }
}

