/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.Mounted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtilleryTracker
implements Serializable {
    private Hashtable<Mounted, Vector<ArtilleryModifier>> weapons = new Hashtable();

    public void addWeapon(Mounted mounted) {
        this.weapons.put(mounted, new Vector());
    }

    public void setModifier(Mounted mounted, int n, Coords coords) {
        Vector<ArtilleryModifier> vector = this.getWeaponModifiers(mounted);
        ArtilleryModifier artilleryModifier = this.getModifierByCoords(vector, coords);
        if (artilleryModifier != null) {
            artilleryModifier.setModifier(n);
        } else {
            artilleryModifier = new ArtilleryModifier(coords, n);
            vector.addElement(artilleryModifier);
        }
    }

    public int getModifier(Mounted mounted, Coords coords) {
        Vector<ArtilleryModifier> vector = this.getWeaponModifiers(mounted);
        ArtilleryModifier artilleryModifier = this.getModifierByCoords(vector, coords);
        if (artilleryModifier != null) {
            return artilleryModifier.getModifier();
        }
        artilleryModifier = new ArtilleryModifier(coords, 0);
        vector.addElement(artilleryModifier);
        return 0;
    }

    protected Vector<ArtilleryModifier> getWeaponModifiers(Mounted mounted) {
        Vector<ArtilleryModifier> vector = this.weapons.get(mounted);
        if (vector == null) {
            vector = new Vector();
            this.weapons.put(mounted, vector);
        }
        return vector;
    }

    protected ArtilleryModifier getModifierByCoords(Vector vector, Coords coords) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ArtilleryModifier artilleryModifier = (ArtilleryModifier)enumeration.nextElement();
            if (!artilleryModifier.getCoords().equals(coords)) continue;
            return artilleryModifier;
        }
        return null;
    }

    private static class ArtilleryModifier
    implements Serializable {
        private Coords coords;
        private int modifier;

        public ArtilleryModifier() {
            this.coords = new Coords();
            this.setModifier(0);
        }

        public ArtilleryModifier(Coords coords, int n) {
            this.coords = coords;
            this.setModifier(n);
        }

        public void setCoords(Coords coords) {
            this.coords = coords;
        }

        public Coords getCoords() {
            return this.coords;
        }

        public void setModifier(int n) {
            this.modifier = n;
        }

        public int getModifier() {
            return this.modifier;
        }
    }
}

