/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.zip.ZipFile;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import megamek.common.loaders.BLKBattleArmorFile;
import megamek.common.loaders.BLKGunEmplacementFile;
import megamek.common.loaders.BLKInfantryFile;
import megamek.common.loaders.BLKMechFile;
import megamek.common.loaders.BLKProtoFile;
import megamek.common.loaders.BLKTankFile;
import megamek.common.loaders.BLKVTOLFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.HmpFile;
import megamek.common.loaders.HmvFile;
import megamek.common.loaders.MepFile;
import megamek.common.loaders.MtfFile;
import megamek.common.loaders.TdbFile;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BuildingBlock;

public class MechFileParser {
    private Entity m_entity = null;
    private static Vector canonUnitNames = null;
    private static final File ROOT = new File(PreferenceManager.getClientPreferences().getMechDirectory());
    private static final File OFFICIALUNITS = new File(ROOT, "OfficialUnitList.txt");

    public MechFileParser(File file) throws EntityLoadingException {
        this(file, null);
    }

    public MechFileParser(File file, String string) throws EntityLoadingException {
        if (string == null) {
            try {
                this.parse(new FileInputStream(file), file.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (exception instanceof EntityLoadingException) {
                    throw new EntityLoadingException("While parsing file " + file.getName() + ", " + exception.getMessage());
                }
                throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
            }
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            this.parse(zipFile.getInputStream(zipFile.getEntry(string)), string);
        }
        catch (EntityLoadingException entityLoadingException) {
            throw new EntityLoadingException(entityLoadingException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
        }
    }

    public MechFileParser(InputStream inputStream, String string) throws EntityLoadingException {
        try {
            this.parse(inputStream, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof EntityLoadingException) {
                throw new EntityLoadingException(exception.getMessage());
            }
            throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
        }
    }

    public Entity getEntity() {
        return this.m_entity;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(InputStream inputStream, String string) throws EntityLoadingException {
        void var4_19;
        String string2 = string.toLowerCase();
        if (string2.endsWith(".mep")) {
            MepFile mepFile = new MepFile(inputStream);
        } else if (string2.endsWith(".mtf")) {
            MtfFile mtfFile = new MtfFile(inputStream);
        } else if (string2.endsWith(".hmp")) {
            HmpFile hmpFile = new HmpFile(inputStream);
        } else if (string2.endsWith(".hmv")) {
            HmvFile hmvFile = new HmvFile(inputStream);
        } else if (string2.endsWith(".xml")) {
            TdbFile tdbFile = new TdbFile(inputStream);
        } else if (string2.endsWith(".blk")) {
            BuildingBlock buildingBlock = new BuildingBlock(inputStream);
            if (buildingBlock.exists("UnitType")) {
                String string3 = buildingBlock.getDataAsString("UnitType")[0];
                if (string3.equals("Tank") || string3.equals("Naval") || string3.equals("Surface") || string3.equals("Hydrofoil")) {
                    BLKTankFile bLKTankFile = new BLKTankFile(buildingBlock);
                } else if (string3.equals("Infantry")) {
                    BLKInfantryFile bLKInfantryFile = new BLKInfantryFile(buildingBlock);
                } else if (string3.equals("BattleArmor")) {
                    BLKBattleArmorFile bLKBattleArmorFile = new BLKBattleArmorFile(buildingBlock);
                } else if (string3.equals("ProtoMech")) {
                    BLKProtoFile bLKProtoFile = new BLKProtoFile(buildingBlock);
                } else if (string3.equals("Mech")) {
                    BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
                } else if (string3.equals("VTOL")) {
                    BLKVTOLFile bLKVTOLFile = new BLKVTOLFile(buildingBlock);
                } else {
                    if (!string3.equals("GunEmplacement")) throw new EntityLoadingException("Unknown UnitType: " + string3);
                    BLKGunEmplacementFile bLKGunEmplacementFile = new BLKGunEmplacementFile(buildingBlock);
                }
            } else {
                BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
            }
        } else {
            if (!string2.endsWith(".dbm")) throw new EntityLoadingException("Unsupported file suffix");
            throw new EntityLoadingException("In order to use mechs from The Drawing Board with MegaMek, you must save your mech as an XML file (look in the 'File' menu of TDB.)  Then use the resulting '.xml' file instead of the '.dbm' file.  Note that only version 2.0.23 or later of TDB is compatible with MegaMek.");
        }
        this.m_entity = var4_19.getEntity();
        this.postLoadInit(this.m_entity);
    }

    private void postLoadInit(Entity entity) throws EntityLoadingException {
        Object object;
        block15: {
            for (Mounted object22 : entity.getMisc()) {
                EquipmentType equipmentType;
                if (object22.getType().hasFlag(512L) && object22.getLinked() == null) {
                    for (Mounted mounted : entity.getWeaponList()) {
                        equipmentType = (WeaponType)mounted.getType();
                        if (((WeaponType)equipmentType).getAmmoType() != 7 && ((WeaponType)equipmentType).getAmmoType() != 50 && ((WeaponType)equipmentType).getAmmoType() != 9 || mounted.getLinkedBy() != null) continue;
                        if (mounted.getLocation() == object22.getLocation()) {
                            object22.setLinked(mounted);
                            break;
                        }
                        if (!(entity instanceof Mech) || object22.getLocation() != 0 || mounted.getLocation() != 1) continue;
                        object22.setLinked(mounted);
                        break;
                    }
                    if (object22.getLinked() == null) {
                        throw new EntityLoadingException("Unable to match Artemis to launcher");
                    }
                } else if ("Stealth".equals(object22.getType().getInternalName()) && object22.getLinked() == null) {
                    for (Mounted mounted : entity.getMisc()) {
                        equipmentType = (MiscType)mounted.getType();
                        if (!equipmentType.hasFlag(1024L)) continue;
                        object22.setLinked(mounted);
                        break;
                    }
                    if (object22.getLinked() == null) {
                        throw new EntityLoadingException("Unable to find an ECM Suite.  Mechs with Stealth Armor must also be equipped with an ECM Suite.");
                    }
                }
                if (!(entity instanceof Mech) || !object22.getType().hasFlag(8L)) continue;
                ((Mech)entity).setAutoEject(false);
            }
            entity.setCanon(false);
            try {
                if (canonUnitNames != null) break block15;
                canonUnitNames = new Vector();
                object = null;
                try {
                    String string;
                    object = new BufferedReader(new FileReader(OFFICIALUNITS));
                    while ((string = ((BufferedReader)object).readLine()) != null) {
                        int n = string.indexOf(124);
                        String string2 = string.substring(0, n);
                        canonUnitNames.addElement(string2);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = canonUnitNames.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (!string.equals(entity.getShortNameRaw())) continue;
            entity.setCanon(true);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Files in a supported MegaMek file format can be specified on\nthe command line.  Multiple files may be processed at once.\nThe supported formats are:\n\t.mtf    The native MegaMek format that your file will be converted into\n\n\t.blk    Another native MegaMek format\n\t.hmp    Heavy Metal Pro (c)RCW Enterprises\n\t.mep    MechEngineer Pro (c)Howling Moon SoftWorks\n\t.xml    The Drawing Board (c)Blackstone Interactive\n\nNote: If you are using the MtfConvert utility, you may also drag and drop files onto it for conversion.\n");
            MechFileParser.getResponse("Press <enter> to exit...");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file = new File(string);
            String string2 = string.substring(0, string.lastIndexOf("."));
            File file2 = new File(string2 = string2 + ".mtf");
            if (file2.exists() && !MechFileParser.getResponse("File already exists, overwrite? ")) {
                return;
            }
            BufferedWriter bufferedWriter = null;
            try {
                MechFileParser mechFileParser = new MechFileParser(file);
                bufferedWriter = new BufferedWriter(new FileWriter(file2));
                bufferedWriter.write(((Mech)mechFileParser.getEntity()).getMtf());
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                MechFileParser.getResponse("Press <enter> to exit...");
                continue;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static boolean getResponse(String string) {
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(string);
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2 != null && string2.toLowerCase().indexOf("y") == 0;
    }

    public static void dispose() {
        canonUnitNames = null;
    }
}

